<?
header("Content-Type: text/html; charset=UTF-8");
?>
<!DOCTYPE html>
<html>
  <head>
    <title>Google Maps JavaScript API v3 Example: Map Simple</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <meta charset="utf-8">
    <style>
      html, body, #map_canvas {
        margin: 0;
        padding: 0;
        height: 100%;
		font-family:Arial, Helvetica, sans-serif;
		font-size:12px;
      }
    </style>
    <script src="https://maps.googleapis.com/maps/api/js?v=3.exp&sensor=false"></script>
    <script>
      var map;
      var myLatlng = new google.maps.LatLng(47.498591,19.075166);
      function initialize() {
        var mapOptions = {
          zoom: 17,
		  //47.498591&lng=19.075166
          center: myLatlng,
          mapTypeId: google.maps.MapTypeId.ROADMAP
        };
        map = new google.maps.Map(document.getElementById('map_canvas'),
            mapOptions);
       var contentString = '<div id="content">'+
            '<strong>ERRA</strong>'+
            ''+
            '<p>R70 Office Complex,<br>Rákóczi út 70-72,<br>1074 Budapest, Hungary</p>'+
            '</div>'+
            '';

        var infowindow = new google.maps.InfoWindow({
            content: contentString
        });

        var marker = new google.maps.Marker({
            position: myLatlng,
            map: map,
            title: 'Uluru (Ayers Rock)'
        });
        google.maps.event.addListener(marker, 'click', function() {
          infowindow.open(map,marker);
        });
		
		setTimeout(function(){infowindow.open(map,marker)},500);
      }
    </script>
  </head>
  <body onload="initialize()">
    <div id="map_canvas"></div>
  </body>
</html>
