--
-- Adatbázis: `atlantisz`
--

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_brands`
--

CREATE TABLE `eshop_brands` (
  `id` int(11) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `company` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `logo` varchar(50) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `url` varchar(100) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_brand_info`
--

CREATE TABLE `eshop_brand_info` (
  `id` int(11) NOT NULL DEFAULT '0',
  `url` varchar(100) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `url_clicked` int(11) NOT NULL DEFAULT '0',
  `description` text CHARACTER SET utf8 NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_categories`
--

CREATE TABLE `eshop_categories` (
  `id` int(11) NOT NULL,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `shortname` varchar(255) NOT NULL DEFAULT '',
  `name` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `short_name` varchar(255) NOT NULL,
  `description` text CHARACTER SET utf8 NOT NULL,
  `category_type` tinyint(1) NOT NULL DEFAULT '0',
  `pagetype` enum('auto','list','category') NOT NULL DEFAULT 'auto',
  `image` varchar(50) CHARACTER SET utf8 NOT NULL DEFAULT '0',
  `refine` tinyint(4) NOT NULL DEFAULT '0',
  `refine_global` tinyint(1) NOT NULL DEFAULT '0',
  `show_brands` tinyint(1) NOT NULL DEFAULT '1',
  `links` tinyint(4) NOT NULL DEFAULT '0',
  `accessories` tinyint(4) NOT NULL DEFAULT '0',
  `features` tinyint(4) NOT NULL DEFAULT '0',
  `specifications` tinyint(4) NOT NULL DEFAULT '0',
  `reviews` tinyint(4) NOT NULL DEFAULT '0',
  `includes` tinyint(4) NOT NULL DEFAULT '0',
  `def_listpage_tab` varchar(20) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `def_detailspage_tab` varchar(20) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `show_advert` tinyint(1) NOT NULL DEFAULT '0',
  `advertise` text CHARACTER SET utf8 NOT NULL,
  `adv_block` int(11) NOT NULL DEFAULT '0',
  `adv_block2` int(11) NOT NULL,
  `adv_block3` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `pos` int(11) NOT NULL DEFAULT '0',
  `sorted` tinyint(4) NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `seo_data` text CHARACTER SET utf8
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- A tábla adatainak kiíratása `eshop_categories`
--

INSERT INTO `eshop_categories` (`id`, `parent_id`, `shortname`, `name`, `short_name`, `description`, `category_type`, `pagetype`, `image`, `refine`, `refine_global`, `show_brands`, `links`, `accessories`, `features`, `specifications`, `reviews`, `includes`, `def_listpage_tab`, `def_detailspage_tab`, `show_advert`, `advertise`, `adv_block`, `adv_block2`, `adv_block3`, `created`, `modified`, `pos`, `sorted`, `visible`, `seo_data`) VALUES
(182, 0, '', 'Szellőztetés', 'szelloztetes', '', 2, 'auto', 'catImage_182_1559223952.jpg', 0, 0, 0, 0, 0, 0, 0, 0, 0, 'refine', 'accessories', 0, '', 0, 0, 0, '2019-05-30 15:45:52', '2019-05-30 15:45:58', 0, 0, 1, 'a:3:{s:5:"title";s:0:"";s:11:"description";s:0:"";s:8:"keywords";s:0:"";}'),
(184, 0, '', 'VRF', 'vrf', '', 2, 'auto', 'catImage_184_1559224254.jpg', 0, 0, 0, 0, 0, 0, 0, 0, 0, 'refine', 'accessories', 0, '', 0, 0, 0, '2019-05-30 15:50:54', '2019-05-30 15:50:54', 0, 0, 1, 'a:3:{s:5:"title";s:0:"";s:11:"description";s:0:"";s:8:"keywords";s:0:"";}'),
(179, 0, '', 'Lakossági', 'lakossagi', '', 2, 'auto', 'catImage_179_1559222373.jpg', 0, 0, 0, 0, 0, 0, 0, 0, 0, 'refine', 'accessories', 0, '', 0, 0, 0, '2019-05-30 15:19:33', '2019-05-30 15:19:33', 0, 0, 1, 'a:3:{s:5:"title";s:0:"";s:11:"description";s:0:"";s:8:"keywords";s:0:"";}'),
(185, 0, '', 'Ipari', 'ipari', '', 2, 'auto', 'catImage_185_1559224289.jpg', 0, 0, 0, 0, 0, 0, 0, 0, 0, 'refine', 'accessories', 0, '', 0, 0, 0, '2019-05-30 15:51:18', '2019-05-30 15:51:29', 0, 0, 1, 'a:3:{s:5:"title";s:0:"";s:11:"description";s:0:"";s:8:"keywords";s:0:"";}'),
(183, 179, '', 'Mono', 'mono', '', 1, 'auto', 'catImage_183_1559224056.jpg', 0, 0, 0, 0, 0, 0, 0, 0, 0, 'refine', 'accessories', 0, '', 0, 0, 0, '2019-05-30 15:47:36', '2019-05-30 15:47:36', 0, 0, 1, 'a:3:{s:5:"title";s:0:"";s:11:"description";s:0:"";s:8:"keywords";s:0:"";}'),
(187, 0, '', 'Estia', 'estia', '', 2, 'auto', 'catImage_187_1559224381.jpg', 0, 0, 0, 0, 0, 0, 0, 0, 0, 'refine', 'accessories', 0, '', 0, 0, 0, '2019-05-30 15:53:01', '2019-05-30 15:53:01', 0, 0, 1, 'a:3:{s:5:"title";s:0:"";s:11:"description";s:0:"";s:8:"keywords";s:0:"";}'),
(188, 0, '', 'Vezérlők', 'vezerlok', '', 2, 'auto', 'catImage_188_1559224401.jpg', 0, 0, 0, 0, 0, 0, 0, 0, 0, 'refine', 'accessories', 0, '', 0, 0, 0, '2019-05-30 15:53:20', '2019-05-30 15:53:21', 0, 0, 1, 'a:3:{s:5:"title";s:0:"";s:11:"description";s:0:"";s:8:"keywords";s:0:"";}');

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_categories_lang`
--

CREATE TABLE `eshop_categories_lang` (
  `id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `description` text CHARACTER SET utf8 NOT NULL,
  `lang` char(3) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `seo_data` text CHARACTER SET utf8
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_categories_links`
--

CREATE TABLE `eshop_categories_links` (
  `id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL DEFAULT '0',
  `link_title` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `link_description` text CHARACTER SET utf8 NOT NULL,
  `link_url` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `link_target` varchar(20) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `clicked` int(11) NOT NULL DEFAULT '0',
  `last_click` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `position` tinyint(4) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='kategoriahoz kapcsolodo linkek';

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_categories_refines`
--

CREATE TABLE `eshop_categories_refines` (
  `id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `position` tinyint(4) NOT NULL DEFAULT '0',
  `display` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_categories_refines_lang`
--

CREATE TABLE `eshop_categories_refines_lang` (
  `id` int(11) NOT NULL,
  `refine_id` int(11) NOT NULL DEFAULT '0',
  `type` enum('name','value') CHARACTER SET utf8 NOT NULL DEFAULT 'name',
  `name` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `lang` char(3) CHARACTER SET utf8 NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_categories_refines_values`
--

CREATE TABLE `eshop_categories_refines_values` (
  `id` int(11) NOT NULL,
  `refine_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `position` tinyint(4) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_categories_specifications`
--

CREATE TABLE `eshop_categories_specifications` (
  `id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL DEFAULT '0',
  `type` enum('label','text','list') CHARACTER SET utf8 NOT NULL DEFAULT 'label',
  `name` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `position` int(11) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_categories_specifications_lang`
--

CREATE TABLE `eshop_categories_specifications_lang` (
  `id` int(11) NOT NULL,
  `spec_id` int(11) NOT NULL DEFAULT '0',
  `type` enum('name','value') CHARACTER SET utf8 NOT NULL DEFAULT 'name',
  `name` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `lang` char(3) CHARACTER SET utf8 NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_categories_specifications_values`
--

CREATE TABLE `eshop_categories_specifications_values` (
  `id` int(11) NOT NULL,
  `spec_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `position` tinyint(4) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_categories_types`
--

CREATE TABLE `eshop_categories_types` (
  `id` tinyint(4) NOT NULL DEFAULT '0',
  `category_type` varchar(200) CHARACTER SET utf8 NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_category_to_items`
--

CREATE TABLE `eshop_category_to_items` (
  `id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL DEFAULT '0',
  `item_id` int(11) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_countries`
--

CREATE TABLE `eshop_countries` (
  `id` int(11) NOT NULL,
  `name` varchar(64) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `iso_code2` char(2) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `iso_code3` char(3) CHARACTER SET utf8 NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_country_hu`
--

CREATE TABLE `eshop_country_hu` (
  `id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_currencies`
--

CREATE TABLE `eshop_currencies` (
  `id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(32) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `code` char(3) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `symbol_left` varchar(24) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `symbol_right` varchar(24) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `decimals` tinyint(1) NOT NULL DEFAULT '0',
  `thousand_separator` varchar(10) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `decimal_separator` varchar(10) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `value` float NOT NULL DEFAULT '0',
  `last_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_customers`
--

CREATE TABLE `eshop_customers` (
  `uid` int(11) NOT NULL DEFAULT '0',
  `group_id` int(11) NOT NULL DEFAULT '0',
  `gender` varchar(10) NOT NULL DEFAULT '',
  `first_name` varchar(100) NOT NULL DEFAULT '',
  `last_name` varchar(100) NOT NULL DEFAULT '',
  `company_name` varchar(250) NOT NULL DEFAULT '',
  `birthday` date NOT NULL DEFAULT '0000-00-00',
  `email` varchar(100) NOT NULL DEFAULT '',
  `default_address_id` int(11) NOT NULL DEFAULT '0',
  `phone1` varchar(20) NOT NULL DEFAULT '',
  `phone2` varchar(20) NOT NULL DEFAULT '',
  `fax` varchar(20) NOT NULL DEFAULT '',
  `vatnumber` varchar(20) NOT NULL,
  `company_vatnumber` varchar(20) NOT NULL,
  `newsletter` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_customer_addresses`
--

CREATE TABLE `eshop_customer_addresses` (
  `uid` int(11) NOT NULL DEFAULT '0',
  `address_type` enum('billing','shipping') NOT NULL DEFAULT 'billing',
  `first_name` varchar(100) NOT NULL DEFAULT '',
  `last_name` varchar(100) NOT NULL DEFAULT '',
  `company_name` varchar(100) NOT NULL DEFAULT '',
  `address1` varchar(200) NOT NULL DEFAULT '',
  `address2` varchar(200) NOT NULL DEFAULT '',
  `is_po_box` tinyint(1) NOT NULL DEFAULT '0',
  `city` varchar(100) NOT NULL DEFAULT '',
  `zip_code` varchar(7) NOT NULL DEFAULT '',
  `country_code` char(3) NOT NULL DEFAULT '',
  `country_H` tinyint(4) NOT NULL DEFAULT '0',
  `phone1` varchar(15) NOT NULL DEFAULT '',
  `phone1_ext` varchar(5) NOT NULL DEFAULT '',
  `phone2` varchar(15) NOT NULL DEFAULT '',
  `phone2_ext` varchar(5) NOT NULL DEFAULT '',
  `fax` varchar(15) NOT NULL DEFAULT '',
  `email` varchar(50) NOT NULL DEFAULT '',
  `adoszam` varchar(30) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_customer_cart`
--

CREATE TABLE `eshop_customer_cart` (
  `uid` int(11) NOT NULL DEFAULT '0',
  `item_id` varchar(100) NOT NULL DEFAULT '0',
  `quantity` int(11) NOT NULL DEFAULT '0',
  `item_data` text NOT NULL,
  `rebate` text NOT NULL,
  `attributes` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_customer_groups`
--

CREATE TABLE `eshop_customer_groups` (
  `id` int(11) NOT NULL,
  `name` varchar(200) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `allowance` smallint(6) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_customer_info`
--

CREATE TABLE `eshop_customer_info` (
  `uid` int(11) NOT NULL DEFAULT '0',
  `last_logon` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `number_of_logons` int(11) NOT NULL DEFAULT '0',
  `account_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `global_notifications` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Extension of the customers table';

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_customer_wishlist`
--

CREATE TABLE `eshop_customer_wishlist` (
  `uid` int(11) NOT NULL DEFAULT '0',
  `item_id` varchar(20) NOT NULL DEFAULT '',
  `item_category` varchar(20) NOT NULL DEFAULT '',
  `item_brand` varchar(200) NOT NULL DEFAULT '',
  `added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_discount_special`
--

CREATE TABLE `eshop_discount_special` (
  `id` int(11) NOT NULL,
  `discpercent` tinyint(4) NOT NULL,
  `disabled` tinyint(1) NOT NULL,
  `dated` tinyint(1) NOT NULL,
  `startdate` date DEFAULT NULL,
  `enddate` date DEFAULT NULL,
  `disclabel` varchar(255) NOT NULL,
  `typename` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `description` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_discount_special_category`
--

CREATE TABLE `eshop_discount_special_category` (
  `disc_id` int(11) NOT NULL,
  `cat_id` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_email_confirmation`
--

CREATE TABLE `eshop_email_confirmation` (
  `pn_uid` int(11) NOT NULL,
  `token` varchar(32) NOT NULL,
  `pn_uname` varchar(60) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_email_templates`
--

CREATE TABLE `eshop_email_templates` (
  `code` varchar(10) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `subject` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `email` varchar(100) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `from_name` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `body` text CHARACTER SET utf8 NOT NULL,
  `lang` char(3) CHARACTER SET utf8 NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_globals`
--

CREATE TABLE `eshop_globals` (
  `gl_name` varchar(100) NOT NULL DEFAULT '',
  `gl_value` text NOT NULL,
  `comment` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- A tábla adatainak kiíratása `eshop_globals`
--

INSERT INTO `eshop_globals` (`gl_name`, `gl_value`, `comment`) VALUES
('imageSmallWidth', '350', ''),
('imageSmallHeight', '350', ''),
('imageMediumWidth', '500', ''),
('imageLargeWidth', '900', ''),
('imageMediumHeight', '500', ''),
('imageLargeHeight', '900', ''),
('itemOnPage', '', ''),
('categoryImages', '1', ''),
('catImageWidth', '999', ''),
('catImageHeight', '999', ''),
('brandLogoWidth', '', ''),
('brandLogoHeight', '', ''),
('pageAfterLogout', '', ''),
('startPage', '', ''),
('defCountry', '', ''),
('cartOnListPage', '', ''),
('shoppingInfoPage', '', ''),
('dataProtectionPage', '', ''),
('itemQuantityReg', '', ''),
('itemsInRowOnListpage', '0', ''),
('maxHitsOnSearchPage', '', ''),
('orderAdviceEmail', '', ''),
('declarationEnabled', '', ''),
('declarationText', '', '');

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_items`
--

CREATE TABLE `eshop_items` (
  `id` int(11) NOT NULL,
  `shortname` varchar(255) NOT NULL DEFAULT '',
  `name` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `description` text CHARACTER SET utf8 NOT NULL,
  `article_id` varchar(50) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `ean` varchar(13) NOT NULL,
  `brand` int(11) NOT NULL DEFAULT '0',
  `brand_name` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `supplier_id` int(11) NOT NULL DEFAULT '0',
  `price` float NOT NULL DEFAULT '0',
  `tax` int(11) NOT NULL DEFAULT '0',
  `quantity` int(11) NOT NULL DEFAULT '0',
  `status` int(11) NOT NULL DEFAULT '0',
  `category` int(11) NOT NULL DEFAULT '0',
  `notice` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `comment` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `delivery_time_info` varchar(255) NOT NULL,
  `weight` decimal(7,2) NOT NULL DEFAULT '0.00',
  `packing` varchar(255) NOT NULL DEFAULT '',
  `virtual` tinyint(4) NOT NULL DEFAULT '0',
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_available` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordered` int(11) NOT NULL DEFAULT '0',
  `min_order` int(11) NOT NULL DEFAULT '0',
  `max_order` int(11) NOT NULL DEFAULT '0',
  `order_units` int(11) NOT NULL DEFAULT '0',
  `qyuantity_box_status` tinyint(1) NOT NULL DEFAULT '0',
  `allow_rating` tinyint(1) NOT NULL DEFAULT '0',
  `allow_review` tinyint(1) NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `discount` tinyint(1) NOT NULL DEFAULT '0',
  `new_item` tinyint(1) NOT NULL DEFAULT '0',
  `promotion` tinyint(1) NOT NULL DEFAULT '0',
  `special` tinyint(1) NOT NULL DEFAULT '0',
  `cart_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `top_seller` tinyint(1) NOT NULL DEFAULT '0',
  `features_text` text CHARACTER SET utf8 NOT NULL,
  `seo_data` text CHARACTER SET utf8,
  `uniqueHeaderImage` varchar(255) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_items_lang`
--

CREATE TABLE `eshop_items_lang` (
  `id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `description` text CHARACTER SET utf8 NOT NULL,
  `notice` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `comment` tinytext CHARACTER SET utf8 NOT NULL,
  `lang` char(3) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `seo_data` text CHARACTER SET utf8
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_item_accessories`
--

CREATE TABLE `eshop_item_accessories` (
  `item_id` int(11) NOT NULL DEFAULT '0',
  `accessory_id` int(11) NOT NULL DEFAULT '0',
  `position` int(11) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Termekhey kapcsolodo cikkek';

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_item_attributes`
--

CREATE TABLE `eshop_item_attributes` (
  `id` int(11) NOT NULL,
  `item_id` int(11) NOT NULL DEFAULT '0',
  `option_id` int(11) NOT NULL DEFAULT '0',
  `position` smallint(6) NOT NULL DEFAULT '0',
  `display` tinyint(4) NOT NULL DEFAULT '1'
) ENGINE=MyISAM DEFAULT CHARSET=latin1 PACK_KEYS=0;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_item_attributes_values`
--

CREATE TABLE `eshop_item_attributes_values` (
  `id` int(11) NOT NULL,
  `attributes_id` int(11) NOT NULL DEFAULT '0',
  `option_value_id` int(11) NOT NULL DEFAULT '0',
  `position` smallint(6) NOT NULL DEFAULT '0',
  `default_value` tinyint(1) NOT NULL DEFAULT '0',
  `display` tinyint(1) NOT NULL DEFAULT '1',
  `price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `weight` decimal(10,2) NOT NULL DEFAULT '0.00',
  `image` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_item_discounts`
--

CREATE TABLE `eshop_item_discounts` (
  `id` int(11) NOT NULL,
  `item_id` int(11) NOT NULL DEFAULT '0',
  `price` float NOT NULL DEFAULT '0',
  `quantity` int(11) NOT NULL DEFAULT '0',
  `date_from` date NOT NULL DEFAULT '0000-00-00',
  `date_to` date NOT NULL DEFAULT '0000-00-00'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_item_documents`
--

CREATE TABLE `eshop_item_documents` (
  `id` int(11) NOT NULL,
  `item_id` int(11) NOT NULL,
  `filename` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `description` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_item_features`
--

CREATE TABLE `eshop_item_features` (
  `id` int(11) NOT NULL,
  `item_id` int(11) NOT NULL DEFAULT '0',
  `features` text CHARACTER SET utf8 NOT NULL,
  `lang` char(3) CHARACTER SET utf8 NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_item_images`
--

CREATE TABLE `eshop_item_images` (
  `id` int(11) NOT NULL,
  `item_id` int(11) NOT NULL DEFAULT '0',
  `position` tinyint(4) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_item_includes`
--

CREATE TABLE `eshop_item_includes` (
  `id` int(11) NOT NULL,
  `item_id` int(11) NOT NULL DEFAULT '0',
  `includes` text CHARACTER SET utf8 NOT NULL,
  `lang` char(3) CHARACTER SET utf8 NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_item_promotions`
--

CREATE TABLE `eshop_item_promotions` (
  `id` int(11) NOT NULL,
  `item_id` int(11) NOT NULL DEFAULT '0',
  `price` float NOT NULL DEFAULT '0',
  `date_from` date NOT NULL DEFAULT '0000-00-00',
  `date_to` date NOT NULL DEFAULT '0000-00-00'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_item_refines`
--

CREATE TABLE `eshop_item_refines` (
  `id` int(11) NOT NULL,
  `item_id` int(11) NOT NULL DEFAULT '0',
  `refine_id` int(11) NOT NULL DEFAULT '0',
  `refine_value_id` int(11) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_item_reviews`
--

CREATE TABLE `eshop_item_reviews` (
  `id` int(11) NOT NULL,
  `brand_name` varchar(255) NOT NULL DEFAULT '',
  `item_id` int(11) NOT NULL DEFAULT '0',
  `item_name` text NOT NULL,
  `review_title` varchar(255) NOT NULL DEFAULT '',
  `review` text NOT NULL,
  `reviewer_name` varchar(100) NOT NULL DEFAULT '',
  `reviewer_location` varchar(50) NOT NULL DEFAULT '',
  `reviewer_email` varchar(50) NOT NULL DEFAULT '',
  `rating` int(11) NOT NULL DEFAULT '0',
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `approved` tinyint(1) NOT NULL DEFAULT '0',
  `helpful_yes` int(11) NOT NULL DEFAULT '0',
  `helpful_no` int(11) NOT NULL DEFAULT '0',
  `viewed` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_item_reviews_config`
--

CREATE TABLE `eshop_item_reviews_config` (
  `terms_text` text NOT NULL,
  `thanks_text` text NOT NULL,
  `must_approval` tinyint(1) NOT NULL DEFAULT '0',
  `must_login` tinyint(1) NOT NULL DEFAULT '0',
  `allow_rating` tinyint(1) NOT NULL DEFAULT '0',
  `allow_vote_review` tinyint(1) NOT NULL DEFAULT '0',
  `lang` char(3) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_item_specifications`
--

CREATE TABLE `eshop_item_specifications` (
  `id` int(11) NOT NULL,
  `item_id` int(11) NOT NULL DEFAULT '0',
  `spec_id` int(11) NOT NULL DEFAULT '0',
  `spec_value` text CHARACTER SET utf8 NOT NULL,
  `spec_value_id` int(11) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_item_specifications_lang`
--

CREATE TABLE `eshop_item_specifications_lang` (
  `id` int(11) NOT NULL,
  `spec_id` int(11) NOT NULL DEFAULT '0',
  `spec_value` text CHARACTER SET utf8 NOT NULL,
  `lang` char(3) CHARACTER SET utf8 NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_item_status`
--

CREATE TABLE `eshop_item_status` (
  `id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(32) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `css_name` varchar(32) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `standard_name` varchar(40) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='TermÃ©k stÃ¡tusz tÃ­pusok';

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_notify`
--

CREATE TABLE `eshop_notify` (
  `email` varchar(50) CHARACTER SET utf8 NOT NULL DEFAULT '0',
  `notify_type` varchar(20) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `notify_id` int(11) NOT NULL DEFAULT '0',
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_options`
--

CREATE TABLE `eshop_options` (
  `id` int(11) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `type` enum('radiobutton','list','checkbox') CHARACTER SET utf8 NOT NULL DEFAULT 'radiobutton',
  `comment` text CHARACTER SET utf8 NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_options_lang`
--

CREATE TABLE `eshop_options_lang` (
  `id` int(11) NOT NULL DEFAULT '0',
  `name` text CHARACTER SET utf8 NOT NULL,
  `lang` char(3) CHARACTER SET utf8 NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_options_values`
--

CREATE TABLE `eshop_options_values` (
  `id` int(11) NOT NULL,
  `option_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `position` tinyint(4) NOT NULL DEFAULT '0',
  `color` varchar(10) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_options_values_lang`
--

CREATE TABLE `eshop_options_values_lang` (
  `id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `lang` char(3) CHARACTER SET utf8 NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_orders`
--

CREATE TABLE `eshop_orders` (
  `order_id` int(11) NOT NULL,
  `uid` int(11) NOT NULL DEFAULT '0',
  `bill_first_name` varchar(100) NOT NULL DEFAULT '',
  `bill_last_name` varchar(100) NOT NULL DEFAULT '',
  `bill_company_name` varchar(100) NOT NULL DEFAULT '',
  `bill_address1` varchar(100) NOT NULL DEFAULT '',
  `bill_address2` varchar(100) NOT NULL DEFAULT '',
  `bill_city` varchar(100) NOT NULL DEFAULT '',
  `bill_zip_code` varchar(7) NOT NULL DEFAULT '',
  `bill_country_code` char(3) NOT NULL DEFAULT '',
  `bill_country_HU_code` tinyint(4) NOT NULL DEFAULT '0',
  `bill_phone1` varchar(15) NOT NULL DEFAULT '',
  `bill_phone1_ext` varchar(5) NOT NULL DEFAULT '',
  `bill_phone2` varchar(15) NOT NULL DEFAULT '',
  `bill_phone2_ext` varchar(5) NOT NULL DEFAULT '',
  `bill_fax` varchar(15) NOT NULL DEFAULT '',
  `bill_email` varchar(50) NOT NULL DEFAULT '',
  `bill_adoszam` varchar(30) NOT NULL,
  `ship_first_name` varchar(100) NOT NULL DEFAULT '',
  `ship_last_name` varchar(100) NOT NULL DEFAULT '',
  `ship_company_name` varchar(100) NOT NULL DEFAULT '',
  `ship_address1` varchar(100) NOT NULL DEFAULT '',
  `ship_address2` varchar(100) NOT NULL DEFAULT '',
  `ship_is_po_box` tinyint(1) NOT NULL DEFAULT '0',
  `ship_city` varchar(100) NOT NULL DEFAULT '',
  `ship_zip_code` varchar(7) NOT NULL DEFAULT '',
  `ship_country_code` char(3) NOT NULL DEFAULT '',
  `ship_country_HU_code` tinyint(4) NOT NULL DEFAULT '0',
  `ship_phone1` varchar(15) NOT NULL DEFAULT '',
  `ship_phone1_ext` varchar(5) NOT NULL DEFAULT '',
  `ship_phone2` varchar(15) NOT NULL DEFAULT '',
  `ship_phone2_ext` varchar(5) NOT NULL DEFAULT '',
  `ship_fax` varchar(15) NOT NULL DEFAULT '',
  `ship_email` varchar(50) NOT NULL DEFAULT '',
  `comment` text NOT NULL,
  `payment_method_id` int(11) NOT NULL DEFAULT '0',
  `shipping_method_id` int(11) NOT NULL DEFAULT '0',
  `shipping_method_name` varchar(255) NOT NULL DEFAULT '',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_finished` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `currency_code` char(3) NOT NULL DEFAULT '',
  `currency_value` decimal(7,2) NOT NULL DEFAULT '0.00',
  `shipping_price` decimal(7,2) NOT NULL DEFAULT '0.00',
  `order_total` decimal(10,2) NOT NULL DEFAULT '0.00',
  `order_netto` decimal(10,2) NOT NULL DEFAULT '0.00',
  `order_rebates` decimal(10,2) NOT NULL DEFAULT '0.00',
  `order_tax` decimal(10,2) NOT NULL DEFAULT '0.00',
  `order_status` tinyint(4) NOT NULL DEFAULT '0',
  `bank_tr_id` varchar(50) NOT NULL DEFAULT '',
  `bank_status` varchar(50) NOT NULL,
  `banktr_id` int(11) DEFAULT NULL,
  `cart_checksum` varchar(50) NOT NULL DEFAULT '',
  `session_id` varchar(33) NOT NULL DEFAULT '',
  `email_text` text NOT NULL,
  `ip` varchar(100) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_orders_banklog`
--

CREATE TABLE `eshop_orders_banklog` (
  `tranzakcioazonosito` bigint(16) NOT NULL,
  `bank_id` tinyint(2) NOT NULL,
  `order_id` int(11) NOT NULL,
  `authorizacioskod` int(10) NOT NULL,
  `pos_id` int(10) NOT NULL,
  `start_time` datetime NOT NULL,
  `osszeg` int(10) NOT NULL,
  `devizanem` varchar(5) NOT NULL,
  `banklog_nev` varchar(255) NOT NULL,
  `banklog_orszag` varchar(255) NOT NULL,
  `banklog_megye` varchar(255) NOT NULL,
  `banklog_telepules` varchar(255) NOT NULL,
  `banklog_iranyitoszam` mediumint(4) NOT NULL,
  `banklog_utca` varchar(255) NOT NULL,
  `banklog_mail` varchar(255) NOT NULL,
  `banklog_kozlemeny` text NOT NULL,
  `statuszkod` varchar(50) NOT NULL,
  `teljesites` varchar(30) NOT NULL,
  `posvalaszkod` varchar(100) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_orders_details`
--

CREATE TABLE `eshop_orders_details` (
  `order_id` int(11) NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL DEFAULT '0',
  `item_id` varchar(100) NOT NULL DEFAULT '0',
  `quantity` int(11) NOT NULL DEFAULT '0',
  `item_data` text NOT NULL,
  `rebate` text NOT NULL,
  `attributes` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_order_status`
--

CREATE TABLE `eshop_order_status` (
  `id` tinyint(4) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `position` tinyint(4) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_payment2shipping`
--

CREATE TABLE `eshop_payment2shipping` (
  `payment_id` int(11) NOT NULL,
  `shipping_id` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_payment_methods`
--

CREATE TABLE `eshop_payment_methods` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `banktype` varchar(15) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_payment_methods_lang`
--

CREATE TABLE `eshop_payment_methods_lang` (
  `id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(100) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `lang` char(3) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_shipping_methods`
--

CREATE TABLE `eshop_shipping_methods` (
  `id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `note` text NOT NULL,
  `domestic` tinyint(1) NOT NULL DEFAULT '0',
  `international` tinyint(1) NOT NULL DEFAULT '0',
  `min_price` decimal(7,2) NOT NULL DEFAULT '0.00',
  `weight_price` decimal(7,2) NOT NULL DEFAULT '0.00',
  `weight_price_from` decimal(7,2) NOT NULL DEFAULT '0.00',
  `tax` tinyint(1) NOT NULL DEFAULT '0',
  `ship_time` varchar(200) NOT NULL DEFAULT '',
  `order_by` int(11) NOT NULL DEFAULT '0',
  `default_method` tinyint(1) NOT NULL DEFAULT '0',
  `show_price` tinyint(1) NOT NULL DEFAULT '0',
  `custom_type` varchar(255) NOT NULL,
  `json_custom_settings` text NOT NULL,
  `desc_page` varchar(250) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_shipping_methods_lang`
--

CREATE TABLE `eshop_shipping_methods_lang` (
  `id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `ship_time` varchar(200) NOT NULL DEFAULT '',
  `lang` char(3) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_shipping_method_limits`
--

CREATE TABLE `eshop_shipping_method_limits` (
  `method_id` int(11) NOT NULL DEFAULT '0',
  `from_price` float NOT NULL DEFAULT '0',
  `to_price` float NOT NULL DEFAULT '0',
  `limit_price` float NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_suppliers`
--

CREATE TABLE `eshop_suppliers` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `bank_account_no` varchar(50) NOT NULL DEFAULT '',
  `tax_no` varchar(50) NOT NULL DEFAULT '',
  `address1` varchar(255) NOT NULL DEFAULT '',
  `address2` varchar(255) NOT NULL DEFAULT '',
  `phone1` varchar(40) NOT NULL DEFAULT '',
  `phone2` varchar(40) NOT NULL DEFAULT '',
  `fax` varchar(40) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_taxes`
--

CREATE TABLE `eshop_taxes` (
  `id` int(11) NOT NULL,
  `rate` decimal(7,4) NOT NULL DEFAULT '0.0000',
  `description` varchar(255) NOT NULL DEFAULT '',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='AdÃ³k (Ã¡fa)';

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `eshop_transaction_log`
--

CREATE TABLE `eshop_transaction_log` (
  `trans_id` bigint(20) NOT NULL COMMENT 'alapveto azonosito',
  `trans_time` datetime NOT NULL COMMENT 'tranzakcio idopontja',
  `trans_type` enum('admin','order','service') NOT NULL COMMENT 'tranz. b. objektum tipusa',
  `typeobj_id` int(11) NOT NULL COMMENT 'tranz. b. objektum azonositoja',
  `item_id` int(11) NOT NULL COMMENT 'elem azonositoja',
  `item_pnumber` varchar(255) NOT NULL COMMENT 'elem cikkszama',
  `trans_diff` int(11) NOT NULL COMMENT 'valtozas merteke',
  `item_amount` int(11) NOT NULL COMMENT 'elemhez tartozo mennyiseg a tranz. utan',
  `trans_attributes` tinytext NOT NULL COMMENT 'rendeles termek-attributumai',
  `trans_comment` tinytext NOT NULL COMMENT 'tranzakciohoz fuzott megjegyzes'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- A tábla adatainak kiíratása `eshop_transaction_log`
--

INSERT INTO `eshop_transaction_log` (`trans_id`, `trans_time`, `trans_type`, `typeobj_id`, `item_id`, `item_pnumber`, `trans_diff`, `item_amount`, `trans_attributes`, `trans_comment`) VALUES
(41, '2019-05-30 13:44:20', 'admin', 599, 688, 'prod_', 0, 0, '', 'Deleted'),
(42, '2019-05-30 15:36:18', 'admin', 599, 690, '0002', 0, 0, '', 'Deleted'),
(43, '2019-05-30 15:47:45', 'admin', 599, 689, '0001', 0, 0, '', 'Deleted');

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_ajanlo`
--

CREATE TABLE `opey_ajanlo` (
  `id` int(11) NOT NULL,
  `tipus` varchar(50) CHARACTER SET utf8 NOT NULL,
  `params` varchar(250) CHARACTER SET utf8 NOT NULL,
  `from_name` varchar(200) CHARACTER SET utf8 NOT NULL,
  `from_email` varchar(200) CHARACTER SET utf8 NOT NULL,
  `to_name` varchar(200) CHARACTER SET utf8 NOT NULL,
  `to_email` varchar(200) CHARACTER SET utf8 NOT NULL,
  `add_date` datetime NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_arculateditor_preview`
--

CREATE TABLE `opey_arculateditor_preview` (
  `id` tinyint(4) NOT NULL DEFAULT '0',
  `session_id` varchar(255) NOT NULL DEFAULT '',
  `Name` varchar(250) NOT NULL DEFAULT '',
  `Arculat` varchar(250) NOT NULL DEFAULT '',
  `Note` text NOT NULL,
  `ColumnSpacer` char(1) NOT NULL DEFAULT 'F',
  `PageWidth` int(11) NOT NULL DEFAULT '0',
  `PageWidthUnit` varchar(5) NOT NULL DEFAULT '',
  `PageHeight` int(11) NOT NULL DEFAULT '0',
  `PageHeightUnit` varchar(5) NOT NULL DEFAULT '',
  `PageBorderWidth` tinyint(4) NOT NULL DEFAULT '0',
  `PageBorderColor` varchar(8) NOT NULL DEFAULT '',
  `PageAlign` varchar(10) NOT NULL DEFAULT '',
  `PageVAlign` varchar(20) NOT NULL DEFAULT '',
  `BodyBgColor` varchar(7) NOT NULL DEFAULT '',
  `BodyBgImage` varchar(250) NOT NULL DEFAULT '',
  `BodyBgImageRepeat` varchar(100) NOT NULL DEFAULT '',
  `BodyBgProperties` varchar(20) NOT NULL DEFAULT '',
  `ColumnStyle` varchar(10) NOT NULL DEFAULT '',
  `HeadBgColor` varchar(7) NOT NULL DEFAULT '',
  `HeadBgImage` varchar(250) NOT NULL DEFAULT '',
  `HeadBgImageRepeat` varchar(10) NOT NULL DEFAULT '',
  `HeadHeight` int(11) NOT NULL DEFAULT '0',
  `LeftWidth` int(11) NOT NULL DEFAULT '0',
  `LeftWidthUnit` varchar(5) NOT NULL DEFAULT '',
  `LeftBgColor` varchar(7) NOT NULL DEFAULT '',
  `LeftBgImage` varchar(250) NOT NULL DEFAULT '',
  `LeftBgImageRepeat` varchar(10) NOT NULL DEFAULT '',
  `LeftSpacerWidth` int(11) NOT NULL DEFAULT '0',
  `LeftSpacerBgColor` varchar(8) NOT NULL DEFAULT '',
  `LeftSpacerBgImage` varchar(250) NOT NULL DEFAULT '',
  `LeftSpacerBgImageRepeat` varchar(20) NOT NULL DEFAULT '',
  `MidWidth` varchar(4) NOT NULL DEFAULT '0',
  `MidWidthUnit` varchar(5) NOT NULL DEFAULT '',
  `MidBgColor` varchar(7) NOT NULL DEFAULT '',
  `MidBgImage` varchar(250) NOT NULL DEFAULT '',
  `MidBgImageRepeat` varchar(10) NOT NULL DEFAULT '',
  `RightSpacerWidth` int(11) NOT NULL DEFAULT '0',
  `RightSpacerBgColor` varchar(8) NOT NULL DEFAULT '',
  `RightSpacerBgImage` varchar(250) NOT NULL DEFAULT '',
  `RightSpacerBgImageRepeat` varchar(20) NOT NULL DEFAULT '',
  `RightWidth` int(11) NOT NULL DEFAULT '0',
  `RightWidthUnit` varchar(5) NOT NULL DEFAULT '',
  `RightBgColor` varchar(7) NOT NULL DEFAULT '',
  `RightBgImage` varchar(250) NOT NULL DEFAULT '',
  `RightBgImageRepeat` varchar(10) NOT NULL DEFAULT '',
  `FootBgColor` varchar(7) NOT NULL DEFAULT '',
  `FootHeight` int(11) NOT NULL DEFAULT '0',
  `FootBgImage` varchar(250) NOT NULL DEFAULT '',
  `FootBgImageRepeat` varchar(10) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_arculat_param`
--

CREATE TABLE `opey_arculat_param` (
  `id` tinyint(4) NOT NULL,
  `IsCustomLayout` tinyint(1) NOT NULL DEFAULT '0',
  `CustomLayoutId` int(11) DEFAULT NULL,
  `Name` varchar(250) NOT NULL DEFAULT '',
  `Arculat` varchar(250) NOT NULL DEFAULT '',
  `Note` text NOT NULL,
  `ColumnSpacer` char(1) NOT NULL DEFAULT 'F',
  `PageWidth` int(11) NOT NULL DEFAULT '0',
  `PageWidthUnit` varchar(5) NOT NULL DEFAULT '',
  `PageHeight` int(11) NOT NULL DEFAULT '0',
  `PageHeightUnit` varchar(5) NOT NULL DEFAULT '',
  `PageBorderWidth` tinyint(4) NOT NULL DEFAULT '0',
  `PageBorderColor` varchar(8) NOT NULL DEFAULT '',
  `PageAlign` varchar(10) NOT NULL DEFAULT '',
  `PageVAlign` varchar(20) NOT NULL DEFAULT '',
  `BodyBgColor` varchar(7) NOT NULL DEFAULT '',
  `BodyBgImage` varchar(250) NOT NULL DEFAULT '',
  `BodyBgImageRepeat` varchar(100) NOT NULL DEFAULT '',
  `BodyBgProperties` varchar(20) NOT NULL DEFAULT '',
  `ColumnStyle` varchar(10) NOT NULL DEFAULT '',
  `HeadBgColor` varchar(7) NOT NULL DEFAULT '',
  `HeadBgImage` varchar(250) NOT NULL DEFAULT '',
  `HeadBgImageRepeat` varchar(10) NOT NULL DEFAULT '',
  `HeadHeight` int(11) NOT NULL DEFAULT '0',
  `LeftWidth` int(11) NOT NULL DEFAULT '0',
  `LeftWidthUnit` varchar(5) NOT NULL DEFAULT '',
  `LeftBgColor` varchar(7) NOT NULL DEFAULT '',
  `LeftBgImage` varchar(250) NOT NULL DEFAULT '',
  `LeftBgImageRepeat` varchar(10) NOT NULL DEFAULT '',
  `LeftSpacerWidth` int(11) NOT NULL DEFAULT '0',
  `LeftSpacerBgColor` varchar(8) NOT NULL DEFAULT '',
  `LeftSpacerBgImage` varchar(250) NOT NULL DEFAULT '',
  `LeftSpacerBgImageRepeat` varchar(20) NOT NULL DEFAULT '',
  `MidWidth` varchar(4) NOT NULL DEFAULT '0',
  `MidWidthUnit` varchar(5) NOT NULL DEFAULT '',
  `MidBgColor` varchar(7) NOT NULL DEFAULT '',
  `MidBgImage` varchar(250) NOT NULL DEFAULT '',
  `MidBgImageRepeat` varchar(10) NOT NULL DEFAULT '',
  `RightSpacerWidth` int(11) NOT NULL DEFAULT '0',
  `RightSpacerBgColor` varchar(8) NOT NULL DEFAULT '',
  `RightSpacerBgImage` varchar(250) NOT NULL DEFAULT '',
  `RightSpacerBgImageRepeat` varchar(20) NOT NULL DEFAULT '',
  `RightWidth` int(11) NOT NULL DEFAULT '0',
  `RightWidthUnit` varchar(5) NOT NULL DEFAULT '',
  `RightBgColor` varchar(7) NOT NULL DEFAULT '',
  `RightBgImage` varchar(250) NOT NULL DEFAULT '',
  `RightBgImageRepeat` varchar(10) NOT NULL DEFAULT '',
  `FootBgColor` varchar(7) NOT NULL DEFAULT '',
  `FootHeight` int(11) NOT NULL DEFAULT '0',
  `FootBgImage` varchar(250) NOT NULL DEFAULT '',
  `FootBgImageRepeat` varchar(10) NOT NULL DEFAULT '',
  `LayoutStyles` text NOT NULL COMMENT 'json_encoded'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- A tábla adatainak kiíratása `opey_arculat_param`
--

INSERT INTO `opey_arculat_param` (`id`, `IsCustomLayout`, `CustomLayoutId`, `Name`, `Arculat`, `Note`, `ColumnSpacer`, `PageWidth`, `PageWidthUnit`, `PageHeight`, `PageHeightUnit`, `PageBorderWidth`, `PageBorderColor`, `PageAlign`, `PageVAlign`, `BodyBgColor`, `BodyBgImage`, `BodyBgImageRepeat`, `BodyBgProperties`, `ColumnStyle`, `HeadBgColor`, `HeadBgImage`, `HeadBgImageRepeat`, `HeadHeight`, `LeftWidth`, `LeftWidthUnit`, `LeftBgColor`, `LeftBgImage`, `LeftBgImageRepeat`, `LeftSpacerWidth`, `LeftSpacerBgColor`, `LeftSpacerBgImage`, `LeftSpacerBgImageRepeat`, `MidWidth`, `MidWidthUnit`, `MidBgColor`, `MidBgImage`, `MidBgImageRepeat`, `RightSpacerWidth`, `RightSpacerBgColor`, `RightSpacerBgImage`, `RightSpacerBgImageRepeat`, `RightWidth`, `RightWidthUnit`, `RightBgColor`, `RightBgImage`, `RightBgImageRepeat`, `FootBgColor`, `FootHeight`, `FootBgImage`, `FootBgImageRepeat`, `LayoutStyles`) VALUES
(1, 0, NULL, 'Default', 'Default', 'Ez az alap layout', 'F', 980, '', 100, '%', 0, '', 'CENTER', 'TOP', 'f1ffc8', 'parameters/vitabalance//documents/oecms/Design/bodyBg.jpg', 'no-repeat', '', '3ORIG', '', '', 'repeat-x', 194, 221, '', '', '', 'repeat-y', 0, '', '', 'repeat-x', '681', '', 'f1ffc8', '', 'repeat', 0, '', '', 'repeat-x', 78, '', '', '', 'repeat-y', '', 130, '', 'repeat-x', ''),
(2, 0, NULL, 'Admin', 'Default', 'Ez az adminisztr layoutja', 'T', 780, '', 100, '%', 0, '#000000', 'LEFT', 'TOP', '#FFFFFF', '', '', '', 'NONE', '', '', 'repeat', 50, 150, '', '#669992', '', 'repeat', 5, '#177D86', '', '', '', '', '#ffffff', '', 'repeat', 10, '#cccccc', '', '', 150, '', '#FFFFFF', '', '', '#eeeeee', 10, '', 'repeat', ''),
(3, 0, NULL, 'Nincs keret', 'Default', 'Ugy tölti be a modult, hogy nem teszi ki az arculati elemeket', '0', 780, '', 100, '%', 1, 'FF0000', 'LEFT', 'TOP', '#FFFFFF', '', '', '', 'NONE', '', '', '', 1, 150, '', '#FFFFFF', '', '', 10, '#cccccc', '', '', '100', '', '#ffffff', '', '', 10, '#cccccc', '', '', 150, '', '#FFFFFF', '', '', '', 100, '', '', ''),
(4, 0, NULL, 'akadalymentes', 'Default', 'Ez az alap layout', 'T', 780, '', 100, '%', 0, '#000000', 'LEFT', 'TOP', '#000000', '', 'no-repeat', '', 'ONE', '', '', 'repeat', 80, 217, '', '', '', 'repeat-y', 20, '', '', '', '', '', '', '', 'repeat', 20, '', '', '', 30, '', '', '', 'repeat', '', 25, '', 'repeat-y', ''),
(14, 1, 10, 'Atlantisz arculat', '', '', 'F', 0, '', 0, '', 0, '', '', '', '', '', '', '', 'CUSTOM', '', '', '', 0, 0, '', '', '', '', 0, '', '', '', '0', '', '', '', '', 0, '', '', '', 0, '', '', '', '', '', 0, '', '', '');

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_attachment`
--

CREATE TABLE `opey_attachment` (
  `attach_id` int(11) NOT NULL,
  `type` enum('document','link') NOT NULL,
  `owner` varchar(20) NOT NULL,
  `own_id` int(11) NOT NULL,
  `folder_id` int(11) NOT NULL,
  `document_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `url` text NOT NULL,
  `link_type` varchar(10) NOT NULL,
  `target` varchar(10) NOT NULL,
  `sort` int(11) NOT NULL,
  `lang` varchar(3) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf16;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_attachment_edit`
--

CREATE TABLE `opey_attachment_edit` (
  `attach_id` int(11) NOT NULL,
  `type` enum('document','link') NOT NULL,
  `owner` varchar(20) NOT NULL,
  `own_id` int(11) NOT NULL,
  `folder_id` int(11) NOT NULL,
  `document_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `url` text NOT NULL,
  `link_type` varchar(10) NOT NULL,
  `target` varchar(10) NOT NULL,
  `sort` int(11) NOT NULL,
  `lang` varchar(3) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf16;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_autolinks`
--

CREATE TABLE `opey_autolinks` (
  `pn_lid` int(11) NOT NULL,
  `pn_keyword` varchar(100) NOT NULL DEFAULT '',
  `pn_title` varchar(100) NOT NULL DEFAULT '',
  `pn_url` varchar(200) NOT NULL DEFAULT '',
  `pn_comment` text,
  `pn_type` varchar(20) NOT NULL DEFAULT '',
  `pn_target` varchar(10) NOT NULL DEFAULT '',
  `pn_counter` int(11) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- A tábla adatainak kiíratása `opey_autolinks`
--

INSERT INTO `opey_autolinks` (`pn_lid`, `pn_keyword`, `pn_title`, `pn_url`, `pn_comment`, `pn_type`, `pn_target`, `pn_counter`) VALUES
(35, 'patronet', 'PatroNet CMS', 'http://www.patronet.hu', '', 'link', '_blank', 0);

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_blockadmin`
--

CREATE TABLE `opey_blockadmin` (
  `valtozo` varchar(255) NOT NULL DEFAULT '',
  `ertek_hun` text NOT NULL,
  `ertek_eng` text NOT NULL,
  `megjegyzes` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_blocks`
--

CREATE TABLE `opey_blocks` (
  `pn_bid` int(11) UNSIGNED NOT NULL,
  `pn_bkey` varchar(255) NOT NULL DEFAULT '',
  `pn_title` varchar(255) NOT NULL DEFAULT '',
  `pn_content` text NOT NULL,
  `pn_url` varchar(255) NOT NULL DEFAULT '',
  `pn_mid` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `pn_position` char(1) NOT NULL DEFAULT 'l',
  `pn_weight` decimal(10,1) NOT NULL DEFAULT '0.0',
  `pn_active` tinyint(3) UNSIGNED NOT NULL DEFAULT '1',
  `pn_refresh` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `pn_last_update` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `pn_language` varchar(30) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- A tábla adatainak kiíratása `opey_blocks`
--

INSERT INTO `opey_blocks` (`pn_bid`, `pn_bkey`, `pn_title`, `pn_content`, `pn_url`, `pn_mid`, `pn_position`, `pn_weight`, `pn_active`, `pn_refresh`, `pn_last_update`, `pn_language`) VALUES
(8, 'SliderBlock', 'Slider Block', '', '', 0, 'l', '2.0', 1, 3600, '2019-05-30 12:19:21', ''),
(9, 'eShopCategoryNav', 'eShop Category Nav', '', '', 0, 'l', '1.0', 1, 3600, '2019-05-30 12:19:21', '');

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_columns_edit`
--

CREATE TABLE `opey_columns_edit` (
  `id` bigint(20) NOT NULL,
  `page_id` int(11) NOT NULL DEFAULT '0',
  `sorszam` tinyint(4) NOT NULL DEFAULT '0',
  `pozicio` varchar(20) NOT NULL DEFAULT '',
  `obj_tipus` varchar(50) NOT NULL DEFAULT '',
  `tartalom` longtext NOT NULL,
  `params` text NOT NULL,
  `tabla` int(11) NOT NULL DEFAULT '0',
  `tr` int(11) NOT NULL DEFAULT '0',
  `td` int(11) NOT NULL DEFAULT '0',
  `lang` varchar(10) NOT NULL DEFAULT 'def',
  `locked` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_columns_objects`
--

CREATE TABLE `opey_columns_objects` (
  `id` bigint(20) NOT NULL,
  `page_id` int(11) NOT NULL DEFAULT '0',
  `sorszam` tinyint(4) NOT NULL DEFAULT '0',
  `pozicio` varchar(20) NOT NULL DEFAULT '',
  `obj_tipus` varchar(50) NOT NULL DEFAULT '',
  `tartalom` longtext NOT NULL,
  `params` text NOT NULL,
  `tabla` int(11) NOT NULL DEFAULT '0',
  `tr` int(11) NOT NULL DEFAULT '0',
  `td` int(11) NOT NULL DEFAULT '0',
  `lang` varchar(10) NOT NULL DEFAULT 'hun',
  `locked` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- A tábla adatainak kiíratása `opey_columns_objects`
--

INSERT INTO `opey_columns_objects` (`id`, `page_id`, `sorszam`, `pozicio`, `obj_tipus`, `tartalom`, `params`, `tabla`, `tr`, `td`, `lang`, `locked`) VALUES
(1130, 1, 1, 'footer-secondary', 'freehtml', '', '', 0, 0, 0, 'hun', 0);

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_columns_pages`
--

CREATE TABLE `opey_columns_pages` (
  `shortlink_id` int(11) NOT NULL DEFAULT '0',
  `modosithato` char(1) NOT NULL DEFAULT 'I',
  `mod_sessid` varchar(50) NOT NULL DEFAULT '',
  `mod_uid` varchar(5) NOT NULL DEFAULT '',
  `mod_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- A tábla adatainak kiíratása `opey_columns_pages`
--

INSERT INTO `opey_columns_pages` (`shortlink_id`, `modosithato`, `mod_sessid`, `mod_uid`, `mod_time`) VALUES
(1, 'I', '', '', '0000-00-00 00:00:00'),
(1, 'I', '', '', '0000-00-00 00:00:00'),
(1, 'I', '', '', '0000-00-00 00:00:00'),
(1, 'I', '', '', '0000-00-00 00:00:00'),
(1, 'I', '', '', '0000-00-00 00:00:00'),
(1, 'I', '', '', '0000-00-00 00:00:00'),
(1, 'I', '', '', '0000-00-00 00:00:00'),
(1, 'I', '', '', '0000-00-00 00:00:00'),
(1, 'I', '', '', '0000-00-00 00:00:00'),
(1, 'I', '', '', '0000-00-00 00:00:00'),
(1, 'I', '', '', '0000-00-00 00:00:00'),
(1, 'I', '', '', '0000-00-00 00:00:00'),
(1, 'I', '', '', '0000-00-00 00:00:00'),
(1, 'I', '', '', '0000-00-00 00:00:00'),
(1, 'I', '', '', '0000-00-00 00:00:00'),
(1, 'I', '', '', '0000-00-00 00:00:00'),
(1, 'I', '', '', '0000-00-00 00:00:00'),
(1, 'I', '', '', '0000-00-00 00:00:00'),
(1, 'I', '', '', '0000-00-00 00:00:00'),
(1, 'I', '', '', '0000-00-00 00:00:00'),
(1, 'I', '', '', '0000-00-00 00:00:00'),
(1, 'I', '', '', '0000-00-00 00:00:00'),
(1, 'I', '', '', '0000-00-00 00:00:00'),
(1, 'I', '', '', '0000-00-00 00:00:00'),
(1, 'I', '', '', '0000-00-00 00:00:00'),
(1, 'I', '', '', '0000-00-00 00:00:00'),
(1, 'I', '', '', '0000-00-00 00:00:00'),
(1, 'I', '', '', '0000-00-00 00:00:00'),
(1, 'I', '', '', '0000-00-00 00:00:00'),
(1, 'I', '', '', '0000-00-00 00:00:00'),
(1, 'I', '', '', '0000-00-00 00:00:00'),
(1, 'I', '', '', '0000-00-00 00:00:00'),
(1, 'I', '', '', '0000-00-00 00:00:00'),
(1, 'I', '', '', '0000-00-00 00:00:00'),
(1, 'I', '', '', '0000-00-00 00:00:00'),
(1, 'I', '', '', '0000-00-00 00:00:00'),
(1, 'I', '', '', '0000-00-00 00:00:00'),
(1, 'I', '', '', '0000-00-00 00:00:00'),
(1, 'I', '', '', '0000-00-00 00:00:00');

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_contact_us_email`
--

CREATE TABLE `opey_contact_us_email` (
  `id` int(11) NOT NULL,
  `nev` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `sorszam` int(11) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_contact_us_lang`
--

CREATE TABLE `opey_contact_us_lang` (
  `cu_id` int(11) NOT NULL DEFAULT '0',
  `nev` varchar(255) NOT NULL DEFAULT '',
  `lang` char(3) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_counter`
--

CREATE TABLE `opey_counter` (
  `pn_type` varchar(80) NOT NULL DEFAULT '',
  `pn_var` varchar(80) NOT NULL DEFAULT '',
  `pn_count` int(11) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_currency_codes`
--

CREATE TABLE `opey_currency_codes` (
  `CurrencyCoded` char(3) NOT NULL DEFAULT '',
  `CurrencyName` varchar(255) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- A tábla adatainak kiíratása `opey_currency_codes`
--

INSERT INTO `opey_currency_codes` (`CurrencyCoded`, `CurrencyName`) VALUES
('AFA', 'Afghani'),
('ALL', 'Leck'),
('DZD', 'Algerian Dinar'),
('ADP', 'Andorran Peseta'),
('AOA', 'Kwanza'),
('ARS', 'Argentine Peso'),
('AMD', 'Armenian Dram'),
('AWG', 'Aruban Guilder'),
('AZM', 'Azerbaijanian Manat'),
('BSD', 'Bahamian Dollar'),
('BHD', 'Bahraini Dinar'),
('BDT', 'Taka'),
('BBD', 'Barbados Dollar'),
('BYR', 'Belarussian Ruble'),
('BZD', 'Belize Dollar'),
('BMD', 'Bermudian Dollar'),
('BTN', 'Ngultrum'),
('INR', 'Indian Rupee'),
('BOV', 'Mvdol'),
('BOB', 'Boliviano'),
('BAM', 'Convertible Marks'),
('BWP', 'Pula'),
('BRL', 'Brazilian Real'),
('BND', 'Brunei Dollar'),
('BGL', 'Lev'),
('BGN', 'Bulgarian Lev'),
('BIF', 'Burundi Franc'),
('KHR', 'Riel'),
('CAD', 'Canadian Dollar'),
('CVE', 'Cape Verde Escudo'),
('KYD', 'Cayman Islands Dollar'),
('XAF', 'CFA Franc BEAC'),
('CLF', 'Unidades de fomento'),
('CLP', 'Chilean Peso'),
('CNY', 'Yuan Renminbi'),
('COP', 'Colombian Peso'),
('KMF', 'Comoro Franc'),
('CDF', 'Franc Congolais'),
('CRC', 'Costa Rican Colon'),
('HRK', 'Croatian kuna'),
('CUP', 'Cuban Peso'),
('CYP', 'Cyprus Pound'),
('CZK', 'Czech Koruna'),
('DKK', 'Danish Krone'),
('DJF', 'Djibouti Franc'),
('DOP', 'Dominican Peso'),
('TPE', 'Timor Escudo'),
('ECV', 'Unidad de Valor Constante (UVC)'),
('ECS', 'Sucre'),
('EGP', 'Egyptian Pound'),
('SVC', 'El Salvador Colon'),
('ERN', 'Nakfa'),
('EEK', 'Kroon'),
('ETB', 'Ethiopian Birr'),
('FKP', 'Falkland Islands Pound'),
('FJD', 'Fiji Dollar'),
('GMD', 'Dalasi'),
('GEL', 'Lari'),
('GHC', 'Cedi'),
('GIP', 'Gibraltar Pound'),
('GTQ', 'Quetzal'),
('GNF', 'Guinea Franc'),
('GWP', 'Guinea-Bissau Peso'),
('GYD', 'Guyana Dollar'),
('HTG', 'Gourde'),
('HNL', 'Lempira'),
('HKD', 'Hong Kong Dollar'),
('HUF', 'Forint'),
('ISK', 'Iceland Krona'),
('IDR', 'Rupiah'),
('IRR', 'Iranian Rial'),
('IQD', 'Iraqi Dinar'),
('ILS', 'New Israeli Sheqel'),
('JMD', 'Jamaican Dollar'),
('JPY', 'Yen'),
('JOD', 'Jordanian Dinar'),
('KZT', 'Tenge'),
('KES', 'Kenyan Shilling'),
('AUD', 'Australian Dollar'),
('KPW', 'North Korean Won'),
('KRW', 'Won'),
('KWD', 'Kuwaiti Dinar'),
('KGS', 'Som'),
('LAK', 'Kip'),
('LVL', 'Latvian Lats'),
('LBP', 'Lebanese Pound'),
('LSL', 'Loti'),
('LRD', 'Liberian Dollar'),
('LYD', 'Lybian Dinar'),
('CHF', 'Swiss Franc'),
('LTL', 'Lithuanian Litus'),
('MOP', 'Pataca'),
('MKD', 'Denar'),
('MGF', 'Malagasy Franc'),
('MWK', 'Kwacha'),
('MYR', 'Malaysian Ringgit'),
('MVR', 'Rufiyaa'),
('MTL', 'Maltese Lira'),
('EUR', 'Euro'),
('MRO', 'Ouguiya'),
('MUR', 'Mauritius Rupee'),
('MXN', 'Mexican Peso'),
('MXV', 'Mexican Unidad de Inversion (UDI)'),
('MDL', 'Moldovan Leu'),
('MNT', 'Tugrik'),
('XCD', 'East Caribbean Dollar'),
('MZM', 'Metical'),
('MMK', 'Kyat'),
('ZAR', 'Rand'),
('NAD', 'Namibia Dollar'),
('NPR', 'Nepalese Rupee'),
('ANG', 'Netherlands Antillan Guilder'),
('XPF', 'CFP Franc'),
('NIO', 'Cordoba Oro'),
('NGN', 'Naira'),
('NOK', 'Norwegian Krone'),
('OMR', 'Rial Omani'),
('PKR', 'Pakistan Rupee'),
('PAB', 'Balboa'),
('PGK', 'Kina'),
('PYG', 'Guarani'),
('PEN', 'Nuevo Sol'),
('PHP', 'Philippine Peso'),
('PLN', 'Zloty'),
('USD', 'US Dollar'),
('QAR', 'Qatari Rial'),
('ROL', 'Leu'),
('RUB', 'Russian Ruble'),
('RUR', 'Russian Ruble'),
('RWF', 'Rwanda Franc'),
('SHP', 'Saint Helena Pound'),
('WST', 'Tala'),
('STD', 'Dobra'),
('SAR', 'Saudi Riyal'),
('SCR', 'Seychelles Rupee'),
('SLL', 'Leone'),
('SGD', 'Singapore Dollar'),
('SKK', 'Slovak Koruna'),
('SIT', 'Tolar'),
('SBD', 'Solomon Islands Dollar'),
('SOS', 'Somali Shilling'),
('LKR', 'Sri Lanka Rupee'),
('SDD', 'Sudanese Dinar'),
('SRG', 'Suriname Guilder'),
('SZL', 'Lilangeni'),
('SEK', 'Swedish Krona'),
('SYP', 'Syrian Pound'),
('TWD', 'New Taiwan Dollar'),
('TJS', 'Somoni'),
('TZS', 'Tanzanian Shilling'),
('THB', 'Baht'),
('XOF', 'CFA Franc BCEAO'),
('NZD', 'New Zealand Dollar'),
('TOP', 'Pa`anga'),
('TTD', 'Trinidad and Tobago Dollar'),
('TND', 'Tunisian Dinar'),
('TRL', 'Turkish Lira'),
('TMM', 'Manat'),
('UGX', 'Uganda Shilling'),
('UAH', 'Hryvnia'),
('AED', 'UAE Dirham'),
('GBP', 'Pound Sterling'),
('USS', 'US Dollar (Same day)'),
('USN', 'US Dollar (Next day)'),
('UYU', 'Peso Uruguayo'),
('UZS', 'Uzbekistan Sum'),
('VUV', 'Vatu'),
('VEB', 'Bolivar'),
('VND', 'Dong'),
('MAD', 'Moroccan Dirham'),
('YER', 'Yemeni Rial'),
('YUM', 'Yugoslavian Dinar'),
('ZMK', 'Kwacha'),
('ZWD', 'Zimbabwe Dollar');

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_customlayout`
--

CREATE TABLE `opey_customlayout` (
  `customlayout_id` int(11) NOT NULL,
  `pnlayout_id` int(11) DEFAULT NULL,
  `module` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `json_parameters` text NOT NULL,
  `additionalcss` text NOT NULL,
  `additionalhead` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- A tábla adatainak kiíratása `opey_customlayout`
--

INSERT INTO `opey_customlayout` (`customlayout_id`, `pnlayout_id`, `module`, `label`, `description`, `json_parameters`, `additionalcss`, `additionalhead`) VALUES
(10, 14, 'site.atlantisz', 'Atlantisz arculat', '', '[]', '', '');

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_eventcalendar`
--

CREATE TABLE `opey_eventcalendar` (
  `id` int(11) NOT NULL,
  `linked_id` int(11) NOT NULL,
  `ev` year(4) NOT NULL,
  `honap` tinyint(4) NOT NULL,
  `type` enum('time','period') NOT NULL DEFAULT 'time',
  `date_from` date NOT NULL,
  `date_time` varchar(100) CHARACTER SET utf8 NOT NULL,
  `date_to` date NOT NULL,
  `name_hun` varchar(255) CHARACTER SET utf8 NOT NULL,
  `place_hun` text CHARACTER SET utf8 NOT NULL,
  `author_hun` varchar(255) CHARACTER SET utf8 NOT NULL,
  `contact_hun` text CHARACTER SET utf8 NOT NULL,
  `description_hun` text CHARACTER SET utf8 NOT NULL,
  `name_eng` varchar(255) CHARACTER SET utf8 NOT NULL,
  `place_eng` text CHARACTER SET utf8 NOT NULL,
  `author_eng` varchar(255) CHARACTER SET utf8 NOT NULL,
  `contact_eng` text CHARACTER SET utf8 NOT NULL,
  `description_eng` text CHARACTER SET utf8 NOT NULL,
  `name_deu` varchar(255) CHARACTER SET utf8 NOT NULL,
  `place_deu` text CHARACTER SET utf8 NOT NULL,
  `author_deu` varchar(255) CHARACTER SET utf8 NOT NULL,
  `contact_deu` text CHARACTER SET utf8 NOT NULL,
  `description_deu` text CHARACTER SET utf8 NOT NULL,
  `name_fra` varchar(255) CHARACTER SET utf8 NOT NULL,
  `place_fra` text CHARACTER SET utf8 NOT NULL,
  `author_fra` varchar(255) CHARACTER SET utf8 NOT NULL,
  `contact_fra` text CHARACTER SET utf8 NOT NULL,
  `description_fra` text CHARACTER SET utf8 NOT NULL,
  `name_ron` varchar(255) CHARACTER SET utf8 NOT NULL,
  `place_ron` text CHARACTER SET utf8 NOT NULL,
  `author_ron` varchar(255) CHARACTER SET utf8 NOT NULL,
  `contact_ron` text CHARACTER SET utf8 NOT NULL,
  `description_ron` text CHARACTER SET utf8 NOT NULL,
  `name_ita` varchar(255) CHARACTER SET utf8 NOT NULL,
  `place_ita` text CHARACTER SET utf8 NOT NULL,
  `author_ita` varchar(255) CHARACTER SET utf8 NOT NULL,
  `contact_ita` text CHARACTER SET utf8 NOT NULL,
  `description_ita` text CHARACTER SET utf8 NOT NULL,
  `groups` varchar(255) CHARACTER SET utf8 NOT NULL,
  `background_color` varchar(20) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_eventcalendar_perm`
--

CREATE TABLE `opey_eventcalendar_perm` (
  `id` int(10) NOT NULL,
  `eventId` int(10) NOT NULL,
  `groupId` varchar(255) CHARACTER SET utf8 NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_event_delayed`
--

CREATE TABLE `opey_event_delayed` (
  `event_id` bigint(20) NOT NULL,
  `datetime_registered` datetime NOT NULL,
  `datetime_trigger` datetime NOT NULL,
  `registrator` varchar(50) COLLATE utf8_hungarian_ci NOT NULL,
  `handler` varchar(50) COLLATE utf8_hungarian_ci NOT NULL,
  `eventname` varchar(50) COLLATE utf8_hungarian_ci NOT NULL,
  `json_data` text COLLATE utf8_hungarian_ci NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_hungarian_ci;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_faqanswer`
--

CREATE TABLE `opey_faqanswer` (
  `pn_id` int(11) NOT NULL,
  `pn_id_cat` int(11) DEFAULT NULL,
  `order` int(11) NOT NULL,
  `pn_ishtml` tinyint(4) NOT NULL DEFAULT '0',
  `pn_question` text,
  `pn_answer` text,
  `pn_submittedby` varchar(250) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_faqcategories`
--

CREATE TABLE `opey_faqcategories` (
  `pn_id_cat` int(11) NOT NULL,
  `pn_categories` varchar(255) DEFAULT NULL,
  `pn_description` text NOT NULL,
  `pn_language` varchar(30) NOT NULL DEFAULT '',
  `pn_parent_id` tinyint(3) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_form_sent`
--

CREATE TABLE `opey_form_sent` (
  `fid` int(11) NOT NULL,
  `form_name` varchar(255) CHARACTER SET utf8 NOT NULL,
  `form_url` varchar(255) CHARACTER SET utf8 NOT NULL,
  `form_recipient` varchar(255) CHARACTER SET utf8 NOT NULL,
  `form_mail_content` longtext CHARACTER SET utf8 NOT NULL,
  `sender_ip` varchar(25) CHARACTER SET utf8 NOT NULL,
  `sender_useragent` varchar(255) CHARACTER SET utf8 NOT NULL,
  `referer_page` varchar(255) CHARACTER SET utf8 NOT NULL,
  `ref_search_keywords` varchar(255) CHARACTER SET utf8 NOT NULL,
  `ref_search_page` varchar(255) CHARACTER SET utf8 NOT NULL,
  `campaign_id` varchar(100) CHARACTER SET utf8 NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- A tábla adatainak kiíratása `opey_form_sent`
--

INSERT INTO `opey_form_sent` (`fid`, `form_name`, `form_url`, `form_recipient`, `form_mail_content`, `sender_ip`, `sender_useragent`, `referer_page`, `ref_search_keywords`, `ref_search_page`, `campaign_id`) VALUES
(1, 'kapcsolat', 'http://iparitisztitoszer.patronet.hu/kapcsolat', 'iroda@rlphigienia.hu', '<br><font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Message from the Ipari tisztítószer <br>website: http://iparitisztitoszer.patronet.hu</b><br><br>Sending time: 2016-06-01 10:53:27</font><br><br>\r\n			<table width=550 cellpadding=''3'' cellspacing=0 >\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Nev: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >fgsfdgfg&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Telefonszam: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >fdgfds&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Email: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >sdafgsdfg&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Uzenet: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >dfsagsdg&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>referer page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >http://iparitisztitoszer.patronet.hu/kiszallitas&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search keywords: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>campaign id: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>form name: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >kapcsolat&nbsp;</font></td></tr>\n</table>', '193.91.81.217', 'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/46.0.2486.0 Safari/537.36 Edge/13.10586', 'http://iparitisztitoszer.patronet.hu/kiszallitas', '', '', ''),
(2, 'kapcsolat', 'http://iparitisztitoszer.patronet.hu/kapcsolat', 'iroda@rlphigienia.hu', '<br><font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Message from the Ipari tisztítószer <br>website: http://iparitisztitoszer.patronet.hu</b><br><br>Sending time: 2016-07-18 15:01:49</font><br><br>\r\n			<table width=550 cellpadding=''3'' cellspacing=0 >\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Nev: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >Bodnár otília&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Telefonszam: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >1234546789&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Email: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >bodnaroti@vipmail.hu&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Uzenet: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >teszt üzenet Otitól<br />\r\nSzép napot nektek!&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>referer page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >http://iparitisztitoszer.patronet.hu/webaruhaz?&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search keywords: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>campaign id: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>form name: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >kapcsolat&nbsp;</font></td></tr>\n</table>', '178.48.31.249', 'Mozilla/5.0 (Windows NT 6.1; rv:47.0) Gecko/20100101 Firefox/47.0', 'http://iparitisztitoszer.patronet.hu/webaruhaz?', '', '', ''),
(3, 'kapcsolat', 'http://ipari-tisztitoszer.hu/kapcsolat', 'iroda@rlphigienia.hu', '<br><font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Message from the Ipari tisztítószer <br>website: http://ipari-tisztitoszer.hu</b><br><br>Sending time: 2016-08-08 13:54:34</font><br><br>\r\n			<table width=550 cellpadding=''3'' cellspacing=0 >\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Nev: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >Balláné Pétervári Zsuzsanna&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Telefonszam: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >30/828-1089&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Email: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >petevari.zsuzsanna@hm.gov.hu&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Uzenet: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >Kérnék szépen árajánlatot Önöktől 1 literes kiszerelésű, kézkímélő zsíroldó kézi mosogatószerre.<br />\r\nKöszönettel:<br />\r\n<br />\r\nBalláné Pétervári Zsuzsanna<br />\r\nMH Egészségügyi Központ<br />\r\nÉlelmezési Alosztály<br />\r\nalostályvezető&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>referer page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >http://ipari-tisztitoszer.hu/webaruhaz/tisztitoszerek/konyhahigieniahoz/kezi-mosogatoszerek&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search keywords: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>campaign id: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>form name: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >kapcsolat&nbsp;</font></td></tr>\n</table>', '193.225.105.50', 'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.103 Safari/537.36', 'http://ipari-tisztitoszer.hu/webaruhaz/tisztitoszerek/konyhahigieniahoz/kezi-mosogatoszerek', '', '', ''),
(4, 'rlphigiénia ajánlatkérés', 'http://rlphigienia.patronet.hu/ajanlatkeres', 'iroda@rlphigienia.hu', '<br><font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Message from the Ipari tisztítószer <br>website: http://rlphigienia.patronet.hu</b><br><br>Sending time: 2016-09-28 14:20:48</font><br><br>\r\n			<table width=550 cellpadding=''3'' cellspacing=0 >\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Cégnév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >patronet&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Vezetéknév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >teszt&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Keresztnév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >oti&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Telefonszám: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >06-30-33333333&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>E-mail: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >bodnaroti@vipmail.hu&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Üzenet: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >teszt küldése &nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>referer page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >http://rlphigienia.patronet.hu/szolgaltatasaink&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search keywords: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>campaign id: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>form name: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >rlphigiénia ajánlatkérés&nbsp;</font></td></tr>\n</table>', '178.48.31.249', 'Mozilla/5.0 (Windows NT 6.1; rv:49.0) Gecko/20100101 Firefox/49.0', 'http://rlphigienia.patronet.hu/szolgaltatasaink', '', '', ''),
(5, 'rlphigiénia ajánlatkérés', 'http://rlphigienia.patronet.hu/ajanlatkeres', 'otilia.bodnar@patronet.net', '<br><font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Message from the Ipari tisztítószer <br>website: http://rlphigienia.patronet.hu</b><br><br>Sending time: 2016-09-28 14:22:13</font><br><br>\r\n			<table width=550 cellpadding=''3'' cellspacing=0 >\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Cégnév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >oti&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Vezetéknév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >teszt&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Keresztnév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >teszt&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Telefonszám: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >06-30-333333&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>E-mail: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >otilia.bodnar@patronet.net&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Üzenet: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >teszt üzenet &nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>referer page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >http://rlphigienia.patronet.hu/ajanlatkeres/sent&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search keywords: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>campaign id: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>form name: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >rlphigiénia ajánlatkérés&nbsp;</font></td></tr>\n</table>', '178.48.31.249', 'Mozilla/5.0 (Windows NT 6.1; rv:49.0) Gecko/20100101 Firefox/49.0', 'http://rlphigienia.patronet.hu/ajanlatkeres/sent', '', '', ''),
(6, 'rlphigiénia ajánlatkérés', 'http://rlphigienia.patronet.hu/ajanlatkeres', 'otilia.bodnar@patronet.net', '<br><font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Message from the Ipari tisztítószer <br>website: http://rlphigienia.patronet.hu</b><br><br>Sending time: 2016-09-28 14:23:25</font><br><br>\r\n			<table width=550 cellpadding=''3'' cellspacing=0 >\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Cégnév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >teszt&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Vezetéknév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >oti&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Keresztnév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >tika&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Telefonszám: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>E-mail: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >szvass77@gamil.com&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Üzenet: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >ziwuhwzgwvg9qzv9e7zg9e7zvg9qeizqervg7rtzg79rezgrezg9rezgrz r7zqeigqi duhfdiqhfqz9&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>referer page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >http://rlphigienia.patronet.hu/ajanlatkeres/sent&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search keywords: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>campaign id: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>form name: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >rlphigiénia ajánlatkérés&nbsp;</font></td></tr>\n</table>', '178.48.31.249', 'Mozilla/5.0 (Windows NT 6.1; rv:49.0) Gecko/20100101 Firefox/49.0', 'http://rlphigienia.patronet.hu/ajanlatkeres/sent', '', '', ''),
(7, 'rlphigiénia ajánlatkérés', 'http://rlphigienia.patronet.hu/ajanlatkeres', 'otilia.bodnar@patronet.net', '<br><font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Message from the Ipari tisztítószer <br>website: http://rlphigienia.patronet.hu</b><br><br>Sending time: 2016-09-28 14:25:31</font><br><br>\r\n			<table width=550 cellpadding=''3'' cellspacing=0 >\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Cégnév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >derr&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Vezetéknév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Keresztnév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >rzhjerzhjrz&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Telefonszám: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >06-30-3554798584589&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>E-mail: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >otilia.bodnar@patron&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Üzenet: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >fvlifahgiehbohueboufdakb rhuihiuhbi huihuihf uihailhui uihlaihli auihlifh auhvgiauhih&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>referer page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >http://rlphigienia.patronet.hu/ajanlatkeres/sent&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search keywords: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>campaign id: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>form name: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >rlphigiénia ajánlatkérés&nbsp;</font></td></tr>\n</table>', '178.48.31.249', 'Mozilla/5.0 (Windows NT 6.1; rv:49.0) Gecko/20100101 Firefox/49.0', 'http://rlphigienia.patronet.hu/ajanlatkeres/sent', '', '', ''),
(8, 'rlphigiénia ajánlatkérés', 'http://rlphigienia.patronet.hu/ajanlatkeres', 'otilia.bodnar@patronet.net', '<br><font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Message from the Ipari tisztítószer <br>website: http://rlphigienia.patronet.hu</b><br><br>Sending time: 2016-09-30 14:48:34</font><br><br>\r\n			<table width=550 cellpadding=''3'' cellspacing=0 >\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Cégnév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >PatroNet Kft.&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Vezetéknév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >Horváth&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Keresztnév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >Dávid&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Telefonszám: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >1111111&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>E-mail: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >horvath@patronet.net&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Üzenet: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >asdf&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>referer page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search keywords: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>campaign id: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>form name: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >rlphigiénia ajánlatkérés&nbsp;</font></td></tr>\n</table>', '178.48.31.249', 'Mozilla/5.0 (X11; Linux x86_64; rv:50.0) Gecko/20100101 Firefox/50.0', '', '', '', ''),
(9, 'rlphigiénia ajánlatkérés', 'http://rlphigienia.patronet.hu/ajanlatkeres', 'otilia.bodnar@patronet.net', '<br><font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Message from the Ipari tisztítószer <br>website: http://rlphigienia.patronet.hu</b><br><br>Sending time: 2016-09-30 16:31:00</font><br><br>\r\n			<table width=550 cellpadding=''3'' cellspacing=0 >\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Cégnév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Vezetéknév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Keresztnév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Telefonszám: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>E-mail: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Üzenet: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>referer page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search keywords: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>campaign id: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>form name: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >rlphigiénia ajánlatkérés&nbsp;</font></td></tr>\n</table>', '178.48.31.249', 'Mozilla/5.0 (X11; Linux x86_64; rv:50.0) Gecko/20100101 Firefox/50.0', '', '', '', ''),
(10, 'rlphigiénia ajánlatkérés', 'http://rlphigienia.patronet.hu/ajanlatkeres', 'otilia.bodnar@patronet.net', '<br><font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Message from the Ipari tisztítószer <br>website: http://rlphigienia.patronet.hu</b><br><br>Sending time: 2016-09-30 18:00:47</font><br><br>\r\n			<table width=550 cellpadding=''3'' cellspacing=0 >\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Cégnév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Vezetéknév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Keresztnév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Telefon: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>E-mail: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Üzenet: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>referer page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search keywords: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>campaign id: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>form name: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >rlphigiénia ajánlatkérés&nbsp;</font></td></tr>\n</table>', '178.48.31.249', 'Mozilla/5.0 (X11; Linux x86_64; rv:50.0) Gecko/20100101 Firefox/50.0', '', '', '', ''),
(11, 'rlphigiénia ajánlatkérés', 'http://rlphigienia.patronet.hu/ajanlatkeres', 'otilia.bodnar@patronet.net', '<br><font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Message from the Ipari tisztítószer <br>website: http://rlphigienia.patronet.hu</b><br><br>Sending time: 2016-09-30 18:03:10</font><br><br>\r\n			<table width=550 cellpadding=''3'' cellspacing=0 >\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Cégnév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >PatroNet Kft.&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Vezetéknév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >Horváth&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Keresztnév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >Dávid&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Telefon: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >1234&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>E-mail: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >horvath@patronet.net&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Üzenet: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >Teszt&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>referer page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search keywords: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>campaign id: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>form name: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >rlphigiénia ajánlatkérés&nbsp;</font></td></tr>\n</table>', '178.48.31.249', 'Mozilla/5.0 (X11; Linux x86_64; rv:50.0) Gecko/20100101 Firefox/50.0', '', '', '', ''),
(12, 'rlphigiénia ajánlatkérés', 'http://rlphigienia.patronet.hu/ajanlatkeres', 'otilia.bodnar@patronet.net', '<br><font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Message from the Ipari tisztítószer <br>website: http://rlphigienia.patronet.hu</b><br><br>Sending time: 2016-10-04 16:10:16</font><br><br>\r\n			<table width=550 cellpadding=''3'' cellspacing=0 >\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Cégnév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >patronet&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Vezetéknév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >Bodnár&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Keresztnév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >Oti&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Telefon: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >121131&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>E-mail: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >otilia.bodnar@patronet.net&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Üzenet: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >rehesthaethetheqwthaewth&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>referer page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >http://rlphigienia.patronet.hu/&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search keywords: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>campaign id: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>form name: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >rlphigiénia ajánlatkérés&nbsp;</font></td></tr>\n</table>', '178.48.31.249', 'Mozilla/5.0 (Windows NT 6.1; rv:49.0) Gecko/20100101 Firefox/49.0', 'http://rlphigienia.patronet.hu/', '', '', '');
INSERT INTO `opey_form_sent` (`fid`, `form_name`, `form_url`, `form_recipient`, `form_mail_content`, `sender_ip`, `sender_useragent`, `referer_page`, `ref_search_keywords`, `ref_search_page`, `campaign_id`) VALUES
(13, 'rlphigiénia ajánlatkérés', 'http://rlphigienia.patronet.hu/ajanlatkeres', 'otilia.bodnar@patronet.net', '<br><font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Message from the Ipari tisztítószer <br>website: http://rlphigienia.patronet.hu</b><br><br>Sending time: 2016-10-05 08:45:44</font><br><br>\r\n			<table width=550 cellpadding=''3'' cellspacing=0 >\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Cégnév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >Ro-Land Plus Kft.&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Vezetéknév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >Rozmüller&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Keresztnév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >Krisztián&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Telefon: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >06703674580&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>E-mail: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >iroda@rlphigienia.hu&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Üzenet: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >kkkkkkkkkkkkkkksaldggggggggggggggggggggggkjkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkddddddddddddddddddddddddddddddddddd&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>referer page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >http://rlphigienia.patronet.hu/rolunk&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search keywords: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>campaign id: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>form name: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >rlphigiénia ajánlatkérés&nbsp;</font></td></tr>\n</table>', '87.97.108.183', 'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/53.0.2785.143 Safari/537.36', 'http://rlphigienia.patronet.hu/rolunk', '', '', ''),
(14, 'rlphigiénia ajánlatkérés', 'http://rlphigienia.patronet.hu/ajanlatkeres', 'otilia.bodnar@patronet.net', '<br><font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Message from the Ipari tisztítószer <br>website: http://rlphigienia.patronet.hu</b><br><br>Sending time: 2016-10-05 10:16:28</font><br><br>\r\n			<table width=550 cellpadding=''3'' cellspacing=0 >\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Cégnév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >Patronet&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Vezetéknév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >Bodnár&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Keresztnév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >Otilia&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Telefon: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >1555555&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>E-mail: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >otilia.bodnar@patronet.net&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Üzenet: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >hiwvgiwgvizqgvzuewgvzqegvuzqgvzegvzgvzigvizrqwgvigvigvigivgwivgizgvirgvzirgvligvizgvizgvli&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>referer page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >http://rlphigienia.patronet.hu/&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search keywords: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>campaign id: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>form name: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >rlphigiénia ajánlatkérés&nbsp;</font></td></tr>\n</table>', '178.48.31.249', 'Mozilla/5.0 (Windows NT 6.1; rv:49.0) Gecko/20100101 Firefox/49.0', 'http://rlphigienia.patronet.hu/', '', '', ''),
(15, 'rlphigiénia ajánlatkérés', 'http://rlphigienia.patronet.hu/ajanlatkeres', 'otilia.bodnar@patronet.net', '<br><font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Message from the Ipari tisztítószer <br>website: http://rlphigienia.patronet.hu</b><br><br>Sending time: 2016-10-05 15:48:55</font><br><br>\r\n			<table width=550 cellpadding=''3'' cellspacing=0 >\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Cégnév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >PatroNet Kft.&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Vezetéknév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >Horváth&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Keresztnév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >Dávid&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Telefon: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >1234&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>E-mail: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >horvath@patronet.net&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Üzenet: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >lila lali&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>referer page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >http://rlphigienia.patronet.hu/&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search keywords: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>campaign id: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>form name: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >rlphigiénia ajánlatkérés&nbsp;</font></td></tr>\n</table>', '178.48.31.249', 'Mozilla/5.0 (X11; Linux x86_64; rv:50.0) Gecko/20100101 Firefox/50.0', 'http://rlphigienia.patronet.hu/', '', '', ''),
(16, 'rlphigiénia ajánlatkérés', 'http://rlphigienia.patronet.hu/ajanlatkeres', 'iroda@rlphigienia.hu', '<br><font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Message from the Ipari tisztítószer <br>website: http://rlphigienia.patronet.hu</b><br><br>Sending time: 2016-10-06 15:09:54</font><br><br>\r\n			<table width=550 cellpadding=''3'' cellspacing=0 >\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Cégnév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >patronet teszt&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Vezetéknév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >Bodnár&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Keresztnév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >Otilia&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Telefon: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >4544646464646&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>E-mail: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >otilia.bodnar@patronet.net&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Üzenet: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >huhnohohnoéijnoéidfjnojdfonijjnkjcnjijnoidjnjd&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>referer page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >http://rlphigienia.patronet.hu/szolgaltatasaink/szaktanacsadas-szakmai-trening&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search keywords: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>campaign id: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>form name: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >rlphigiénia ajánlatkérés&nbsp;</font></td></tr>\n</table>', '178.48.31.249', 'Mozilla/5.0 (Windows NT 6.1; rv:49.0) Gecko/20100101 Firefox/49.0', 'http://rlphigienia.patronet.hu/szolgaltatasaink/szaktanacsadas-szakmai-trening', '', '', ''),
(17, 'rlphigiénia ajánlatkérés', 'http://rlphigienia.patronet.hu/ajanlatkeres', 'iroda@rlphigienia.hu', '<br><font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Message from the Ipari tisztítószer <br>website: http://rlphigienia.patronet.hu</b><br><br>Sending time: 2016-10-13 12:29:17</font><br><br>\r\n			<table width=550 cellpadding=''3'' cellspacing=0 >\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Cégnév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >teszt cég&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Vezetéknév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >vass&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Keresztnév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >szilvia&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Telefon: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >0614520050&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>E-mail: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >vass@patronet.net&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Üzenet: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >teszt&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>referer page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >http://rlphigienia.patronet.hu/&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search keywords: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>campaign id: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>form name: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >rlphigiénia ajánlatkérés&nbsp;</font></td></tr>\n</table>', '178.48.31.249', 'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/53.0.2785.143 Safari/537.36', 'http://rlphigienia.patronet.hu/', '', '', ''),
(18, 'rlphigiénia ajánlatkérés', 'http://rlphigienia.patronet.hu/ajanlatkeres', 'iroda@rlphigienia.hu', '<br><font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Message from the Ipari tisztítószer <br>website: http://rlphigienia.patronet.hu</b><br><br>Sending time: 2016-10-27 15:52:54</font><br><br>\r\n			<table width=550 cellpadding=''3'' cellspacing=0 >\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Cégnév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >Oti teszt&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Vezetéknév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >oti&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Keresztnév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >teszt&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Telefon: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >145258955&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>E-mail: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >otilia.bodnar@patronet.net&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Üzenet: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >teszt&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>referer page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >http://rlphigienia.patronet.hu/kapcsolat&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search keywords: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>campaign id: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>form name: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >rlphigiénia ajánlatkérés&nbsp;</font></td></tr>\n</table>', '178.48.31.249', 'Mozilla/5.0 (Windows NT 6.1; rv:49.0) Gecko/20100101 Firefox/49.0', 'http://rlphigienia.patronet.hu/kapcsolat', '', '', ''),
(19, 'rlphigiénia ajánlatkérés', 'http://www.rlphigienia.hu/ajanlatkeres', 'iroda@rlphigienia.hu', '<br><font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Message from the RLP Higiénia <br>website: http://www.rlphigienia.hu</b><br><br>Sending time: 2018-03-13 14:38:54</font><br><br>\r\n			<table width=550 cellpadding=''3'' cellspacing=0 >\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Cégnév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >Hotel Bara***&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Vezetéknév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >Nagy&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Keresztnév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >Alexandra&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Telefon: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >0613859445&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>E-mail: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >info@hotelbara.hu&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Üzenet: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >Tisztelt Címzett!<br />\r\nA Hotel Bara*** keres napi szintű takarításra takarító céget. A takarítás kb. 100 szobát foglal magában, plusz a közös területek és a Hotel épülete előtti részt.<br />\r\nSzállodai referenciákat és ajánlatkérést várunk a fenti e-mail címre.<br />\r\nKöszönöm szépen!&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>referer page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >http://www.rlphigienia.hu/referenciaink&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search keywords: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>campaign id: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>form name: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >rlphigiénia ajánlatkérés&nbsp;</font></td></tr>\n</table>', '86.101.230.97', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:58.0) Gecko/20100101 Firefox/58.0', 'http://www.rlphigienia.hu/referenciaink', '', '', ''),
(20, 'rlphigiénia ajánlatkérés', 'https://www.rlphigienia.hu/ajanlatkeres', 'iroda@rlphigienia.hu', '<br><font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Message from the RLP Higiénia <br>website: https://www.rlphigienia.hu</b><br><br>Sending time: 2019-01-15 14:20:54</font><br><br>\r\n			<table width=550 cellpadding=''3'' cellspacing=0 >\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Cégnév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >Mezőker Hungária Kft.&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Vezetéknév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >Nyikos-Luterán &nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Keresztnév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >Lilla&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Telefon: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >+36 20 336 2742&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>E-mail: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >info@tarnocakuria.hu&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Üzenet: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >Tisztelt Cím! <br />\r\nA soponyai Tarnóca Kúria nagytakarításához keresünk profi, szakértői csapatot, akik rövid határidőn belül és pár nap alatt elvégzik a kért feladatokat. <br />\r\nFeladat leírása: <br />\r\n- 8 szoba alapos takarítása, fürdőszobákkal együtt - közösségi terek, ezen felül mosdók, étkező, konyha, rendezvényterem, előtér nagytakarítása. Minden helyiségben, portalanítás, ablakok megtakarítása, szőnyegek kitakarítása, fürdők vízkő eltávolítása, fertőtlenítése. Gondoljuk helyszíni megtekintés szükséges az árajánlatot megelőzően! Kérjük, hogy az ismert elérhetőségeinken keressenek minket. Köszönettel.&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>adatvedelem: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >on&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>referer page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >https://www.rlphigienia.hu/szolgaltatasaink/szalloda-takaritas&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search keywords: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>campaign id: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>form name: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >rlphigiénia ajánlatkérés&nbsp;</font></td></tr>\n</table>', '149.126.29.146', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36', 'https://www.rlphigienia.hu/szolgaltatasaink/szalloda-takaritas', '', '', ''),
(21, 'rlphigiénia ajánlatkérés', 'https://www.rlphigienia.hu/ajanlatkeres', 'iroda@rlphigienia.hu', '<br><font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Message from the RLP Higiénia <br>website: https://www.rlphigienia.hu</b><br><br>Sending time: 2019-05-07 11:39:12</font><br><br>\r\n			<table width=550 cellpadding=''3'' cellspacing=0 >\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Cégnév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >MLSZ Edzőcentrum Kft&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Vezetéknév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >Sponga&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Keresztnév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >Mónika&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Telefon: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >+36305588199&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>E-mail: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >sponga.monika@globall.hu&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Üzenet: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >Tisztelt Hölgyem/Uram!<br />\r\n<br />\r\nEzúton szeretnék ajánlatot kérni szállodai takarításra a Telkiben található Globall Hotel számára. Honlapunkon (www.globall.hu) tájékozódhat a szálloda területének részleteiről, de bármilyen kérdése van, állok szíves rendelkezésére!<br />\r\n<br />\r\nÜdvözlettel:<br />\r\n<br />\r\nSponga Mónika&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>adatvedelem: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >on&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>referer page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >https://www.rlphigienia.hu/szolgaltatasaink/szalloda-takaritas&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search keywords: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>campaign id: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>form name: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >rlphigiénia ajánlatkérés&nbsp;</font></td></tr>\n</table>', '91.82.124.218', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.131 Safari/537.36', 'https://www.rlphigienia.hu/szolgaltatasaink/szalloda-takaritas', '', '', ''),
(22, 'rlphigiénia ajánlatkérés', 'https://www.rlphigienia.hu/ajanlatkeres', 'iroda@rlphigienia.hu', '<br><font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Message from the RLP Higiénia <br>website: https://www.rlphigienia.hu</b><br><br>Sending time: 2019-05-10 13:37:14</font><br><br>\r\n			<table width=550 cellpadding=''3'' cellspacing=0 >\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Cégnév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >Gold Hotel Kft.&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Vezetéknév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >Arany-Tóth&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Keresztnév: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >Mariann&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Telefon: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >06304768384&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>E-mail: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >info@goldhotel.hu&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>Üzenet: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >Árajánlatot szeretnék kérni az alábbi munkára:<br />\r\n <br />\r\nA Gold Hotel 24 szobával (20-24 négyzetméter) és<br />\r\na mellettünk található épületben 6 apartmannal rendelkezik (42-49 négyzetméteres).<br />\r\nKözterület:<br />\r\n- 4 db folyosó 10-15 négyzetméter <br />\r\n- recepció kb 30 négyzetméter<br />\r\n- lépcsőház (nem mindennapos)<br />\r\n<br />\r\nFeladatok:<br />\r\n1. Változó mennyiségű utazó szoba és napi szoba takarítás.<br />\r\n <br />\r\n2. Jelenleg önellátók vagyunk, <br />\r\nházon belül mosunk és mángorló gépekkel vasalunk. A szobalányok munkája ezt is tartalmazza.<br />\r\n<br />\r\n3. Közterületek rendben és tisztán tartása.<br />\r\n<br />\r\nNapi 8 órában 07.00-15.30-ig<br />\r\n2 vagy 3 szobalány végzi a fenti feladatokat.<br />\r\n<br />\r\nMunkaidőbeosztás:<br />\r\nReggel 7-9-ig vasalás<br />\r\n9-14.30-ig szobatakarítás<br />\r\nközben mosógépek feltöltése<br />\r\n14.30-tól teregetés és vasalás  <br />\r\n <br />\r\nHa szeretné megnézni a helyszínt, akkor naponta 9 órától itt vagyok.<br />\r\n<br />\r\nArany-Tóth Mariann<br />\r\nGold Hotel Budapest<br />\r\n1016 Budapest, Hegyalja út 14.<br />\r\n&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>adatvedelem: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >on&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>referer page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >https://www.rlphigienia.hu/szolgaltatasaink/szalloda-takaritas&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search keywords: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>ref search page: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>campaign id: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >&nbsp;</font></td></tr>\n<tr><td width=''200'' valign=''top'' nowrap  style="border-bottom:1px solid #cccccc">\n<font face=''Tahoma,Arial,Helvetica'' size=''2''><b>form name: </b>&nbsp;</font></td><td valign=''top'' style="border-bottom:1px solid #cccccc"><font face=''Tahoma,Arial,Helvetica'' size=''2'' >rlphigiénia ajánlatkérés&nbsp;</font></td></tr>\n</table>', '80.98.73.32', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.131 Safari/537.36', 'https://www.rlphigienia.hu/szolgaltatasaink/szalloda-takaritas', '', '', '');

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_groups`
--

CREATE TABLE `opey_groups` (
  `pn_gid` int(11) NOT NULL,
  `pn_name` varchar(255) NOT NULL DEFAULT '',
  `pn_show` tinyint(4) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 PACK_KEYS=1;

--
-- A tábla adatainak kiíratása `opey_groups`
--

INSERT INTO `opey_groups` (`pn_gid`, `pn_name`, `pn_show`) VALUES
(1, 'Users', 0),
(2, 'Admins', 0),
(4, 'SiteAdmins', 1);

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_group_membership`
--

CREATE TABLE `opey_group_membership` (
  `pn_gid` int(11) NOT NULL DEFAULT '0',
  `pn_uid` int(11) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- A tábla adatainak kiíratása `opey_group_membership`
--

INSERT INTO `opey_group_membership` (`pn_gid`, `pn_uid`) VALUES
(2, 2),
(1, 1),
(2, 599);

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_group_perms`
--

CREATE TABLE `opey_group_perms` (
  `pn_pid` int(11) NOT NULL,
  `pn_gid` int(11) NOT NULL DEFAULT '0',
  `pn_sequence` int(11) NOT NULL DEFAULT '0',
  `pn_realm` smallint(4) NOT NULL DEFAULT '0',
  `pn_component` varchar(255) NOT NULL DEFAULT '',
  `pn_instance` varchar(255) NOT NULL DEFAULT '',
  `pn_level` smallint(4) NOT NULL DEFAULT '0',
  `pn_bond` int(2) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- A tábla adatainak kiíratása `opey_group_perms`
--

INSERT INTO `opey_group_perms` (`pn_pid`, `pn_gid`, `pn_sequence`, `pn_realm`, `pn_component`, `pn_instance`, `pn_level`, `pn_bond`) VALUES
(1, 2, 3, 0, '.*', '.*', 1000, 0),
(3, 1, 4, 0, '.*', '.*', 200, 0),
(46, 0, 1, 0, '.*', '.*', 200, 0),
(49, -1, 2, 0, '.*', '.*', 200, 0),
(50, 4, 5, 0, 'Contact_Us::', '::', 800, 0),
(51, 4, 6, 0, 'OEBlockEditor::', '::', 800, 0),
(52, 4, 7, 0, 'ArculatEditor::', '::', 800, 0),
(53, 4, 8, 0, 'Autolinks::', '::', 800, 0),
(54, 4, 9, 0, 'AdminHome::', '::', 800, 0),
(55, 4, 10, 0, 'Blocks::', 'Block key:Block title:Block ID', 800, 0),
(56, 4, 11, 0, 'OE-MenuBuilder::', '::', 800, 0),
(57, 4, 12, 0, 'OEObjectEditor::', '::', 800, 0),
(58, 4, 13, 0, 'Shortlink::', '::', 800, 0),
(59, 4, 14, 0, 'OECMS::', '::', 800, 0),
(60, 4, 15, 0, 'SiteStatistics::', '::', 800, 0),
(61, 4, 16, 0, 'vendegkonyv::', '::', 800, 0),
(62, 4, 17, 0, 'eLibrary::', '::', 800, 0),
(63, 4, 18, 0, 'eShop::', '::', 800, 0),
(64, 4, 19, 0, 'FAQ::', 'Category name:File name:File ID', 800, 0),
(65, 4, 20, 0, 'Contact_Us::', 'Contact_Us_Email:Contact_Us_Text', 800, 0),
(66, 4, 21, 0, 'News::', '::', 800, 0),
(67, 4, 22, 0, 'UserAdminBasic::', '::', 800, 0),
(68, 4, 23, 0, 'eShop::', '::', 800, 0),
(69, 4, 24, 0, 'MiniOrder::', '::', 800, 0),
(70, 8, 25, 0, 'MiniOrder::', '::', 700, 0),
(71, 9, 26, 0, 'MiniOrder::', '::', 600, 0),
(72, 4, 27, 0, 'OENewsletter::', '::', 800, 0),
(73, 10, 28, 0, 'MiniOrder::', '::', 600, 0),
(74, 4, 29, 0, 'PopUp::', '::', 800, 0);

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_help`
--

CREATE TABLE `opey_help` (
  `id` int(11) NOT NULL,
  `node` varchar(64) NOT NULL DEFAULT '',
  `subnode` varchar(64) DEFAULT NULL,
  `filename` varchar(255) NOT NULL DEFAULT '',
  `keywords` varchar(255) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `parentid` int(11) NOT NULL DEFAULT '0',
  `level` int(11) NOT NULL DEFAULT '0',
  `description` varchar(255) NOT NULL DEFAULT '',
  `subdescription` varchar(255) NOT NULL DEFAULT '',
  `content` text
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_hooks`
--

CREATE TABLE `opey_hooks` (
  `pn_id` int(11) UNSIGNED NOT NULL,
  `pn_object` varchar(64) NOT NULL DEFAULT '',
  `pn_action` varchar(64) NOT NULL DEFAULT '',
  `pn_smodule` varchar(64) DEFAULT NULL,
  `pn_stype` varchar(64) DEFAULT NULL,
  `pn_tarea` varchar(64) NOT NULL DEFAULT '',
  `pn_tmodule` varchar(64) NOT NULL DEFAULT '',
  `pn_ttype` varchar(64) NOT NULL DEFAULT '',
  `pn_tfunc` varchar(64) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- A tábla adatainak kiíratása `opey_hooks`
--

INSERT INTO `opey_hooks` (`pn_id`, `pn_object`, `pn_action`, `pn_smodule`, `pn_stype`, `pn_tarea`, `pn_tmodule`, `pn_ttype`, `pn_tfunc`) VALUES
(2, 'item', 'transform', '', '', 'API', 'Autolinks', 'user', 'transform');

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_imagegallery_images`
--

CREATE TABLE `opey_imagegallery_images` (
  `id` int(11) NOT NULL,
  `subcatid` int(11) NOT NULL DEFAULT '0',
  `number` int(11) NOT NULL DEFAULT '0',
  `type` varchar(255) NOT NULL DEFAULT 'image',
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `filename` varchar(250) NOT NULL,
  `params` text NOT NULL,
  `added` datetime NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- A tábla adatainak kiíratása `opey_imagegallery_images`
--

INSERT INTO `opey_imagegallery_images` (`id`, `subcatid`, `number`, `type`, `name`, `description`, `filename`, `params`, `added`) VALUES
(35, 1, 1, 'image', '', '', 'stock-photo-air-conditioner-inside-the-room-with-woman-operating-remote-controller-air-conditioner-with-507015844.jpg', '', '0000-00-00 00:00:00');

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_imagegallery_lang`
--

CREATE TABLE `opey_imagegallery_lang` (
  `id` int(11) NOT NULL,
  `obj_type` varchar(10) NOT NULL DEFAULT '',
  `obj_id` int(11) NOT NULL DEFAULT '0',
  `value` text NOT NULL,
  `lang` varchar(5) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- A tábla adatainak kiíratása `opey_imagegallery_lang`
--

INSERT INTO `opey_imagegallery_lang` (`id`, `obj_type`, `obj_id`, `value`, `lang`) VALUES
(1, 'maincat', 1, 'Design', 'hun'),
(2, 'maincatdes', 1, '', 'hun'),
(3, 'subcat', 1, 'Slider', 'hun'),
(4, 'subcatdes', 1, '', 'hun'),
(15, 'image', 35, 'Jobb közérzet, jobb élet minőség', 'hun'),
(16, 'imagedesc', 35, 'Lélegezzen tiszta levegőt! A TOSHIBA klímaberendezések javítják a  helyiségek  klímáját!', 'hun');

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_imagegallery_maincat`
--

CREATE TABLE `opey_imagegallery_maincat` (
  `id` int(11) NOT NULL,
  `number` int(11) NOT NULL DEFAULT '0',
  `protected` tinyint(4) NOT NULL,
  `pngroups` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `no_list` tinyint(4) NOT NULL,
  `description` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- A tábla adatainak kiíratása `opey_imagegallery_maincat`
--

INSERT INTO `opey_imagegallery_maincat` (`id`, `number`, `protected`, `pngroups`, `name`, `no_list`, `description`) VALUES
(1, 1, 0, '', 'Slider', 0, '');

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_imagegallery_subcat`
--

CREATE TABLE `opey_imagegallery_subcat` (
  `id` int(11) NOT NULL,
  `maincatid` int(11) NOT NULL DEFAULT '0',
  `number` int(11) NOT NULL DEFAULT '0',
  `protected` tinyint(4) NOT NULL,
  `pngroups` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `no_list` tinyint(4) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- A tábla adatainak kiíratása `opey_imagegallery_subcat`
--

INSERT INTO `opey_imagegallery_subcat` (`id`, `maincatid`, `number`, `protected`, `pngroups`, `name`, `no_list`) VALUES
(1, 1, 1, 0, '', 'Slider', 0);

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_journal`
--

CREATE TABLE `opey_journal` (
  `id` int(11) NOT NULL,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `module` varchar(100) NOT NULL,
  `type` varchar(50) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `user` int(11) NOT NULL DEFAULT '0',
  `ip` varchar(15) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `details` text CHARACTER SET utf8 NOT NULL,
  `hash` varchar(100) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- A tábla adatainak kiíratása `opey_journal`
--

INSERT INTO `opey_journal` (`id`, `date`, `module`, `type`, `user`, `ip`, `details`, `hash`) VALUES
(1, '2019-05-23 14:11:48', 'OE-ShortLink', 'shortlink_cms_01', 2, '178.48.31.249', 'a:11:{s:10:"short_path";s:5:"nyito";s:4:"path";s:42:"index.php?name=OE-CMS&file=index&page_id=1";s:5:"owner";s:6:"OE-CMS";s:6:"own_id";s:1:"1";s:10:"path_level";i:0;s:8:"oeLayout";s:2:"13";s:12:"menu_caption";s:0:"";s:11:"description";s:0:"";s:9:"pagetitle";s:0:"";s:4:"meta";s:0:"";s:7:"display";i:0;}', '6468450f7d58a04c54c69607ca3e9e9b6db69b08'),
(2, '2019-05-23 14:20:35', 'TUser_class', 'user_03', 2, '178.48.31.249', 'a:3:{s:6:"pn_uid";s:3:"599";s:8:"pn_uname";s:5:"david";s:11:"newpass_md5";s:32:"550b30fc7ba86117a59d433f5cd63e74";}', '87b645c17224befa9ab93a8352c10c9fcee85dcc'),
(3, '2019-05-23 14:28:04', 'OE-User', 'login_04', 0, '178.48.31.249', 'a:2:{s:5:"uname";s:6:"berecz";s:4:"pass";s:5:"*****";}', 'f7ad0d000536ac2ca21e44a48613fd4241a9483d'),
(4, '2019-05-23 14:28:10', 'OE-User', 'login_01', 599, '178.48.31.249', 'a:2:{s:5:"uname";s:5:"david";s:4:"pass";s:6:"******";}', '5efc4c74ee50df519d82b11019efb972f9bfff0c'),
(5, '2019-05-24 07:22:35', 'OE-User', 'login_01', 2, '86.59.231.13', 'a:2:{s:5:"uname";s:8:"sysadmin";s:4:"pass";s:6:"******";}', '8950f073f3682dc180f4358f273b2c665720763b'),
(6, '2019-05-24 08:37:55', 'TUser_class', 'user_02', 2, '86.59.231.13', 'a:2:{s:6:"pn_uid";s:3:"599";s:8:"pn_uname";s:5:"david";}', '48c2da3377ae31bfad4058307cea4be0ae766fd4'),
(7, '2019-05-27 09:49:36', 'OE-User', 'login_01', 599, '178.48.31.249', 'a:2:{s:5:"uname";s:5:"david";s:4:"pass";s:6:"******";}', '5efc4c74ee50df519d82b11019efb972f9bfff0c'),
(8, '2019-05-27 11:49:50', 'OE-User', 'login_01', 599, '178.48.31.249', 'a:2:{s:5:"uname";s:5:"david";s:4:"pass";s:6:"******";}', '5efc4c74ee50df519d82b11019efb972f9bfff0c'),
(9, '2019-05-27 15:49:37', 'OE-ObjectEditor', 'objecteditor_cms_02', 599, '178.48.31.249', 'a:2:{s:7:"page_id";s:1:"1";s:9:"shortlink";s:5:"nyito";}', '8456955ecbc67c51b19174f3ca65bb7c74522a5f'),
(10, '2019-05-27 15:51:00', 'OE-ObjectEditor', 'objecteditor_cms_02', 599, '178.48.31.249', 'a:2:{s:7:"page_id";s:1:"1";s:9:"shortlink";s:5:"nyito";}', '8456955ecbc67c51b19174f3ca65bb7c74522a5f'),
(11, '2019-05-28 09:19:56', 'OE-User', 'login_01', 599, '178.48.31.249', 'a:2:{s:5:"uname";s:5:"david";s:4:"pass";s:6:"******";}', '5efc4c74ee50df519d82b11019efb972f9bfff0c'),
(12, '2019-05-28 12:36:28', 'OE-User', 'login_04', 0, '127.0.0.1', 'a:2:{s:5:"uname";s:6:"otilia";s:4:"pass";s:5:"*****";}', '4140496cd606538a923874d9052c62434029007f'),
(13, '2019-05-28 12:36:36', 'OE-User', 'login_04', 0, '127.0.0.1', 'a:2:{s:5:"uname";s:5:"varga";s:4:"pass";s:5:"*****";}', '1c49e557ac5836596b9b14017be531215a6e607f'),
(14, '2019-05-28 12:36:49', 'OE-User', 'login_01', 599, '127.0.0.1', 'a:2:{s:5:"uname";s:5:"david";s:4:"pass";s:6:"******";}', 'e7d6214192324ffeaaf9e2dbc30afe0faa779751'),
(15, '2019-05-28 12:38:55', 'ArculatEditor', 'layout_03', 599, '127.0.0.1', 'a:2:{s:8:"layoutID";s:2:"14";s:11:"Layout name";s:17:"Atlantisz arculat";}', 'ce0276109a7501ebca2d9cf1f397a5a0a25f92ef'),
(16, '2019-05-28 12:39:23', 'OE-ShortLink', 'shortlink_cms_02', 599, '127.0.0.1', 'a:9:{s:10:"short_path";s:5:"nyito";s:10:"path_level";i:0;s:8:"oeLayout";s:2:"14";s:10:"menu_order";s:1:"0";s:12:"menu_caption";s:0:"";s:11:"description";s:0:"";s:9:"pagetitle";s:0:"";s:4:"meta";s:0:"";s:7:"display";i:0;}', '4d234fa3de388a54abded8a90976341cc1b01c6c'),
(17, '2019-05-28 12:54:26', 'OE-ShortLink', 'shortlink_cms_01', 599, '127.0.0.1', 'a:11:{s:10:"short_path";s:5:"teszt";s:4:"path";s:42:"index.php?name=OE-CMS&file=index&page_id=2";s:5:"owner";s:6:"OE-CMS";s:6:"own_id";s:1:"2";s:10:"path_level";i:0;s:8:"oeLayout";s:2:"14";s:12:"menu_caption";s:0:"";s:11:"description";s:0:"";s:9:"pagetitle";s:0:"";s:4:"meta";s:0:"";s:7:"display";i:0;}', 'a8147da8e69135d3902d4ec3f93c478778d565dd'),
(18, '2019-05-28 13:05:01', 'OE-ObjectEditor', 'objecteditor_cms_02', 599, '127.0.0.1', 'a:2:{s:7:"page_id";s:1:"1";s:9:"shortlink";s:5:"nyito";}', '293d98415a6f486b97b12970f28cbaee3c1f2182'),
(19, '2019-05-28 13:38:20', 'OE-ObjectEditor', 'objecteditor_cms_02', 599, '127.0.0.1', 'a:2:{s:7:"page_id";s:1:"1";s:9:"shortlink";s:5:"nyito";}', '293d98415a6f486b97b12970f28cbaee3c1f2182'),
(20, '2019-05-28 13:43:25', 'OE-ObjectEditor', 'objecteditor_cms_02', 599, '127.0.0.1', 'a:2:{s:7:"page_id";s:1:"1";s:9:"shortlink";s:5:"nyito";}', '293d98415a6f486b97b12970f28cbaee3c1f2182'),
(21, '2019-05-28 13:46:20', 'OE-ObjectEditor', 'objecteditor_cms_02', 599, '127.0.0.1', 'a:2:{s:7:"page_id";s:1:"1";s:9:"shortlink";s:5:"nyito";}', '293d98415a6f486b97b12970f28cbaee3c1f2182'),
(22, '2019-05-28 13:46:32', 'OE-ObjectEditor', 'objecteditor_cms_02', 599, '127.0.0.1', 'a:2:{s:7:"page_id";s:1:"1";s:9:"shortlink";s:5:"nyito";}', '293d98415a6f486b97b12970f28cbaee3c1f2182'),
(23, '2019-05-28 13:50:14', 'OE-ObjectEditor', 'objecteditor_cms_02', 599, '127.0.0.1', 'a:2:{s:7:"page_id";s:1:"1";s:9:"shortlink";s:5:"nyito";}', '293d98415a6f486b97b12970f28cbaee3c1f2182'),
(24, '2019-05-28 13:50:57', 'OE-ObjectEditor', 'objecteditor_cms_02', 599, '127.0.0.1', 'a:2:{s:7:"page_id";s:1:"1";s:9:"shortlink";s:5:"nyito";}', '293d98415a6f486b97b12970f28cbaee3c1f2182'),
(25, '2019-05-28 13:54:38', 'OE-ObjectEditor', 'objecteditor_cms_02', 599, '127.0.0.1', 'a:2:{s:7:"page_id";s:1:"1";s:9:"shortlink";s:5:"nyito";}', '293d98415a6f486b97b12970f28cbaee3c1f2182'),
(26, '2019-05-28 14:10:02', 'OE-ShortLink', 'shortlink_cms_02', 599, '127.0.0.1', 'a:9:{s:10:"short_path";s:5:"teszt";s:10:"path_level";i:0;s:8:"oeLayout";s:1:"1";s:10:"menu_order";s:1:"0";s:12:"menu_caption";s:0:"";s:11:"description";s:0:"";s:9:"pagetitle";s:0:"";s:4:"meta";s:0:"";s:7:"display";i:0;}', '867ac964e9a177148c2f79c85a301ba31e373343'),
(27, '2019-05-28 14:15:08', 'OE-ObjectEditor', 'objecteditor_cms_02', 599, '127.0.0.1', 'a:2:{s:7:"page_id";s:1:"2";s:9:"shortlink";s:5:"teszt";}', '823815c604efb92ed497f567da31dbf15ed8df51'),
(28, '2019-05-28 14:15:47', 'OE-ObjectEditor', 'objecteditor_cms_02', 599, '127.0.0.1', 'a:2:{s:7:"page_id";s:1:"2";s:9:"shortlink";s:5:"teszt";}', '823815c604efb92ed497f567da31dbf15ed8df51'),
(29, '2019-05-28 14:35:51', 'OE-ShortLink', 'shortlink_cms_02', 599, '127.0.0.1', 'a:9:{s:10:"short_path";s:5:"teszt";s:10:"path_level";i:0;s:8:"oeLayout";s:2:"14";s:10:"menu_order";s:1:"0";s:12:"menu_caption";s:0:"";s:11:"description";s:0:"";s:9:"pagetitle";s:0:"";s:4:"meta";s:0:"";s:7:"display";i:0;}', '359867f46d5cd60b3080c4e8d0ac70a186abb3e4'),
(30, '2019-05-28 14:43:53', 'OE-ShortLink', 'shortlink_cms_01', 599, '127.0.0.1', 'a:11:{s:10:"short_path";s:9:"kapcsolat";s:4:"path";s:42:"index.php?name=OE-CMS&file=index&page_id=3";s:5:"owner";s:6:"OE-CMS";s:6:"own_id";s:1:"3";s:10:"path_level";i:0;s:8:"oeLayout";s:2:"14";s:12:"menu_caption";s:0:"";s:11:"description";s:0:"";s:9:"pagetitle";s:0:"";s:4:"meta";s:0:"";s:7:"display";i:0;}', '865df11ac0ff76e4b7c9a4d3ab884435ae163191'),
(31, '2019-05-28 14:48:15', 'OE-ObjectEditor', 'objecteditor_cms_02', 599, '127.0.0.1', 'a:2:{s:7:"page_id";s:1:"3";s:9:"shortlink";s:9:"kapcsolat";}', '0f464af1f43f67831c0d51f42fcb57d7c00d29d5'),
(32, '2019-05-28 15:04:49', 'OE-ObjectEditor', 'objecteditor_cms_02', 599, '127.0.0.1', 'a:2:{s:7:"page_id";s:1:"3";s:9:"shortlink";s:9:"kapcsolat";}', '0f464af1f43f67831c0d51f42fcb57d7c00d29d5'),
(33, '2019-05-29 09:29:24', 'OE-User', 'login_01', 599, '127.0.0.1', 'a:2:{s:5:"uname";s:5:"david";s:4:"pass";s:6:"******";}', 'e7d6214192324ffeaaf9e2dbc30afe0faa779751'),
(34, '2019-05-29 09:31:26', 'OE-ObjectEditor', 'objecteditor_cms_02', 599, '127.0.0.1', 'a:2:{s:7:"page_id";s:1:"1";s:9:"shortlink";s:5:"nyito";}', '293d98415a6f486b97b12970f28cbaee3c1f2182'),
(35, '2019-05-29 09:37:07', 'OE-ObjectEditor', 'objecteditor_cms_02', 599, '127.0.0.1', 'a:2:{s:7:"page_id";s:1:"1";s:9:"shortlink";s:5:"nyito";}', '293d98415a6f486b97b12970f28cbaee3c1f2182'),
(36, '2019-05-29 09:37:53', 'OE-ObjectEditor', 'objecteditor_cms_02', 599, '127.0.0.1', 'a:2:{s:7:"page_id";s:1:"1";s:9:"shortlink";s:5:"nyito";}', '293d98415a6f486b97b12970f28cbaee3c1f2182'),
(37, '2019-05-29 09:46:05', 'OE-ObjectEditor', 'objecteditor_cms_02', 599, '127.0.0.1', 'a:2:{s:7:"page_id";s:1:"1";s:9:"shortlink";s:5:"nyito";}', '293d98415a6f486b97b12970f28cbaee3c1f2182'),
(38, '2019-05-29 10:03:17', 'OE-ObjectEditor', 'objecteditor_cms_02', 599, '127.0.0.1', 'a:2:{s:7:"page_id";s:1:"1";s:9:"shortlink";s:5:"nyito";}', '293d98415a6f486b97b12970f28cbaee3c1f2182'),
(39, '2019-05-29 10:04:53', 'OE-ObjectEditor', 'objecteditor_cms_02', 599, '127.0.0.1', 'a:2:{s:7:"page_id";s:1:"1";s:9:"shortlink";s:5:"nyito";}', '293d98415a6f486b97b12970f28cbaee3c1f2182'),
(40, '2019-05-29 10:28:25', 'OE-ObjectEditor', 'objecteditor_cms_02', 599, '127.0.0.1', 'a:2:{s:7:"page_id";s:1:"1";s:9:"shortlink";s:5:"nyito";}', '293d98415a6f486b97b12970f28cbaee3c1f2182'),
(41, '2019-05-29 10:28:42', 'OE-ObjectEditor', 'objecteditor_cms_02', 599, '127.0.0.1', 'a:2:{s:7:"page_id";s:1:"1";s:9:"shortlink";s:5:"nyito";}', '293d98415a6f486b97b12970f28cbaee3c1f2182'),
(42, '2019-05-29 11:23:08', 'OE-ObjectEditor', 'objecteditor_cms_02', 599, '127.0.0.1', 'a:2:{s:7:"page_id";s:1:"1";s:9:"shortlink";s:5:"nyito";}', '293d98415a6f486b97b12970f28cbaee3c1f2182'),
(43, '2019-05-29 11:25:29', 'OE-ObjectEditor', 'objecteditor_cms_02', 599, '127.0.0.1', 'a:2:{s:7:"page_id";s:1:"1";s:9:"shortlink";s:5:"nyito";}', '293d98415a6f486b97b12970f28cbaee3c1f2182'),
(44, '2019-05-29 11:26:22', 'OE-ObjectEditor', 'objecteditor_cms_02', 599, '127.0.0.1', 'a:2:{s:7:"page_id";s:1:"1";s:9:"shortlink";s:5:"nyito";}', '293d98415a6f486b97b12970f28cbaee3c1f2182'),
(45, '2019-05-29 11:29:35', 'OE-ObjectEditor', 'objecteditor_cms_02', 599, '127.0.0.1', 'a:2:{s:7:"page_id";s:1:"1";s:9:"shortlink";s:5:"nyito";}', '293d98415a6f486b97b12970f28cbaee3c1f2182'),
(46, '2019-05-29 11:30:14', 'OE-ObjectEditor', 'objecteditor_cms_02', 599, '127.0.0.1', 'a:2:{s:7:"page_id";s:1:"1";s:9:"shortlink";s:5:"nyito";}', '293d98415a6f486b97b12970f28cbaee3c1f2182'),
(47, '2019-05-29 13:36:59', 'OE-ObjectEditor', 'objecteditor_cms_02', 599, '127.0.0.1', 'a:2:{s:7:"page_id";s:1:"1";s:9:"shortlink";s:5:"nyito";}', '293d98415a6f486b97b12970f28cbaee3c1f2182'),
(48, '2019-05-29 17:00:37', 'OE-User', 'login_02', 599, '127.0.0.1', 's:0:"";', '43242fe753c8ce1228655cf63b706a482035f020'),
(49, '2019-05-29 17:00:43', 'OE-User', 'login_01', 599, '127.0.0.1', 'a:2:{s:5:"uname";s:5:"david";s:4:"pass";s:6:"******";}', 'e7d6214192324ffeaaf9e2dbc30afe0faa779751'),
(50, '2019-05-30 09:41:14', 'OE-User', 'login_01', 599, '127.0.0.1', 'a:2:{s:5:"uname";s:5:"david";s:4:"pass";s:6:"******";}', 'e7d6214192324ffeaaf9e2dbc30afe0faa779751'),
(51, '2019-05-30 09:53:11', 'OE-ObjectEditor', 'objecteditor_cms_02', 599, '127.0.0.1', 'a:2:{s:7:"page_id";s:1:"1";s:9:"shortlink";s:5:"nyito";}', '293d98415a6f486b97b12970f28cbaee3c1f2182'),
(52, '2019-05-30 09:59:25', 'OE-ObjectEditor', 'objecteditor_cms_02', 599, '127.0.0.1', 'a:2:{s:7:"page_id";s:1:"1";s:9:"shortlink";s:5:"nyito";}', '293d98415a6f486b97b12970f28cbaee3c1f2182'),
(53, '2019-05-30 10:01:24', 'OE-ObjectEditor', 'objecteditor_cms_02', 599, '127.0.0.1', 'a:2:{s:7:"page_id";s:1:"1";s:9:"shortlink";s:5:"nyito";}', '293d98415a6f486b97b12970f28cbaee3c1f2182'),
(54, '2019-05-30 10:02:37', 'OE-ObjectEditor', 'objecteditor_cms_02', 599, '127.0.0.1', 'a:2:{s:7:"page_id";s:1:"1";s:9:"shortlink";s:5:"nyito";}', '293d98415a6f486b97b12970f28cbaee3c1f2182'),
(55, '2019-05-30 10:03:39', 'OE-ObjectEditor', 'objecteditor_cms_02', 599, '127.0.0.1', 'a:2:{s:7:"page_id";s:1:"1";s:9:"shortlink";s:5:"nyito";}', '293d98415a6f486b97b12970f28cbaee3c1f2182'),
(56, '2019-05-30 11:18:19', 'OE-ObjectEditor', 'objecteditor_cms_02', 599, '127.0.0.1', 'a:2:{s:7:"page_id";s:1:"1";s:9:"shortlink";s:5:"nyito";}', '293d98415a6f486b97b12970f28cbaee3c1f2182'),
(57, '2019-05-30 11:53:02', 'OE-ObjectEditor', 'objecteditor_cms_02', 599, '127.0.0.1', 'a:2:{s:7:"page_id";s:1:"1";s:9:"shortlink";s:5:"nyito";}', '293d98415a6f486b97b12970f28cbaee3c1f2182'),
(58, '2019-05-30 13:48:26', 'OE-ShortLink', 'shortlink_cms_02', 599, '127.0.0.1', 'a:9:{s:10:"short_path";s:5:"nyito";s:10:"path_level";i:0;s:8:"oeLayout";s:2:"14";s:10:"menu_order";s:1:"0";s:12:"menu_caption";s:0:"";s:11:"description";s:0:"";s:9:"pagetitle";s:11:"Kezdőoldal";s:4:"meta";s:0:"";s:7:"display";i:0;}', '264d65661350d90c3d6124fed04e1f7a4c40a714'),
(59, '2019-05-30 14:20:47', 'OE-ObjectEditor', 'objecteditor_cms_02', 599, '127.0.0.1', 'a:2:{s:7:"page_id";s:1:"1";s:9:"shortlink";s:5:"nyito";}', '293d98415a6f486b97b12970f28cbaee3c1f2182'),
(60, '2019-05-30 15:10:14', 'OE-ShortLink', 'shortlink_modul_01', 599, '127.0.0.1', 'a:11:{s:10:"short_path";s:8:"termekek";s:4:"path";s:31:"index.php?name=eShop&file=index";s:5:"owner";s:5:"eShop";s:6:"own_id";i:0;s:10:"path_level";i:0;s:8:"oeLayout";s:2:"14";s:12:"menu_caption";s:0:"";s:11:"description";s:0:"";s:9:"pagetitle";s:0:"";s:4:"meta";s:0:"";s:7:"display";i:0;}', 'e0d54598d522b0219aa00930d8ea90686000e42e');

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_journal_codes`
--

CREATE TABLE `opey_journal_codes` (
  `code` varchar(50) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `event` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `module` varchar(50) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `comment` text CHARACTER SET utf8 NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- A tábla adatainak kiíratása `opey_journal_codes`
--

INSERT INTO `opey_journal_codes` (`code`, `event`, `module`, `comment`) VALUES
('login_01', 'Belépés', 'OE-User', 'Sikeres belépés a rendszerbe'),
('login_02', 'Kilépés', 'OE-User', 'Kilépés a rendszerből'),
('login_03', 'Belépési kisérlet (rossz jelszó)', 'OE-User', 'Belépési kisérlet a rendszerbe, létező felhasználó, rossz jelszó'),
('login_04', 'Belépési kisérlet (nincs ilyen felhasználó)', 'OE-User', 'Belépési kisérlet a rendszerbe, nem létező felhasználó'),
('news_01', 'Új cikk felvitele', 'OE-News', ''),
('news_02', 'Cikk módosítása', 'OE-News', ''),
('news_03', 'Cikk törlése', 'OE-News', ''),
('seo2_project_list', 'Projektek listája megjelent', 'SEO2', 'A felhasználó számára listázásra kerültek a fejlegyzett projektek'),
('seo2_project_details', 'Projek részletek megjelenítve', 'SEO2', 'Megjelent a SEO projek részletes kimutatása a feljegyzett időszakra'),
('library_01', 'Új dokumentum feltöltése', 'OE-eLibrary', ''),
('library_02', 'Dokumentum módosítása', 'OE-eLibrary', ''),
('library_03', 'Dokumentumok kötegelt módosítása', 'OE-eLibrary', ''),
('library_04', 'Dokumentum törlése', 'OE-eLibrary', ''),
('cover_page_modified', 'Nyitólap elemei módosításra kerültek', 'CoverPageItems', ''),
('shortlink_news_01', 'Új hír oldal létrehozása', 'OE-ShortLink', ''),
('shortlink_news_02', 'Hír oldal adatainak módosítása', 'OE-ShortLink', ''),
('shortlink_cms_01', 'Új tartalmi oldal létrehozása', 'OE-ShortLink', ''),
('shortlink_cms_02', 'Tartalmi oldal adatainak módosítása', 'OE-ShortLink', ''),
('objecteditor_block_02', 'Blokk módosítása (mentése)', 'OE-ObjectEditor', ''),
('objecteditor_cms_02', 'Tartalmi oldal módosítása (mentése)', 'OE-ObjectEditor', ''),
('bookshop_20', 'Kedvezmény adatainak mentése', 'BookShopAdv', 'Kedvezmény adatainak mentése'),
('bookshop_21', 'Kedvezmény törlése', 'BookShopAdv', 'Kedvezmény törlése'),
('bookshop_22', 'Beállítások mentése', 'BookShopAdv', 'Beállítások mentése'),
('bookshop_11', 'Szerző adatainak mentése', 'BookShopAdv', 'Szerző adatainak mentése'),
('bookshop_12', 'Szerző törlése', 'BookShopAdv', 'Szerző törlése'),
('bookshop_40', 'Kategória adatainak mentése', 'BookShopAdv', 'Kategória adatainak mentése'),
('bookshop_41', 'Kategória törlése', 'BookShopAdv', 'Kategória törlése'),
('bookshop_50', 'Hozzászólás módosítása', 'BookShopAdv', 'Hozzászólás módosítása'),
('bookshop_51', 'Hozzászólás törlése', 'BookShopAdv', 'Hozzászólás törlése'),
('bookshop_71', 'Kártyák törlése', 'BookShopAdv', 'Presentilo kártyák törlése'),
('bookshop_01', 'Könyv adatainak módosítása', 'BookShopAdv', 'Könyv adatainak módosítása'),
('bookshop_011', 'Könyv leírásának módosítása', 'BookShopAdv', 'Könyv leírásának módosítása'),
('bookshop_012', 'Könyv képének módosítása', 'BookShopAdv', 'Könyv képének módosítása'),
('bookshop_02', 'Könyv törlése', 'BookShopAdv', 'Könyv törlése'),
('bookshop_60', 'Felhasználó adatainak módosítása', 'BookShopAdv', 'Felhasználó adatainak módosítása'),
('bookshop_61', 'Felhasználó törlése', 'BookShopAdv', 'Felhasználó törlése'),
('bookshop_15', 'Megrendelés státuszának módosítása', 'BookShopAdv', 'Megrendelés státuszának módosítása'),
('bookshop_16', 'Megrendelés törlése', 'BookShopAdv', 'Megrendelés törlése'),
('user_01', 'Új felhasználó felvitele', 'TUser_class', 'Új felhasználó került hozzáadásra.'),
('user_03', 'Felhasználó mentése, jelszó módosítással', 'TUser_class', 'A felhasználó adatai módosításra kerültek, a jelszó megváltoztatásra került.'),
('user_02', 'Felhasználó mentése', 'TUser_class', 'A felhasználó adatai módosításra kerültek.'),
('user_04', 'Felhasználó törlésre került', 'TUser_class', 'A felhasználó törlésre került.');

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_journal_prefs`
--

CREATE TABLE `opey_journal_prefs` (
  `var` varchar(50) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `value` text CHARACTER SET utf8 NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_keywords_docs`
--

CREATE TABLE `opey_keywords_docs` (
  `keyword_doc_id` int(11) NOT NULL COMMENT 'Dokumentum egyedi azonositoja',
  `doc_date` datetime NOT NULL COMMENT 'Forrasdokumentum referencia-datuma',
  `doc_id` int(11) NOT NULL COMMENT 'Forrasdokumentum azonositoja',
  `module` varchar(255) NOT NULL COMMENT 'Forrasmodul neve',
  `doc_title` varchar(255) NOT NULL COMMENT 'Forrasdokumentum cime',
  `doc_intro` text NOT NULL COMMENT 'Forrasdokumentum bevezeto szovege vagy rovid leirasa',
  `doc_image` tinytext NOT NULL COMMENT 'Forrasdokumentumhoz tartozo fo kep',
  `doc_url` tinytext NOT NULL COMMENT 'Forrasdokumentum URL-je',
  `doc_keywords` text NOT NULL COMMENT 'A kulcsszavak teljes listaja'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_keywords_word2doc`
--

CREATE TABLE `opey_keywords_word2doc` (
  `keyword_id` int(11) NOT NULL COMMENT 'Kulcsszo azonositoja',
  `keyword_doc_id` int(11) NOT NULL COMMENT 'Dokumentum azonositoja'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_keywords_words`
--

CREATE TABLE `opey_keywords_words` (
  `keyword_id` int(11) NOT NULL COMMENT 'Kulcsszo azonositoja',
  `keyword` varchar(255) NOT NULL COMMENT 'Maga a kulcsszo'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_languages_constant`
--

CREATE TABLE `opey_languages_constant` (
  `pn_constant` varchar(32) NOT NULL DEFAULT '',
  `pn_file` varchar(64) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_languages_file`
--

CREATE TABLE `opey_languages_file` (
  `pn_target` varchar(64) NOT NULL DEFAULT '',
  `pn_source` varchar(64) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_languages_translation`
--

CREATE TABLE `opey_languages_translation` (
  `pn_language` varchar(32) NOT NULL DEFAULT '',
  `pn_constant` varchar(32) NOT NULL DEFAULT '',
  `pn_translation` longblob NOT NULL,
  `pn_level` tinyint(4) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_library`
--

CREATE TABLE `opey_library` (
  `id` int(11) NOT NULL,
  `datum` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `folder_id` int(11) NOT NULL DEFAULT '0',
  `filename` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `tipus` varchar(10) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `kat_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `author` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `ev` int(11) NOT NULL DEFAULT '0',
  `lang` varchar(32) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `leiras` text CHARACTER SET utf8 NOT NULL,
  `kulcs` text CHARACTER SET utf8 NOT NULL,
  `uploader` int(11) NOT NULL DEFAULT '0',
  `mod_uid` tinyint(4) NOT NULL,
  `filesize` bigint(20) NOT NULL DEFAULT '0',
  `vedett` char(1) CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `webdoc` tinyint(4) NOT NULL DEFAULT '0',
  `einfoszab` tinyint(4) NOT NULL DEFAULT '0',
  `is_oai` tinyint(1) NOT NULL,
  `oai_id` int(11) DEFAULT NULL,
  `oai_set_id` int(11) DEFAULT NULL,
  `download` int(11) NOT NULL DEFAULT '0',
  `modify_date` datetime NOT NULL,
  `torolve` tinyint(1) NOT NULL DEFAULT '0',
  `torol_datum` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `torol_user` int(11) NOT NULL DEFAULT '0',
  `is_excludedfromsearch` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_library_archive`
--

CREATE TABLE `opey_library_archive` (
  `id` int(11) NOT NULL,
  `doc_id` int(11) NOT NULL,
  `version` int(11) NOT NULL,
  `filename` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `year` int(11) DEFAULT NULL,
  `datetime_changed` datetime NOT NULL,
  `changer_admin_id` int(11) NOT NULL,
  `datetime_archived` datetime NOT NULL,
  `archiver_admin_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_library_dockats`
--

CREATE TABLE `opey_library_dockats` (
  `doc_id` int(11) NOT NULL DEFAULT '0',
  `kat_id` int(11) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_library_doctopic`
--

CREATE TABLE `opey_library_doctopic` (
  `doc_id` int(11) NOT NULL DEFAULT '0',
  `topic_id` int(11) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_library_folders`
--

CREATE TABLE `opey_library_folders` (
  `id` int(11) NOT NULL,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `vedett` char(1) CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `torolve` tinyint(1) NOT NULL DEFAULT '0',
  `torol_datum` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `torol_user` int(11) NOT NULL DEFAULT '0',
  `moduldir` tinyint(4) NOT NULL,
  `modname` varchar(255) CHARACTER SET utf8 NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- A tábla adatainak kiíratása `opey_library_folders`
--

INSERT INTO `opey_library_folders` (`id`, `parent_id`, `name`, `vedett`, `torolve`, `torol_datum`, `torol_user`, `moduldir`, `modname`) VALUES
(1, 0, 'adatvedelem', 'N', 0, '0000-00-00 00:00:00', 0, 0, '');

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_library_folders_lang`
--

CREATE TABLE `opey_library_folders_lang` (
  `id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `lang` char(3) CHARACTER SET utf8 NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_library_kats`
--

CREATE TABLE `opey_library_kats` (
  `id` int(11) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `download` int(11) NOT NULL DEFAULT '0',
  `torolve` tinyint(1) NOT NULL DEFAULT '0',
  `torol_datum` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `torol_user` int(11) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_library_kats_lang`
--

CREATE TABLE `opey_library_kats_lang` (
  `id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `lang` char(3) CHARACTER SET utf8 NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_library_stats`
--

CREATE TABLE `opey_library_stats` (
  `id` int(11) NOT NULL,
  `doc_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `datum` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- A tábla adatainak kiíratása `opey_library_stats`
--

INSERT INTO `opey_library_stats` (`id`, `doc_id`, `user_id`, `datum`) VALUES
(1, 4, 0, '2018-07-02 20:42:40'),
(2, 4, 0, '2018-07-03 04:43:21'),
(3, 4, 0, '2018-07-03 23:18:12'),
(4, 4, 0, '2018-07-05 17:58:27'),
(5, 4, 0, '2018-07-06 09:30:06'),
(6, 4, 0, '2018-07-19 16:22:12'),
(7, 4, 0, '2018-07-25 05:32:41'),
(8, 4, 0, '2018-07-26 17:25:34'),
(9, 4, 0, '2018-07-27 02:07:10'),
(10, 4, 0, '2018-07-28 08:33:36'),
(11, 4, 0, '2018-07-30 06:49:05'),
(12, 4, 0, '2018-08-03 17:19:42'),
(13, 4, 0, '2018-08-10 18:12:13'),
(14, 4, 0, '2018-08-13 15:32:18'),
(15, 4, 0, '2018-10-04 11:30:04'),
(16, 4, 0, '2018-10-04 21:23:04'),
(17, 4, 0, '2018-10-10 22:07:28'),
(18, 4, 0, '2018-10-14 18:25:44'),
(19, 4, 0, '2018-10-20 19:05:58'),
(20, 4, 0, '2018-10-23 16:06:14'),
(21, 4, 0, '2018-10-28 10:49:45'),
(22, 4, 0, '2018-11-01 03:47:03'),
(23, 4, 0, '2018-11-09 17:22:56'),
(24, 4, 0, '2018-11-13 07:47:00'),
(25, 4, 0, '2018-11-14 03:47:26'),
(26, 4, 0, '2018-11-30 18:52:45'),
(27, 4, 0, '2018-12-06 12:35:57'),
(28, 4, 0, '2018-12-17 13:40:18'),
(29, 4, 0, '2018-12-20 18:21:22'),
(30, 4, 0, '2019-01-05 15:29:14'),
(31, 4, 0, '2019-01-14 04:52:32'),
(32, 4, 0, '2019-01-18 20:38:20'),
(33, 4, 0, '2019-01-20 08:47:33'),
(34, 4, 0, '2019-01-21 09:32:45'),
(35, 4, 0, '2019-01-23 13:38:31'),
(36, 4, 0, '2019-02-10 11:19:54'),
(37, 4, 0, '2019-02-14 03:10:11'),
(38, 4, 0, '2019-02-17 13:00:35'),
(39, 4, 0, '2019-02-17 14:12:31'),
(40, 4, 0, '2019-02-21 14:27:01'),
(41, 4, 0, '2019-03-04 23:50:06'),
(42, 4, 0, '2019-03-09 13:05:36'),
(43, 4, 0, '2019-03-14 11:19:57'),
(44, 4, 0, '2019-03-24 00:40:14'),
(45, 4, 0, '2019-03-27 05:04:58'),
(46, 4, 0, '2019-04-01 02:29:59'),
(47, 4, 0, '2019-04-01 02:30:00'),
(48, 4, 0, '2019-04-01 02:30:02'),
(49, 4, 0, '2019-04-01 02:30:02'),
(50, 4, 0, '2019-04-01 02:30:03'),
(51, 4, 0, '2019-04-01 02:30:03'),
(52, 4, 0, '2019-04-01 02:30:03'),
(53, 4, 0, '2019-04-01 02:30:04'),
(54, 4, 0, '2019-04-01 02:30:04'),
(55, 4, 0, '2019-04-01 02:30:04'),
(56, 4, 0, '2019-04-01 02:30:05'),
(57, 4, 0, '2019-04-01 02:30:05'),
(58, 4, 0, '2019-04-01 02:30:05'),
(59, 4, 0, '2019-04-01 02:30:06'),
(60, 4, 0, '2019-04-01 02:30:06'),
(61, 4, 0, '2019-04-01 02:30:06'),
(62, 4, 0, '2019-04-01 02:30:07'),
(63, 4, 0, '2019-04-01 02:30:07'),
(64, 4, 0, '2019-04-01 02:30:07'),
(65, 4, 0, '2019-04-01 02:30:08'),
(66, 4, 0, '2019-04-01 02:30:08'),
(67, 4, 0, '2019-04-05 07:51:02'),
(68, 4, 0, '2019-04-09 13:42:51'),
(69, 4, 0, '2019-04-10 11:58:05'),
(70, 4, 0, '2019-04-11 03:35:19'),
(71, 4, 0, '2019-04-11 03:35:28'),
(72, 4, 0, '2019-04-13 19:31:16'),
(73, 4, 0, '2019-04-13 19:31:17'),
(74, 4, 0, '2019-04-13 19:31:18'),
(75, 4, 0, '2019-04-13 19:31:19'),
(76, 4, 0, '2019-04-13 19:31:19'),
(77, 4, 0, '2019-04-13 19:31:19'),
(78, 4, 0, '2019-04-13 19:31:20'),
(79, 4, 0, '2019-04-13 19:31:20'),
(80, 4, 0, '2019-04-13 19:31:20'),
(81, 4, 0, '2019-04-13 19:31:21'),
(82, 4, 0, '2019-04-13 19:31:21'),
(83, 4, 0, '2019-04-13 19:31:21'),
(84, 4, 0, '2019-04-13 19:31:22'),
(85, 4, 0, '2019-04-13 19:31:22'),
(86, 4, 0, '2019-04-13 19:31:22'),
(87, 4, 0, '2019-04-13 19:31:23'),
(88, 4, 0, '2019-04-13 19:31:23'),
(89, 4, 0, '2019-04-13 19:31:23'),
(90, 4, 0, '2019-04-13 19:31:24'),
(91, 4, 0, '2019-04-13 19:31:24'),
(92, 4, 0, '2019-04-13 19:31:24'),
(93, 4, 0, '2019-04-17 04:37:54'),
(94, 4, 0, '2019-04-17 17:59:19'),
(95, 4, 0, '2019-04-19 19:13:09'),
(96, 4, 0, '2019-04-21 07:51:17'),
(97, 4, 0, '2019-04-24 17:37:42'),
(98, 4, 0, '2019-04-24 21:14:38'),
(99, 4, 0, '2019-05-01 21:18:06'),
(100, 4, 0, '2019-05-08 11:16:41'),
(101, 4, 0, '2019-05-15 17:43:20');

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_library_topic`
--

CREATE TABLE `opey_library_topic` (
  `id` int(11) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `download` int(11) NOT NULL DEFAULT '0',
  `torolve` tinyint(1) NOT NULL DEFAULT '0',
  `torol_datum` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `torol_user` int(11) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_library_topic_lang`
--

CREATE TABLE `opey_library_topic_lang` (
  `id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `lang` char(3) CHARACTER SET utf8 NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_linkchecker_details`
--

CREATE TABLE `opey_linkchecker_details` (
  `link_id` int(11) NOT NULL,
  `sh_id` int(11) NOT NULL,
  `shortlink` varchar(255) CHARACTER SET utf8 NOT NULL,
  `url` varchar(255) CHARACTER SET utf8 NOT NULL,
  `link_text` varchar(255) CHARACTER SET utf8 NOT NULL,
  `result` varchar(100) CHARACTER SET utf8 NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_linkchecker_info`
--

CREATE TABLE `opey_linkchecker_info` (
  `tip` varchar(10) CHARACTER SET utf8 NOT NULL,
  `last_start` datetime NOT NULL,
  `last_end` datetime NOT NULL,
  `user_id` int(11) NOT NULL,
  `user_name` varchar(255) CHARACTER SET utf8 NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_linkchecker_links`
--

CREATE TABLE `opey_linkchecker_links` (
  `id` int(11) NOT NULL,
  `url` varchar(255) CHARACTER SET utf8 NOT NULL,
  `result` varchar(255) CHARACTER SET utf8 NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_mailadmindomains`
--

CREATE TABLE `opey_mailadmindomains` (
  `domain` varchar(50) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `defQuota` int(11) NOT NULL DEFAULT '0',
  `maxQuota` int(11) NOT NULL DEFAULT '0',
  `maxEmail` int(11) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- A tábla adatainak kiíratása `opey_mailadmindomains`
--

INSERT INTO `opey_mailadmindomains` (`domain`, `defQuota`, `maxQuota`, `maxEmail`) VALUES
('atlantiszklima.hu', 23068672, 52428800, 10);

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_menuitems`
--

CREATE TABLE `opey_menuitems` (
  `id` bigint(15) NOT NULL,
  `menuid` bigint(15) NOT NULL DEFAULT '0',
  `parentid` bigint(15) NOT NULL DEFAULT '0',
  `params` text,
  `tmp_id` bigint(15) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- A tábla adatainak kiíratása `opey_menuitems`
--

INSERT INTO `opey_menuitems` (`id`, `menuid`, `parentid`, `params`, `tmp_id`) VALUES
(19, 2, 0, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:7:"Rólunk";s:9:"mi_linkto";s:7:"/rolunk";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(20, 2, 0, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:9:"Termékek";s:9:"mi_linkto";s:9:"/termekek";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(21, 2, 0, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:12:"Letöltések";s:9:"mi_linkto";s:11:"/letoltesek";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(22, 2, 0, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:12:"Referenciák";s:9:"mi_linkto";s:12:"/referenciak";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(23, 2, 0, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:9:"Kapcsolat";s:9:"mi_linkto";s:10:"/kapcsolat";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(24, 2, 0, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:24:"Toshiba partnerhálózat";s:9:"mi_linkto";s:23:"/toshiba_partnerhalozat";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(31, 6, 0, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:7:"Rólunk";s:9:"mi_linkto";s:7:"/rolunk";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(32, 6, 0, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:12:"Referenciák";s:9:"mi_linkto";s:12:"/referenciak";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(33, 6, 0, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:9:"Kapcsolat";s:9:"mi_linkto";s:10:"/kapcsolat";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(34, 6, 0, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:24:"Toshiba partnerhálózat";s:9:"mi_linkto";s:23:"/toshiba_partnerhalozat";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(35, 6, 0, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:10:"Impresszum";s:9:"mi_linkto";s:11:"/impresszum";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(36, 6, 0, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:24:"Adatvédelmi nyilatkozat";s:9:"mi_linkto";s:24:"/adatvedelmi_nyilatkozat";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(37, 7, 0, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:7:"Rólunk";s:9:"mi_linkto";s:7:"/rolunk";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(38, 7, 0, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:12:"Referenciák";s:9:"mi_linkto";s:12:"/referenciak";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(39, 7, 0, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:9:"Kapcsolat";s:9:"mi_linkto";s:10:"/kapcsolat";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(40, 7, 0, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:24:"Toshiba partnerhálózat";s:9:"mi_linkto";s:23:"/toshiba_partnerhalozat";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(41, 7, 0, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:10:"Impresszum";s:9:"mi_linkto";s:11:"/impresszum";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(42, 7, 0, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:24:"Adatvédelmi nyilatkozat";s:9:"mi_linkto";s:24:"/adatvedelmi_nyilatkozat";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(43, 5, 0, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:7:"Rólunk";s:9:"mi_linkto";s:7:"/rolunk";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(44, 5, 0, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:12:"Referenciák";s:9:"mi_linkto";s:12:"/referenciak";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(45, 5, 0, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:9:"Kapcsolat";s:9:"mi_linkto";s:10:"/kapcsolat";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(46, 5, 0, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:24:"Toshiba partnerhálózat";s:9:"mi_linkto";s:23:"/toshiba_partnerhalozat";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(47, 5, 0, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:10:"Impresszum";s:9:"mi_linkto";s:11:"/impresszum";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(48, 5, 0, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:24:"Adatvédelmi nyilatkozat";s:9:"mi_linkto";s:24:"/adatvedelmi_nyilatkozat";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(74, 8, 0, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:10:"Lakossági";s:9:"mi_linkto";s:0:"";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(75, 8, 74, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:4:"Mono";s:9:"mi_linkto";s:0:"";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(76, 8, 74, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:5:"Multi";s:9:"mi_linkto";s:0:"";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(77, 8, 0, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:8:"Kisipari";s:9:"mi_linkto";s:0:"";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(78, 8, 77, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:8:"Beltéri";s:9:"mi_linkto";s:0:"";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(79, 8, 77, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:9:"Kültéri";s:9:"mi_linkto";s:0:"";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(80, 8, 77, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:20:"DX csomagolómodulok";s:9:"mi_linkto";s:0:"";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(81, 8, 77, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:28:"Iker és hármas megoldások";s:9:"mi_linkto";s:0:"";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(82, 8, 0, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:3:"VRF";s:9:"mi_linkto";s:0:"";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(83, 8, 82, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:8:"Beltéri";s:9:"mi_linkto";s:0:"";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(84, 8, 82, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:9:"Kültéri";s:9:"mi_linkto";s:0:"";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(85, 8, 0, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:14:"Szellőztetés";s:9:"mi_linkto";s:0:"";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(86, 8, 85, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:28:"Levegő-levegő hőcserélő";s:9:"mi_linkto";s:0:"";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(87, 8, 85, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:44:"Levegő-levegő hőcserélő DX-regiszterrel";s:9:"mi_linkto";s:0:"";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(88, 8, 85, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:64:"Levegő-levegő hőcserélő DX-regiszterrel és párásítóval";s:9:"mi_linkto";s:0:"";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(89, 8, 0, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:5:"ESTIA";s:9:"mi_linkto";s:0:"";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(90, 8, 89, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:18:"Beltéri egységek";s:9:"mi_linkto";s:0:"";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(91, 8, 89, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:19:"Kültéri egységek";s:9:"mi_linkto";s:0:"";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(92, 8, 89, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:13:"HMV-tárolók";s:9:"mi_linkto";s:0:"";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(93, 8, 89, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:14:"Kiegészítők";s:9:"mi_linkto";s:0:"";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(94, 8, 0, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:10:"Vezérlők";s:9:"mi_linkto";s:0:"";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(95, 8, 94, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:16:"Helyi vezérlők";s:9:"mi_linkto";s:0:"";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(96, 8, 94, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:20:"Központi vezérlők";s:9:"mi_linkto";s:0:"";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(97, 8, 94, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:31:"Épületfelügyeleti rendszerek";s:9:"mi_linkto";s:0:"";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0),
(98, 8, 94, 'a:11:{s:10:"mi_usetext";b:1;s:10:"mi_caption";s:20:"Külső vezérlések";s:9:"mi_linkto";s:0:"";s:9:"mi_target";s:5:"_self";s:7:"mi_type";N;s:10:"mi_tiptext";s:0:"";s:9:"mi_status";s:0:"";s:13:"mi_sameaslink";b:0;s:8:"mi_align";N;s:9:"mi_valign";N;s:8:"mi_width";s:0:"";}', 0);

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_menuitems_archive`
--

CREATE TABLE `opey_menuitems_archive` (
  `id` bigint(15) NOT NULL,
  `menuid` bigint(15) NOT NULL DEFAULT '0',
  `parentid` bigint(15) NOT NULL DEFAULT '0',
  `params` text
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_menus`
--

CREATE TABLE `opey_menus` (
  `id` bigint(15) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `lang` char(3) NOT NULL DEFAULT 'eng',
  `params` text NOT NULL,
  `deleted` tinyint(4) NOT NULL,
  `delete_uid` int(11) NOT NULL,
  `delete_date` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- A tábla adatainak kiíratása `opey_menus`
--

INSERT INTO `opey_menus` (`id`, `name`, `lang`, `params`, `deleted`, `delete_uid`, `delete_date`) VALUES
(2, 'MainMenu', 'eng', '', 0, 0, '0000-00-00 00:00:00'),
(7, 'footer_main_menu', 'eng', '', 1, 599, '2019-05-29 10:21:51'),
(8, 'footer_main_categories', 'eng', '', 0, 0, '0000-00-00 00:00:00'),
(9, 'footer_main_menu', 'eng', '', 0, 599, '2019-05-29 10:21:51');

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_menus_archive`
--

CREATE TABLE `opey_menus_archive` (
  `id` bigint(15) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `lang` char(3) NOT NULL DEFAULT 'eng',
  `params` text NOT NULL,
  `orig_id` bigint(15) NOT NULL,
  `add_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_menu_default`
--

CREATE TABLE `opey_menu_default` (
  `menuid` bigint(15) NOT NULL,
  `type` enum('f','u') NOT NULL,
  `params` text CHARACTER SET utf8 NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_minicatalog`
--

CREATE TABLE `opey_minicatalog` (
  `id` int(5) NOT NULL,
  `name` varchar(200) NOT NULL,
  `parent_id` int(5) NOT NULL DEFAULT '0',
  `desc_short` varchar(255) DEFAULT NULL,
  `block_id` tinyint(5) NOT NULL,
  `template` varchar(255) NOT NULL DEFAULT '',
  `del` enum('n','i') NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- A tábla adatainak kiíratása `opey_minicatalog`
--

INSERT INTO `opey_minicatalog` (`id`, `name`, `parent_id`, `desc_short`, `block_id`, `template`, `del`) VALUES
(1, 'asd', 0, '', 0, '', 'n');

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_minicatalog_image`
--

CREATE TABLE `opey_minicatalog_image` (
  `id` int(5) NOT NULL,
  `name` varchar(200) NOT NULL,
  `real_name` varchar(100) NOT NULL,
  `parent_id` int(5) NOT NULL DEFAULT '0',
  `type` varchar(10) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_minicatalog_item`
--

CREATE TABLE `opey_minicatalog_item` (
  `id` int(5) NOT NULL,
  `name` varchar(200) NOT NULL,
  `parent_id` int(5) NOT NULL DEFAULT '0',
  `desc_short` varchar(255) DEFAULT NULL,
  `desc_long` text,
  `cikkszam` varchar(20) NOT NULL,
  `jellemzo` varchar(255) NOT NULL,
  `emphasized_item` tinyint(1) NOT NULL,
  `kiszereles` varchar(255) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_minicatalog_option`
--

CREATE TABLE `opey_minicatalog_option` (
  `name` varchar(30) CHARACTER SET utf8 NOT NULL,
  `value` varchar(30) CHARACTER SET utf8 NOT NULL,
  `real_name` varchar(50) CHARACTER SET utf8 NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- A tábla adatainak kiíratása `opey_minicatalog_option`
--

INSERT INTO `opey_minicatalog_option` (`name`, `value`, `real_name`) VALUES
('maxImageWidth', '500', 'Kép szélesség'),
('maxImageWidthTmb', '500', 'Kis kép szélesség'),
('sample_sh_id', '8', 'Minta oldal shortlinkje'),
('shortlink_prefix', 'termekeink', 'Shortlink előtag'),
('long_link', '0', 'Hosszú hivatkozás'),
('sample_sh_id', '8', 'Minta oldal shortlinkje'),
('shortlink_prefix', 'termekeink', 'Shortlink előtag'),
('long_link', '0', 'Hosszú hivatkozás');

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_minicatalog_properties`
--

CREATE TABLE `opey_minicatalog_properties` (
  `prop_id` int(5) NOT NULL,
  `prop_name` varchar(255) NOT NULL,
  `prop_title` varchar(255) NOT NULL,
  `prop_type` varchar(255) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- A tábla adatainak kiíratása `opey_minicatalog_properties`
--

INSERT INTO `opey_minicatalog_properties` (`prop_id`, `prop_name`, `prop_title`, `prop_type`) VALUES
(1, 'kiszereles', 'Kiszerelés', 'text');

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_modules`
--

CREATE TABLE `opey_modules` (
  `pn_id` int(11) UNSIGNED NOT NULL,
  `pn_name` varchar(64) NOT NULL DEFAULT '',
  `pn_type` int(6) NOT NULL DEFAULT '0',
  `pn_displayname` varchar(64) NOT NULL DEFAULT '',
  `pn_description` varchar(255) NOT NULL DEFAULT '',
  `pn_regid` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `pn_directory` varchar(64) NOT NULL DEFAULT '',
  `pn_version` varchar(10) NOT NULL DEFAULT '0',
  `pn_supports_moduleinfo` tinyint(1) NOT NULL DEFAULT '0',
  `pn_admin_capable` tinyint(1) NOT NULL DEFAULT '0',
  `pn_user_capable` tinyint(1) NOT NULL DEFAULT '0',
  `pn_state` tinyint(1) NOT NULL DEFAULT '0',
  `pn_blocks_type` int(11) NOT NULL DEFAULT '0',
  `pn_blocks_id` text NOT NULL,
  `oeLayout` int(11) NOT NULL DEFAULT '1'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- A tábla adatainak kiíratása `opey_modules`
--

INSERT INTO `opey_modules` (`pn_id`, `pn_name`, `pn_type`, `pn_displayname`, `pn_description`, `pn_regid`, `pn_directory`, `pn_version`, `pn_supports_moduleinfo`, `pn_admin_capable`, `pn_user_capable`, `pn_state`, `pn_blocks_type`, `pn_blocks_id`, `oeLayout`) VALUES
(7, 'Admin', 1, 'Admin', 'Administration', 9, 'OE-Admin', '0.1', 0, 1, 0, 3, 0, '61', 2),
(17, 'Modules', 2, 'Modules', 'Module configuration', 1, 'Modules', '2.0', 0, 1, 0, 3, 0, '0', 2),
(418, 'ErrorAdmin', 1, 'ErrorAdmin', 'Hiba adminisztr&aacute;ci&oacute;', 0, 'ErrorAdmin', '0.1', 0, 1, 1, 3, 0, '', 1),
(419, 'ArculatEditor', 1, 'ArculatEditor', 'Arculat szerkeszt&#337; modul', 0, 'ArculatEditor', '1.2', 0, 1, 1, 3, 0, '', 1),
(420, 'SqlDump', 1, 'SqlDump', 'Sql adatb&aacute;zis dump', 0, 'SqlDump', '1.0', 0, 1, 0, 1, 0, '', 1),
(421, 'Blocks', 2, 'Blocks', 'Az oldals&oacute; &eacute;s k&ouml;z&eacute;ps&#337; blokkok adminisztr&aacute;ci&oacute;ja', 13, 'Blocks', '2.0', 0, 1, 1, 3, 0, '', 1),
(422, 'Cimlap', 2, 'Cimlap', 'OpenEye - Nyitó oldal modul', 0, 'Cimlap', '1.0', 0, 0, 1, 1, 0, '', 1),
(423, 'Contact_Us', 1, 'Contact Us', 'Contact Module', 0, 'Contact_Us', '1.2', 0, 1, 1, 3, 0, '', 1),
(424, 'ErrorPage', 1, 'ErrorPage', 'OpenEye - Hibalista(404)', 0, 'ErrorPage', '1.0', 0, 0, 1, 3, 0, '', 3),
(425, 'Members_List', 1, 'Members List', 'Tag lista modul', 0, 'Members_List', '1.0', 0, 0, 1, 1, 0, '', 1),
(426, 'Admin_Messages', 1, 'Admin Messages', 'Automatiz&aacute;lt/programozott &uuml;zenetek megjelen&iacute;t&eacute;se.', 0, 'OE-Admin_Messages', '1.2', 0, 1, 0, 1, 0, '', 1),
(427, 'RSSAdmin', 1, 'RSSAdmin', 'RSS kimenet adminisztracio', 0, 'OE-RSSAdmin', '1.0', 0, 1, 1, 3, 0, '', 1),
(428, 'MailAdmin', 1, 'MailAdmin', 'PatroNet CMS - E-mail admin', 0, 'OE-MailAdmin', '1.0', 0, 1, 0, 3, 0, '', 1),
(429, 'CMS', 1, 'CMS', 'CMS Content Pages', 0, 'OE-CMS', '1.0', 0, 1, 1, 3, 0, '', 1),
(430, 'Groups', 1, 'Groups', 'Csoportok szerkeszt&eacute;se', 16, 'OE-Groups', '0.1', 0, 1, 0, 3, 0, '', 1),
(431, 'Languages', 1, 'Languages', 'Nyelvek list&aacute;z&aacute;sa &eacute;s ISO.', 17, 'OE-Languages', '1.2', 0, 1, 0, 3, 0, '', 1),
(432, 'LostPassword', 1, 'LostPassword', 'Elk&uuml;ldi az elvesztett jelsz&oacute;t a felhaszn&aacute;l&oacute;nak.', 18, 'OE-LostPassword', '0,5', 0, 0, 0, 1, 0, '', 1),
(433, 'Multisites', 1, 'Multisites', '', 20, 'OE-Multisites', '0', 0, 0, 0, 1, 0, '', 1),
(434, 'Default', 1, 'Default', 'Sablon modul', 0, 'Default', '1.0', 0, 1, 1, 1, 0, '', 1),
(435, 'Settings', 1, 'Settings', 'A honlap alapbe&aacute;ll&iacute;t&aacute;sai.', 26, 'OE-Settings', '1.2', 0, 1, 0, 3, 0, '', 1),
(436, 'ShortLink', 1, 'ShortLink', 'R&ouml;vid el&eacute;r&eacute;si utak be&aacute;ll&iacute;t&aacute;sai', 0, 'OE-ShortLink', '1.1', 0, 1, 0, 3, 0, '', 1),
(437, 'Statistics', 1, 'Statistics', 'Statisztik&aacute;k &eacute;s riportok', 0, 'OE-Statistics', '1.0', 0, 1, 1, 1, 0, '', 1),
(438, 'User', 1, 'User', 'OpenEye k&ouml;zponti modul', 27, 'OE-User', '0.1', 0, 1, 0, 3, 0, '', 1),
(439, 'Your_Account', 1, 'Your Account', 'Felhaszn&aacute;l&oacute;i be&aacute;ll&iacute;t&aacute;sok', 0, 'OE-Your_Account', '1.0', 0, 0, 1, 3, 0, '', 1),
(440, 'Permissions', 2, 'Permissions', 'Biztons&aacute;gi jogosults&aacute;gok m&oacute;dos&iacute;t&aacute;sa', 22, 'Permissions', '0.1', 0, 1, 0, 3, 0, '', 1),
(441, 'BlockEditor', 1, 'BlockEditor', 'Block Editor', 0, 'OE-BlockEditor', '1.0', 0, 1, 1, 3, 0, '', 1),
(442, 'StartLap', 1, 'StartLap', 'OpenEye - Nyit&oacute; oldal modul', 0, 'StartLap', '1.0', 0, 0, 1, 1, 0, '', 1),
(443, 'News', 1, 'News', '', 7, 'OE-News', '0', 0, 1, 1, 3, 0, '', 1),
(444, 'xmlrpc', 1, 'xmlrpc', 'XML-RPC kliens &eacute;s szerver k&oacute;d', 40, 'xmlrpc', '1.0', 0, 0, 0, 1, 0, '', 1),
(445, 'ObjectEditor', 1, 'ObjectEditor', 'CMS Objects Editor', 0, 'OE-ObjectEditor', '1.2', 0, 1, 1, 3, 0, '', 1),
(446, 'SimpleMenuBuilder', 1, 'SimpleMenuBuilder', 'PatroNet CMS - Simple DHTML Menu Builder', 0, 'OE-SimpleMenuBuilder', '1.0', 0, 1, 0, 1, 0, '', 1),
(526, 'ErrorAdmin2', 1, 'ErrorAdmin2', 'Hiba adminisztráció v2', 0, 'ErrorAdmin2', '2.0', 0, 1, 1, 4, 0, '', 1),
(449, 'Newsletter', 1, 'Newsletter', 'OE Newsletter', 0, 'OE-Newsletter', '1.2', 0, 1, 1, 3, 0, '', 1),
(450, 'CagaShop', 1, 'CagaShop', 'Caga Shop', 0, 'CagaShop', '1.0', 0, 1, 1, 4, 0, '', 1),
(451, 'Guestbook', 1, 'Guestbook', 'Guestbook', 0, 'Guestbook', '1.0', 0, 0, 1, 1, 0, '', 1),
(452, 'DocManager', 1, 'DocManager', 'Document Manager', 0, 'OE-DocManager', '1.2', 0, 1, 1, 1, 0, '', 1),
(525, 'SiteStatistics2', 1, 'SiteStatistics2', 'Site statisztika adminisztracio 2008', 0, 'SiteStatistics2', '2.0', 0, 1, 1, 4, 0, '', 1),
(454, 'Help', 1, 'Help', 'OpenEye CMS help rendszer', 0, 'OE-Help', '1.0', 0, 1, 1, 1, 0, '', 1),
(455, 'IngatlanShop', 1, 'IngatlanShop', 'Ingatlan Shop', 0, 'IngatlanShop', '1.0', 0, 1, 1, 4, 0, '', 1),
(456, 'SearchEngine', 1, 'SearchEngine', 'OpenEye CMS  - Search Engine', 0, 'OE-SearchEngine', '1.0', 0, 1, 1, 3, 0, '', 3),
(524, 'Forum-ERRA', 1, 'Forum-ERRA', 'Forum modul', 0, 'Forum-ERRA', '1.0', 0, 1, 1, 1, 0, '', 1),
(458, 'FormSender', 2, 'FormSender', '', 0, 'FormSender', '0', 0, 0, 1, 5, 0, '', 1),
(459, 'Autolinks', 1, 'Autolinks', 'Automatically link key words', 0, 'Autolinks', '1.01', 0, 1, 0, 3, 0, '', 1),
(460, 'MenuBuilder', 1, 'MenuBuilder', 'OpenEye CMS - DHTML Munu Builder', 0, 'OE-MenuBuilder', '1.0', 0, 1, 0, 3, 0, '', 1),
(461, 'PopUp', 1, 'PopUp', 'Felugr&oacute; ablakok adminisztr&aacute;ci&oacute;ja', 0, 'OE-PopUp', '1.0', 0, 1, 1, 3, 0, '', 1),
(462, 'Journal', 1, 'Journal', 'Rendszer napl&oacute;', 0, 'OE-Journal', '1.0', 0, 1, 1, 3, 0, '', 1),
(463, 'SiteStatistics', 1, 'SiteStatistics', 'Site statisztika adminisztracio', 0, 'SiteStatistics', '1.0', 0, 1, 1, 3, 0, '', 1),
(464, 'photoshare', 2, 'photoshare', 'Online photo album', 0, 'photoshare', '3.0.0', 0, 1, 1, 4, 0, '', 1),
(465, 'TeaShop', 1, 'TeaShop', 'Tea Shop', 0, 'TeaShop', '1.0', 0, 1, 1, 1, 0, '', 1),
(466, 'Kepgaleria', 1, 'Kepgaleria', 'Kategorizált képgaléria', 0, 'Kepgaleria', '1.0', 0, 1, 1, 1, 0, '', 1),
(467, 'FAQ', 1, 'FAQ', 'Gyakran Ismételt Kérdések modul', 4, 'FAQ', '1.11', 0, 1, 1, 3, 0, '', 1),
(468, 'CourierPro', 1, 'CourierPro', 'Folyoirat kezel&#337;', 0, 'CourierPro', '1.0', 0, 1, 1, 2, 0, '', 1),
(469, 'BlockAdmin', 1, 'BlockAdmin', 'Blockok Adminja', 0, 'BlockAdmin', '1.0', 0, 1, 0, 3, 0, '', 1),
(470, 'Ajanlo', 1, 'Ajanlo', 'Aj&aacute;nlja a honlapot/Elk&uuml;ldi a h&iacute;reket ismer&#337;s&ouml;knek', 0, 'Ajanlo', '1.0', 0, 0, 1, 5, 0, '', 1),
(471, 'Linkek', 1, 'Linkek', 'Linkgyûjtemény', 0, 'Linkek', '1.0', 0, 1, 1, 1, 0, '', 1),
(472, 'KeywordRedirect', 1, 'KeywordRedirect', 'Set up keywords for landing redirect', 0, 'OE-KeywordRedirect', '1.0', 0, 1, 0, 1, 0, '', 1),
(473, 'OldAdmin', 1, 'OldAdmin', 'Régi OpenEye adminisztráció kompatibilitás', 0, 'OE-OldAdmin', '1.0', 0, 1, 0, 1, 0, '', 1),
(474, 'PageRank', 1, 'PageRank', 'PageRank checker module for PatroNet CMS', 0, 'PageRank', '1.0', 0, 0, 1, 1, 0, '', 1),
(475, 'eLibrary', 1, 'eLibrary', 'Document Library', 0, 'OE-eLibrary', '1.2', 0, 1, 1, 3, 0, '', 1),
(529, 'NewsTickerFL', 2, 'NewsTickerFL', 'Flash News Ticker', 0, 'NewsTickerFL', '1.1', 0, 1, 1, 1, 0, '', 1),
(477, 'WHOIS', 2, 'WHOIS', 'Whois module for PatroNet CMS', 0, 'WHOIS', '1.0', 0, 0, 1, 1, 0, '', 1),
(530, 'MiniCatalog', 1, 'MiniCatalog', 'Mini Catalog', 0, 'MiniCatalog', '1.0', 0, 1, 1, 3, 0, '', 1),
(528, 'Jelentkezes', 1, 'Jelentkezes', 'PatroNet Jelentkezes', 0, 'Jelentkezes', '1.2', 0, 1, 1, 1, 0, '', 1),
(539, 'eShop', 1, 'eShop', 'eShop module', 0, 'eShop', '1.0', 0, 1, 1, 3, 0, '', 3),
(483, 'UserAdmin_Basic', 1, 'UserAdmin Basic', 'UserAdmin Basic', 0, 'UserAdmin_Basic', '1.0', 0, 1, 1, 3, 0, '', 1),
(484, 'Forum', 1, 'Forum', 'Forum modul', 0, 'Forum', '1.0', 0, 1, 1, 2, 0, '', 1),
(488, 'Postcard', 1, 'Postcard', 'E-mailes képeslapküldô', 0, 'Postcard', '1.0', 0, 1, 1, 1, 0, '', 1),
(492, 'BookShop', 1, 'BookShop', 'Book Shop', 0, 'BookShop', '1.0', 0, 1, 1, 3, 0, '', 1),
(493, 'DomainReg', 1, 'DomainReg', 'Domain registration', 0, 'DomainReg', '1.0', 0, 1, 1, 4, 0, '', 1),
(494, 'MailBag', 2, 'MailBag', 'E-mail Processor', 0, 'MailBag', '0.82', 0, 1, 0, 1, 0, '', 1),
(495, 'ImageGalleryNew', 1, 'ImageGalleryNew', 'Image Gallery New', 0, 'ImageGalleryNew', '1.0', 0, 1, 1, 3, 0, '', 1),
(496, 'Vote', 1, 'Vote', 'Szavaz&aacute;s', 0, 'OE-Vote', '1.0', 0, 1, 1, 1, 0, '', 1),
(497, 'Einfoszab', 1, 'Einfoszab', 'Einfoszab kiszolgalo', 0, 'Einfoszab', '1.0', 0, 1, 1, 1, 0, '', 1),
(498, 'Aprohirdetes', 1, 'Aprohirdetes', 'Aprohirdetes modul', 0, 'Aprohirdetes', '1.0', 0, 1, 1, 1, 0, '', 1),
(499, 'Allasborze', 1, 'Allasborze', 'Allasborze', 0, 'Allasborze', '1.0', 0, 1, 1, 1, 0, '', 1),
(500, 'ECard', 1, 'ECard', 'ECard', 0, 'ECard', '1.0', 0, 1, 1, 1, 0, '', 1),
(501, 'FitnessJelentkezes', 1, 'FitnessJelentkezes', 'Fitness Jelentkezes', 0, 'FitnessJelentkezes', '1.0', 0, 1, 1, 1, 0, '', 1),
(505, 'TemplateStore', 1, 'TemplateStore', 'Template Store', 0, 'TemplateStore', '1.0', 0, 1, 1, 1, 0, '', 1),
(506, 'Kerdoiv', 1, 'Kerdoiv', 'Kerdoiv', 0, 'Kerdoiv', '1.0', 0, 1, 1, 1, 0, '', 1),
(507, 'iPhone', 1, 'iPhone', 'iPhone GUI for PatroNet CMS', 0, 'iPhone', '1.0', 0, 1, 1, 4, 0, '', 1),
(508, 'SiteRegeneration', 1, 'SiteRegeneration', 'Portál újra publikálása (HTML generálás)', 0, 'SiteRegeneration', '1.0', 0, 1, 0, 3, 0, '', 1),
(511, 'URLforwarder', 1, 'URLforwarder', 'URL átirányítások adminisztrációja', 0, 'URLforwarder', '1.0', 0, 1, 0, 3, 0, '', 1),
(513, 'VideoConverter', 1, 'VideoConverter', 'Video konverter', 0, 'VideoConverter', '1.0', 0, 1, 0, 3, 0, '', 1),
(514, 'TemplateAccess', 1, 'TemplateAccess', 'Honlap sablon konyvtarak elerese', 0, 'TemplateAccess', '1.0', 0, 1, 1, 1, 0, '', 1),
(515, 'AdminHome', 1, 'AdminHome', 'Admin Home', 0, 'AdminHome', '1.0', 0, 1, 1, 3, 0, '', 1),
(517, 'Approval', 1, 'Approval', 'Jóváhagyatás', 0, 'OE-Approval', '1.0', 0, 1, 1, 1, 0, '', 1),
(518, 'adServerLogin', 1, 'adServerLogin', 'adServerLogin', 0, 'adServerLogin', '1.0', 0, 0, 1, 1, 0, '', 1),
(519, 'FileManager', 1, 'FileManager', 'File Manager', 0, 'FileManager', '1.0', 0, 1, 1, 1, 0, '', 1),
(522, 'Favorites', 1, 'Favorites', 'Kedvencek blokk es funkcioi;', 0, 'OE-Favorites', '1.0', 0, 1, 1, 1, 0, '', 1),
(531, 'Bloghirek', 1, 'Bloghirek', 'Bloghirek', 0, 'Bloghirek', '1.0', 0, 1, 1, 1, 0, '', 1),
(532, 'CegKutatas', 1, 'CegKutatas', 'Ceges kutatas', 0, 'CegKutatas', '1.0', 0, 1, 1, 1, 0, '', 1),
(533, 'MobileView', 2, 'MobileView', '', 0, 'MobileView', '0', 0, 0, 1, 4, 0, '', 1),
(534, 'dplink', 2, 'dplink', 'Postnuke to dotProject login manager', 0, 'dplink', '1.02', 0, 1, 1, 4, 0, '', 1),
(535, 'PartnerLekerdezes', 1, 'PartnerLekerdezes', 'Partner kerdoivlekerdezes', 0, 'PartnerLekerdezes', '1.0', 0, 1, 1, 1, 0, '', 1),
(536, 'BioKatalogus', 1, 'BioKatalogus', 'Bio Katalogus', 0, 'BioKatalogus', '1.0', 0, 1, 1, 1, 0, '', 1),
(537, 'EventCalendar', 1, 'EventCalendar', 'Eseménynaptár', 0, 'EventCalendar', '1.0', 0, 1, 1, 3, 0, '', 1),
(538, 'Vendegkonyv', 1, 'Vendegkonyv', 'Vendégkönyv', 0, 'Vendegkonyv', '1.0', 0, 1, 1, 3, 0, '', 1),
(540, 'Keyword', 1, 'Keyword', 'Keyword', 0, 'Keyword', '1.0', 0, 1, 1, 3, 0, '', 1),
(541, 'BookShopAdv', 1, 'BookShopAdv', 'Könyváruház (Adv)', 0, 'BookShopAdv', '1.0', 0, 1, 1, 1, 0, '', 1),
(542, 'SysUpdate', 1, 'SysUpdate', 'PatroNet CMS version updater', 0, 'OE-SysUpdate', '1.0', 0, 1, 0, 1, 0, '', 1),
(543, 'Blog', 1, 'Blog', 'Blog', 0, 'Blog', '1.0', 0, 1, 1, 1, 0, '', 1),
(544, 'LinkExchange', 1, 'LinkExchange', 'Link Exchange', 0, 'LinkExchange', '1.0', 0, 1, 1, 1, 0, '', 1),
(545, 'LinkChecker', 1, 'LinkChecker', 'Törött linkek ellenőrzése', 0, 'LinkChecker', '1.0', 0, 1, 1, 1, 0, '', 1),
(546, 'instantSite', 1, 'instantSite', 'Instant Site Creator', 0, 'instantSite', '0.1', 0, 1, 1, 1, 0, '', 1),
(547, 'SEO2', 1, 'SEO2', '', 0, 'SEO2', '0', 0, 1, 1, 1, 0, '', 1),
(548, 'TicketSmith', 1, 'TicketSmith', 'Ügyfélszolgálat', 0, 'TicketSmith', '1.0', 0, 1, 1, 3, 0, '', 1),
(549, 'Webshop', 1, 'Webshop', 'Webshop module', 0, 'Webshop', '1.0', 0, 1, 1, 1, 0, '', 1),
(550, 'NewsPortal', 1, 'NewsPortal', 'NewsPortal', 0, 'NewsPortal', '1.0', 0, 1, 1, 1, 0, '', 1),
(551, 'OnlineBanking', 1, 'OnlineBanking', 'Online Banking', 0, 'OnlineBanking', '1.2', 0, 1, 0, 1, 0, '', 1),
(552, 'GitUpdate', 1, 'GitUpdate', 'Git update', 0, 'OE-GitUpdate', '1.0', 0, 1, 1, 1, 0, '', 1),
(553, 'DelayedEventRunner', 1, 'DelayedEventRunner', '', 0, 'DelayedEventRunner', '0', 0, 0, 1, 1, 0, '', 1),
(554, 'MiniOrder', 1, 'MiniOrder', 'Mini rendeles', 0, 'MiniOrder', '1.0', 0, 1, 1, 3, 0, '', 1);

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_module_vars`
--

CREATE TABLE `opey_module_vars` (
  `pn_id` int(11) UNSIGNED NOT NULL,
  `pn_modname` varchar(64) NOT NULL DEFAULT '',
  `pn_name` varchar(64) NOT NULL DEFAULT '',
  `pn_value` longtext,
  `lang` varchar(16) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- A tábla adatainak kiíratása `opey_module_vars`
--

INSERT INTO `opey_module_vars` (`pn_id`, `pn_modname`, `pn_name`, `pn_value`, `lang`) VALUES
(1, '/PNConfig', 'debug', 'i:0;', ''),
(2, '/PNConfig', 'sitename', 's:16:"Atlantisz klíma";', ''),
(689, '/PNConfig', 'slogan', 's:0:"";', ''),
(5, '/PNConfig', 'metakeywords', 's:0:"";', ''),
(595, '/PNConfig', 'funtext', 's:1:"0";', ''),
(596, '/PNConfig', 'blindpage', 's:1:"0";', ''),
(597, '/PNConfig', 'foot1', 's:0:"";', ''),
(598, '/PNConfig', 'intranet', 's:1:"0";', ''),
(601, '/PNConfig', 'dyn_keywords', 's:1:"0";', ''),
(7, '/PNConfig', 'startdate', 's:11:"2016.11.01.";', ''),
(8, '/PNConfig', 'adminmail', 's:16:"info@patronet.hu";', ''),
(9, '/PNConfig', 'Default_Theme', 's:7:"Default";', ''),
(10, '/PNConfig', 'commentlimit', 'i:4096;', ''),
(11, '/PNConfig', 'anonymous', 's:9:"Anonymous";', ''),
(12, '/PNConfig', 'defaultgroup', 's:5:"Users";', ''),
(13, '/PNConfig', 'timezone_offset', 's:2:"13";', ''),
(14, '/PNConfig', 'reportlevel', 's:1:"1";', ''),
(15, '/PNConfig', 'startpage', 's:9:"Guestbook";', ''),
(16, '/PNConfig', 'backend_title', 's:22:"tejtermekertekesito.hu";', ''),
(17, '/PNConfig', 'backend_language', 's:2:"hu";', ''),
(18, '/PNConfig', 'seclevel', 's:4:"High";', ''),
(19, '/PNConfig', 'secmeddays', 's:1:"7";', ''),
(20, '/PNConfig', 'secinactivemins', 's:2:"60";', ''),
(21, '/PNConfig', 'Version_Num', 's:4:"3.02";', ''),
(22, '/PNConfig', 'Version_ID', 's:8:"PatroNet";', ''),
(23, '/PNConfig', 'Version_Sub', 's:8:"Business";', ''),
(24, '/PNConfig', 'debug_sql', 'i:0;', ''),
(25, '/PNConfig', 'anonpost', 'i:1;', ''),
(26, '/PNConfig', 'minpass', 's:1:"5";', ''),
(28, '/PNConfig', 'minage', 's:1:"0";', ''),
(29, '/PNConfig', 'top', 'i:0;', ''),
(31, '/PNConfig', 'banners', 's:1:"0";', ''),
(32, '/PNConfig', 'myIP', 's:12:"150.10.10.10";', ''),
(33, '/PNConfig', 'language', 's:3:"hun";', ''),
(34, '/PNConfig', 'locale', 's:5:"en_US";', ''),
(35, '/PNConfig', 'multilingual', 's:1:"1";', ''),
(36, '/PNConfig', 'useflags', 's:1:"1";', ''),
(37, '/PNConfig', 'perpage', 'i:10;', ''),
(43, '/PNConfig', 'notify', 's:1:"1";', ''),
(44, '/PNConfig', 'notify_email', 's:12:"petho@apd.hu";', ''),
(45, '/PNConfig', 'notify_subject', 's:16:"NEWS for my site";', ''),
(46, '/PNConfig', 'notify_message', 's:46:"Hey! \r\nYou got a new submission for your site.";', ''),
(47, '/PNConfig', 'notify_from', 's:9:"webmaster";', ''),
(48, '/PNConfig', 'moderate', 'i:1;', ''),
(49, '/PNConfig', 'tipath', 's:14:"images/topics/";', ''),
(50, '/PNConfig', 'userimg', 's:11:"images/menu";', ''),
(51, '/PNConfig', 'usergraphic', 's:1:"1";', ''),
(52, '/PNConfig', 'topicsinrow', 's:1:"5";', ''),
(53, '/PNConfig', 'httpref', 's:1:"1";', ''),
(54, '/PNConfig', 'httprefmax', 's:4:"1000";', ''),
(55, '/PNConfig', 'reasons', 'a:11:{i:0;s:5:"As Is";i:1;s:8:"Offtopic";i:2;s:9:"Flamebait";i:3;s:5:"Troll";i:4;s:9:"Redundant";i:5;s:10:"Insightful";i:6;s:11:"Interesting";i:7;s:11:"Informative";i:8;s:5:"Funny";i:9;s:9:"Overrated";i:10;s:10:"Underrated";}', ''),
(56, '/PNConfig', 'AllowableHTML', 'a:26:{s:3:"!--";i:0;s:1:"a";i:0;s:1:"b";i:0;s:10:"blockquote";i:0;s:2:"br";i:0;s:6:"center";i:0;s:3:"div";i:0;s:2:"em";i:0;s:4:"font";i:0;s:2:"hr";i:0;s:1:"i";i:0;s:3:"img";i:0;s:2:"li";i:0;s:7:"marquee";i:0;s:2:"ol";i:0;s:1:"p";i:0;s:3:"pre";i:0;s:6:"script";i:0;s:4:"span";i:0;s:6:"strong";i:0;s:2:"tt";i:0;s:2:"ul";i:0;s:5:"table";i:0;s:2:"td";i:0;s:2:"th";i:0;s:2:"tr";i:0;}', ''),
(57, '/PNConfig', 'CensorList', 'a:14:{i:0;s:4:"fuck";i:1;s:4:"cunt";i:2;s:6:"fucker";i:3;s:7:"fucking";i:4;s:5:"pussy";i:5;s:4:"cock";i:6;s:4:"c0ck";i:7;s:3:"cum";i:8;s:4:"twat";i:9;s:4:"clit";i:10;s:5:"bitch";i:11;s:3:"fuk";i:12;s:6:"fuking";i:13;s:12:"motherfucker";}', ''),
(58, '/PNConfig', 'CensorMode', 'i:1;', ''),
(59, '/PNConfig', 'CensorReplace', 's:5:"*****";', ''),
(60, '/PNConfig', 'theme_change', 's:1:"1";', ''),
(61, '/PNConfig', 'startlap', 's:1:"1";', ''),
(82, 'OE-Newsletter', 'NL_nem', 'I', ''),
(83, 'OE-Newsletter', 'NL_zipcode', 'N', ''),
(84, 'OE-Newsletter', 'NL_web', 'N', ''),
(85, 'OE-Newsletter', 'NL_megjegyzes', 'N', ''),
(86, 'OE-Newsletter', 'NL_datum_add', 'I', ''),
(87, 'OE-Newsletter', 'NL_hirlevel', 'N', ''),
(88, 'OE-Newsletter', 'NL_country', 'I', ''),
(89, 'OE-Newsletter', 'NL_state', 'N', ''),
(90, 'OE-Newsletter', 'NL_city', 'N', ''),
(91, 'OE-Newsletter', 'NL_cim', 'N', ''),
(92, 'OE-Newsletter', 'NL_department', 'N', ''),
(93, 'OE-Newsletter', 'NL_telefon', 'N', ''),
(94, 'OE-Newsletter', 'NL_mobil', 'N', ''),
(95, 'OE-Newsletter', 'NL_fax', 'N', ''),
(96, 'OE-Newsletter', 'NL_mnev', 'I', ''),
(97, 'OE-Newsletter', 'NL_knev', 'I', ''),
(98, 'OE-Newsletter', 'NL_email', 'I', ''),
(99, 'OE-Newsletter', 'NL_pozicio', 'I', ''),
(100, 'OE-Newsletter', 'NL_ceg', 'I', ''),
(101, 'OE-Newsletter', 'NL_vnev', 'I', ''),
(102, 'OE-Newsletter', 'NL_nev', 'I', ''),
(103, 'OE-Newsletter', 'NL_cegnev', 'I', ''),
(104, 'OE-Newsletter', 'NL_ceghely', 'I', ''),
(105, 'OE-Newsletter', 'NL_beosztas', 'N', ''),
(106, 'OE-Newsletter', 'NL_h6', 'N', ''),
(107, 'OE-Newsletter', 'NL_h6text', 'N', ''),
(108, 'OE-Newsletter', 'NL_h7', 'N', ''),
(109, 'OE-Newsletter', 'NL_h7text', 'N', ''),
(110, 'OE-Newsletter', 'NL_h8', 'N', ''),
(111, 'OE-Newsletter', 'NL_h8text', 'N', ''),
(112, 'OE-Newsletter', 'NL_h9', 'N', ''),
(113, 'OE-Newsletter', 'NL_h10', 'N', ''),
(114, 'OE-Newsletter', 'NL_h11', 'N', ''),
(118, '/PNConfig', 'admingraphic', 's:1:"1";', ''),
(123, '/PNConfig', 'admart', 's:2:"10";', ''),
(124, '/PNConfig', 'storyhome', 's:1:"5";', ''),
(196, '/PNConfig', 'LangsActives', 'a:1:{i:0;s:3:"hun";}', ''),
(203, '/PNConfig', 'site_logo', 's:0:"";', ''),
(205, '/PNConfig', 'nobox', 's:1:"0";', ''),
(170, 'Contact_Us', 'from_address', '1', ''),
(171, 'Contact_Us', 'replay_email', '1', ''),
(189, 'OE-MailAdmin', 'maxEmail', '5', ''),
(218, '/PNConfig', 'maxpages', 's:3:"100";', ''),
(222, '/PNConfig', 'autolinkpref', 's:1:"2";', ''),
(395, 'Autolinks', 'itemsperpage', '20', ''),
(396, 'Autolinks', 'linkfirst', '1', ''),
(226, '/PNConfig', 'backend_description', 's:5:"Nincs";', ''),
(227, '/PNConfig', 'backend_rsscount', 's:2:"10";', ''),
(228, '/PNConfig', 'backend_searchrss', 's:1:"1";', ''),
(229, '/PNConfig', 'backend_rssitems', 's:20:"a:1:{i:0;s:3:"0,0";}";', ''),
(251, '/PNConfig', 'form_email', 's:19:"info@rlphigienia.hu";', ''),
(394, 'Autolinks', 'dictionaryImage', '1', ''),
(397, 'Autolinks', 'invisilinks', '0', ''),
(412, '/PNConfig', 'BarScale', 's:2:"50";', ''),
(593, '/PNConfig', 'cmsprintikon', 's:1:"0";', ''),
(594, '/PNConfig', 'centerdown', 's:1:"0";', ''),
(564, '/PNConfig', 'blindversion', 's:1:"0";', ''),
(568, 'OE-Vote', 'issue_height', '100', ''),
(569, 'OE-Vote', 'issue_big_height', '300', ''),
(615, '/PNConfig', 'stat_identifier', 's:29:"www.tejtermekertekesitokft.hu";', ''),
(658, '/PNConfig', 'voteLineImageDir', 's:29:"modules/OE-Vote/images/lines/";', ''),
(671, '/PNConfig', 'cmslastupdate', 's:1:"0";', ''),
(715, '/PNConfig', 'numofundo', 's:2:"10";', ''),
(718, '/PNConfig', 'cmspdfikon', 's:1:"0";', ''),
(789, '/PNConfig', 'form_send_response', 's:1:"1";', ''),
(790, '/PNConfig', 'bannercsuszka', 's:1:"0";', ''),
(797, 'ImageGalleryNew', 'imagewidth', '1920', ''),
(798, 'ImageGalleryNew', 'imageheight', '1080', ''),
(799, 'ImageGalleryNew', 'thumbwidth', '600', ''),
(800, 'ImageGalleryNew', 'thumbheight', '600', ''),
(801, 'ImageGalleryNew', 'maincatwidth', '600', ''),
(802, 'ImageGalleryNew', 'maincatheight', '600', ''),
(803, 'ImageGalleryNew', 'subcatwidth', '600', ''),
(804, 'ImageGalleryNew', 'subcatheight', '600', ''),
(805, 'ImageGalleryNew', 'popupwidth', '1920', ''),
(806, 'ImageGalleryNew', 'popupheight', '1080', ''),
(807, 'ImageGalleryNew', 'popupthumbwidth', '640', ''),
(808, 'ImageGalleryNew', 'popupthumbheight', '480', ''),
(809, 'OE-eLibrary', 'RAD_fold_id', '13', ''),
(810, 'OE-eLibrary', 'RAD_kat_ids', '', ''),
(811, 'OE-eLibrary', 'RAD_rov_ids', '', ''),
(815, '/PNConfig', 'diagramtype', 's:1:"0";', ''),
(819, '/PNConfig', 'googleanalytics', 's:1:"1";', ''),
(820, '/PNConfig', 'googleanalyticscode', 's:0:"";', ''),
(1134, '/PNConfig', 'facebooklogin', 's:1:"0";', ''),
(1002, '/PNConfig', 'password_remember_security', 's:1:"0";', ''),
(1045, 'UserAdmin_Basic', 'UNUS_ENABLED', '', ''),
(1046, 'UserAdmin_Basic', 'UNUS_MAIL', '', ''),
(1047, 'UserAdmin_Basic', 'UNUS_AUTOOPEN', '', ''),
(1077, 'OE-eLibrary', 'RAD_public', '1', ''),
(1105, '/PNConfig', 'googlesitemapscode', 's:0:"";', ''),
(1136, '/PNConfig', 'dublincore', 's:1:"0";', ''),
(1125, 'OE-News', 'shortlinkprefix_hun', 'news', ''),
(1126, '/PNConfig', 'form_send_save', 's:1:"0";', ''),
(1127, '/PNConfig', 'utf_shortlink', 's:1:"0";', ''),
(1128, '/PNConfig', 'admin_mainpage', 's:0:"";', ''),
(1129, '/PNConfig', 'admin_logoutpage', 's:0:"";', ''),
(1130, '/PNConfig', 'campaign_ids', 's:5:"gclid";', ''),
(1131, '/PNConfig', 'opengraphprotocol', 's:1:"0";', ''),
(1137, 'OE-Newsletter', 'bb_addr_email', '', ''),
(1133, 'Contact_Us', 'checkSecCode', '1', ''),
(1135, '/PNConfig', 'search_part_enabled', 's:1:"0";', ''),
(1138, '/PNConfig', 'google_api_key', 's:0:"";', '');

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_navigation_pages`
--

CREATE TABLE `opey_navigation_pages` (
  `id` int(11) NOT NULL,
  `params` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_newslettercamp_campaigns`
--

CREATE TABLE `opey_newslettercamp_campaigns` (
  `camp_id` int(10) UNSIGNED NOT NULL,
  `group_id` int(10) UNSIGNED NOT NULL,
  `camp_archive` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `camp_paused` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `camp_blocked` tinyint(4) NOT NULL DEFAULT '0',
  `camp_stages` int(10) UNSIGNED NOT NULL,
  `camp_label` varchar(255) NOT NULL,
  `camp_description` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- A tábla adatainak kiíratása `opey_newslettercamp_campaigns`
--

INSERT INTO `opey_newslettercamp_campaigns` (`camp_id`, `group_id`, `camp_archive`, `camp_paused`, `camp_blocked`, `camp_stages`, `camp_label`, `camp_description`) VALUES
(1, 3, 0, 0, 0, 0, 'xvcxcv', 'xvx xxvc xc xc xc vx vxcv xc x');

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_newslettercamp_letters`
--

CREATE TABLE `opey_newslettercamp_letters` (
  `cnl_id` int(10) UNSIGNED NOT NULL,
  `camp_id` int(10) UNSIGNED NOT NULL,
  `cnl_days` int(10) UNSIGNED NOT NULL,
  `cnl_backbounces` int(11) NOT NULL,
  `cnl_subject` varchar(255) NOT NULL,
  `cnl_content` text NOT NULL,
  `cnl_textcontent` text NOT NULL,
  `cnl_style` text NOT NULL,
  `domain_dir` varchar(255) NOT NULL DEFAULT '',
  `embedded_images` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_newslettercamp_userstates`
--

CREATE TABLE `opey_newslettercamp_userstates` (
  `nluser_id` int(10) UNSIGNED NOT NULL,
  `camp_id` int(10) UNSIGNED NOT NULL,
  `progress` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `days_diff` int(11) NOT NULL DEFAULT '0',
  `date_start` datetime NOT NULL,
  `date_step` datetime DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_newsletter_archive`
--

CREATE TABLE `opey_newsletter_archive` (
  `id` int(11) NOT NULL,
  `backs` int(11) NOT NULL DEFAULT '0',
  `bodytext` text NOT NULL,
  `styletext` text NOT NULL,
  `title` varchar(255) NOT NULL DEFAULT '',
  `started` tinyint(4) NOT NULL DEFAULT '0',
  `progress` int(11) NOT NULL DEFAULT '0',
  `archive` tinyint(4) NOT NULL DEFAULT '0',
  `usercount` int(11) NOT NULL DEFAULT '0',
  `datum_start` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `datum_end` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `paused` tinyint(1) NOT NULL DEFAULT '0',
  `textversion` text NOT NULL,
  `groups` text NOT NULL,
  `multisend` tinyint(4) NOT NULL DEFAULT '0',
  `datum_create` datetime NOT NULL,
  `in_archive` tinyint(4) NOT NULL DEFAULT '0',
  `html_preview` text NOT NULL,
  `editor_type` varchar(255) NOT NULL DEFAULT 'rte',
  `json_editor_parameters` text NOT NULL,
  `domain_dir` varchar(255) NOT NULL DEFAULT '',
  `embedded_images` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_newsletter_backbounces`
--

CREATE TABLE `opey_newsletter_backbounces` (
  `id` int(11) NOT NULL,
  `letterspecial` tinyint(4) NOT NULL DEFAULT '0',
  `lettertype` enum('normal','camp') NOT NULL DEFAULT 'normal',
  `archive_id` int(11) NOT NULL,
  `date` datetime NOT NULL,
  `status` int(11) NOT NULL,
  `sstate` varchar(10) NOT NULL,
  `email` varchar(255) NOT NULL,
  `type` enum('error','unknown','reply') NOT NULL,
  `message` text NOT NULL,
  `fulltext` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_newsletter_email_templates`
--

CREATE TABLE `opey_newsletter_email_templates` (
  `template_id` int(11) NOT NULL,
  `label` varchar(255) NOT NULL,
  `subject` varchar(255) NOT NULL,
  `html_content` text NOT NULL,
  `html_preview` text NOT NULL,
  `editor_type` varchar(255) NOT NULL,
  `json_editor_parameters` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_newsletter_groups`
--

CREATE TABLE `opey_newsletter_groups` (
  `id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `public` tinyint(4) NOT NULL,
  `autogroup` tinyint(4) NOT NULL,
  `grouptype` enum('normal','camp') NOT NULL DEFAULT 'normal',
  `sort` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- A tábla adatainak kiíratása `opey_newsletter_groups`
--

INSERT INTO `opey_newsletter_groups` (`id`, `name`, `description`, `public`, `autogroup`, `grouptype`, `sort`) VALUES
(1, 'Címlista', '', 0, 0, 'normal', 0),
(2, 'Teszt', '', 0, 0, 'normal', 0),
(3, 'Kampány xvcxcv', 'xvx xxvc xc xc xc vx vxcv xc x', 0, 1, 'camp', 0),
(4, 'Automatikus feliratkozások', 'Automatikus feliratkozások', 0, 0, 'normal', 0);

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_newsletter_groups_lang`
--

CREATE TABLE `opey_newsletter_groups_lang` (
  `id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `lang` varchar(3) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_newsletter_reg`
--

CREATE TABLE `opey_newsletter_reg` (
  `nev` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `ertek` text CHARACTER SET utf8 NOT NULL,
  `lang` char(3) CHARACTER SET utf8 NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- A tábla adatainak kiíratása `opey_newsletter_reg`
--

INSERT INTO `opey_newsletter_reg` (`nev`, `ertek`, `lang`) VALUES
('reg_email', 'Kedves _NEV_!\r\n\r\nKöszönjük, hogy regisztrálta magát hírlevelünkre!\r\nKérjük a regisztráció véglegesítéséhez kattintson az alábbi linkre:\r\n_LINK_', 'hun'),
('unreg_email', 'Kedves _NEV_!\r\n  \r\nAz ön leiratkozása hírlevelünkről megtörtént.', 'hun'),
('advice_email', 'iroda@rlphigienia.hu', 'hun'),
('multiReg', '0', 'hun'),
('fromName', 'RLP Higiénia', 'hun'),
('fromEmail', 'iroda@rlphigienia.hu', 'hun'),
('replayEmail', '', 'hun'),
('embedImages', '0', 'hun');

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_newsletter_stat`
--

CREATE TABLE `opey_newsletter_stat` (
  `email_id` int(11) NOT NULL,
  `readed` int(11) NOT NULL DEFAULT '0',
  `last_read` datetime NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_newsletter_stat_flags`
--

CREATE TABLE `opey_newsletter_stat_flags` (
  `email_id` int(11) NOT NULL,
  `email` varchar(100) CHARACTER SET utf8 NOT NULL,
  `type` varchar(20) CHARACTER SET utf8 NOT NULL,
  `code` varchar(255) CHARACTER SET utf8 NOT NULL,
  `add_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_newsletter_users`
--

CREATE TABLE `opey_newsletter_users` (
  `id` bigint(20) NOT NULL,
  `backs` int(11) NOT NULL DEFAULT '0',
  `errorpoints` int(11) NOT NULL DEFAULT '0',
  `email` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `nev` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `cegnev` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `telefon` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `beosztas` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `datum_add` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `hirlevel` char(1) CHARACTER SET utf8 NOT NULL DEFAULT 'I',
  `group_id` int(11) NOT NULL,
  `group_num` tinyint(4) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- A tábla adatainak kiíratása `opey_newsletter_users`
--

INSERT INTO `opey_newsletter_users` (`id`, `backs`, `errorpoints`, `email`, `nev`, `cegnev`, `telefon`, `beosztas`, `datum_add`, `hirlevel`, `group_id`, `group_num`) VALUES
(1, 0, 0, 'Judit.Kiss@wgs-stamping.com', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(2, 0, 0, 'Judit.Kiss@wgs-stamping.com', '', '', '', '', '2016-08-22 12:07:42', 'I', 1, 0),
(3, 0, 0, 'Marietta_Penzes@zollner.de', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(4, 0, 0, 'Marietta_Penzes@zollner.de', '', '', '', '', '2016-08-22 12:07:42', 'I', 1, 0),
(5, 0, 0, 'Csaba.b@mama.co.th', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(6, 0, 0, 'Csaba.b@mama.co.th', '', '', '', '', '2016-08-22 12:07:42', 'I', 1, 0),
(7, 0, 0, 'beszerzes@ih.gov.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(8, 0, 0, 'beszerzes@ih.gov.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 1, 0),
(9, 0, 0, 'zsuzsnna_margit@freemail.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(10, 0, 0, 'zsuzsnna_margit@freemail.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 1, 0),
(11, 0, 0, 'kovalik.eva@wochna.com', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(12, 0, 0, 'kovalik.eva@wochna.com', '', '', '', '', '2016-08-22 12:07:42', 'I', 1, 0),
(13, 0, 0, 'matolcsy.gabriella@ujbudagamesz.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(14, 0, 0, 'matolcsy.gabriella@ujbudagamesz.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 1, 0),
(15, 0, 0, 'melicopter300@gmail.com', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(16, 0, 0, 'melicopter300@gmail.com', '', '', '', '', '2016-08-22 12:07:42', 'I', 1, 0),
(17, 0, 0, 'judit.banyari@gmail.com', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(18, 0, 0, 'judit.banyari@gmail.com', '', '', '', '', '2016-08-22 12:07:42', 'I', 1, 0),
(19, 0, 0, 'rscheilli@euroform.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(20, 0, 0, 'rscheilli@euroform.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 1, 0),
(21, 0, 0, 'phtranshungary@gmail.com', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(22, 0, 0, 'phtranshungary@gmail.com', '', '', '', '', '2016-08-22 12:07:42', 'I', 1, 0),
(23, 0, 0, 'KirályE@richter.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(24, 0, 0, 'KirályE@richter.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 1, 0),
(25, 0, 0, 'polapola2011kft@gmail.com', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(26, 0, 0, 'polapola2011kft@gmail.com', '', '', '', '', '2016-08-22 12:07:42', 'I', 1, 0),
(27, 0, 0, 'info@periplus24.com', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(28, 0, 0, 'info@periplus24.com', '', '', '', '', '2016-08-22 12:07:42', 'I', 1, 0),
(29, 0, 0, 'mirjai.eszter@doctorclean.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(30, 0, 0, 'mirjai.eszter@doctorclean.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 1, 0),
(31, 0, 0, 'karaszi.sandor@oroshazaglas.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(32, 0, 0, 'karaszi.sandor@oroshazaglas.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 1, 0),
(33, 0, 0, 'beszerzes@medirex.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(34, 0, 0, 'beszerzes@medirex.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 1, 0),
(35, 0, 0, 'eniko.veres@medline.com.ro', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(36, 0, 0, 'eniko.veres@medline.com.ro', '', '', '', '', '2016-08-22 12:07:42', 'I', 1, 0),
(37, 0, 0, 'imre.kamasz@medirex.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(38, 0, 0, 'imre.kamasz@medirex.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 1, 0),
(39, 0, 0, 'Sz.Kovacs@vasuttechnika.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(40, 0, 0, 'Sz.Kovacs@vasuttechnika.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 1, 0),
(41, 0, 0, 'csaba.torok@cabtecgroup.com', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(42, 0, 0, 'csaba.torok@cabtecgroup.com', '', '', '', '', '2016-08-22 12:07:42', 'I', 1, 0),
(43, 0, 0, 'consule@t-online.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(44, 0, 0, 'consule@t-online.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 1, 0),
(45, 0, 0, 'beszerzas@mezobutor.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(46, 0, 0, 'beszerzas@mezobutor.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 1, 0),
(47, 0, 0, 'szilagyi.heni@gmail.com', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(48, 0, 0, 'szilagyi.heni@gmail.com', '', '', '', '', '2016-08-22 12:07:42', 'I', 1, 0),
(49, 0, 0, 'iurban@bkf.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(50, 0, 0, 'iurban@bkf.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 1, 0),
(51, 0, 0, 'hejja.csaba@matisz.org', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(52, 0, 0, 'hejja.csaba@matisz.org', '', '', '', '', '2016-08-22 12:07:42', 'I', 1, 0),
(53, 0, 0, 'eumed@eumedtender.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(54, 0, 0, 'eumed@eumedtender.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 1, 0),
(55, 0, 0, 'partnerkenoanyag@partnerkenoanyag.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(56, 0, 0, 'partnerkenoanyag@partnerkenoanyag.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 1, 0),
(57, 0, 0, 'magyarmartoncsaba@icloud.com', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(58, 0, 0, 'magyarmartoncsaba@icloud.com', '', '', '', '', '2016-08-22 12:07:42', 'I', 1, 0),
(59, 0, 0, 'takojanesz@gmail.com', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(60, 0, 0, 'takojanesz@gmail.com', '', '', '', '', '2016-08-22 12:07:42', 'I', 1, 0),
(61, 0, 0, 'irodamix@zelkanet.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(62, 0, 0, 'irodamix@zelkanet.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 1, 0),
(63, 0, 0, 'hillender.timea@vivaholding.eu', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(64, 0, 0, 'hillender.timea@vivaholding.eu', '', '', '', '', '2016-08-22 12:07:42', 'I', 1, 0),
(65, 0, 0, 'dorman.jozsef@kotr92.fm.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(66, 0, 0, 'dorman.jozsef@kotr92.fm.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 1, 0),
(67, 0, 0, 'kisgabor910@t-online.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(68, 0, 0, 'kisgabor910@t-online.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 1, 0),
(69, 0, 0, 'anyaggazdalkodas@pvarszri.axelero.net', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(70, 0, 0, 'anyaggazdalkodas@pvarszri.axelero.net', '', '', '', '', '2016-08-22 12:07:42', 'I', 1, 0),
(71, 0, 0, 'gyorgy.banyai@pinguinfoods.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(72, 0, 0, 'gyorgy.banyai@pinguinfoods.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 1, 0),
(73, 0, 0, 'molnarmarcsi17@gmail.com', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(74, 0, 0, 'molnarmarcsi17@gmail.com', '', '', '', '', '2016-08-22 12:07:42', 'I', 1, 0),
(75, 0, 0, 'housekeeping@kehidatermal.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(76, 0, 0, 'housekeeping@kehidatermal.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 1, 0),
(77, 0, 0, 'csilla.penzes@gmail.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(78, 0, 0, 'csilla.penzes@gmail.hu', '', '', '', '', '2016-08-22 12:07:42', 'I', 1, 0),
(79, 0, 0, 'malatinszkigy@gmail.com', '', '', '', '', '2016-08-22 12:07:42', 'I', 0, 1),
(80, 0, 0, 'malatinszkigy@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(81, 0, 0, 'barbara.b@mama.co.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(82, 0, 0, 'barbara.b@mama.co.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(83, 0, 0, 'info@youtrucks.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(84, 0, 0, 'info@youtrucks.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(85, 0, 0, 'BELLOVITS@mail.duf.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(86, 0, 0, 'BELLOVITS@mail.duf.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(87, 0, 0, 'attila.stumigroup@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(88, 0, 0, 'attila.stumigroup@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(89, 0, 0, 'zoltan.andreka@globalclean.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(90, 0, 0, 'zoltan.andreka@globalclean.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(91, 0, 0, 'siklosine@gaudiopolis.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(92, 0, 0, 'siklosine@gaudiopolis.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(93, 0, 0, 'nikoletta.gonda@te.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(94, 0, 0, 'nikoletta.gonda@te.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(95, 0, 0, 'aniko@transmotors.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(96, 0, 0, 'aniko@transmotors.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(97, 0, 0, 'balazs.gloria@taneszkoz.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(98, 0, 0, 'balazs.gloria@taneszkoz.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(99, 0, 0, 'martakatica@gmail.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(100, 0, 0, 'martakatica@gmail.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(101, 0, 0, 'eukonzultacio@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(102, 0, 0, 'eukonzultacio@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(103, 0, 0, 'illyes.veronika@pasztorcsoport.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(104, 0, 0, 'illyes.veronika@pasztorcsoport.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(105, 0, 0, 'gabi.imre@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(106, 0, 0, 'gabi.imre@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(107, 0, 0, 'pall@iroda2000.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(108, 0, 0, 'pall@iroda2000.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(109, 0, 0, 'zsanett@lpclean.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(110, 0, 0, 'zsanett@lpclean.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(111, 0, 0, 'dobos.katalin@taneszkoz.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(112, 0, 0, 'dobos.katalin@taneszkoz.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(113, 0, 0, 'vera.morocz@gstv.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(114, 0, 0, 'vera.morocz@gstv.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(115, 0, 0, 'Takacsm@baranya.police.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(116, 0, 0, 'Takacsm@baranya.police.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(117, 0, 0, 'szolgaltatas@agriahuman.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(118, 0, 0, 'szolgaltatas@agriahuman.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(119, 0, 0, 'peter.csak@nissin.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(120, 0, 0, 'peter.csak@nissin.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(121, 0, 0, 'gurnyik.endre@timarvasker.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(122, 0, 0, 'gurnyik.endre@timarvasker.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(123, 0, 0, 'tamas.borok@lechner-co.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(124, 0, 0, 'tamas.borok@lechner-co.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(557, 0, 0, 'tamaska@tamaska.hu', '', '', '', '', '2016-09-06 11:40:07', 'I', 0, 0),
(556, 0, 0, 'lesirenata@gmail.com', '', '', '', '', '2016-09-06 11:38:47', 'I', 0, 0),
(127, 0, 0, 'kovacs.ferenc.1@freemail.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(128, 0, 0, 'kovacs.ferenc.1@freemail.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(129, 0, 0, 'info@keritas-special.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(130, 0, 0, 'info@keritas-special.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(131, 0, 0, 'KovacsnePS@kgei.police.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(132, 0, 0, 'KovacsnePS@kgei.police.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(133, 0, 0, 'Edina.Balazsi@audischule.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(134, 0, 0, 'Edina.Balazsi@audischule.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(135, 0, 0, 'numberonecleaningkft@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(136, 0, 0, 'numberonecleaningkft@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(137, 0, 0, 'haver40@citromail.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(138, 0, 0, 'haver40@citromail.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(139, 0, 0, 'kissjanos1122@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(140, 0, 0, 'kissjanos1122@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(141, 0, 0, 'szucsi.civilhaz@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(142, 0, 0, 'szucsi.civilhaz@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(143, 0, 0, 'banyai@behatherm.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(144, 0, 0, 'banyai@behatherm.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(145, 0, 0, 'CsabragiV@kgei.police.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(146, 0, 0, 'CsabragiV@kgei.police.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(147, 0, 0, 'ertekesites@brill-clean.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(148, 0, 0, 'ertekesites@brill-clean.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(149, 0, 0, 'veronika@barzak.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(150, 0, 0, 'veronika@barzak.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(151, 0, 0, 'iroda@lpclean.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(152, 0, 0, 'iroda@lpclean.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(153, 0, 0, 'katalin76@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(154, 0, 0, 'katalin76@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(155, 0, 0, 'iskola@szadaiskola.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(156, 0, 0, 'iskola@szadaiskola.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(157, 0, 0, 'innosite.kft@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(158, 0, 0, 'innosite.kft@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(159, 0, 0, 'Zsuzsanna.Paszti@ecserikft.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(160, 0, 0, 'Zsuzsanna.Paszti@ecserikft.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(161, 0, 0, 'Jozsef.Koroknai@ecserikft.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(162, 0, 0, 'Jozsef.Koroknai@ecserikft.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(163, 0, 0, 'kochcsab@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(164, 0, 0, 'kochcsab@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(165, 0, 0, 'juditder@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(166, 0, 0, 'juditder@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(167, 0, 0, 'bestcleanbest@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(168, 0, 0, 'bestcleanbest@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(169, 0, 0, 'steelco@t-online.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(170, 0, 0, 'steelco@t-online.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(171, 0, 0, 'Gaborne.Halasz@katved.gov.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(172, 0, 0, 'Gaborne.Halasz@katved.gov.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(173, 0, 0, 'strobl.anita@palmfood.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(174, 0, 0, 'strobl.anita@palmfood.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(175, 0, 0, 'B.BAKO@denso.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(176, 0, 0, 'B.BAKO@denso.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(177, 0, 0, 'jaszkanics@tlakft.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(178, 0, 0, 'jaszkanics@tlakft.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(179, 0, 0, 'marton.pelenyi@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(180, 0, 0, 'marton.pelenyi@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(181, 0, 0, 'papp.sandor@mobilan.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(182, 0, 0, 'papp.sandor@mobilan.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(183, 0, 0, 'ferenc.stefan@bestkft.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(184, 0, 0, 'ferenc.stefan@bestkft.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(185, 0, 0, 'krisztina.pali@cemelog.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(186, 0, 0, 'krisztina.pali@cemelog.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(187, 0, 0, 'theisz.laszlo@szolsport.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(188, 0, 0, 'theisz.laszlo@szolsport.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(189, 0, 0, 'tellusinvictus@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(190, 0, 0, 'tellusinvictus@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(191, 0, 0, 'livia.tischer@bdi.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(192, 0, 0, 'livia.tischer@bdi.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(193, 0, 0, 'vitez.anita@medihotel.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(194, 0, 0, 'vitez.anita@medihotel.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(195, 0, 0, 'info@cifratakarito.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(196, 0, 0, 'info@cifratakarito.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(197, 0, 0, 'balogh.a@dker.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(198, 0, 0, 'balogh.a@dker.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(199, 0, 0, 'csori.csaba@linea-art.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(200, 0, 0, 'csori.csaba@linea-art.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(201, 0, 0, 'info@ppcenter.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(202, 0, 0, 'info@ppcenter.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(203, 0, 0, 'tolnai.dorottya@b32.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(204, 0, 0, 'tolnai.dorottya@b32.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(205, 0, 0, 'szabo.lajos@agrikon.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(206, 0, 0, 'szabo.lajos@agrikon.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(207, 0, 0, 'hatvani.ilona@avapack.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(208, 0, 0, 'hatvani.ilona@avapack.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(209, 0, 0, 'pallaibau@t-online.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(210, 0, 0, 'pallaibau@t-online.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(211, 0, 0, 'foszto.judit@balaton-butor.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(212, 0, 0, 'foszto.judit@balaton-butor.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(213, 0, 0, 't.garami@euroknife.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(214, 0, 0, 't.garami@euroknife.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(215, 0, 0, 'henrik@intebu.eu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(216, 0, 0, 'henrik@intebu.eu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(217, 0, 0, 'sales@jasz.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(218, 0, 0, 'sales@jasz.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(219, 0, 0, 'prita1970@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(220, 0, 0, 'prita1970@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(221, 0, 0, 'csontosne.marika@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(222, 0, 0, 'csontosne.marika@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(223, 0, 0, 'kissiskolabutor4130@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(224, 0, 0, 'kissiskolabutor4130@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(225, 0, 0, 'sipos.piroska@wellis.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(226, 0, 0, 'sipos.piroska@wellis.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(227, 0, 0, 'adorjan.mader@jci.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(228, 0, 0, 'adorjan.mader@jci.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(229, 0, 0, 'fanni.harangi@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(230, 0, 0, 'fanni.harangi@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(231, 0, 0, 'mayer.m.zsofia@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(232, 0, 0, 'mayer.m.zsofia@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(233, 0, 0, 'sport@educentrum.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(234, 0, 0, 'sport@educentrum.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(235, 0, 0, 'noemi.balazs@cemelog.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(236, 0, 0, 'noemi.balazs@cemelog.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(237, 0, 0, 'hegedus.helga@unikornkft.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(238, 0, 0, 'hegedus.helga@unikornkft.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(239, 0, 0, 'k.barabas@ujlaki.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(240, 0, 0, 'k.barabas@ujlaki.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(241, 0, 0, 'marian.eva@vemevszer.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(242, 0, 0, 'marian.eva@vemevszer.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(243, 0, 0, 'mailto:ferenc.macsai@strabag.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(244, 0, 0, 'mailto:ferenc.macsai@strabag.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(245, 0, 0, 'david.superrolling@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(246, 0, 0, 'david.superrolling@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(247, 0, 0, 'stag010kft@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(248, 0, 0, 'stag010kft@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(249, 0, 0, 'goldwepa@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(250, 0, 0, 'goldwepa@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(251, 0, 0, 'darvai@mnsk.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(252, 0, 0, 'darvai@mnsk.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(253, 0, 0, 'csizmadia.attila@veas.videoton.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(254, 0, 0, 'csizmadia.attila@veas.videoton.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(255, 0, 0, 'novotni.viktor@diminfo.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(256, 0, 0, 'novotni.viktor@diminfo.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(257, 0, 0, 'Herczku@zuglo.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(258, 0, 0, 'Herczku@zuglo.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(259, 0, 0, 'kadarnemethi@bodrogibau.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(260, 0, 0, 'kadarnemethi@bodrogibau.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(261, 0, 0, 'spillerdini@spillerkft.axelero.net', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(262, 0, 0, 'spillerdini@spillerkft.axelero.net', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(263, 0, 0, 'Nyemetz.Gabor@euro-vet.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(264, 0, 0, 'Nyemetz.Gabor@euro-vet.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(265, 0, 0, 'erdei.gabor@uniszol.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(266, 0, 0, 'erdei.gabor@uniszol.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(267, 0, 0, 'megrendeles@drderm.net', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(268, 0, 0, 'megrendeles@drderm.net', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(559, 0, 0, 'horvath@patronet.net', 'Horváth Dávid', '', '', '', '2016-09-09 16:35:51', 'I', 0, 0),
(558, 0, 0, 'karancssag@gergihalo.hu', '', '', '', '', '2016-09-06 11:40:50', 'I', 0, 0),
(271, 0, 0, 'alexa.kovacs@creagroup.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(272, 0, 0, 'alexa.kovacs@creagroup.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(273, 0, 0, 'iroda@automagic.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(274, 0, 0, 'iroda@automagic.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(275, 0, 0, 'szattila.stumigroup@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(276, 0, 0, 'szattila.stumigroup@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(277, 0, 0, 'rendelesavv@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(278, 0, 0, 'rendelesavv@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(279, 0, 0, 'email.gyulai.laszlo@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(280, 0, 0, 'email.gyulai.laszlo@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(281, 0, 0, 'anett.magony@nissin.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(282, 0, 0, 'anett.magony@nissin.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(283, 0, 0, 'RestasT@budapest.police.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(284, 0, 0, 'RestasT@budapest.police.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(285, 0, 0, 'hamptons@hamptons.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(286, 0, 0, 'hamptons@hamptons.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(287, 0, 0, 'benedek.csipesz@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(288, 0, 0, 'benedek.csipesz@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(289, 0, 0, 'titkarsag@toalmas.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(290, 0, 0, 'titkarsag@toalmas.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(291, 0, 0, 'norbert.gulyas@velux.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(292, 0, 0, 'norbert.gulyas@velux.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(293, 0, 0, 'gazsi@mkab.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(294, 0, 0, 'gazsi@mkab.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(295, 0, 0, 'Peter.Timko@certa.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(296, 0, 0, 'Peter.Timko@certa.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(297, 0, 0, 'eles.orsolya@varosgazda18.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(298, 0, 0, 'eles.orsolya@varosgazda18.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(299, 0, 0, 'toth.bernadett@varosgazda18.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(300, 0, 0, 'toth.bernadett@varosgazda18.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(301, 0, 0, 'beszerzes@hajduhadhaz.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(302, 0, 0, 'beszerzes@hajduhadhaz.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(303, 0, 0, 'csillagnebirloni@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(304, 0, 0, 'csillagnebirloni@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(580, 0, 0, 'horvath.teszt.345978349534853894593@patronet.net', 'Horváth Dávid', '', '', '', '2016-09-23 15:50:44', 'I', 4, 1),
(577, 0, 0, 'horvath.teszt.231242434@patronet.net', 'Horváth Dávid', '', '', '', '2016-09-23 15:41:41', 'I', 0, 1),
(307, 0, 0, 'lichengkft@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(308, 0, 0, 'lichengkft@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(309, 0, 0, 'Katalin.Csonka@certa.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(310, 0, 0, 'Katalin.Csonka@certa.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(311, 0, 0, 'borzsei@ante.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(312, 0, 0, 'borzsei@ante.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(313, 0, 0, 'vincze.a@eftech.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(314, 0, 0, 'vincze.a@eftech.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(315, 0, 0, 'szabo.attila@pecel.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(316, 0, 0, 'szabo.attila@pecel.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(317, 0, 0, 'radai.imre@dipa.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(318, 0, 0, 'radai.imre@dipa.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(319, 0, 0, 'gemex.vevoszolgalatkozpont@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(320, 0, 0, 'gemex.vevoszolgalatkozpont@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(321, 0, 0, 'irodaszer@ril.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(322, 0, 0, 'irodaszer@ril.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(323, 0, 0, 'marosfalvi@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(324, 0, 0, 'marosfalvi@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(325, 0, 0, 'nnadi.kristof@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(326, 0, 0, 'nnadi.kristof@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(327, 0, 0, 'szuts207@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(328, 0, 0, 'szuts207@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(329, 0, 0, 'sztojka.gusztav@esztergom.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(330, 0, 0, 'sztojka.gusztav@esztergom.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(331, 0, 0, 'nagy.istvan@nitech.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(332, 0, 0, 'nagy.istvan@nitech.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(333, 0, 0, 'julianna.pechlof@ekol.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(334, 0, 0, 'julianna.pechlof@ekol.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(335, 0, 0, 'adamikgabor@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(336, 0, 0, 'adamikgabor@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(337, 0, 0, 'berenyi.janos@tkki.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(338, 0, 0, 'berenyi.janos@tkki.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(339, 0, 0, 'anyag@pantaleon.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(340, 0, 0, 'anyag@pantaleon.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(341, 0, 0, 'iroda@dorlin.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(342, 0, 0, 'iroda@dorlin.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(343, 0, 0, 'rscheili@euroform.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(344, 0, 0, 'rscheili@euroform.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(345, 0, 0, 'potrake1@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(346, 0, 0, 'potrake1@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(347, 0, 0, 'Tamas.Kovacs@nilfisk.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(348, 0, 0, 'Tamas.Kovacs@nilfisk.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(349, 0, 0, 'zavori.mario@ferterminal.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(350, 0, 0, 'zavori.mario@ferterminal.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(351, 0, 0, 'Bognar.Istvanne@tmkorhaz.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(352, 0, 0, 'Bognar.Istvanne@tmkorhaz.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(353, 0, 0, 'nemeth.imre@pfm.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(354, 0, 0, 'nemeth.imre@pfm.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(355, 0, 0, 'otthon.zakanyszek@hoszkp.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(356, 0, 0, 'otthon.zakanyszek@hoszkp.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(357, 0, 0, 'office@gusti.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(358, 0, 0, 'office@gusti.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(359, 0, 0, 'gabriella.sagi@multi-will.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(360, 0, 0, 'gabriella.sagi@multi-will.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(361, 0, 0, 'sales@conductive.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(362, 0, 0, 'sales@conductive.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(363, 0, 0, 'anita.bartfai@wgs-stamping.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(364, 0, 0, 'anita.bartfai@wgs-stamping.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(365, 0, 0, 'csongor79@yahoo.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(366, 0, 0, 'csongor79@yahoo.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(367, 0, 0, 'agikalmar@citromail.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(368, 0, 0, 'agikalmar@citromail.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(369, 0, 0, 'ujcsillag@citromail.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(370, 0, 0, 'ujcsillag@citromail.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(371, 0, 0, 'bakai.ildiko@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(372, 0, 0, 'bakai.ildiko@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(373, 0, 0, 'ruvill.bt@chello.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(374, 0, 0, 'ruvill.bt@chello.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(375, 0, 0, 'porta.erd@prettl.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(376, 0, 0, 'porta.erd@prettl.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(377, 0, 0, 'lacipeti69@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(378, 0, 0, 'lacipeti69@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(379, 0, 0, 'imreaniko@god.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(380, 0, 0, 'imreaniko@god.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(381, 0, 0, 'attilabinder450@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(382, 0, 0, 'attilabinder450@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(383, 0, 0, 'iranynevada@freemail.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(384, 0, 0, 'iranynevada@freemail.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(385, 0, 0, 'nandor.ivanchich@hamptons.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(386, 0, 0, 'nandor.ivanchich@hamptons.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(387, 0, 0, 'virgilia.kissne@cabtecgroup.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(388, 0, 0, 'virgilia.kissne@cabtecgroup.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(389, 0, 0, 'vontszemu.gabor@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(390, 0, 0, 'vontszemu.gabor@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(391, 0, 0, 'maros.janos@digistar.h', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(392, 0, 0, 'maros.janos@digistar.h', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(393, 0, 0, 'iroda@optakaritas.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(394, 0, 0, 'iroda@optakaritas.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(395, 0, 0, 'gyorgy.deak@eers.sk', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(396, 0, 0, 'gyorgy.deak@eers.sk', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(397, 0, 0, 'agnes.keszthelyi@easywayfacility.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(398, 0, 0, 'agnes.keszthelyi@easywayfacility.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(399, 0, 0, 'faluhaz.info@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(400, 0, 0, 'faluhaz.info@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(401, 0, 0, 'info@homaly.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(402, 0, 0, 'info@homaly.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(403, 0, 0, 'szerszambolt@alati.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(404, 0, 0, 'szerszambolt@alati.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(405, 0, 0, 'koos.katalin@porplast.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(406, 0, 0, 'koos.katalin@porplast.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(407, 0, 0, 'nagy.gabor@agrikon.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(408, 0, 0, 'nagy.gabor@agrikon.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(409, 0, 0, 'golyasupply@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(410, 0, 0, 'golyasupply@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(411, 0, 0, 'balazsmakai@gmail.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(412, 0, 0, 'balazsmakai@gmail.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(413, 0, 0, 'globalservice@t-online.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(414, 0, 0, 'globalservice@t-online.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(415, 0, 0, 'info@aquacomet.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(416, 0, 0, 'info@aquacomet.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(417, 0, 0, 'titkarsag@ercsirendelo.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(418, 0, 0, 'titkarsag@ercsirendelo.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(419, 0, 0, 'info@irodamixhungary.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(420, 0, 0, 'info@irodamixhungary.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(421, 0, 0, 'szalaydavid@irodamixhungary.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(422, 0, 0, 'szalaydavid@irodamixhungary.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(423, 0, 0, 'csnemethdavid906@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(424, 0, 0, 'csnemethdavid906@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(425, 0, 0, 'ferenc.balog@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(426, 0, 0, 'ferenc.balog@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(427, 0, 0, 'jonasne@god.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(428, 0, 0, 'jonasne@god.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(429, 0, 0, 'info@sesametrade.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(430, 0, 0, 'info@sesametrade.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(431, 0, 0, 'jazocleaning@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(432, 0, 0, 'jazocleaning@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(433, 0, 0, 'mezey.krisztina@primerate.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(434, 0, 0, 'mezey.krisztina@primerate.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(435, 0, 0, 'nagy.janos@primerate.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(436, 0, 0, 'nagy.janos@primerate.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(437, 0, 0, 'peterdi.agota@primerate.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(438, 0, 0, 'peterdi.agota@primerate.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(439, 0, 0, 'nagnes@primerate.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(440, 0, 0, 'nagnes@primerate.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(441, 0, 0, 'holdosi.franciska@partnerkenoanyag.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(442, 0, 0, 'holdosi.franciska@partnerkenoanyag.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(578, 0, 0, 'horvath.teszt.231242434@patronet.net', 'Horváth Dávid', '', '', '', '2016-09-23 15:41:41', 'I', 4, 1),
(579, 0, 0, 'horvath.teszt.345978349534853894593@patronet.net', 'Horváth Dávid', '', '', '', '2016-09-23 15:50:44', 'I', 0, 1),
(447, 0, 0, 'gymaria@reof.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(448, 0, 0, 'gymaria@reof.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(449, 0, 0, 'gabor.farago.87@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(450, 0, 0, 'gabor.farago.87@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(451, 0, 0, 'katalin.gatay@premiergmed.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(452, 0, 0, 'katalin.gatay@premiergmed.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(453, 0, 0, 'harmat@ante.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(454, 0, 0, 'harmat@ante.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(455, 0, 0, 'kazsuk.istvan@hajduvitez.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(456, 0, 0, 'kazsuk.istvan@hajduvitez.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(457, 0, 0, 'karoly.gyuris@nissin.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(458, 0, 0, 'karoly.gyuris@nissin.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(459, 0, 0, 'gabor.bojtos@nissin.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(460, 0, 0, 'gabor.bojtos@nissin.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(461, 0, 0, 'henrietta.somodi@nissin.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(462, 0, 0, 'henrietta.somodi@nissin.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(463, 0, 0, 'sandor.laszlo@fokefe.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(464, 0, 0, 'sandor.laszlo@fokefe.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(465, 0, 0, 'penzugy@rotovill.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(466, 0, 0, 'penzugy@rotovill.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(467, 0, 0, 'housekeeping@parlament-hotel.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(468, 0, 0, 'housekeeping@parlament-hotel.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(469, 0, 0, 'nagyapati.andrea@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(470, 0, 0, 'nagyapati.andrea@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(471, 0, 0, 'tiborritz@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(472, 0, 0, 'tiborritz@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(473, 0, 0, 'eom1987@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(474, 0, 0, 'eom1987@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(475, 0, 0, 'gkanel@hotelmoments.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(476, 0, 0, 'gkanel@hotelmoments.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(477, 0, 0, 'lorincz.karoly@zoldhid.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(478, 0, 0, 'lorincz.karoly@zoldhid.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(479, 0, 0, 'janosne@god.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(480, 0, 0, 'janosne@god.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(481, 0, 0, 'pusztai.peter@gladiolus.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(482, 0, 0, 'pusztai.peter@gladiolus.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(483, 0, 0, 'muakereskedes@enternet.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(484, 0, 0, 'muakereskedes@enternet.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(485, 0, 0, 'sivaglob@t-online.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(486, 0, 0, 'sivaglob@t-online.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(487, 0, 0, 'info@cleanbanding.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(488, 0, 0, 'info@cleanbanding.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(489, 0, 0, 'sajtosl91@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(490, 0, 0, 'sajtosl91@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(491, 0, 0, 'manokcsaladinapkozi@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(492, 0, 0, 'manokcsaladinapkozi@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(493, 0, 0, 'p.spipeskft@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(494, 0, 0, 'p.spipeskft@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(495, 0, 0, 'kgszoc@enternet.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(496, 0, 0, 'kgszoc@enternet.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(497, 0, 0, 'kovacs.marta@balaton-butor.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(498, 0, 0, 'kovacs.marta@balaton-butor.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(499, 0, 0, 'gazso.gergely@deluxer.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(500, 0, 0, 'gazso.gergely@deluxer.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(503, 0, 0, 'autopalkft@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(504, 0, 0, 'autopalkft@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(505, 0, 0, 'szaraz.janos@tct.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(506, 0, 0, 'szaraz.janos@tct.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(507, 0, 0, 'bognar.janos@tct.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(508, 0, 0, 'bognar.janos@tct.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(509, 0, 0, 'attila.csepregi@csepregi.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(510, 0, 0, 'attila.csepregi@csepregi.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(511, 0, 0, 'iroda@ppcenter.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(512, 0, 0, 'iroda@ppcenter.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(513, 0, 0, 'etoile.takaritas@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(514, 0, 0, 'etoile.takaritas@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(515, 0, 0, 'somogyszob@latsat.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(516, 0, 0, 'somogyszob@latsat.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(517, 0, 0, 'info@etterem-zsira.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(518, 0, 0, 'info@etterem-zsira.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(519, 0, 0, 'kozfog@soltvadkert.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(520, 0, 0, 'kozfog@soltvadkert.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(521, 0, 0, 'hundfutterkft@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(522, 0, 0, 'hundfutterkft@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(523, 0, 0, 'lilla.csokas@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(524, 0, 0, 'lilla.csokas@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(527, 0, 0, 'thebigfishseafoodbistro@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(528, 0, 0, 'thebigfishseafoodbistro@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(529, 0, 0, 'borsi.t@freemail.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(530, 0, 0, 'borsi.t@freemail.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(531, 0, 0, 'kovacsmario@digikabel.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(532, 0, 0, 'kovacsmario@digikabel.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(533, 0, 0, 'keko.gepkft@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(534, 0, 0, 'keko.gepkft@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(535, 0, 0, 'makkaizsoltne@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(536, 0, 0, 'makkaizsoltne@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(537, 0, 0, 'pari.ezermester@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(538, 0, 0, 'pari.ezermester@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(541, 0, 0, 'info@feromix.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(542, 0, 0, 'info@feromix.hu', '', '', '', '', '2016-08-22 12:07:43', 'I', 1, 0),
(543, 0, 0, 'pestidiszno@gmail.com', '', '', '', '', '2016-08-22 12:07:43', 'I', 0, 1),
(544, 0, 0, 'pestidiszno@gmail.com', '', '', '', '', '2016-08-22 12:07:44', 'I', 1, 0),
(545, 0, 0, 'viktorusa@freemail.hu', '', '', '', '', '2016-08-22 12:07:44', 'I', 0, 1),
(546, 0, 0, 'viktorusa@freemail.hu', '', '', '', '', '2016-08-22 12:07:44', 'I', 1, 0),
(547, 0, 0, 'info@tesofuvar.hu', '', '', '', '', '2016-08-22 12:07:44', 'I', 0, 1),
(548, 0, 0, 'info@tesofuvar.hu', '', '', '', '', '2016-08-22 12:07:44', 'I', 1, 0),
(549, 0, 0, 'szada@szadafaluhaz.hu', '', '', '', '', '2016-08-22 12:07:44', 'I', 0, 1),
(550, 0, 0, 'szada@szadafaluhaz.hu', '', '', '', '', '2016-08-22 12:07:44', 'I', 1, 0),
(551, 0, 0, 'korongos2000@gmail.com', '', '', '', '', '2016-08-22 12:07:44', 'I', 0, 1),
(552, 0, 0, 'korongos2000@gmail.com', '', '', '', '', '2016-08-22 12:07:44', 'I', 1, 0),
(553, 0, 0, 'iroda@rlphigienia.hu', 'RLP Iroda', '', '', '', '2016-09-05 13:26:30', 'I', 0, 0),
(554, 0, 0, 'iroda@rlphigienia.hu', 'RLP Iroda', '', '', '', '2016-09-05 13:26:30', 'I', 2, 0),
(555, 0, 0, 'edocs.janos@doctorclean.hu', '', '', '', '', '2016-09-06 11:29:46', 'I', 0, 0),
(569, 0, 0, 'f.bede@chello.hu', 'Bede  Ferenc', '', '', '', '2016-09-13 09:43:35', 'I', 0, 1),
(570, 0, 0, 'f.bede@chello.hu', 'Bede  Ferenc', '', '', '', '2016-09-13 09:43:35', 'I', 4, 1),
(571, 0, 0, 'petho@patronet.net', 'psz', '', '', '', '2016-09-20 08:30:11', 'I', 0, 0),
(572, 0, 0, 'petho@patronet.net', 'psz', '', '', '', '2016-09-20 08:30:11', 'I', 2, 0),
(573, 0, 0, 'egerfarmos@egerfarmos.hu', 'EGERFARMOS ÖNKORMÁNYZAT', '', '', '', '2016-09-22 11:06:20', 'I', 0, 1),
(574, 0, 0, 'egerfarmos@egerfarmos.hu', 'EGERFARMOS ÖNKORMÁNYZAT', '', '', '', '2016-09-22 11:06:20', 'I', 4, 1),
(575, 0, 0, '', ' ', '', '', '', '2016-09-22 11:50:00', 'I', 0, 1),
(576, 0, 0, '', ' ', '', '', '', '2016-09-22 11:50:00', 'I', 4, 1);

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_news_archive_eng`
--

CREATE TABLE `opey_news_archive_eng` (
  `id` int(11) NOT NULL,
  `news_id` int(11) NOT NULL,
  `shortlink_id` int(11) NOT NULL,
  `short_path` varchar(500) NOT NULL,
  `catid` int(11) NOT NULL DEFAULT '0',
  `topicid` int(11) NOT NULL DEFAULT '0',
  `userid` int(11) NOT NULL DEFAULT '0',
  `authorid` int(11) NOT NULL,
  `title` text,
  `hometext` text,
  `bodytext` text,
  `is_oai` tinyint(1) NOT NULL DEFAULT '0',
  `oai_setspec` varchar(255) NOT NULL DEFAULT '',
  `oai_id` int(11) DEFAULT NULL,
  `content_images` text,
  `notes` text,
  `counter` int(11) NOT NULL DEFAULT '0',
  `lang` varchar(4) NOT NULL DEFAULT '',
  `imgid` int(11) DEFAULT NULL,
  `keywords` varchar(255) DEFAULT NULL,
  `prog` tinyint(1) NOT NULL DEFAULT '0',
  `prog_end` tinyint(1) NOT NULL DEFAULT '0',
  `progdate` datetime DEFAULT NULL,
  `progdate_end` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `datum` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comments` bigint(11) DEFAULT NULL,
  `themeoverride` varchar(64) DEFAULT NULL,
  `accepted` tinyint(1) NOT NULL DEFAULT '0',
  `modified` datetime DEFAULT '0000-00-00 00:00:00',
  `displaynotes` tinyint(1) DEFAULT NULL,
  `links` text,
  `relatedlinks` text,
  `evfolyam` varchar(16) DEFAULT NULL,
  `szam` smallint(6) DEFAULT NULL,
  `author` varchar(255) DEFAULT NULL,
  `author_url` varchar(255) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `delete_userid` int(11) DEFAULT NULL,
  `delete_date` datetime DEFAULT NULL,
  `leadimagecat` int(11) NOT NULL DEFAULT '0',
  `leadimage` int(11) NOT NULL DEFAULT '0',
  `story` tinyint(1) NOT NULL,
  `commentenable` tinyint(1) NOT NULL,
  `exist_lang` tinyint(1) DEFAULT NULL,
  `locked` int(11) NOT NULL DEFAULT '0',
  `twitter_id` varchar(255) DEFAULT NULL,
  `facebook_id` varchar(255) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_news_archive_hun`
--

CREATE TABLE `opey_news_archive_hun` (
  `id` int(11) NOT NULL,
  `news_id` int(11) NOT NULL,
  `version_identifier` varchar(255) NOT NULL,
  `datetime_archived` datetime NOT NULL,
  `archiver_admin_id` int(11) NOT NULL,
  `shortlink_id` int(11) NOT NULL,
  `short_path` varchar(500) NOT NULL,
  `catid` int(11) NOT NULL DEFAULT '0',
  `topicid` int(11) NOT NULL DEFAULT '0',
  `userid` int(11) NOT NULL DEFAULT '0',
  `authorid` int(11) NOT NULL,
  `title` text,
  `hometext` text,
  `bodytext` text,
  `is_oai` tinyint(1) NOT NULL DEFAULT '0',
  `oai_set_id` int(11) DEFAULT NULL,
  `content_images` text,
  `notes` text,
  `counter` int(11) NOT NULL DEFAULT '0',
  `lang` varchar(4) NOT NULL DEFAULT '',
  `imgid` int(11) DEFAULT NULL,
  `keywords` varchar(255) DEFAULT NULL,
  `prog` tinyint(1) NOT NULL DEFAULT '0',
  `prog_end` tinyint(1) NOT NULL DEFAULT '0',
  `progdate` datetime DEFAULT NULL,
  `progdate_end` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `datum` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comments` bigint(11) DEFAULT NULL,
  `themeoverride` varchar(64) DEFAULT NULL,
  `accepted` tinyint(1) NOT NULL DEFAULT '0',
  `modified` datetime DEFAULT '0000-00-00 00:00:00',
  `displaynotes` tinyint(1) DEFAULT NULL,
  `links` text,
  `relatedlinks` text,
  `evfolyam` varchar(16) DEFAULT NULL,
  `szam` smallint(6) DEFAULT NULL,
  `author` varchar(255) DEFAULT NULL,
  `author_url` varchar(255) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `delete_userid` int(11) DEFAULT NULL,
  `delete_date` datetime DEFAULT NULL,
  `leadimagecat` int(11) NOT NULL DEFAULT '0',
  `leadimage` int(11) NOT NULL DEFAULT '0',
  `story` tinyint(1) NOT NULL,
  `commentenable` tinyint(1) NOT NULL,
  `exist_lang` tinyint(1) DEFAULT NULL,
  `locked` int(11) NOT NULL DEFAULT '0',
  `twitter_id` varchar(255) DEFAULT NULL,
  `facebook_id` varchar(255) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_news_authors`
--

CREATE TABLE `opey_news_authors` (
  `id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL,
  `url` varchar(255) NOT NULL DEFAULT '',
  `twitter_url` varchar(255) NOT NULL,
  `facebook_url` varchar(255) NOT NULL,
  `linkedin_url` varchar(255) NOT NULL,
  `rss_url` varchar(255) NOT NULL,
  `image_width` smallint(6) NOT NULL,
  `image_height` smallint(6) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- A tábla adatainak kiíratása `opey_news_authors`
--

INSERT INTO `opey_news_authors` (`id`, `name`, `email`, `url`, `twitter_url`, `facebook_url`, `linkedin_url`, `rss_url`, `image_width`, `image_height`) VALUES
(2, 'Ritz Tibor', '', 'http://www.takaritz.hu/blog/', '', '', '', '', 0, 0);

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_news_categories`
--

CREATE TABLE `opey_news_categories` (
  `id` int(11) NOT NULL,
  `title` varchar(40) DEFAULT NULL,
  `counter` int(11) DEFAULT '0',
  `themeoverride` varchar(30) DEFAULT NULL,
  `title_hun` varchar(64) DEFAULT NULL,
  `title_eng` varchar(64) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- A tábla adatainak kiíratása `opey_news_categories`
--

INSERT INTO `opey_news_categories` (`id`, `title`, `counter`, `themeoverride`, `title_hun`, `title_eng`) VALUES
(1, 'Aktuális', 0, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_news_eng`
--

CREATE TABLE `opey_news_eng` (
  `id` int(11) NOT NULL,
  `catid` int(11) NOT NULL DEFAULT '0',
  `topicid` int(11) NOT NULL DEFAULT '0',
  `userid` int(11) NOT NULL DEFAULT '0',
  `authorid` int(11) NOT NULL,
  `title` text,
  `hometext` text,
  `bodytext` text,
  `content_images` text,
  `notes` text,
  `counter` int(11) NOT NULL DEFAULT '0',
  `lang` varchar(4) NOT NULL DEFAULT '',
  `imgid` int(11) DEFAULT NULL,
  `keywords` varchar(255) DEFAULT NULL,
  `prog` tinyint(1) DEFAULT NULL,
  `progdate` datetime DEFAULT NULL,
  `datum` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comments` bigint(11) DEFAULT NULL,
  `themeoverride` varchar(64) DEFAULT NULL,
  `accepted` tinyint(1) NOT NULL DEFAULT '0',
  `modified` datetime DEFAULT '0000-00-00 00:00:00',
  `displaynotes` tinyint(1) DEFAULT NULL,
  `links` text,
  `relatedlinks` text,
  `evfolyam` varchar(16) DEFAULT NULL,
  `szam` smallint(6) DEFAULT NULL,
  `author` varchar(255) DEFAULT NULL,
  `author_url` varchar(255) NOT NULL DEFAULT '',
  `deleted` tinyint(1) DEFAULT '0',
  `delete_userid` int(11) DEFAULT NULL,
  `delete_date` datetime DEFAULT NULL,
  `leadimagecat` int(11) NOT NULL DEFAULT '0',
  `leadimage` int(11) NOT NULL DEFAULT '0',
  `story` tinyint(1) NOT NULL,
  `commentenable` tinyint(1) NOT NULL,
  `exist_lang` tinyint(1) DEFAULT NULL,
  `locked` int(11) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_news_hun`
--

CREATE TABLE `opey_news_hun` (
  `id` int(11) NOT NULL,
  `catid` int(11) NOT NULL DEFAULT '0',
  `topicid` int(11) NOT NULL DEFAULT '0',
  `userid` int(11) NOT NULL DEFAULT '0',
  `authorid` int(11) NOT NULL,
  `title` text,
  `hometext` text,
  `bodytext` text,
  `is_oai` tinyint(1) NOT NULL DEFAULT '0',
  `oai_id` int(11) DEFAULT NULL,
  `oai_set_id` int(11) DEFAULT NULL,
  `content_images` text,
  `notes` text,
  `counter` int(11) NOT NULL DEFAULT '0',
  `lang` varchar(4) NOT NULL DEFAULT '',
  `imgid` int(11) DEFAULT NULL,
  `keywords` varchar(255) DEFAULT NULL,
  `prog` tinyint(1) NOT NULL DEFAULT '0',
  `prog_end` tinyint(1) NOT NULL DEFAULT '0',
  `progdate` datetime DEFAULT NULL,
  `progdate_end` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `datum` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comments` bigint(11) DEFAULT NULL,
  `themeoverride` varchar(64) DEFAULT NULL,
  `accepted` tinyint(1) NOT NULL DEFAULT '0',
  `modified` datetime DEFAULT '0000-00-00 00:00:00',
  `displaynotes` tinyint(1) DEFAULT NULL,
  `links` text,
  `relatedlinks` text,
  `evfolyam` varchar(16) DEFAULT NULL,
  `szam` smallint(6) DEFAULT NULL,
  `author` varchar(255) DEFAULT NULL,
  `author_url` varchar(255) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `delete_userid` int(11) DEFAULT NULL,
  `delete_date` datetime DEFAULT NULL,
  `leadimagecat` int(11) NOT NULL DEFAULT '0',
  `leadimage` int(11) NOT NULL DEFAULT '0',
  `story` tinyint(1) NOT NULL,
  `commentenable` tinyint(1) NOT NULL,
  `exist_lang` tinyint(1) DEFAULT NULL,
  `locked` int(11) NOT NULL DEFAULT '0',
  `twitter_id` varchar(255) DEFAULT NULL,
  `facebook_id` varchar(255) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_news_pages`
--

CREATE TABLE `opey_news_pages` (
  `id` int(11) NOT NULL,
  `params` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_news_temp`
--

CREATE TABLE `opey_news_temp` (
  `id` int(11) NOT NULL,
  `catid` int(11) NOT NULL DEFAULT '0',
  `topicid` int(11) NOT NULL DEFAULT '0',
  `userid` int(11) NOT NULL DEFAULT '0',
  `authorid` int(11) NOT NULL,
  `title` text,
  `hometext` text,
  `bodytext` text,
  `notes` text,
  `counter` int(11) NOT NULL DEFAULT '0',
  `lang` varchar(4) NOT NULL DEFAULT '',
  `imgid` int(11) DEFAULT NULL,
  `keywords` varchar(255) DEFAULT NULL,
  `prog` tinyint(1) DEFAULT NULL,
  `progdate` datetime DEFAULT NULL,
  `datum` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comments` bigint(11) DEFAULT NULL,
  `themeoverride` varchar(64) DEFAULT NULL,
  `accepted` tinyint(1) NOT NULL DEFAULT '0',
  `modified` datetime DEFAULT '0000-00-00 00:00:00',
  `displaynotes` tinyint(1) DEFAULT NULL,
  `links` text,
  `relatedlinks` text,
  `evfolyam` varchar(16) DEFAULT NULL,
  `szam` smallint(6) DEFAULT NULL,
  `author` varchar(255) DEFAULT NULL,
  `author_url` varchar(255) NOT NULL DEFAULT '',
  `deleted` tinyint(1) DEFAULT '0',
  `delete_userid` int(11) DEFAULT NULL,
  `delete_date` datetime DEFAULT NULL,
  `leadimagecat` int(11) NOT NULL DEFAULT '0',
  `leadimage` int(11) NOT NULL DEFAULT '0',
  `exist_lang` tinyint(1) DEFAULT NULL,
  `locked` int(11) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_objecteditor_clipboard`
--

CREATE TABLE `opey_objecteditor_clipboard` (
  `id` bigint(20) NOT NULL,
  `pn_sessid` varchar(32) NOT NULL,
  `obj_tipus` varchar(50) NOT NULL DEFAULT '',
  `tartalom` longtext NOT NULL,
  `params` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_objecteditor_counter`
--

CREATE TABLE `opey_objecteditor_counter` (
  `tipus` varchar(20) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `szam` bigint(20) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- A tábla adatainak kiíratása `opey_objecteditor_counter`
--

INSERT INTO `opey_objecteditor_counter` (`tipus`, `szam`) VALUES
('oecms', 1406),
('oeblocks', 400),
('columns', 1131);

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_oeblocks`
--

CREATE TABLE `opey_oeblocks` (
  `id` int(11) NOT NULL,
  `cat_id` int(11) NOT NULL DEFAULT '0',
  `nev` varchar(255) NOT NULL DEFAULT '',
  `leiras` text NOT NULL,
  `modosithato` char(1) NOT NULL DEFAULT 'I',
  `mod_sessid` varchar(50) NOT NULL DEFAULT '',
  `mod_uid` varchar(5) NOT NULL DEFAULT '',
  `mod_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_oeblocks_categories`
--

CREATE TABLE `opey_oeblocks_categories` (
  `id` int(11) NOT NULL,
  `name` varchar(250) CHARACTER SET utf8 NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- A tábla adatainak kiíratása `opey_oeblocks_categories`
--

INSERT INTO `opey_oeblocks_categories` (`id`, `name`) VALUES
(1, 'Egyéb');

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_oeblocks_edit`
--

CREATE TABLE `opey_oeblocks_edit` (
  `id` bigint(20) NOT NULL,
  `page_id` int(11) NOT NULL DEFAULT '0',
  `sorszam` tinyint(4) NOT NULL DEFAULT '0',
  `obj_tipus` varchar(50) NOT NULL DEFAULT '',
  `tartalom` longtext NOT NULL,
  `params` text NOT NULL,
  `tabla` int(11) NOT NULL DEFAULT '0',
  `tr` int(11) NOT NULL DEFAULT '0',
  `td` int(11) NOT NULL DEFAULT '0',
  `lang` varchar(10) NOT NULL DEFAULT 'def',
  `locked` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_oeblocks_objects`
--

CREATE TABLE `opey_oeblocks_objects` (
  `id` bigint(20) NOT NULL,
  `page_id` int(11) NOT NULL DEFAULT '0',
  `sorszam` tinyint(4) NOT NULL DEFAULT '0',
  `obj_tipus` varchar(50) NOT NULL DEFAULT '',
  `tartalom` longtext NOT NULL,
  `params` text NOT NULL,
  `tabla` int(11) NOT NULL DEFAULT '0',
  `tr` int(11) NOT NULL DEFAULT '0',
  `td` int(11) NOT NULL DEFAULT '0',
  `lang` varchar(10) NOT NULL DEFAULT 'def',
  `locked` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_oecms_backup`
--

CREATE TABLE `opey_oecms_backup` (
  `id` bigint(20) NOT NULL DEFAULT '0',
  `page_id` int(11) NOT NULL DEFAULT '0',
  `sorszam` tinyint(4) NOT NULL DEFAULT '0',
  `obj_tipus` varchar(50) NOT NULL DEFAULT '',
  `tartalom` text NOT NULL,
  `params` text NOT NULL,
  `tabla` int(11) NOT NULL DEFAULT '0',
  `tr` int(11) NOT NULL DEFAULT '0',
  `td` int(11) NOT NULL DEFAULT '0',
  `lang` varchar(10) NOT NULL DEFAULT 'def',
  `verzio` int(11) NOT NULL DEFAULT '0',
  `verzio_datum` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `locked` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- A tábla adatainak kiíratása `opey_oecms_backup`
--

INSERT INTO `opey_oecms_backup` (`id`, `page_id`, `sorszam`, `obj_tipus`, `tartalom`, `params`, `tabla`, `tr`, `td`, `lang`, `verzio`, `verzio_datum`, `locked`) VALUES
(1389, 1, 1, 'dinblock', '5', 'a:1:{s:11:"dinblockpoz";s:0:"";}', 0, 0, 0, 'hun', 1, '2019-05-28 13:43:25', 0),
(1390, 1, 1, 'dinblock', '5', 'a:1:{s:11:"dinblockpoz";s:0:"";}', 0, 0, 0, 'hun', 2, '2019-05-28 13:46:20', 0),
(1391, 1, 1, 'dinblock', '5', 'a:1:{s:11:"dinblockpoz";s:0:"";}', 0, 0, 0, 'hun', 3, '2019-05-28 13:50:14', 0),
(1392, 1, 1, 'dinblock', '5', 'a:1:{s:11:"dinblockpoz";s:0:"";}', 0, 0, 0, 'hun', 4, '2019-05-28 13:54:38', 0),
(1397, 3, 1, 'freehtml', '<section class=\\"introduction\\">\r\n			<div class=\\"content-inner\\">\r\n				<h1>\r\n					Ismerje meg a TOSHIBA minőségét!\r\n				</h1>\r\n				\r\n				<span>\r\n					Kiváló minőség kompromisszumok nélkül, engedmények nélkül.\r\n				</span>\r\n					\r\n				<p>\r\n					Az elmúlt 30 évben a Toshiba áttanulmányozta a klímatechnikai piacot és forradalmi újításokat fejlesztett ki. A szektort erős konkurencia jellemzi. Egyes versenytársaink más célok érdekében feladták termékfejlesztési törekvéseiket. A Toshiba számára azonban a minőség mindig elsődleges szerepet játszott és a jövőben is ez lesz a legfőbb különbség köztünk és más klímatechnikai gyártó cégek között. Minden egyes klímaberendezés gyártásakor ezt a filozófiát tartjuk szem előtt. Nem engedhetünk meg pontatlanságokat. Nincs kompromisszum, csak kiváló minőség.\r\n				</p>\r\n			</div>\r\n		</section>\r\n\r\n		<section class=\\"categories\\">\r\n			<div class=\\"cat cat-lakossagi\\">\r\n				<h2>Lakossági</h2>\r\n			</div>\r\n			<div class=\\"cat cat-szelloztetes\\">\r\n				<h2>Szellőztetés</h2>\r\n			</div>\r\n			<div class=\\"cat cat-vrf\\">\r\n				<h2>VRF</h2>\r\n			</div>\r\n			<div class=\\"cat cat-ipari\\">\r\n				<h2>Ipari</h2>\r\n			</div>\r\n			<div class=\\"cat cat-estia\\">\r\n				<h2>Estia</h2>\r\n			</div>\r\n			<div class=\\"cat cat-vezerlok\\">\r\n				<h2>Vezérlők</h2>\r\n			</div>\r\n		</section>\r\n\r\n\r\n		<section class=\\"toshiba-details\\">\r\n			<div class=\\"content-inner\\">\r\n				<h1>Miért válasszon Toshibát?</h1>\r\n\r\n				<div class=\\"bekezdes\\">				\r\n					<img src=\\"aplusz.png\\" alt=\\"\\">\r\n					<h5>\r\n						Alacsony energiafelhasználás\r\n					</h5>\r\n					<p>\r\n						A nagy energiahatékonyság a Toshiba rendszerekkel szemben mindig is alapvető elvárás volt. A kompresszor inverteres vezérlése mindig pontosan csak a szükséges teljesítményt állítja elő – ez a lehető legjobb hatékonysági értékeket eredményezi mind fűtés, mind hűtés esetén. A bizonyíték az akár A+++ hatékonysági osztályú energiacímke. Még a szabványos készülék használata is mindössze egy kétszemélyes vacsora nagyságrendjébe eső éves ráfordítással jár.\r\n					</p>\r\n				</div>\r\n				<div class=\\"bekezdes halk-mukodes\\">	\r\n				<img src=\\"aplusz.png\\" alt=\\"\\">				\r\n					<h5>\r\n						Halk működés\r\n					</h5>\r\n					<p>\r\n						A kiváló minőségű ventilátor-alkatrészek révén a Toshiba beltéri egységek legfeljebb 20 dB(A) mellett hűtenek vagy fűtenek – ez nagyjából halk papírzörgésnek vagy a légzés hangerejének felel meg. A fordulatszám-szabályozott kompresszorok és ventilátorok révén a kültéri egységek akár néhány méter távolságból is alig hallhatóak.\r\n					</p>\r\n					\r\n				</div>\r\n\r\n				<div class=\\"bekezdes\\">				\r\n					<img src=\\"aplusz.png\\" alt=\\"\\">\r\n					<h5>\r\n						Öntisztító működés\r\n					</h5>\r\n					<p>\r\n						A Toshiba öntisztító funkciót azért fejlesztettük ki, hogy csökkenjen a páratartalom a klímaberendezés belsejében, amely ha túl magas, penészedéshez vezethet. Ha kikapcsolja a klímaberendezést, a belső ventilátor még 20 percig működik és megszárítja a hőcserélőt  - a kellemetlen szagoknak így semmi esélye.Az otthoni környezetben használt beltéri egységek tisztítási funkcióval is jeleskednek: a hőcserélőben lévő lamellák különleges profilozásai és védőbevonatai lehetővé teszik a rátapadó, levegőből kiszűrt szennyeződések lemosását a hűtési üzem során keletkező kondenzvíz segítségével – intelligens és higiénikus.\r\n					</p>\r\n				</div>\r\n				\r\n\r\n			</div>\r\n		</section>\r\n\r\n\r\n		<section class=\\"legnepszerubb lakossagi\\">\r\n\r\n				<div class=\\"cimsor\\">\r\n					<span>Legnépszerübb</span>\r\n					<h2>Lakossági készülékek</h2>\r\n				</div>\r\n\r\n			<div class=\\"content-inner\\">\r\n				<div class=\\"product\\">\r\n					<div class=\\"prod-img\\">\r\n						<img src=\\"prod.jpg\\" alt=\\"\\">\r\n					</div>\r\n					<div class=\\"prod-desc\\">\r\n						<h4>Daiseikai 9 - R32</h4>\r\n						<h5>PREMIUM SZÓLÓ SPLIT</h5>\r\n						<p>\r\n							A Daiseikai 9 a formatervezést a legmagasabb szintű komforttal és hatékonysággal köti össze. Tökéletes üzemi jellemzők kül- és beltéri egységhez, időtálló formatervezéssel és kiváló minőségű levegőszűrő rendszerrel párosítva.\r\n							<a href=\\"#\\">Tovább Daiseikai 9 - R32 ›</a>\r\n						</p>\r\n					</div>\r\n				</div>\r\n\r\n				<div class=\\"product\\">\r\n					<div class=\\"prod-img\\">\r\n						<img src=\\"prod.jpg\\" alt=\\"\\">\r\n					</div>\r\n					<div class=\\"prod-desc\\">\r\n						<h4>Daiseikai 9 - R32</h4>\r\n						<h5>PREMIUM SZÓLÓ SPLIT</h5>\r\n						<p>\r\n							A Daiseikai 9 a formatervezést a legmagasabb szintű komforttal és hatékonysággal köti össze. Tökéletes üzemi jellemzők kül- és beltéri egységhez, időtálló formatervezéssel és kiváló minőségű levegőszűrő rendszerrel párosítva.\r\n\r\n							<a href=\\"#\\">Tovább Daiseikai 9 - R32 ›</a>\r\n						</p>\r\n					</div>\r\n				</div>\r\n\r\n			</div>\r\n		</section>\r\n\r\n		<section class=\\"legnepszerubb ipari\\">\r\n\r\n				<div class=\\"cimsor\\">\r\n					<span>Legnépszerübb</span>\r\n					<h2>Ipari készülékek</h2>\r\n				</div>\r\n\r\n			<div class=\\"content-inner\\">\r\n				<div class=\\"product\\">\r\n					<div class=\\"prod-img\\">\r\n						<img src=\\"prod.jpg\\" alt=\\"\\">\r\n					</div>\r\n					<div class=\\"prod-desc\\">\r\n						<h4>Daiseikai 9 - R32</h4>\r\n						<h5>PREMIUM SZÓLÓ SPLIT</h5>\r\n						<p>\r\n							A Daiseikai 9 a formatervezést a legmagasabb szintű komforttal és hatékonysággal köti össze. Tökéletes üzemi jellemzők kül- és beltéri egységhez, időtálló formatervezéssel és kiváló minőségű levegőszűrő rendszerrel párosítva.\r\n\r\n							<a href=\\"#\\">Tovább Daiseikai 9 - R32 ›</a>\r\n						</p>\r\n					</div>\r\n				</div>\r\n\r\n				<div class=\\"product\\">\r\n					<div class=\\"prod-img\\">\r\n						<img src=\\"prod.jpg\\" alt=\\"\\">\r\n					</div>\r\n					<div class=\\"prod-desc\\">\r\n						<h4>Daiseikai 9 - R32</h4>\r\n						<h5>PREMIUM SZÓLÓ SPLIT</h5>\r\n						<p>\r\n							A Daiseikai 9 a formatervezést a legmagasabb szintű komforttal és hatékonysággal köti össze. Tökéletes üzemi jellemzők kül- és beltéri egységhez, időtálló formatervezéssel és kiváló minőségű levegőszűrő rendszerrel párosítva.\r\n\r\n							<a href=\\"#\\">Tovább Daiseikai 9 - R32 ›</a>\r\n						</p>\r\n					</div>\r\n				</div>\r\n			</div>\r\n\r\n		</section>\r\n\r\n		<section class=\\"legnepszerubb estia\\">\r\n\r\n				<div class=\\"cimsor\\">\r\n					<span>Legnépszerübb</span>\r\n					<h2>Estia készülékek</h2>\r\n				</div>\r\n\r\n			<div class=\\"content-inner\\">\r\n				<div class=\\"product\\">\r\n					<div class=\\"prod-img\\">\r\n						<img src=\\"prod.jpg\\" alt=\\"\\">\r\n					</div>\r\n					<div class=\\"prod-desc\\">\r\n						<h4>Daiseikai 9 - R32</h4>\r\n						<h5>PREMIUM SZÓLÓ SPLIT</h5>\r\n						<p>\r\n							A Daiseikai 9 a formatervezést a legmagasabb szintű komforttal és hatékonysággal köti össze. Tökéletes üzemi jellemzők kül- és beltéri egységhez, időtálló formatervezéssel és kiváló minőségű levegőszűrő rendszerrel párosítva.\r\n\r\n							<a href=\\"#\\">Tovább Daiseikai 9 - R32 ›</a>\r\n						</p>\r\n					</div>\r\n				</div>\r\n\r\n				<div class=\\"product\\">\r\n					<div class=\\"prod-img\\">\r\n						<img src=\\"prod.jpg\\" alt=\\"\\">\r\n					</div>\r\n					<div class=\\"prod-desc\\">\r\n						<h4>Daiseikai 9 - R32</h4>\r\n						<h5>PREMIUM SZÓLÓ SPLIT</h5>\r\n						<p>\r\n							A Daiseikai 9 a formatervezést a legmagasabb szintű komforttal és hatékonysággal köti össze. Tökéletes üzemi jellemzők kül- és beltéri egységhez, időtálló formatervezéssel és kiváló minőségű levegőszűrő rendszerrel párosítva.\r\n\r\n							<a href=\\"#\\">Tovább Daiseikai 9 - R32 ›</a>\r\n						</p>\r\n					</div>\r\n				</div>\r\n			</div>\r\n			\r\n		</section>\r\n\r\n		<section class=\\"references\\">\r\n			<div class=\\"cimsor\\">\r\n				<span>Legnépszerübb</span>\r\n				<h2>Estia készülékek</h2>\r\n			</div>\r\n			<div class=\\"content-inner\\">\r\n				\r\n			</div>\r\n		</section>', '', 0, 0, 0, 'hun', 1, '2019-05-28 15:04:49', 0),
(1401, 1, 1, 'freehtml', '<section class=\\"introduction container-fluid\\">\r\n			<div class=\\"content-inner row\\">\r\n				<div class=\\"col-2\\"></div>\r\n				<div class=\\"col-12\\">\r\n					<h1>\r\n					Ismerje meg a TOSHIBA minőségét!\r\n				</h1>\r\n				\r\n				<span>\r\n					Kiváló minőség kompromisszumok nélkül, engedmények nélkül.\r\n				</span>\r\n					\r\n				<p>\r\n					Az elmúlt 30 évben a Toshiba áttanulmányozta a klímatechnikai piacot és forradalmi újításokat fejlesztett ki. A szektort erős konkurencia jellemzi. Egyes versenytársaink más célok érdekében feladták termékfejlesztési törekvéseiket. A Toshiba számára azonban a minőség mindig elsődleges szerepet játszott és a jövőben is ez lesz a legfőbb különbség köztünk és más klímatechnikai gyártó cégek között. Minden egyes klímaberendezés gyártásakor ezt a filozófiát tartjuk szem előtt. Nem engedhetünk meg pontatlanságokat. Nincs kompromisszum, csak kiváló minőség.\r\n				</p>\r\n			</div>\r\n				</div>\r\n				\r\n		</section>', '', 0, 0, 0, 'hun', 5, '2019-05-29 10:04:53', 0),
(1401, 1, 1, 'freehtml', '<section class=\\"introduction container-fluid\\">\r\n			<div class=\\"content-inner row\\">\r\n				<div class=\\"col-1\\"></div>\r\n				<div class=\\"col-10\\">\r\n					<h1>\r\n					Ismerje meg a TOSHIBA minőségét!\r\n				</h1>\r\n				\r\n				<span>\r\n					Kiváló minőség kompromisszumok nélkül, engedmények nélkül.\r\n				</span>\r\n					\r\n				<p>\r\n					Az elmúlt 30 évben a Toshiba áttanulmányozta a klímatechnikai piacot és forradalmi újításokat fejlesztett ki. A szektort erős konkurencia jellemzi. Egyes versenytársaink más célok érdekében feladták termékfejlesztési törekvéseiket. A Toshiba számára azonban a minőség mindig elsődleges szerepet játszott és a jövőben is ez lesz a legfőbb különbség köztünk és más klímatechnikai gyártó cégek között. Minden egyes klímaberendezés gyártásakor ezt a filozófiát tartjuk szem előtt. Nem engedhetünk meg pontatlanságokat. Nincs kompromisszum, csak kiváló minőség.\r\n				</p>\r\n			</div>\r\n				</div>\r\n				\r\n		</section>', '', 0, 0, 0, 'hun', 6, '2019-05-30 09:53:11', 0),
(1401, 1, 1, 'freehtml', '<section class=\\"introduction container-fluid\\">\r\n			<div class=\\"content-inner row\\">\r\n				<div class=\\"col-1\\"></div>\r\n				<div class=\\"col-10\\">\r\n					<h1>\r\n					Ismerje meg a TOSHIBA minőségét!\r\n				</h1>\r\n				\r\n				<span>\r\n					Kiváló minőség kompromisszumok nélkül, engedmények nélkül.\r\n				</span>\r\n					\r\n				<p>\r\n					Az elmúlt 30 évben a Toshiba áttanulmányozta a klímatechnikai piacot és forradalmi újításokat fejlesztett ki. A szektort erős konkurencia jellemzi. Egyes versenytársaink más célok érdekében feladták termékfejlesztési törekvéseiket. A Toshiba számára azonban a minőség mindig elsődleges szerepet játszott és a jövőben is ez lesz a legfőbb különbség köztünk és más klímatechnikai gyártó cégek között. Minden egyes klímaberendezés gyártásakor ezt a filozófiát tartjuk szem előtt. Nem engedhetünk meg pontatlanságokat. Nincs kompromisszum, csak kiváló minőség.\r\n				</p>\r\n			</div>\r\n				</div>\r\n				\r\n		</section>', '', 0, 0, 0, 'hun', 7, '2019-05-30 09:59:25', 0),
(1403, 1, 2, 'text', '<p>Kattintson ide a sz&ouml;veg hozz&aacute;ad&aacute;s&aacute;hoz!</p>', 'a:0:{}', 0, 0, 0, 'hun', 7, '2019-05-30 09:59:25', 0),
(1401, 1, 1, 'freehtml', '<section class=\\"introduction container-fluid\\">\r\n			<div class=\\"content-inner row\\">\r\n				<div class=\\"col-xl-1 col-lg-1 col-md-0 col-sm-0\\"></div>\r\n				<div class=\\"col-xl-10 col-lg-10 col-md-12 col-sm-12\\">\r\n					<h1>\r\n					Ismerje meg a TOSHIBA minőségét!\r\n				</h1>\r\n				\r\n				<span>\r\n					Kiváló minőség kompromisszumok nélkül, engedmények nélkül.\r\n				</span>\r\n					\r\n				<p>\r\n					Az elmúlt 30 évben a Toshiba áttanulmányozta a klímatechnikai piacot és forradalmi újításokat fejlesztett ki. A szektort erős konkurencia jellemzi. Egyes versenytársaink más célok érdekében feladták termékfejlesztési törekvéseiket. A Toshiba számára azonban a minőség mindig elsődleges szerepet játszott és a jövőben is ez lesz a legfőbb különbség köztünk és más klímatechnikai gyártó cégek között. Minden egyes klímaberendezés gyártásakor ezt a filozófiát tartjuk szem előtt. Nem engedhetünk meg pontatlanságokat. Nincs kompromisszum, csak kiváló minőség.\r\n				</p>\r\n			</div>\r\n				</div>\r\n				\r\n		</section>', '', 0, 0, 0, 'hun', 8, '2019-05-30 11:18:19', 0),
(1401, 1, 2, 'freehtml', '<section class=\\"introduction container-fluid\\">\r\n			<div class=\\"content-inner row\\">\r\n				<div class=\\"col-xl-1 col-lg-1 col-md-0 col-sm-0\\"></div>\r\n				<div class=\\"col-xl-10 col-lg-10 col-md-12 col-sm-12\\">\r\n					<h1>\r\n					Ismerje meg a TOSHIBA minőségét!\r\n				</h1>\r\n				\r\n				<span>\r\n					Kiváló minőség kompromisszumok nélkül, engedmények nélkül.\r\n				</span>\r\n					\r\n				<p>\r\n					Az elmúlt 30 évben a Toshiba áttanulmányozta a klímatechnikai piacot és forradalmi újításokat fejlesztett ki. A szektort erős konkurencia jellemzi. Egyes versenytársaink más célok érdekében feladták termékfejlesztési törekvéseiket. A Toshiba számára azonban a minőség mindig elsődleges szerepet játszott és a jövőben is ez lesz a legfőbb különbség köztünk és más klímatechnikai gyártó cégek között. Minden egyes klímaberendezés gyártásakor ezt a filozófiát tartjuk szem előtt. Nem engedhetünk meg pontatlanságokat. Nincs kompromisszum, csak kiváló minőség.\r\n				</p>\r\n			</div>\r\n				</div>\r\n				\r\n		</section>', '', 0, 0, 0, 'hun', 9, '2019-05-30 14:20:47', 0),
(1404, 1, 1, 'dinblock', '8', 'a:1:{s:11:"dinblockpoz";s:0:"";}', 0, 0, 0, 'hun', 9, '2019-05-30 14:20:47', 0);

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_oecms_categories`
--

CREATE TABLE `opey_oecms_categories` (
  `id` bigint(20) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `parentid` bigint(20) NOT NULL DEFAULT '0',
  `modcat` tinyint(4) NOT NULL,
  `modname` varchar(255) DEFAULT NULL,
  `modid` int(11) NOT NULL,
  `dir` varchar(255) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- A tábla adatainak kiíratása `opey_oecms_categories`
--

INSERT INTO `opey_oecms_categories` (`id`, `name`, `parentid`, `modcat`, `modname`, `modid`, `dir`) VALUES
(1, 'Design', 0, 0, NULL, 0, '/Design');

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_oecms_edit`
--

CREATE TABLE `opey_oecms_edit` (
  `id` bigint(20) NOT NULL,
  `page_id` int(11) NOT NULL DEFAULT '0',
  `sorszam` tinyint(4) NOT NULL DEFAULT '0',
  `obj_tipus` varchar(50) NOT NULL DEFAULT '',
  `tartalom` longtext NOT NULL,
  `params` text NOT NULL,
  `tabla` int(11) NOT NULL DEFAULT '0',
  `tr` int(11) NOT NULL DEFAULT '0',
  `td` int(11) NOT NULL DEFAULT '0',
  `lang` varchar(10) NOT NULL DEFAULT 'def',
  `locked` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_oecms_files`
--

CREATE TABLE `opey_oecms_files` (
  `id` bigint(20) NOT NULL,
  `version_parentid` int(11) DEFAULT NULL,
  `version_protected` tinyint(4) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT 'nÃƒ?Ã‚Â©vtelen',
  `filename` varchar(255) NOT NULL DEFAULT '',
  `categoryid` bigint(20) NOT NULL DEFAULT '0',
  `filetype` varchar(10) NOT NULL DEFAULT '',
  `keywords` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- A tábla adatainak kiíratása `opey_oecms_files`
--

INSERT INTO `opey_oecms_files` (`id`, `version_parentid`, `version_protected`, `name`, `filename`, `categoryid`, `filetype`, `keywords`, `description`) VALUES
(800, NULL, 0, '', 'menu.svg', 1, '', '', ''),
(799, NULL, 0, '', 'menu.png', 1, 'kep', '', ''),
(798, NULL, 0, '', '14173200.png', 1, 'kep', '', ''),
(797, NULL, 0, '', 'loginroundedrightfilled.png', 1, 'kep', '', ''),
(796, NULL, 0, '', 'logo_2.png', 1, 'kep', '', ''),
(795, NULL, 0, '', '800pxToshiba_logo.svg.png', 1, 'kep', '', '');

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_oecms_form_templates`
--

CREATE TABLE `opey_oecms_form_templates` (
  `id` int(11) NOT NULL,
  `category` tinyint(4) NOT NULL DEFAULT '0',
  `name` varchar(50) NOT NULL DEFAULT '',
  `html` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_oecms_globals`
--

CREATE TABLE `opey_oecms_globals` (
  `valtozo` varchar(255) NOT NULL DEFAULT '',
  `ertek` tinytext NOT NULL,
  `megjegyzes` varchar(255) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_oecms_objects`
--

CREATE TABLE `opey_oecms_objects` (
  `id` bigint(20) NOT NULL,
  `page_id` int(11) NOT NULL DEFAULT '0',
  `sorszam` tinyint(4) NOT NULL DEFAULT '0',
  `obj_tipus` varchar(50) NOT NULL DEFAULT '',
  `tartalom` longtext NOT NULL,
  `params` text NOT NULL,
  `tabla` int(11) NOT NULL DEFAULT '0',
  `tr` int(11) NOT NULL DEFAULT '0',
  `td` int(11) NOT NULL DEFAULT '0',
  `lang` varchar(10) NOT NULL DEFAULT 'def',
  `locked` tinyint(4) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 PACK_KEYS=0;

--
-- A tábla adatainak kiíratása `opey_oecms_objects`
--

INSERT INTO `opey_oecms_objects` (`id`, `page_id`, `sorszam`, `obj_tipus`, `tartalom`, `params`, `tabla`, `tr`, `td`, `lang`, `locked`) VALUES
(1396, 2, 1, 'dinblock', '8', 'a:1:{s:11:"dinblockpoz";s:0:"";}', 0, 0, 0, 'hun', 0),
(1404, 1, 1, 'dinblock', '8', 'a:1:{s:11:"dinblockpoz";s:0:"";}', 0, 0, 0, 'hun', 0),
(1401, 1, 2, 'freehtml', '<section class=\\"introduction container-fluid\\">\r\n			<div class=\\"content-inner row\\">\r\n				<div class=\\"col-xl-1 col-lg-1 col-md-0 col-sm-0\\"></div>\r\n				<div class=\\"col-xl-10 col-lg-10 col-md-12 col-sm-12\\">\r\n					<h1>\r\n					Ismerje meg a TOSHIBA minőségét!\r\n				</h1>\r\n				\r\n				<span>\r\n					Kiváló minőség kompromisszumok nélkül, engedmények nélkül.\r\n				</span>\r\n					\r\n				<p>\r\n					Az elmúlt 30 évben a Toshiba áttanulmányozta a klímatechnikai piacot és forradalmi újításokat fejlesztett ki. A szektort erős konkurencia jellemzi. Egyes versenytársaink más célok érdekében feladták termékfejlesztési törekvéseiket. A Toshiba számára azonban a minőség mindig elsődleges szerepet játszott és a jövőben is ez lesz a legfőbb különbség köztünk és más klímatechnikai gyártó cégek között. Minden egyes klímaberendezés gyártásakor ezt a filozófiát tartjuk szem előtt. Nem engedhetünk meg pontatlanságokat. Nincs kompromisszum, csak kiváló minőség.\r\n				</p>\r\n			</div>\r\n				</div>\r\n				\r\n		</section>', '', 0, 0, 0, 'hun', 0),
(1405, 1, 3, 'dinblock', '9', 'a:1:{s:11:"dinblockpoz";s:0:"";}', 0, 0, 0, 'hun', 0);

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_oecms_pages`
--

CREATE TABLE `opey_oecms_pages` (
  `id` int(11) NOT NULL,
  `modosithato` char(1) NOT NULL DEFAULT 'I',
  `mod_sessid` varchar(50) NOT NULL DEFAULT '',
  `mod_uid` varchar(5) NOT NULL DEFAULT '',
  `mod_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `vedett` tinyint(1) NOT NULL DEFAULT '0',
  `is_oai` tinyint(1) NOT NULL DEFAULT '0',
  `oai_id` int(11) DEFAULT NULL,
  `oai_set_id` int(11) DEFAULT NULL,
  `torolve` char(1) NOT NULL DEFAULT 'N',
  `torles_datuma` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- A tábla adatainak kiíratása `opey_oecms_pages`
--

INSERT INTO `opey_oecms_pages` (`id`, `modosithato`, `mod_sessid`, `mod_uid`, `mod_time`, `vedett`, `is_oai`, `oai_id`, `oai_set_id`, `torolve`, `torles_datuma`) VALUES
(1, 'I', '84soj0ntjf0424mr2sc5tjskm7', '599', '2019-05-30 14:18:49', 0, 0, NULL, NULL, 'N', '0000-00-00 00:00:00'),
(2, 'I', 'uptcjkin29lrlos3i79m4guaq6', '599', '2019-05-28 14:15:20', 0, 0, NULL, NULL, 'N', '0000-00-00 00:00:00'),
(3, 'I', 'uptcjkin29lrlos3i79m4guaq6', '599', '2019-05-28 15:04:44', 0, 0, NULL, NULL, 'N', '0000-00-00 00:00:00');

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_page_migration`
--

CREATE TABLE `opey_page_migration` (
  `fw_id` int(11) NOT NULL,
  `old_page` varchar(255) NOT NULL DEFAULT '',
  `new_page` varchar(255) NOT NULL DEFAULT '',
  `header_code` varchar(30) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_priv_msgs`
--

CREATE TABLE `opey_priv_msgs` (
  `msg_id` int(11) NOT NULL,
  `msg_image` varchar(100) DEFAULT NULL,
  `subject` varchar(100) DEFAULT NULL,
  `from_userid` int(11) NOT NULL DEFAULT '0',
  `to_userid` int(11) NOT NULL DEFAULT '0',
  `msg_time` varchar(20) DEFAULT NULL,
  `msg_text` text,
  `read_msg` tinyint(4) NOT NULL DEFAULT '0',
  `read_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `deleted` tinyint(4) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_referer`
--

CREATE TABLE `opey_referer` (
  `pn_rid` int(11) NOT NULL,
  `pn_url` varchar(100) NOT NULL DEFAULT '',
  `pn_frequency` int(15) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_searchindex`
--

CREATE TABLE `opey_searchindex` (
  `id` int(11) NOT NULL,
  `module` varchar(32) NOT NULL DEFAULT '',
  `mid` int(11) NOT NULL DEFAULT '0',
  `midx` varchar(100) NOT NULL,
  `lang` char(3) NOT NULL DEFAULT '',
  `datum` date NOT NULL DEFAULT '0000-00-00',
  `link` varchar(255) NOT NULL DEFAULT '',
  `title` text NOT NULL,
  `hometext` text NOT NULL,
  `hometext_search` longtext NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- A tábla adatainak kiíratása `opey_searchindex`
--

INSERT INTO `opey_searchindex` (`id`, `module`, `mid`, `midx`, `lang`, `datum`, `link`, `title`, `hometext`, `hometext_search`) VALUES
(11, 'cms', 2, 'T0UtQ01TMg==', 'hun', '2019-05-28', '', '', '', ''),
(13, 'cms', 3, 'T0UtQ01TMw==', 'hun', '2019-05-28', '', '', '', ''),
(38, 'cms', 1, 'T0UtQ01TMQ==', 'hun', '2019-05-30', '', '', '', '');

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_searchindex_reindex`
--

CREATE TABLE `opey_searchindex_reindex` (
  `id` int(11) NOT NULL,
  `module` varchar(255) CHARACTER SET utf8 NOT NULL,
  `mid` int(11) NOT NULL,
  `description` varchar(255) CHARACTER SET utf8 NOT NULL,
  `lang` varchar(5) CHARACTER SET utf8 NOT NULL,
  `progress` tinyint(4) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_hungarian_ci;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_searchindex_words`
--

CREATE TABLE `opey_searchindex_words` (
  `word` varchar(255) CHARACTER SET utf8 NOT NULL COMMENT 'Word to find',
  `word_id` bigint(20) NOT NULL COMMENT 'ID for reference to details table'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_hungarian_ci;

--
-- A tábla adatainak kiíratása `opey_searchindex_words`
--

INSERT INTO `opey_searchindex_words` (`word`, `word_id`) VALUES
('nyito', 1),
('kattintson', 2),
('ide', 3),
('a', 4),
('szöveg', 5),
('hozzáadásához', 6);

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_searchindex_words_doc`
--

CREATE TABLE `opey_searchindex_words_doc` (
  `word_id` bigint(20) DEFAULT NULL COMMENT 'Word ID in the index table',
  `word_count` int(11) DEFAULT NULL COMMENT 'Number of given word in this document',
  `word_firstpos` int(11) NOT NULL,
  `extra` tinyint(4) NOT NULL DEFAULT '0',
  `module` varchar(50) CHARACTER SET utf8 DEFAULT NULL COMMENT 'Module name',
  `lang` varchar(3) CHARACTER SET utf8 NOT NULL,
  `mid` int(11) DEFAULT NULL COMMENT 'ID in given module',
  `docidx` varchar(255) CHARACTER SET utf8 NOT NULL,
  `word_positions` blob COMMENT 'Positions of the given word in this document in a binary array'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_hungarian_ci;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_searchindex_words_temp`
--

CREATE TABLE `opey_searchindex_words_temp` (
  `word` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `position` int(11) DEFAULT NULL,
  `extra` tinyint(4) NOT NULL
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COLLATE=utf8_hungarian_ci;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_session_hard_variables`
--

CREATE TABLE `opey_session_hard_variables` (
  `sid` varchar(63) CHARACTER SET utf8 NOT NULL COMMENT 'session ID',
  `vars` text CHARACTER SET utf8 NOT NULL COMMENT 'változók szerializálva',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='fontos session változók helye';

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_session_info`
--

CREATE TABLE `opey_session_info` (
  `pn_sessid` varchar(32) NOT NULL DEFAULT '',
  `pn_ipaddr` varchar(20) NOT NULL DEFAULT '',
  `pn_firstused` int(11) NOT NULL DEFAULT '0',
  `pn_lastused` int(11) NOT NULL DEFAULT '0',
  `pn_uid` int(11) NOT NULL DEFAULT '0',
  `pn_locked` bigint(4) NOT NULL,
  `pn_inactive` varchar(5) NOT NULL DEFAULT '',
  `pn_vars` blob
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- A tábla adatainak kiíratása `opey_session_info`
--

INSERT INTO `opey_session_info` (`pn_sessid`, `pn_ipaddr`, `pn_firstused`, `pn_lastused`, `pn_uid`, `pn_locked`, `pn_inactive`, `pn_vars`) VALUES
('84soj0ntjf0424mr2sc5tjskm7', '127.0.0.1', 1559200992, 1559226247, 599, 0, ' ', 0x504e535672616e647c693a33303635373b504e53566c616e677c733a333a2268756e223b504e53567569647c693a3539393b504e5356746f6f6c6261724d61696e4672616d657c733a32303a22757365722e7068703f66697273744c6f61643d31223b504e535666696c654c69737452656653657373696f6e7c613a323a7b733a343a2270616765223b693a313b733a31333a227768657265414e444172726179223b613a323a7b733a31303a2263617465676f72796964223b613a323a7b733a353a2276616c7565223b733a313a2231223b733a343a2274797065223b733a313a223d223b7d733a383a2266696c6574797065223b613a323a7b733a353a2276616c7565223b733a393a22756e646566696e6564223b733a343a2274797065223b733a313a2225223b7d7d7d504e53566469724d656469617c733a373a222f44657369676e223b504e53566469724361747c733a313a2231223b504e5356646972547970657c733a393a22756e646566696e6564223b504e53567472656553746174657c733a313a2231223b504e53567461626c615f69647c733a313a2230223b504e53567461626c615f74727c733a313a2230223b504e53567461626c615f74647c733a313a2230223b504e5356696d6753756243617449447c733a313a2231223b504e5356656469745f6d6f647c733a343a2245444954223b504e5356735f6d6f645f69647c733a333a22353339223b504e5356735f6261636b6d6f647c733a373a224d6f64756c6573223b504e5356735f766973737a6168656c797c733a373a226d6f64756c6f6b223b);

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_shortlink`
--

CREATE TABLE `opey_shortlink` (
  `id` int(3) NOT NULL,
  `short_path` varchar(200) NOT NULL DEFAULT '',
  `path` varchar(255) DEFAULT NULL,
  `owner` varchar(50) NOT NULL DEFAULT '',
  `own_id` int(11) NOT NULL DEFAULT '0',
  `path_level` tinyint(4) NOT NULL DEFAULT '0',
  `oeLayout` int(11) NOT NULL DEFAULT '1',
  `blocks_type` int(11) NOT NULL DEFAULT '0',
  `blocks_id` text NOT NULL,
  `display` tinyint(1) DEFAULT '1',
  `menu_caption` varchar(255) DEFAULT NULL,
  `menu_order` tinyint(4) NOT NULL DEFAULT '0',
  `description` varchar(255) DEFAULT NULL,
  `pagetitle` varchar(255) DEFAULT NULL,
  `meta` text,
  `counter` int(11) NOT NULL DEFAULT '0',
  `protected` tinyint(1) NOT NULL DEFAULT '0',
  `edited_column` varchar(31) NOT NULL,
  `subdomain_root` tinyint(1) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- A tábla adatainak kiíratása `opey_shortlink`
--

INSERT INTO `opey_shortlink` (`id`, `short_path`, `path`, `owner`, `own_id`, `path_level`, `oeLayout`, `blocks_type`, `blocks_id`, `display`, `menu_caption`, `menu_order`, `description`, `pagetitle`, `meta`, `counter`, `protected`, `edited_column`, `subdomain_root`) VALUES
(1, 'nyito', 'index.php?name=OE-CMS&file=index&page_id=1', 'OE-CMS', 1, 0, 14, 0, '', 0, '', 0, '', 'Kezdőoldal', '', 948, 0, '', 0),
(2, 'teszt', 'index.php?name=OE-CMS&file=index&page_id=2', 'OE-CMS', 2, 0, 14, 0, '', 0, '', 0, '', '', '', 83, 0, '', 0),
(3, 'kapcsolat', 'index.php?name=OE-CMS&file=index&page_id=3', 'OE-CMS', 3, 0, 14, 0, '', 0, '', 0, '', '', '', 24, 0, '', 0),
(4, 'termekek', 'index.php?name=eShop&file=index', 'eShop', 0, 0, 14, 0, '', 0, '', 0, '', '', '', 7, 0, '', 0);

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_shortlink_lang`
--

CREATE TABLE `opey_shortlink_lang` (
  `shortlink_id` int(11) NOT NULL DEFAULT '0',
  `display` tinyint(4) NOT NULL DEFAULT '0',
  `menu_caption` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `description` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `pagetitle` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `meta` text CHARACTER SET utf8 NOT NULL,
  `lang` char(3) CHARACTER SET utf8 NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_shortlink_modules`
--

CREATE TABLE `opey_shortlink_modules` (
  `id` int(3) NOT NULL,
  `short_path` varchar(200) NOT NULL DEFAULT '',
  `path` varchar(255) DEFAULT NULL,
  `owner` varchar(50) NOT NULL DEFAULT '',
  `own_id` int(11) NOT NULL DEFAULT '0',
  `description` text,
  `pagetitle` varchar(255) DEFAULT NULL,
  `meta` text,
  `counter` int(11) NOT NULL DEFAULT '0',
  `sample_sh_id` int(11) NOT NULL,
  `noheaders` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'dokumentum linkek eseteben nem kell semmi header',
  `extra` varchar(255) NOT NULL,
  `lang` varchar(3) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- A tábla adatainak kiíratása `opey_shortlink_modules`
--

INSERT INTO `opey_shortlink_modules` (`id`, `short_path`, `path`, `owner`, `own_id`, `description`, `pagetitle`, `meta`, `counter`, `sample_sh_id`, `noheaders`, `extra`, `lang`) VALUES
(10, 'termekek/lakossagi', 'index.php?name=eShop&file=index&function=categoryPage&category=179', 'eShop', 179, '', 'Lakossági', '', 3, 0, 0, 'category', ''),
(21, 'termekek/estia', 'index.php?name=eShop&file=index&function=categoryPage&category=187', 'eShop', 187, '', 'Estia', '', 0, 0, 0, 'category', ''),
(22, 'termekek/vezerlok', 'index.php?name=eShop&file=index&function=categoryPage&category=188', 'eShop', 188, '', 'Vezérlők', '', 0, 0, 0, 'category', ''),
(18, 'termekek/vrf', 'index.php?name=eShop&file=index&function=categoryPage&category=184', 'eShop', 184, '', 'VRF', '', 1, 0, 0, 'category', ''),
(16, 'termekek/szelloztetes', 'index.php?name=eShop&file=index&function=categoryPage&category=182', 'eShop', 182, '', 'Szellőztetés', '', 2, 0, 0, 'category', ''),
(17, 'termekek/lakossagi/mono', 'index.php?name=eShop&file=index&function=listPage&category=183', 'eShop', 183, '', 'Mono', '', 0, 0, 0, 'category', ''),
(19, 'termekek/ipari', 'index.php?name=eShop&file=index&function=categoryPage&category=185', 'eShop', 185, '', 'Ipari', '', 0, 0, 0, 'category', '');

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_styles`
--

CREATE TABLE `opey_styles` (
  `id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `params` text NOT NULL,
  `used` int(1) NOT NULL DEFAULT '0',
  `system` int(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- A tábla adatainak kiíratása `opey_styles`
--

INSERT INTO `opey_styles` (`id`, `name`, `params`, `used`, `system`) VALUES
(16, '.bekezdes_cim', 'a:13:{s:15:"style_fontcolor";s:0:"";s:21:"style_backgroundcolor";s:0:"";s:16:"style_lineheight";s:0:"";s:19:"style_letterspacing";s:0:"";s:20:"style_liststyleimage";s:1:"7";s:16:"style_fontfamily";s:0:"";s:14:"style_fontsize";s:0:"";s:16:"style_fontweight";s:4:"bold";s:15:"style_fontstyle";s:6:"normal";s:20:"style_textdecoration";s:4:"none";s:21:"style_lineheight_unit";s:2:"px";s:22:"style_freewrite_styles";s:0:"";s:2:"id";s:2:"11";}', 0, 0),
(17, '.navbar', 'a:13:{s:15:"style_fontcolor";s:0:"";s:21:"style_backgroundcolor";s:0:"";s:16:"style_lineheight";s:0:"";s:19:"style_letterspacing";s:0:"";s:20:"style_liststyleimage";s:1:"7";s:16:"style_fontfamily";s:0:"";s:14:"style_fontsize";s:0:"";s:16:"style_fontweight";s:6:"normal";s:15:"style_fontstyle";s:6:"normal";s:20:"style_textdecoration";s:4:"none";s:21:"style_lineheight_unit";s:2:"px";s:22:"style_freewrite_styles";s:0:"";s:2:"id";s:2:"12";}', 0, 0),
(18, '.head_slog', 'a:13:{s:15:"style_fontcolor";s:0:"";s:21:"style_backgroundcolor";s:0:"";s:16:"style_lineheight";s:0:"";s:19:"style_letterspacing";s:0:"";s:20:"style_liststyleimage";s:1:"7";s:16:"style_fontfamily";s:0:"";s:14:"style_fontsize";s:0:"";s:16:"style_fontweight";s:6:"normal";s:15:"style_fontstyle";s:6:"normal";s:20:"style_textdecoration";s:4:"none";s:21:"style_lineheight_unit";s:2:"px";s:22:"style_freewrite_styles";s:0:"";s:2:"id";s:2:"13";}', 0, 0),
(19, '.vignette_text', 'a:13:{s:15:"style_fontcolor";s:6:"000000";s:21:"style_backgroundcolor";s:7:"#ffffff";s:16:"style_lineheight";s:0:"";s:19:"style_letterspacing";s:0:"";s:20:"style_liststyleimage";s:1:"1";s:16:"style_fontfamily";s:0:"";s:14:"style_fontsize";s:0:"";s:16:"style_fontweight";s:6:"normal";s:15:"style_fontstyle";s:6:"normal";s:20:"style_textdecoration";s:4:"none";s:21:"style_lineheight_unit";s:2:"px";s:22:"style_freewrite_styles";s:0:"";s:2:"id";s:2:"14";}', 0, 0),
(20, '.vignette_title', 'a:13:{s:15:"style_fontcolor";s:6:"000000";s:21:"style_backgroundcolor";s:7:"#ffffff";s:16:"style_lineheight";s:0:"";s:19:"style_letterspacing";s:0:"";s:20:"style_liststyleimage";s:1:"1";s:16:"style_fontfamily";s:0:"";s:14:"style_fontsize";s:0:"";s:16:"style_fontweight";s:6:"normal";s:15:"style_fontstyle";s:6:"normal";s:20:"style_textdecoration";s:4:"none";s:21:"style_lineheight_unit";s:2:"px";s:22:"style_freewrite_styles";s:0:"";s:2:"id";s:2:"15";}', 0, 0);

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_subdomain2shortlink`
--

CREATE TABLE `opey_subdomain2shortlink` (
  `subdomain` varchar(255) NOT NULL DEFAULT '',
  `shortlink` varchar(255) NOT NULL DEFAULT '',
  `site_name` varchar(100) NOT NULL DEFAULT '',
  `rss_topic` tinyint(4) NOT NULL DEFAULT '0',
  `rss_category` tinyint(4) NOT NULL DEFAULT '0',
  `stat_identifier` varchar(50) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Subdomai nevek shortlink cimekre iranyitasa';

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_toolbar`
--

CREATE TABLE `opey_toolbar` (
  `id` int(11) NOT NULL DEFAULT '0',
  `tabHeight` int(11) NOT NULL DEFAULT '0',
  `name` varchar(50) NOT NULL DEFAULT '',
  `title` varchar(50) NOT NULL DEFAULT '',
  `label` varchar(200) NOT NULL DEFAULT '',
  `menuURL` varchar(255) NOT NULL DEFAULT '',
  `perm_component` varchar(255) NOT NULL DEFAULT '',
  `perm_instance` varchar(255) NOT NULL DEFAULT '',
  `perm_access` varchar(20) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='A bal oldali felhasznaloi toolbar adatai';

--
-- A tábla adatainak kiíratása `opey_toolbar`
--

INSERT INTO `opey_toolbar` (`id`, `tabHeight`, `name`, `title`, `label`, `menuURL`, `perm_component`, `perm_instance`, `perm_access`) VALUES
(2, 20, 'SiteMap', '_TAB_SITEMAP', '_TAB_SITEMAP_LABEL', 'modules/OE-User/toolbar/SiteMapXML', '', '', ''),
(1, 20, 'Default', '_TAB_BASE_LINKS', '_TAB_BASE_LINKS_LABEL', 'modules/OE-User/toolbar/Default', '', '', ''),
(4, 20, 'eShop', '_TAB_ESHOP', '_TAB_ESHOP_LABEL', 'modules/eShop/toolbar/eShop', '', '', '');

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_topics`
--

CREATE TABLE `opey_topics` (
  `id` int(11) NOT NULL,
  `image` varchar(255) DEFAULT NULL,
  `counter` int(11) DEFAULT '0',
  `name_hun` varchar(255) DEFAULT NULL,
  `name_eng` varchar(255) DEFAULT NULL,
  `topictext_hun` varchar(255) DEFAULT NULL,
  `topictext_eng` varchar(255) DEFAULT NULL,
  `shortlink_prefix_hun` varchar(255) NOT NULL,
  `shortlink_prefix_eng` varchar(255) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_userblocks`
--

CREATE TABLE `opey_userblocks` (
  `pn_uid` int(11) NOT NULL DEFAULT '0',
  `pn_bid` int(11) NOT NULL DEFAULT '0',
  `pn_active` tinyint(3) NOT NULL DEFAULT '1',
  `pn_last_update` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_users`
--

CREATE TABLE `opey_users` (
  `pn_uid` int(11) NOT NULL,
  `pn_name` varchar(60) NOT NULL DEFAULT '',
  `pn_uname` varchar(60) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `pn_email` varchar(60) NOT NULL DEFAULT '',
  `pn_femail` varchar(60) NOT NULL DEFAULT '',
  `pn_url` varchar(100) NOT NULL DEFAULT '',
  `pn_user_avatar` varchar(30) DEFAULT NULL,
  `pn_user_regdate` varchar(20) NOT NULL DEFAULT '',
  `pn_user_icq` varchar(15) DEFAULT NULL,
  `pn_user_occ` varchar(100) DEFAULT NULL,
  `pn_user_from` varchar(100) DEFAULT NULL,
  `pn_user_intrest` varchar(150) DEFAULT NULL,
  `pn_user_sig` varchar(255) DEFAULT NULL,
  `pn_user_viewemail` tinyint(2) DEFAULT NULL,
  `pn_user_theme` tinyint(3) DEFAULT NULL,
  `pn_user_aim` varchar(18) DEFAULT NULL,
  `pn_user_yim` varchar(25) DEFAULT NULL,
  `pn_user_msnm` varchar(25) DEFAULT NULL,
  `pn_pass` varchar(40) NOT NULL DEFAULT '',
  `pn_storynum` tinyint(4) NOT NULL DEFAULT '10',
  `pn_umode` varchar(10) NOT NULL DEFAULT '',
  `pn_uorder` tinyint(1) NOT NULL DEFAULT '0',
  `pn_thold` tinyint(1) NOT NULL DEFAULT '0',
  `pn_noscore` tinyint(1) NOT NULL DEFAULT '0',
  `pn_bio` tinytext NOT NULL,
  `pn_ublockon` tinyint(1) NOT NULL DEFAULT '0',
  `pn_ublock` text NOT NULL,
  `pn_theme` varchar(255) NOT NULL DEFAULT '',
  `pn_commentmax` int(11) NOT NULL DEFAULT '4096',
  `pn_counter` int(11) NOT NULL DEFAULT '0',
  `pn_timezone_offset` float(3,1) NOT NULL DEFAULT '0.0',
  `pn_lifeend` date NOT NULL DEFAULT '0000-00-00'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- A tábla adatainak kiíratása `opey_users`
--

INSERT INTO `opey_users` (`pn_uid`, `pn_name`, `pn_uname`, `pn_email`, `pn_femail`, `pn_url`, `pn_user_avatar`, `pn_user_regdate`, `pn_user_icq`, `pn_user_occ`, `pn_user_from`, `pn_user_intrest`, `pn_user_sig`, `pn_user_viewemail`, `pn_user_theme`, `pn_user_aim`, `pn_user_yim`, `pn_user_msnm`, `pn_pass`, `pn_storynum`, `pn_umode`, `pn_uorder`, `pn_thold`, `pn_noscore`, `pn_bio`, `pn_ublockon`, `pn_ublock`, `pn_theme`, `pn_commentmax`, `pn_counter`, `pn_timezone_offset`, `pn_lifeend`) VALUES
(1, '', 'Anonymous', '', '', '', 'blank.gif', '1019035313', '', '', '', '', '', 0, 0, '', '', '', 'f9cd11e24d51e94276092cb75c8f298d', 10, '', 0, 0, 0, '', 0, '', '', 4096, 1, 12.0, '0000-00-00'),
(2, 'SysAdmin', 'sysadmin', 'szabolcs@petho.eu', '', '', 'blank.gif', '1019035313', '', 'favágó', '', 'sysadmin', '', 0, 0, '', '', '', '341e20d47e14b241f9fa180a24e58726', 20, 'thread', 0, 4, 0, 'szeretek fát vágni olvasni és moziba járni. \r\nKedvenc színem a barna meg a vörös is, de a szőke sem egy csúnya szín meg még a ferrári is persze és a moziban pedig a svarcenegger is jó mert megvédi a gyengéb', 0, '(òJ(òJass=''content''><aþß·e\0ø\0\0\0AdminAdminpetho@apd.hu\0http://www.apd.hu	blank.gif\n1019035313\0\0\0\0\0\0\0\0 65ae9105a35facec57a2d79b7ef8f572thread7(òJ(òJass=''content''><aþß·e\0ø\0\0\0AdminAdminpetho@apd.hu\0http://www.apd.hu	blank.gif\n1019035313\0\0\0\0\0\0\0\0 65ae9105a35facec57a2d79b7ef8f572thread7(òJ(òJ', 'Default', 4096, 5, 13.0, '0000-00-00'),
(599, 'Dávid', 'david', '', '', '', NULL, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '550b30fc7ba86117a59d433f5cd63e74', 10, '', 0, 0, 0, '', 0, '', '', 4096, 0, 0.0, '0000-00-00');

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_user_data`
--

CREATE TABLE `opey_user_data` (
  `pn_uda_id` int(11) NOT NULL,
  `pn_uda_propid` int(11) NOT NULL DEFAULT '0',
  `pn_uda_uid` int(11) NOT NULL DEFAULT '0',
  `pn_uda_value` mediumblob NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_user_failed_logins`
--

CREATE TABLE `opey_user_failed_logins` (
  `id` int(11) NOT NULL,
  `uname` varchar(255) NOT NULL,
  `ip_address` int(11) UNSIGNED DEFAULT NULL,
  `ip_address_str` varchar(15) NOT NULL,
  `attempted_at` datetime NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_user_modvars`
--

CREATE TABLE `opey_user_modvars` (
  `user_id` int(11) NOT NULL DEFAULT '0',
  `variable` varchar(255) NOT NULL DEFAULT '',
  `value` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- A tábla adatainak kiíratása `opey_user_modvars`
--

INSERT INTO `opey_user_modvars` (`user_id`, `variable`, `value`) VALUES
(6, 'ahWinSizes', 'a:3:{s:12:"topLeftWidth";s:3:"600";s:13:"topRightWidth";s:3:"150";s:12:"bottomHeight";s:3:"250";}'),
(2, 'ahWinSizes', 'a:3:{s:12:"topLeftWidth";s:3:"554";s:13:"topRightWidth";s:3:"150";s:12:"bottomHeight";s:3:"301";}'),
(2, 'editorType', 's:4:"tmce";'),
(2, 'uaOpenedGroups', 'a:167:{i:0;s:1:"4";i:1;s:1:"4";i:2;s:1:"5";i:3;s:1:"7";i:4;s:1:"4";i:5;s:1:"5";i:6;s:1:"7";i:7;s:1:"5";i:8;s:1:"4";i:9;s:1:"7";i:10;s:1:"5";i:11;s:1:"7";i:12;s:1:"4";i:13;s:1:"8";i:14;s:1:"6";i:15;s:1:"7";i:16;s:1:"4";i:17;s:1:"5";i:18;s:1:"8";i:19;s:1:"6";i:20;s:1:"6";i:21;s:1:"7";i:22;s:1:"4";i:23;s:1:"5";i:24;s:1:"2";i:25;s:1:"6";i:26;s:1:"7";i:27;s:1:"4";i:28;s:1:"2";i:29;s:1:"5";i:30;s:1:"6";i:31;s:1:"2";i:32;s:1:"5";i:33;s:1:"7";i:34;s:1:"4";i:35;s:1:"5";i:36;s:1:"7";i:37;s:1:"6";i:38;s:1:"4";i:39;s:1:"2";i:40;s:1:"7";i:41;s:1:"2";i:42;s:1:"4";i:43;s:1:"6";i:44;s:1:"5";i:45;s:1:"5";i:46;s:1:"6";i:47;s:1:"4";i:48;s:1:"2";i:49;s:1:"7";i:50;s:1:"2";i:51;s:1:"7";i:52;s:1:"5";i:53;s:1:"6";i:54;s:1:"4";i:55;s:1:"2";i:56;s:1:"4";i:57;s:1:"5";i:58;s:1:"6";i:59;s:1:"7";i:60;s:1:"2";i:61;s:1:"5";i:62;s:1:"6";i:63;s:1:"7";i:64;s:1:"4";i:65;s:1:"5";i:66;s:1:"4";i:67;s:1:"2";i:68;s:1:"7";i:69;s:1:"6";i:70;s:1:"2";i:71;s:1:"5";i:72;s:1:"6";i:73;s:1:"7";i:74;s:1:"4";i:75;s:1:"2";i:76;s:1:"5";i:77;s:1:"4";i:78;s:1:"7";i:79;s:1:"6";i:80;s:1:"5";i:81;s:1:"6";i:82;s:1:"4";i:83;s:1:"7";i:84;s:1:"8";i:85;s:1:"2";i:86;s:1:"2";i:87;s:1:"4";i:88;s:1:"7";i:89;s:1:"8";i:90;s:1:"6";i:91;s:1:"5";i:92;s:1:"2";i:93;s:1:"8";i:94;s:1:"6";i:95;s:1:"5";i:96;s:1:"7";i:97;s:1:"4";i:98;s:1:"6";i:99;s:1:"8";i:100;s:1:"7";i:101;s:1:"5";i:102;s:1:"4";i:103;s:1:"2";i:104;s:1:"2";i:105;s:1:"4";i:106;s:1:"8";i:107;s:1:"7";i:108;s:1:"6";i:109;s:1:"5";i:110;s:1:"8";i:111;s:1:"7";i:112;s:1:"6";i:113;s:1:"4";i:114;s:1:"2";i:115;s:1:"5";i:116;s:1:"2";i:117;s:1:"5";i:118;s:1:"8";i:119;s:1:"7";i:120;s:1:"4";i:121;s:1:"6";i:122;s:1:"2";i:123;s:1:"6";i:124;s:1:"5";i:125;s:1:"8";i:126;s:1:"4";i:127;s:1:"7";i:128;s:1:"2";i:129;s:1:"5";i:130;s:1:"4";i:131;s:1:"6";i:132;s:1:"7";i:133;s:1:"8";i:134;s:1:"8";i:135;s:1:"5";i:136;s:1:"6";i:137;s:1:"2";i:138;s:1:"7";i:139;s:1:"4";i:140;s:1:"6";i:141;s:1:"2";i:142;s:1:"4";i:143;s:1:"8";i:144;s:1:"5";i:145;s:1:"7";i:146;s:2:"10";i:147;s:1:"2";i:148;s:2:"10";i:149;s:1:"4";i:150;s:1:"8";i:151;s:1:"6";i:152;s:1:"5";i:153;s:1:"7";i:154;s:1:"2";i:155;s:2:"10";i:156;s:1:"8";i:157;s:1:"5";i:158;s:1:"6";i:159;s:1:"4";i:160;s:1:"7";i:161;s:1:"2";i:162;s:1:"4";i:163;s:1:"2";i:164;s:1:"4";i:165;s:1:"2";i:166;s:1:"4";}'),
(126, 'autosave', 'a:2:{i:0;s:1:"y";i:1;s:2:"30";}'),
(10, 'ahWinSizes', 'a:3:{s:12:"topLeftWidth";s:3:"600";s:13:"topRightWidth";s:3:"150";s:12:"bottomHeight";s:3:"250";}'),
(10, 'uaOpenedGroups', 'a:8:{i:0;s:1:"7";i:1;s:1:"7";i:2;s:1:"7";i:3;s:1:"7";i:4;s:1:"6";i:5;s:1:"6";i:6;s:1:"7";i:7;s:1:"4";}'),
(6, 'autosave', 'a:2:{i:0;s:1:"n";i:1;s:2:"30";}'),
(11, 'ahWinSizes', 'a:3:{s:12:"topLeftWidth";s:3:"600";s:13:"topRightWidth";s:3:"150";s:12:"bottomHeight";s:3:"250";}'),
(11, 'editorType', 's:4:"tmce";'),
(11, 'autosave', 'a:2:{i:0;s:1:"y";i:1;s:2:"60";}'),
(11, 'uaOpenedGroups', 'a:8:{i:0;s:1:"6";i:1;s:1:"7";i:2;s:1:"6";i:3;s:1:"7";i:4;s:1:"8";i:5;s:1:"8";i:6;s:1:"6";i:7;s:1:"7";}'),
(7, 'ahWinSizes', 'a:3:{s:12:"topLeftWidth";s:3:"600";s:13:"topRightWidth";s:3:"150";s:12:"bottomHeight";s:3:"250";}'),
(7, 'uaOpenedGroups', 'a:10:{i:0;s:1:"1";i:1;s:1:"1";i:2;s:1:"1";i:3;s:1:"1";i:4;s:1:"1";i:5;s:1:"1";i:6;s:1:"4";i:7;s:1:"1";i:8;s:1:"4";i:9;s:1:"2";}'),
(7, 'editorType', 's:4:"tmce";'),
(13, 'ahWinSizes', 'a:3:{s:12:"topLeftWidth";s:3:"600";s:13:"topRightWidth";s:3:"150";s:12:"bottomHeight";s:3:"250";}'),
(13, 'uaOpenedGroups', 'a:2:{i:0;s:1:"8";i:1;s:1:"8";}'),
(6, 'uaOpenedGroups', 'a:2:{i:0;s:1:"2";i:1;s:1:"4";}'),
(13, 'editorType', 's:4:"tmce";'),
(29, 'ahWinSizes', 'a:3:{s:12:"topLeftWidth";s:3:"600";s:13:"topRightWidth";s:3:"150";s:12:"bottomHeight";s:3:"250";}'),
(2, 'ownColors', 'a:3:{i:2;s:6:"1C2A71";i:3;s:6:"2B7FAD";i:4;s:6:"FCE353";}'),
(2, 'oebOpenedCats', 'a:0:{}'),
(15, 'ahWinSizes', 'a:3:{s:12:"topLeftWidth";s:3:"600";s:13:"topRightWidth";s:3:"150";s:12:"bottomHeight";s:3:"250";}'),
(7, 'oebOpenedCats', 'a:1:{i:0;s:1:"1";}'),
(6, 'oebOpenedCats', 'a:1:{i:0;s:1:"1";}'),
(51, 'ahWinSizes', 'a:3:{s:12:"topLeftWidth";s:3:"600";s:13:"topRightWidth";s:3:"129";s:12:"bottomHeight";s:3:"196";}'),
(108, 'editorType', 's:4:"tmce";'),
(51, 'uaOpenedGroups', 'a:274:{i:0;s:1:"7";i:1;s:1:"6";i:2;s:1:"8";i:3;s:1:"6";i:4;s:1:"8";i:5;s:1:"7";i:6;s:1:"8";i:7;s:1:"6";i:8;s:1:"7";i:9;s:1:"8";i:10;s:1:"6";i:11;s:1:"7";i:12;s:1:"6";i:13;s:1:"8";i:14;s:1:"7";i:15;s:1:"8";i:16;s:1:"7";i:17;s:1:"6";i:18;s:1:"8";i:19;s:1:"6";i:20;s:1:"7";i:21;s:1:"6";i:22;s:1:"8";i:23;s:1:"7";i:24;s:1:"8";i:25;s:1:"6";i:26;s:1:"7";i:27;s:1:"6";i:28;s:1:"8";i:29;s:1:"7";i:30;s:1:"6";i:31;s:1:"8";i:32;s:1:"7";i:33;s:1:"6";i:34;s:1:"8";i:35;s:1:"7";i:36;s:1:"6";i:37;s:1:"8";i:38;s:1:"7";i:39;s:1:"8";i:40;s:1:"6";i:41;s:1:"7";i:42;s:1:"7";i:43;s:1:"6";i:44;s:1:"8";i:45;s:1:"7";i:46;s:1:"6";i:47;s:1:"8";i:48;s:1:"6";i:49;s:1:"7";i:50;s:1:"8";i:51;s:1:"7";i:52;s:1:"6";i:53;s:1:"8";i:54;s:1:"8";i:55;s:1:"7";i:56;s:1:"6";i:57;s:1:"6";i:58;s:1:"8";i:59;s:1:"7";i:60;s:1:"6";i:61;s:1:"7";i:62;s:1:"8";i:63;s:1:"6";i:64;s:1:"7";i:65;s:1:"8";i:66;s:1:"7";i:67;s:1:"8";i:68;s:1:"6";i:69;s:1:"6";i:70;s:1:"7";i:71;s:1:"6";i:72;s:1:"7";i:73;s:1:"6";i:74;s:1:"7";i:75;s:1:"8";i:76;s:1:"7";i:77;s:1:"8";i:78;s:1:"6";i:79;s:1:"6";i:80;s:1:"7";i:81;s:1:"8";i:82;s:1:"6";i:83;s:1:"7";i:84;s:1:"8";i:85;s:1:"7";i:86;s:1:"6";i:87;s:1:"8";i:88;s:1:"6";i:89;s:1:"8";i:90;s:1:"7";i:91;s:1:"6";i:92;s:1:"8";i:93;s:1:"7";i:94;s:1:"6";i:95;s:1:"8";i:96;s:1:"7";i:97;s:1:"8";i:98;s:1:"6";i:99;s:1:"6";i:100;s:1:"7";i:101;s:1:"8";i:102;s:1:"8";i:103;s:1:"6";i:104;s:1:"6";i:105;s:1:"7";i:106;s:1:"8";i:107;s:1:"8";i:108;s:1:"6";i:109;s:1:"7";i:110;s:1:"7";i:111;s:1:"6";i:112;s:1:"8";i:113;s:1:"6";i:114;s:1:"8";i:115;s:1:"7";i:116;s:1:"7";i:117;s:1:"6";i:118;s:1:"8";i:119;s:1:"6";i:120;s:1:"7";i:121;s:1:"8";i:122;s:1:"7";i:123;s:1:"6";i:124;s:1:"8";i:125;s:1:"8";i:126;s:1:"7";i:127;s:1:"6";i:128;s:1:"6";i:129;s:1:"7";i:130;s:1:"8";i:131;s:1:"8";i:132;s:1:"6";i:133;s:1:"7";i:134;s:1:"8";i:135;s:1:"6";i:136;s:1:"6";i:137;s:1:"8";i:138;s:1:"7";i:139;s:1:"6";i:140;s:1:"7";i:141;s:1:"8";i:142;s:1:"6";i:143;s:1:"7";i:144;s:1:"8";i:145;s:1:"6";i:146;s:1:"7";i:147;s:1:"8";i:148;s:1:"7";i:149;s:1:"6";i:150;s:1:"7";i:151;s:1:"8";i:152;s:1:"6";i:153;s:1:"6";i:154;s:1:"8";i:155;s:1:"7";i:156;s:1:"8";i:157;s:1:"7";i:158;s:1:"6";i:159;s:1:"7";i:160;s:1:"6";i:161;s:1:"8";i:162;s:1:"6";i:163;s:1:"8";i:164;s:1:"7";i:165;s:1:"6";i:166;s:1:"8";i:167;s:1:"8";i:168;s:1:"6";i:169;s:1:"7";i:170;s:1:"8";i:171;s:1:"7";i:172;s:1:"6";i:173;s:1:"6";i:174;s:1:"8";i:175;s:1:"6";i:176;s:1:"7";i:177;s:1:"8";i:178;s:1:"7";i:179;s:1:"6";i:180;s:1:"8";i:181;s:1:"6";i:182;s:1:"8";i:183;s:1:"7";i:184;s:1:"6";i:185;s:1:"8";i:186;s:1:"7";i:187;s:1:"6";i:188;s:1:"7";i:189;s:1:"8";i:190;s:1:"6";i:191;s:1:"7";i:192;s:1:"8";i:193;s:1:"6";i:194;s:1:"7";i:195;s:1:"8";i:196;s:1:"6";i:197;s:1:"8";i:198;s:1:"7";i:199;s:1:"6";i:200;s:1:"7";i:201;s:1:"8";i:202;s:1:"6";i:203;s:1:"7";i:204;s:1:"8";i:205;s:1:"7";i:206;s:1:"8";i:207;s:1:"6";i:208;s:1:"7";i:209;s:1:"6";i:210;s:1:"7";i:211;s:1:"6";i:212;s:1:"8";i:213;s:1:"7";i:214;s:1:"8";i:215;s:1:"6";i:216;s:1:"7";i:217;s:1:"8";i:218;s:1:"6";i:219;s:1:"6";i:220;s:1:"8";i:221;s:1:"7";i:222;s:1:"7";i:223;s:1:"6";i:224;s:1:"8";i:225;s:1:"7";i:226;s:1:"6";i:227;s:1:"8";i:228;s:1:"7";i:229;s:1:"8";i:230;s:1:"6";i:231;s:1:"7";i:232;s:1:"8";i:233;s:1:"6";i:234;s:1:"8";i:235;s:1:"7";i:236;s:1:"8";i:237;s:1:"6";i:238;s:1:"7";i:239;s:1:"7";i:240;s:1:"6";i:241;s:1:"8";i:242;s:1:"6";i:243;s:1:"7";i:244;s:1:"8";i:245;s:1:"6";i:246;s:1:"7";i:247;s:1:"8";i:248;s:1:"8";i:249;s:1:"7";i:250;s:1:"6";i:251;s:1:"7";i:252;s:1:"8";i:253;s:1:"6";i:254;s:1:"7";i:255;s:1:"6";i:256;s:1:"8";i:257;s:1:"6";i:258;s:1:"7";i:259;s:1:"8";i:260;s:1:"6";i:261;s:1:"7";i:262;s:1:"8";i:263;s:1:"7";i:264;s:1:"6";i:265;s:1:"8";i:266;s:1:"6";i:267;s:1:"8";i:268;s:1:"7";i:269;s:1:"6";i:270;s:1:"7";i:271;s:1:"8";i:272;s:1:"6";i:273;s:1:"8";}'),
(6, 'editorType', 's:4:"tmce";'),
(126, 'editorType', 's:4:"tmce";'),
(127, 'editorType', 's:4:"tmce";'),
(127, 'autosave', 'a:2:{i:0;s:1:"y";i:1;s:2:"30";}'),
(126, 'uaOpenedGroups', 'a:1:{i:0;s:1:"4";}'),
(128, 'editorType', 's:4:"tmce";'),
(128, 'autosave', 'a:2:{i:0;s:1:"y";i:1;s:2:"30";}'),
(10, 'editorType', 's:4:"tmce";'),
(128, 'uaOpenedGroups', 'a:8:{i:0;s:1:"7";i:1;s:1:"6";i:2;s:1:"4";i:3;s:1:"4";i:4;s:1:"7";i:5;s:1:"7";i:6;s:1:"6";i:7;s:1:"4";}'),
(131, 'uaOpenedGroups', 'a:1:{i:0;s:1:"2";}'),
(2, 'mediaLibraryDefaultView', 's:6:"thumbs";'),
(549, 'mediaLibraryDefaultView', 's:6:"thumbs";'),
(549, 'editorType', 's:4:"tmce";'),
(549, 'uaOpenedGroups', 'a:13:{i:0;s:1:"2";i:1;s:1:"2";i:2;s:1:"5";i:3;s:1:"6";i:4;s:1:"7";i:5;s:1:"4";i:6;s:1:"1";i:7;s:1:"2";i:8;s:1:"6";i:9;s:1:"7";i:10;s:1:"4";i:11;s:1:"5";i:12;s:1:"1";}'),
(550, 'mediaLibraryDefaultView', 's:6:"thumbs";'),
(550, 'editorType', 's:4:"tmce";'),
(550, 'uaOpenedGroups', 'a:54:{i:0;s:1:"7";i:1;s:1:"4";i:2;s:1:"4";i:3;s:1:"7";i:4;s:1:"7";i:5;s:1:"4";i:6;s:1:"9";i:7;s:1:"8";i:8;s:1:"9";i:9;s:1:"8";i:10;s:1:"7";i:11;s:1:"4";i:12;s:1:"7";i:13;s:1:"8";i:14;s:1:"9";i:15;s:1:"4";i:16;s:1:"8";i:17;s:1:"9";i:18;s:1:"4";i:19;s:1:"7";i:20;s:1:"8";i:21;s:1:"7";i:22;s:1:"9";i:23;s:1:"4";i:24;s:1:"8";i:25;s:1:"9";i:26;s:1:"4";i:27;s:1:"7";i:28;s:2:"10";i:29;s:1:"1";i:30;s:1:"8";i:31;s:1:"1";i:32;s:2:"10";i:33;s:1:"9";i:34;s:1:"4";i:35;s:1:"7";i:36;s:1:"1";i:37;s:1:"8";i:38;s:1:"4";i:39;s:1:"9";i:40;s:1:"7";i:41;s:2:"10";i:42;s:1:"8";i:43;s:1:"9";i:44;s:1:"1";i:45;s:1:"4";i:46;s:2:"10";i:47;s:1:"7";i:48;s:1:"9";i:49;s:1:"1";i:50;s:1:"7";i:51;s:2:"10";i:52;s:1:"4";i:53;s:1:"8";}'),
(131, 'editorType', 's:4:"tmce";'),
(551, 'mediaLibraryDefaultView', 's:6:"thumbs";'),
(549, 'oebOpenedCats', 'a:1:{i:0;s:1:"5";}'),
(551, 'uaOpenedGroups', 'a:2:{i:0;s:1:"4";i:1;s:1:"4";}'),
(550, 'oebOpenedCats', 'a:1:{i:0;s:1:"5";}'),
(598, 'editorType', 's:4:"tmce";'),
(595, 'uaOpenedGroups', 'a:0:{}'),
(599, 'editorType', 's:4:"tmce";'),
(599, 'mediaLibraryDefaultView', 's:6:"thumbs";'),
(599, 'oebOpenedCats', 'a:1:{i:0;s:1:"1";}');

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_user_perms`
--

CREATE TABLE `opey_user_perms` (
  `pn_pid` int(11) NOT NULL,
  `pn_uid` int(11) NOT NULL DEFAULT '0',
  `pn_sequence` int(6) NOT NULL DEFAULT '0',
  `pn_realm` int(4) NOT NULL DEFAULT '0',
  `pn_component` varchar(255) NOT NULL DEFAULT '',
  `pn_instance` varchar(255) NOT NULL DEFAULT '',
  `pn_level` int(4) NOT NULL DEFAULT '0',
  `pn_bond` int(2) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_user_property`
--

CREATE TABLE `opey_user_property` (
  `pn_prop_id` int(11) NOT NULL,
  `pn_prop_label` varchar(255) NOT NULL DEFAULT '',
  `pn_prop_dtype` int(11) NOT NULL DEFAULT '0',
  `pn_prop_length` int(11) NOT NULL DEFAULT '255',
  `pn_prop_weight` int(11) NOT NULL DEFAULT '0',
  `pn_prop_validation` varchar(255) DEFAULT NULL,
  `pn_prop_use` tinyint(4) NOT NULL DEFAULT '0',
  `pn_prop_secret` tinyint(4) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- A tábla adatainak kiíratása `opey_user_property`
--

INSERT INTO `opey_user_property` (`pn_prop_id`, `pn_prop_label`, `pn_prop_dtype`, `pn_prop_length`, `pn_prop_weight`, `pn_prop_validation`, `pn_prop_use`, `pn_prop_secret`) VALUES
(1, '_UREALNAME', 0, 255, 1, '', 0, 0),
(2, '_UREALEMAIL', -1, 255, 2, '', 0, 0),
(3, '_UFAKEMAIL', 0, 255, 0, '', 0, 0),
(4, '_YOURHOMEPAGE', 0, 255, 3, '', 0, 0),
(5, '_TIMEZONEOFFSET', 0, 255, 4, '', 0, 0),
(6, '_YOURAVATAR', 0, 255, 0, '', 0, 0),
(7, '_YICQ', 0, 255, 0, '', 0, 0),
(8, '_YAIM', 0, 255, 0, '', 0, 0),
(9, '_YYIM', 0, 255, 0, '', 0, 0),
(10, '_YMSNM', 0, 255, 0, '', 0, 0),
(11, '_YLOCATION', 0, 255, 5, '', 0, 0),
(12, '_YOCCUPATION', 0, 255, 6, '', 0, 0),
(13, '_YINTERESTS', 0, 255, 7, '', 0, 0),
(14, '_SIGNATURE', 0, 255, 0, '', 0, 0),
(15, '_EXTRAINFO', 0, 255, 8, '', 0, 0),
(16, '_PASSWORD', -1, 255, 9, '', 0, 0);

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_vendegkonyv`
--

CREATE TABLE `opey_vendegkonyv` (
  `id` int(10) NOT NULL,
  `name` varchar(255) NOT NULL,
  `text` text NOT NULL,
  `date` datetime NOT NULL,
  `checked` enum('0','1') NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_vendegkonyv_option`
--

CREATE TABLE `opey_vendegkonyv_option` (
  `name` varchar(30) NOT NULL,
  `value` varchar(30) NOT NULL,
  `real_name` varchar(50) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- A tábla adatainak kiíratása `opey_vendegkonyv_option`
--

INSERT INTO `opey_vendegkonyv_option` (`name`, `value`, `real_name`) VALUES
('db_per_oldal', '10', 'Hozzászólás / oldal'),
('check', '1', 'Moderálás (0-nem, 1-igen)');

-- --------------------------------------------------------

--
-- Tábla szerkezet ehhez a táblához `opey_visitors_404`
--

CREATE TABLE `opey_visitors_404` (
  `id` int(11) NOT NULL,
  `vis_id` int(11) NOT NULL DEFAULT '0',
  `url` text NOT NULL,
  `referrer_url` varchar(250) NOT NULL DEFAULT '',
  `time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ip_address` varchar(100) NOT NULL DEFAULT '',
  `browser` varchar(250) NOT NULL,
  `user_agent` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='A nem talalhato oldalak listaja';

--
-- A tábla adatainak kiíratása `opey_visitors_404`
--

INSERT INTO `opey_visitors_404` (`id`, `vis_id`, `url`, `referrer_url`, `time`, `ip_address`, `browser`, `user_agent`) VALUES
(1, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.hu/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-23 14:11:32', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.131 Safari/537.36'),
(2, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_header.gif', 'http://atlantisz.patronet.hu/nyito', '2019-05-23 14:11:56', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.131 Safari/537.36'),
(3, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.hu/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-23 14:28:12', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.157 Safari/537.36'),
(4, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.hu/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-23 15:28:47', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.157 Safari/537.36'),
(5, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_footer-primary.gif', 'http://atlantisz.patronet.hu/nyito', '2019-05-23 15:29:23', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.157 Safari/537.36'),
(6, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.hu/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-24 07:22:36', '86.59.231.13', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.131 Safari/537.36'),
(7, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_footer-primary.gif', 'http://atlantisz.patronet.hu/nyito', '2019-05-24 08:46:57', '86.59.231.13', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.131 Safari/537.36'),
(8, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-24 10:35:27', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.131 Safari/537.36'),
(9, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.hu/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-27 09:49:37', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(10, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 09:49:40', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(11, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 09:49:40', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(12, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 09:49:40', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(13, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 09:49:41', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(14, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 09:49:41', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(15, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 09:49:47', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(16, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 09:49:47', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(17, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 09:49:48', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(18, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/', '2019-05-27 09:49:48', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(19, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/', '2019-05-27 09:49:48', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(20, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/', '2019-05-27 09:49:50', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(21, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/', '2019-05-27 09:49:50', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(22, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/', '2019-05-27 09:49:55', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(23, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/', '2019-05-27 09:49:55', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(24, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.hu/', '2019-05-27 09:49:56', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(25, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.hu/', '2019-05-27 09:49:56', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(26, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/', '2019-05-27 09:50:00', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(27, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/', '2019-05-27 09:50:00', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(28, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.hu/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-27 09:50:10', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(29, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 09:50:14', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(30, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 09:50:14', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(31, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 09:50:14', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(32, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 09:50:14', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(33, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 09:50:14', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(34, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/', '2019-05-27 09:50:14', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(35, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/', '2019-05-27 09:50:14', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(36, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 09:50:16', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(37, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 09:50:16', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(38, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 09:50:16', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(39, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 09:50:19', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(40, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 09:50:19', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(41, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_header.gif', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 09:50:19', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(42, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 09:50:19', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(43, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/', '2019-05-27 11:49:35', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(44, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/', '2019-05-27 11:49:35', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(45, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/', '2019-05-27 11:49:35', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(46, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/', '2019-05-27 11:49:35', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(47, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.hu/', '2019-05-27 11:49:36', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(48, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.hu/', '2019-05-27 11:49:36', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(49, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/', '2019-05-27 11:49:41', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(50, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/', '2019-05-27 11:49:41', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(51, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.hu/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-27 11:49:51', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(52, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 11:49:58', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(53, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 11:49:58', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(54, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 11:49:58', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(55, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 11:50:00', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(56, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 11:50:00', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(57, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 11:50:08', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(58, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 11:50:08', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(59, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 11:50:08', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(60, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 11:50:11', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(61, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 11:50:11', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(62, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_footer-primary.gif', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 11:50:11', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(63, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 11:50:11', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(64, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/', '2019-05-27 14:51:18', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(65, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/', '2019-05-27 14:51:18', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(66, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.hu/', '2019-05-27 14:51:18', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(67, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.hu/', '2019-05-27 14:51:19', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(68, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/', '2019-05-27 14:51:31', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(69, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/', '2019-05-27 14:51:31', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(70, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.hu/', '2019-05-27 14:51:31', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(71, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.hu/', '2019-05-27 14:51:31', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(72, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.hu/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-27 14:51:33', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(73, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 14:51:33', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(74, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 14:51:33', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(75, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 14:51:34', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(76, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 14:51:34', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(77, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 14:51:34', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(78, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_footer-primary.gif', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 14:51:34', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(79, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 14:51:34', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(80, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.hu/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-27 14:51:36', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(81, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/', '2019-05-27 15:46:00', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(82, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/', '2019-05-27 15:46:00', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(83, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.hu/', '2019-05-27 15:46:00', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(84, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.hu/', '2019-05-27 15:46:00', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(85, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.hu/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-27 15:46:05', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(86, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:46:08', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(87, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:46:08', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(88, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:46:08', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(89, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:46:08', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(90, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:46:08', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(91, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/', '2019-05-27 15:46:09', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(92, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/', '2019-05-27 15:46:09', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(93, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:49:09', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(94, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_footer-primary.gif', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:49:09', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(95, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:49:09', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(96, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:49:09', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(97, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:49:09', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(98, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:49:09', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(99, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/', '2019-05-27 15:49:33', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(100, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/', '2019-05-27 15:49:33', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(101, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/', '2019-05-27 15:49:35', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(102, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/', '2019-05-27 15:49:35', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(103, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:49:38', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(104, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:49:38', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(105, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:49:38', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(106, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/', '2019-05-27 15:49:40', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(107, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/', '2019-05-27 15:49:40', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(108, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:49:43', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(109, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:49:43', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(110, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_footer-primary.gif', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:49:43', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(111, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:49:43', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(112, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:50:39', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(113, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:50:39', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(114, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:50:39', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(115, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_footer-primary.gif', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:50:39', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(116, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:50:53', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(117, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:50:53', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(118, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:50:53', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(119, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:50:53', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(120, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:50:54', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(121, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:50:55', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(122, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:50:55', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(123, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:50:55', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(124, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:50:55', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(125, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_footer-primary.gif', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:50:55', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(126, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:50:56', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(127, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:51:01', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(128, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:51:01', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(129, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:51:01', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(130, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:51:10', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(131, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:51:10', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(132, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:51:10', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(133, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:51:12', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(134, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:51:12', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(135, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_header.gif', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:51:12', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(136, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-27 15:51:12', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(137, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/', '2019-05-27 15:52:46', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(138, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/', '2019-05-27 15:52:47', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(139, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/', '2019-05-27 16:06:19', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(140, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/', '2019-05-27 16:06:19', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(141, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/', '2019-05-28 09:18:42', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(142, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/', '2019-05-28 09:18:42', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(143, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.hu/', '2019-05-28 09:18:42', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(144, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.hu/', '2019-05-28 09:18:42', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(145, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/', '2019-05-28 09:18:47', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(146, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/', '2019-05-28 09:18:47', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(147, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/', '2019-05-28 09:19:42', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(148, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/', '2019-05-28 09:19:42', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(149, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/', '2019-05-28 09:19:44', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(150, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/', '2019-05-28 09:19:44', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(151, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.hu/', '2019-05-28 09:19:44', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(152, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.hu/', '2019-05-28 09:19:44', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(153, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/', '2019-05-28 09:19:48', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(154, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/', '2019-05-28 09:19:48', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(155, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.hu/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-28 09:19:57', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(156, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-28 09:20:04', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(157, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-28 09:20:04', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(158, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-28 09:20:06', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(159, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-28 09:20:06', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(160, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-28 09:20:10', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(161, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.hu/nyito', '2019-05-28 09:20:10', '178.48.31.249', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(162, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 12:36:02', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(163, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 12:36:02', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(164, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/', '2019-05-28 12:36:02', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(165, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/', '2019-05-28 12:36:02', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36');
INSERT INTO `opey_visitors_404` (`id`, `vis_id`, `url`, `referrer_url`, `time`, `ip_address`, `browser`, `user_agent`) VALUES
(166, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 12:36:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(167, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 12:36:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(168, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-28 12:36:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(169, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 12:36:56', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(170, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 12:36:56', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(171, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 12:36:57', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(172, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 12:36:57', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(173, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 12:36:57', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(174, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 12:36:57', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(175, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 12:42:22', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(176, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 12:42:22', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(177, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 12:42:22', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(178, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 12:42:23', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(179, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 12:42:23', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(180, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 12:43:14', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(181, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 12:43:15', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(182, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 12:43:15', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(183, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 12:43:15', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(184, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 12:43:15', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(185, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-28 12:43:20', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(186, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 12:43:23', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(187, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 12:43:24', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(188, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 12:43:24', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(189, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 12:43:24', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(190, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 12:43:24', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(191, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 12:44:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(192, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 12:44:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(193, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/', '2019-05-28 12:44:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(194, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/', '2019-05-28 12:44:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(195, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-28 12:46:46', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(196, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-28 12:48:47', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(197, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-28 12:51:16', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(198, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 12:52:52', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(199, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 12:52:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(200, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 12:52:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(201, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 12:52:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(202, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-28 12:54:03', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(203, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 12:55:15', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(204, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 12:55:15', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(205, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 12:55:15', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(206, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 12:55:18', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(207, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 12:55:18', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(208, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 12:55:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(209, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 12:55:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(210, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 12:55:47', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(211, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 12:55:48', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(212, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/', '2019-05-28 12:55:48', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(213, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/', '2019-05-28 12:55:48', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(214, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 12:55:49', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(215, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 12:55:49', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(216, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 12:57:16', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(217, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 12:57:16', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(218, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 12:58:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(219, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 12:58:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(220, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 12:58:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(221, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 12:58:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(222, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 12:59:29', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(223, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 12:59:29', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(224, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 12:59:29', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(225, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:00:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(226, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/media/placeholder-images/logo.png', 'http://atlantisz.patronet.local/', '2019-05-28 13:00:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(227, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:00:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(228, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:00:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(229, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-28 13:01:10', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(230, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/media/placeholder-images/logo.png', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:01:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(231, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:01:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(232, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:01:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(233, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:01:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(234, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:04:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(235, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:04:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(236, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:04:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(237, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:04:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(238, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:04:24', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(239, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:04:24', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(240, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:04:24', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(241, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:04:24', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(242, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_header.gif', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:04:24', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(243, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:04:32', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(244, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:04:32', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(245, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:04:50', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(246, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:04:50', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(247, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:04:52', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(248, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_header.gif', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:04:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(249, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:04:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(250, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:05:03', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(251, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:05:03', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(252, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 13:05:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(253, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 13:05:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(254, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:05:07', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(255, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:05:07', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(256, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 13:05:10', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(257, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 13:05:10', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(258, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:05:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(259, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:05:35', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(260, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:11:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(261, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:11:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(262, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:11:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(263, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:11:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(264, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:11:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(265, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:11:38', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(266, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:11:38', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(267, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:11:38', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(268, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:11:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(269, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:11:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(270, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:11:57', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(271, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:11:57', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(272, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:11:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(273, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:11:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(274, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:11:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(275, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:13:01', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(276, 0, 'index.php?&_ORIGINAL_REQUEST=javascript/highslide/highslide/highslide.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:13:01', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(277, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:13:01', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(278, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:13:01', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(279, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:13:01', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(280, 0, 'index.php?&_ORIGINAL_REQUEST=javascript/highslide/highslide/highslide.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:13:01', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(281, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:13:01', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(282, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:13:01', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(283, 0, 'index.php?&_ORIGINAL_REQUEST=javascript/highslide/highslide/highslide.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:13:01', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(284, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:14:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(285, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:14:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(286, 0, 'index.php?&_ORIGINAL_REQUEST=_DEFAULTIMAGE', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:14:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(287, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:14:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(288, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:14:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(289, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:14:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(290, 0, 'index.php?&_ORIGINAL_REQUEST=_DEFAULTIMAGE', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:14:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(291, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:14:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(292, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:14:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(293, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:14:35', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(294, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:14:35', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(295, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:29:10', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(296, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:29:10', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(297, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:29:10', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(298, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:29:10', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(299, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:29:10', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(300, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:29:10', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(301, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:29:18', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(302, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:29:18', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(303, 0, 'index.php?&_ORIGINAL_REQUEST=_DEFAULTIMAGE', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:29:18', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(304, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:29:18', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(305, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:29:18', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(306, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:29:18', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(307, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:29:18', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(308, 0, 'index.php?&_ORIGINAL_REQUEST=_DEFAULTIMAGE', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:29:19', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(309, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:29:31', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(310, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:29:31', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(311, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:29:32', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(312, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:29:32', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(313, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:29:32', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(314, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:29:40', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(315, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:29:40', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(316, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:29:40', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(317, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:29:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(318, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:29:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(319, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:29:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(320, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:29:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(321, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:29:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(322, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:29:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(323, 0, 'index.php?&_ORIGINAL_REQUEST=javascript/highslide/highslide/highslide.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:29:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(324, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:29:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(325, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:29:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(326, 0, 'index.php?&_ORIGINAL_REQUEST=javascript/highslide/highslide/highslide.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:29:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(327, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:38:17', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(328, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:38:17', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(329, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:38:17', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(330, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:38:17', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(331, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:38:17', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(332, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:38:18', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36');
INSERT INTO `opey_visitors_404` (`id`, `vis_id`, `url`, `referrer_url`, `time`, `ip_address`, `browser`, `user_agent`) VALUES
(333, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:38:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(334, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:38:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(335, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:38:22', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(336, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:38:22', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(337, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:38:25', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(338, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:38:25', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(339, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:39:32', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(340, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:39:32', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(341, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/', '2019-05-28 13:39:32', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(342, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/', '2019-05-28 13:39:32', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(343, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:39:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(344, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:39:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(345, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:41:08', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(346, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:41:08', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(347, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:42:31', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(348, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:42:31', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(349, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:42:40', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(350, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:42:40', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(351, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:42:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(352, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:42:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(353, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:42:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(354, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:43:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(355, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:43:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(356, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:43:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(357, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:43:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(358, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:43:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(359, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:43:22', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(360, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:43:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(361, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:43:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(362, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:43:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(363, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:43:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(364, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:43:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(365, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:43:50', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(366, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:43:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(367, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:43:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(368, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:43:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(369, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:43:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(370, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:43:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(371, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:43:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(372, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:44:55', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(373, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:44:55', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(374, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:45:07', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(375, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:45:07', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(376, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:45:11', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(377, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:45:11', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(378, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:45:11', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(379, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:45:11', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(380, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:45:11', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(381, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-28 13:45:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(382, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:45:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(383, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:45:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(384, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:45:43', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(385, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:45:44', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(386, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:45:44', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(387, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:45:44', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(388, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:45:44', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(389, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:45:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(390, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:45:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(391, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:45:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(392, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:45:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(393, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:46:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(394, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:46:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(395, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:46:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(396, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:46:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(397, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:46:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(398, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:46:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(399, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:46:22', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(400, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:46:22', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(401, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:46:22', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(402, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:46:22', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(403, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:46:22', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(404, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:46:24', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(405, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:46:24', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(406, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:46:24', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(407, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:46:24', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(408, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:46:24', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(409, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:46:30', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(410, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:46:30', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(411, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:46:30', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(412, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:46:30', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(413, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:46:31', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(414, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:46:31', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(415, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:46:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(416, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:46:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(417, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:46:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(418, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:46:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(419, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:46:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(420, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:46:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(421, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:46:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(422, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:46:44', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(423, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:46:44', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(424, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:47:06', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(425, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:47:06', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(426, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:48:05', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(427, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:48:05', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(428, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:48:16', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(429, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:48:16', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(430, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:48:37', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(431, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:48:38', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(432, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:49:06', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(433, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:49:06', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(434, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:49:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(435, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:49:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(436, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:49:50', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(437, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:49:50', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(438, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:49:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(439, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:49:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(440, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:49:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(441, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:49:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(442, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:49:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(443, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:49:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(444, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:50:15', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(445, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:50:15', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(446, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:50:15', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(447, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:50:16', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(448, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:50:16', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(449, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:50:17', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(450, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:50:17', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(451, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:50:17', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(452, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:50:36', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(453, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:50:36', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(454, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:50:36', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(455, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:50:36', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(456, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:50:37', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(457, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:50:37', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(458, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:50:47', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(459, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:50:47', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(460, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:50:47', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(461, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:50:47', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(462, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:50:48', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(463, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:50:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(464, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:50:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(465, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:50:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(466, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:50:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(467, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:50:55', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(468, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:50:55', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(469, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:50:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(470, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:50:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(471, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:50:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(472, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:50:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(473, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:50:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(474, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:51:50', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(475, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:51:50', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(476, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:52:00', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(477, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:52:00', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(478, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:52:01', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(479, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:52:01', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(480, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:52:02', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(481, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:52:02', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(482, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/', '2019-05-28 13:52:02', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(483, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/', '2019-05-28 13:52:02', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(484, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:52:52', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(485, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:52:52', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(486, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:52:56', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(487, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:52:56', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(488, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:52:56', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(489, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:52:56', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(490, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:52:56', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(491, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:54:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(492, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:54:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(493, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:54:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(494, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:54:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(495, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:54:35', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(496, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:54:35', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(497, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:54:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(498, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:54:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(499, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:54:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(500, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:54:40', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36');
INSERT INTO `opey_visitors_404` (`id`, `vis_id`, `url`, `referrer_url`, `time`, `ip_address`, `browser`, `user_agent`) VALUES
(501, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 13:54:40', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(502, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:54:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(503, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:54:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(504, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:55:48', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(505, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 13:55:48', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(506, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 14:07:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(507, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 14:07:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(508, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 14:07:37', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(509, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 14:07:37', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(510, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 14:07:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(511, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 14:07:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(512, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:10:05', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(513, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:10:05', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(514, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:10:05', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(515, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:10:05', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(516, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:10:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(517, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 14:10:17', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(518, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 14:10:17', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(519, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 14:10:17', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(520, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 14:10:17', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(521, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 14:10:18', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(522, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:10:24', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(523, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:10:24', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(524, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:10:24', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(525, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:10:24', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(526, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:10:24', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(527, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:10:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(528, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:10:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(529, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:10:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(530, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:10:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(531, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:10:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(532, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:10:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(533, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:10:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(534, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:11:07', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(535, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:11:08', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(536, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:11:08', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(537, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:11:24', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(538, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:11:24', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(539, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:11:24', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(540, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:11:24', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(541, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/', '2019-05-28 14:14:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(542, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/', '2019-05-28 14:14:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(543, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:14:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(544, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:14:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(545, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:14:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(546, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:14:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(547, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:14:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(548, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:15:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(549, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:15:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(550, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:15:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(551, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:15:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(552, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:15:10', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(553, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:15:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(554, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:15:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(555, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:15:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(556, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:15:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(557, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:15:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(558, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:15:18', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(559, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:15:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(560, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:15:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(561, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:15:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(562, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:15:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(563, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:15:45', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(564, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:15:45', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(565, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:15:45', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(566, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:15:45', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(567, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:15:45', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(568, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:15:48', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(569, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:15:48', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(570, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:15:49', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(571, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:15:49', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(572, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:15:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(573, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:15:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(574, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:15:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(575, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:15:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(576, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:16:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(577, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:16:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(578, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:16:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(579, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:16:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(580, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:16:43', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(581, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:16:43', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(582, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:16:43', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(583, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:16:44', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(584, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:16:44', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(585, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:16:47', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(586, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:16:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(587, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:16:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(588, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:16:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(589, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:17:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(590, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:19:22', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(591, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:19:22', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(592, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:19:22', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(593, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:19:22', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(594, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:19:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(595, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:32:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(596, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:32:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(597, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:32:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(598, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:32:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(599, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:32:47', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(600, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:34:00', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(601, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:34:01', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(602, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:34:01', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(603, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:34:01', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(604, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:34:01', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(605, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:34:01', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(606, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:34:01', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(607, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:34:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(608, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:34:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(609, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:34:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(610, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:34:05', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(611, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:34:07', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(612, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:34:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(613, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:34:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(614, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:34:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(615, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:34:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(616, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:34:22', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(617, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:34:22', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(618, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:34:22', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(619, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:34:22', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(620, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:34:23', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(621, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:34:26', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(622, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:35:08', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(623, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:35:08', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(624, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:35:08', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(625, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:35:08', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(626, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:35:08', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(627, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:35:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(628, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:35:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(629, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:35:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(630, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:35:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(631, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:35:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(632, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:35:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(633, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/jquery-3.4.1.slim.min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:35:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(634, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:35:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(635, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/style.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:35:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(636, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/style/bootstrap.min.css', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:35:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(637, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/jquery-3.4.1.slim.min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:35:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(638, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:35:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(639, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:35:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(640, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:35:55', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(641, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:35:55', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(642, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:35:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(643, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js', 'http://atlantisz.patronet.local/teszt', '2019-05-28 14:35:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(644, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 14:36:50', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(645, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/', '2019-05-28 14:40:10', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(646, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/', '2019-05-28 14:40:10', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(647, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 14:40:14', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(648, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 14:41:17', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(649, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 14:41:36', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(650, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 14:41:40', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(651, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 14:41:49', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(652, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 14:41:52', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(653, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 14:41:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(654, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 14:44:06', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(655, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 14:44:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(656, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 14:47:40', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(657, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=0&keret=N', '2019-05-28 14:48:11', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(658, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=0&keret=N', '2019-05-28 14:48:11', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36');
INSERT INTO `opey_visitors_404` (`id`, `vis_id`, `url`, `referrer_url`, `time`, `ip_address`, `browser`, `user_agent`) VALUES
(659, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=0&keret=N', '2019-05-28 14:48:11', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(660, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=0&keret=N', '2019-05-28 14:48:11', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(661, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=0&keret=N', '2019-05-28 14:48:11', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(662, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-28 14:48:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(663, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-28 14:48:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(664, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-28 14:48:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(665, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-28 14:48:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(666, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 14:48:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(667, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-28 14:48:16', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(668, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-28 14:48:16', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(669, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-28 14:48:17', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(670, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-28 14:48:17', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(671, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 14:48:17', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(672, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-28 14:48:45', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(673, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-28 14:48:45', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(674, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-28 14:48:46', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(675, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 14:48:46', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(676, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-28 14:48:46', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(677, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/admin.php?module=MiniCatalog&op=block_preview&id=', '2019-05-28 14:49:30', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(678, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/admin.php?module=MiniCatalog&op=block_preview&id=', '2019-05-28 14:49:31', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(679, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/admin.php?module=MiniCatalog&op=block_preview&id=', '2019-05-28 14:49:31', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(680, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/admin/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?module=MiniCatalog&op=main', '2019-05-28 14:49:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(681, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-28 14:50:50', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(682, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-28 14:50:50', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(683, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-28 14:50:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(684, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-28 14:50:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(685, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 14:50:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(686, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/admin/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?module=MiniCatalog&op=main', '2019-05-28 14:52:37', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(687, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/admin.php?module=MiniCatalog&op=block_preview&id=0', '2019-05-28 14:52:43', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(688, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/admin.php?module=MiniCatalog&op=block_preview&id=0', '2019-05-28 14:52:43', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(689, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/admin.php?module=MiniCatalog&op=block_preview&id=0', '2019-05-28 14:52:43', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(690, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/admin.php?module=MiniCatalog&op=block_preview&id=0', '2019-05-28 14:52:43', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(691, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/admin.php?module=MiniCatalog&op=block_preview&id=0', '2019-05-28 14:52:43', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(692, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-28 14:53:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(693, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-28 14:55:31', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(694, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-28 14:56:35', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(695, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-28 14:56:35', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(696, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-28 14:56:36', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(697, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 14:56:36', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(698, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-28 14:56:36', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(699, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-28 14:56:49', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(700, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-28 14:56:49', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(701, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 14:56:50', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(702, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-28 14:56:50', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(703, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-28 14:56:50', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(704, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-28 14:58:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(705, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-28 14:58:31', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(706, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-28 14:58:31', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(707, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-28 14:58:31', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(708, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-28 14:58:31', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(709, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 14:58:31', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(710, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 15:03:36', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(711, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 15:03:55', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(712, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 15:03:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(713, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-28 15:03:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(714, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 15:03:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(715, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-28 15:03:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(716, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 15:04:03', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(717, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 15:04:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(718, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=0&keret=N', '2019-05-28 15:04:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(719, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=0&keret=N', '2019-05-28 15:04:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(720, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=0&keret=N', '2019-05-28 15:04:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(721, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=0&keret=N', '2019-05-28 15:04:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(722, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:04:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(723, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:04:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(724, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:04:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(725, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:04:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(726, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:04:35', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(727, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:04:35', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(728, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 15:04:35', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(729, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-28 15:04:38', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(730, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-28 15:04:38', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(731, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-28 15:04:38', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(732, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 15:04:38', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(733, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-28 15:04:38', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(734, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-28 15:04:44', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(735, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-28 15:04:44', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(736, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 15:04:45', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(737, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-28 15:04:45', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(738, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-28 15:04:45', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(739, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 15:04:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(740, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 15:04:52', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(741, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_footer-primary.gif', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:04:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(742, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 15:04:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(743, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 15:05:08', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(744, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:06:06', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(745, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:06:07', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(746, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:06:07', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(747, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:06:07', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(748, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:06:07', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(749, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:06:07', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(750, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 15:06:07', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(751, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:06:07', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(752, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-28 15:06:20', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(753, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:06:22', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(754, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:06:22', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(755, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:06:22', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(756, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:06:22', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(757, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:06:22', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(758, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:06:22', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(759, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 15:06:23', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(760, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:06:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(761, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:06:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(762, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:06:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(763, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:06:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(764, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:06:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(765, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:06:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(766, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:06:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(767, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:06:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(768, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:06:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(769, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:06:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(770, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:06:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(771, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:06:40', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(772, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 15:06:40', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(773, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-28 15:06:44', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(774, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:06:50', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(775, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:06:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(776, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:06:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(777, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:06:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(778, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:06:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(779, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:06:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(780, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 15:06:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(781, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:06:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(782, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:06:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(783, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:06:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(784, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:06:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(785, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:06:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(786, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:06:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(787, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:06:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(788, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:07:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(789, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:07:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(790, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:07:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(791, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:07:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(792, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:07:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(793, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:07:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(794, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:07:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(795, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 15:07:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(796, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:07:48', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(797, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:07:49', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(798, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:07:49', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(799, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:07:49', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(800, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:07:49', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(801, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:07:49', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(802, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:08:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(803, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:08:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(804, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:08:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(805, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:08:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(806, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:08:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(807, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:08:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(808, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-28 15:08:36', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(809, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:08:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(810, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:08:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(811, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:08:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(812, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:08:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(813, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:08:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(814, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:08:40', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(815, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:08:40', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(816, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 15:08:40', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(817, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:08:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(818, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 15:08:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(819, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:09:55', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(820, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:10:31', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(821, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:10:31', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(822, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:10:31', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(823, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:10:31', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(824, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:10:31', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(825, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:10:32', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(826, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 15:10:32', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(827, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:10:32', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(828, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:11:48', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(829, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:11:48', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(830, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:11:48', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(831, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:11:49', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(832, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:11:49', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(833, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:11:49', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(834, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:11:52', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(835, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:11:52', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(836, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:11:52', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(837, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:11:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(838, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:11:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(839, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:11:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(840, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:12:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36');
INSERT INTO `opey_visitors_404` (`id`, `vis_id`, `url`, `referrer_url`, `time`, `ip_address`, `browser`, `user_agent`) VALUES
(841, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:12:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(842, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:12:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(843, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:12:15', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(844, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:12:15', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(845, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:12:15', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(846, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:12:15', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(847, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:12:16', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(848, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:12:16', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(849, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:12:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(850, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:12:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(851, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:12:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(852, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-28 15:12:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(853, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:12:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(854, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:12:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(855, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:12:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(856, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:12:49', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(857, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:12:49', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(858, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:12:49', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(859, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:12:49', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(860, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:12:49', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(861, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:12:49', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(862, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:22:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(863, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:22:29', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(864, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:22:29', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(865, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:22:29', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(866, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:22:29', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(867, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-28 15:22:44', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(868, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:22:46', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(869, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:22:46', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(870, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:22:47', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(871, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:22:47', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(872, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:22:47', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(873, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:22:47', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(874, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:23:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(875, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:23:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(876, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:23:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(877, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:24:32', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(878, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 15:24:32', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(879, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-28 15:29:38', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(880, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:29:40', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(881, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:29:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(882, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:29:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(883, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:29:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(884, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:29:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(885, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:29:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(886, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:30:57', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(887, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:30:57', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(888, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:30:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(889, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:30:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(890, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:30:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(891, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:30:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(892, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:30:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(893, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:30:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(894, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-28 15:34:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(895, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:34:30', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(896, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:34:30', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(897, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:34:30', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(898, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:34:30', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(899, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:34:30', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(900, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:34:30', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(901, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:34:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(902, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 15:34:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(903, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:35:22', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(904, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:35:22', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(905, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:35:22', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(906, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:35:23', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(907, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:35:23', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(908, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:35:23', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(909, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 15:35:23', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(910, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:35:23', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(911, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:36:24', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(912, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:36:24', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(913, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:36:24', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(914, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:36:25', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(915, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:36:25', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(916, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 15:36:25', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(917, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:39:11', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(918, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:39:11', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(919, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:39:11', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(920, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:39:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(921, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:39:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(922, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 15:39:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(923, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:39:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(924, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:39:56', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(925, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:39:56', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(926, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:39:57', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(927, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:39:57', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(928, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:39:57', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(929, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:39:57', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(930, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 15:39:57', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(931, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:39:57', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(932, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:40:07', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(933, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:40:07', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(934, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:40:08', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(935, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:40:08', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(936, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:40:08', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(937, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:40:08', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(938, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 15:40:08', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(939, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:40:08', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(940, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:40:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(941, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:40:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(942, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:40:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(943, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:40:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(944, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:40:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(945, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:40:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(946, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 15:40:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(947, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:40:14', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(948, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:40:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(949, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:40:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(950, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:40:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(951, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:40:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(952, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:40:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(953, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:40:29', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(954, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 15:40:29', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(955, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:40:29', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(956, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:40:37', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(957, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:40:37', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(958, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:40:38', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(959, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:40:38', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(960, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:40:38', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(961, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:40:38', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(962, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 15:40:38', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(963, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:40:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(964, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:41:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(965, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:41:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(966, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:41:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(967, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:41:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(968, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:41:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(969, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:41:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(970, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:41:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(971, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-28 15:41:16', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(972, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:41:18', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(973, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:41:18', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(974, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:41:18', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(975, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:41:19', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(976, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:41:19', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(977, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:41:19', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(978, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:41:46', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(979, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 15:41:46', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(980, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:41:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(981, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 15:41:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(982, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:42:19', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(983, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:42:20', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(984, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:42:20', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(985, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:42:20', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(986, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:42:20', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(987, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:42:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(988, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 15:42:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(989, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:42:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(990, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:42:44', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(991, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:42:44', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(992, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:42:45', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(993, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:42:45', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(994, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:42:45', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(995, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:42:45', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(996, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 15:42:45', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(997, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:42:45', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(998, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-28 15:46:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(999, 0, 'index.php?&_ORIGINAL_REQUEST=referenciak', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-28 15:47:31', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1000, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/referenciak', '2019-05-28 15:47:31', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1001, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/referenciak', '2019-05-28 15:47:31', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1002, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/referenciak', '2019-05-28 15:47:32', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1003, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/referenciak', '2019-05-28 15:47:32', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1004, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/referenciak', '2019-05-28 15:47:32', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1005, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:47:38', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1006, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:47:38', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1007, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:47:38', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1008, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:49:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1009, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:49:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1010, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:49:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1011, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:49:10', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1012, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-28 15:51:20', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1013, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:51:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1014, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:51:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1015, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:51:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1016, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:51:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1017, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 15:51:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1018, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 15:51:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1019, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 15:51:24', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1020, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 15:51:24', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1021, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:53:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1022, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:53:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1023, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:53:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1024, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:53:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1025, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:53:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1026, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:53:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1027, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-28 15:53:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1028, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:54:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1029, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:54:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36');
INSERT INTO `opey_visitors_404` (`id`, `vis_id`, `url`, `referrer_url`, `time`, `ip_address`, `browser`, `user_agent`) VALUES
(1030, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:54:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1031, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:54:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1032, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:54:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1033, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-28 15:54:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1034, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-28 15:54:25', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1035, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 16:01:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1036, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-28 16:01:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1037, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-28 16:01:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1038, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 16:01:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1039, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-28 16:01:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1040, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-28 16:01:40', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1041, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 16:01:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1042, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 16:01:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1043, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 16:01:43', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1044, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 16:01:43', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1045, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 16:01:43', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1046, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 16:01:43', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1047, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 16:02:10', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1048, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 16:02:10', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1049, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 16:02:10', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1050, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 16:02:11', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1051, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 16:02:11', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1052, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 16:02:11', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1053, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 16:02:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1054, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 16:02:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1055, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 16:02:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1056, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 16:02:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1057, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 16:02:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1058, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 16:02:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1059, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 16:02:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1060, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 16:02:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1061, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 16:05:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1062, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 16:11:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1063, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 16:11:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1064, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 16:11:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1065, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 16:11:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1066, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 16:11:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1067, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 16:11:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1068, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 16:11:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1069, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 16:11:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1070, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 16:13:20', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1071, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 16:13:20', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1072, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 16:13:20', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1073, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 16:13:20', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1074, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 16:13:20', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1075, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 16:13:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1076, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1398&keret=N', '2019-05-28 16:13:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1077, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1398&keret=N', '2019-05-28 16:13:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1078, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1398&keret=N', '2019-05-28 16:13:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1079, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 16:13:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1080, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-28 16:13:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1081, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 16:13:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1082, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-28 16:13:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1083, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-28 16:13:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1084, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 16:13:49', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1085, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 16:13:49', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1086, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1398&keret=N', '2019-05-28 16:14:11', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1087, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1398&keret=N', '2019-05-28 16:14:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1088, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1398&keret=N', '2019-05-28 16:14:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1089, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1398&keret=N', '2019-05-28 16:14:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1090, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 16:14:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1091, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-28 16:14:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1092, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-28 16:14:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1093, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 16:14:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1094, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-28 16:14:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1095, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-28 16:14:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1096, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 16:14:17', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1097, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 16:14:17', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1098, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 16:14:17', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1099, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 16:14:18', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1100, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 16:14:18', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1101, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 16:14:18', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1102, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 16:14:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1103, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 16:14:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1104, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 16:15:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1105, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 16:15:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1106, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 16:15:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1107, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 16:15:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1108, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 16:15:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1109, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 16:15:05', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1110, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 16:15:05', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1111, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-28 16:15:07', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1112, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1398&keret=N', '2019-05-28 16:15:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1113, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1398&keret=N', '2019-05-28 16:15:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1114, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1398&keret=N', '2019-05-28 16:15:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1115, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1398&keret=N', '2019-05-28 16:15:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1116, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-28 16:15:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1117, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-28 16:15:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1118, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-28 16:15:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1119, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 16:15:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1120, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 16:15:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1121, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 16:15:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1122, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/', '2019-05-28 16:15:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1123, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/', '2019-05-28 16:15:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1124, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/', '2019-05-28 16:15:40', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1125, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/', '2019-05-29 09:29:11', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1126, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/', '2019-05-29 09:29:11', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1127, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 09:29:26', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1128, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_header.gif', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:31:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1129, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_header.gif', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:32:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1130, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:32:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1131, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:32:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1132, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:32:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1133, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:32:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1134, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:32:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1135, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:32:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1136, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:32:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1137, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 09:33:16', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1138, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:33:18', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1139, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:33:19', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1140, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:33:19', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1141, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:33:19', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1142, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:33:19', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1143, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:33:19', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1144, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/', '2019-05-29 09:33:31', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1145, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/', '2019-05-29 09:33:31', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1146, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 09:36:26', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1147, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:36:29', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1148, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/customlayout/modules/atlantisz/images/800px-Toshiba_logo.svg', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:36:29', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1149, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:36:29', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1150, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:36:29', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1151, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:36:29', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1152, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:36:29', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1153, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:36:29', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1154, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:36:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1155, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:36:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1156, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/customlayout/modules/atlantisz/images/800px-Toshiba_logo.svg', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:36:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1157, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:36:35', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1158, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 09:36:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1159, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/customlayout/modules/atlantisz/images/800px-Toshiba_logo.svg', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-29 09:36:57', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1160, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/customlayout/modules/atlantisz/images/800px-Toshiba_logo.svg', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:36:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1161, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:36:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1162, 0, 'index.php?&_ORIGINAL_REQUEST=style.css', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:36:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1163, 0, 'index.php?&_ORIGINAL_REQUEST=aplusz.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:36:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1164, 0, 'index.php?&_ORIGINAL_REQUEST=prod.jpg', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:36:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1165, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/customlayout/modules/atlantisz/images/800px-Toshiba_logo.svg', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:37:01', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1166, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/customlayout/modules/atlantisz/images/800px-Toshiba_logo.svg', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:37:05', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1167, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/customlayout/modules/atlantisz/images/800px-Toshiba_logo.svg', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:37:08', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1168, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_header.gif', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:37:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1169, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/customlayout/modules/atlantisz/images/800px-Toshiba_logo.svg', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:37:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1170, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/customlayout/modules/atlantisz/images/800px-Toshiba_logo.svg', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:37:16', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1171, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/customlayout/modules/atlantisz/images/800px-Toshiba_logo.svg', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:37:17', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1172, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/customlayout/modules/atlantisz/images/800px-Toshiba_logo.svg', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:37:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1173, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 09:37:36', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1174, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/customlayout/modules/atlantisz/images/800px-Toshiba_logo.svg', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:37:38', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1175, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/customlayout/modules/atlantisz/images/800px-Toshiba_logo.svg', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:37:40', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1176, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/customlayout/modules/atlantisz/images/800px-Toshiba_logo.svg', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:37:55', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1177, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/customlayout/modules/atlantisz/images/800px-Toshiba_logo.svg', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-29 09:37:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1178, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/customlayout/modules/atlantisz/images/800px-Toshiba_logo.svg', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:38:02', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1179, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/customlayout/modules/atlantisz/images/800px-Toshiba_logo.svg', 'http://atlantisz.patronet.local/', '2019-05-29 09:38:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1180, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow2', '2019-05-29 09:39:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1181, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 09:42:47', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1182, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/customlayout/modules/atlantisz/images/800px-Toshiba_logo.svg', 'http://atlantisz.patronet.local/', '2019-05-29 09:42:48', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1183, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 09:42:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1184, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 09:43:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1185, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 09:43:23', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1186, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/customlayout/modules/atlantisz/images/800px-Toshiba_logo.svg', 'http://atlantisz.patronet.local/', '2019-05-29 09:43:25', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1187, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/customlayout/modules/atlantisz/images/800px-Toshiba_logo.svg', 'http://atlantisz.patronet.local/', '2019-05-29 09:43:52', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1188, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/customlayout/modules/atlantisz/images/800px-Toshiba_logo.svg', 'http://atlantisz.patronet.local/', '2019-05-29 09:43:57', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1189, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 09:44:03', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1190, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/customlayout/modules/atlantisz/images/800px-Toshiba_logo.svg', 'http://atlantisz.patronet.local/', '2019-05-29 09:44:49', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1191, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 09:44:49', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1192, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=0&keret=N', '2019-05-29 09:46:03', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1193, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=0&keret=N', '2019-05-29 09:46:03', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1194, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=0&keret=N', '2019-05-29 09:46:03', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1195, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=0&keret=N', '2019-05-29 09:46:03', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1196, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_header.gif', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:46:17', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1197, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_footer-primary.gif', 'http://atlantisz.patronet.local/nyito', '2019-05-29 09:46:24', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1198, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1401&keret=N', '2019-05-29 10:03:30', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1199, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1401&keret=N', '2019-05-29 10:03:30', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1200, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1401&keret=N', '2019-05-29 10:03:30', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1201, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 10:03:52', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36');
INSERT INTO `opey_visitors_404` (`id`, `vis_id`, `url`, `referrer_url`, `time`, `ip_address`, `browser`, `user_agent`) VALUES
(1202, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/', '2019-05-29 10:03:52', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1203, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/', '2019-05-29 10:03:52', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1204, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:03:55', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1205, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1401&keret=N', '2019-05-29 10:04:11', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1206, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1401&keret=N', '2019-05-29 10:04:11', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1207, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1401&keret=N', '2019-05-29 10:04:11', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1208, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1401&keret=N', '2019-05-29 10:04:11', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1209, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1401&keret=N', '2019-05-29 10:04:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1210, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:04:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1211, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 10:04:29', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1212, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/', '2019-05-29 10:04:35', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1213, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/', '2019-05-29 10:04:35', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1214, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:04:37', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1215, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1401&keret=N', '2019-05-29 10:04:52', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1216, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1401&keret=N', '2019-05-29 10:04:52', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1217, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1401&keret=N', '2019-05-29 10:04:52', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1218, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1401&keret=N', '2019-05-29 10:04:52', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1219, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:04:56', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1220, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:05:02', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1221, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:07:31', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1222, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/', '2019-05-29 10:07:46', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1223, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/', '2019-05-29 10:07:46', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1224, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:07:46', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1225, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/', '2019-05-29 10:08:15', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1226, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:08:15', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1227, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/', '2019-05-29 10:08:15', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1228, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 10:08:25', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1229, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/', '2019-05-29 10:08:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1230, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/', '2019-05-29 10:08:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1231, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:08:36', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1232, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:09:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1233, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/', '2019-05-29 10:09:10', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1234, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/', '2019-05-29 10:09:10', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1235, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:09:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1236, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:10:07', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1237, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:10:07', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1238, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:10:07', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1239, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:10:26', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1240, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:10:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1241, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 10:11:00', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1242, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:11:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1243, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:11:10', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1244, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:11:18', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1245, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/', '2019-05-29 10:11:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1246, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:11:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1247, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/', '2019-05-29 10:11:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1248, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/', '2019-05-29 10:11:23', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1249, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:11:23', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1250, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/', '2019-05-29 10:11:23', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1251, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:11:23', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1252, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/', '2019-05-29 10:11:23', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1253, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:11:52', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1254, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/', '2019-05-29 10:11:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1255, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:11:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1256, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/', '2019-05-29 10:11:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1257, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/', '2019-05-29 10:11:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1258, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:11:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1259, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/', '2019-05-29 10:11:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1260, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:11:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1261, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:11:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1262, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/', '2019-05-29 10:11:55', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1263, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/', '2019-05-29 10:11:55', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1264, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 10:12:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1265, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_header.gif', 'http://atlantisz.patronet.local/nyito', '2019-05-29 10:12:14', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1266, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:14:20', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1267, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/', '2019-05-29 10:14:26', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1268, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/', '2019-05-29 10:14:26', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1269, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:14:26', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1270, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/', '2019-05-29 10:14:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1271, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/', '2019-05-29 10:14:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1272, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:14:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1273, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/', '2019-05-29 10:14:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1274, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:14:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1275, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:14:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1276, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/', '2019-05-29 10:14:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1277, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:14:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1278, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/', '2019-05-29 10:14:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1279, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/', '2019-05-29 10:14:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1280, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/', '2019-05-29 10:14:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1281, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 10:14:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1282, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:14:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1283, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:14:46', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1284, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:14:47', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1285, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:14:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1286, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:14:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1287, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:15:37', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1288, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:15:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1289, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_footer-secondary.gif', 'http://atlantisz.patronet.local/nyito', '2019-05-29 10:15:46', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1290, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:15:47', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1291, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:16:08', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1292, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 10:21:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1293, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 10:21:56', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1294, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:22:07', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1295, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 10:23:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1296, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:23:15', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1297, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 10:23:15', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1298, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 10:23:15', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1299, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:23:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1300, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_footer-secondary.gif', 'http://atlantisz.patronet.local/nyito', '2019-05-29 10:23:24', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1301, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:23:24', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1302, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 10:24:48', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1303, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_footer-secondary.gif', 'http://atlantisz.patronet.local/nyito', '2019-05-29 10:24:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1304, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:24:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1305, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 10:25:38', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1306, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_footer-secondary.gif', 'http://atlantisz.patronet.local/nyito', '2019-05-29 10:25:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1307, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:25:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1308, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:25:47', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1309, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_footer-secondary.gif', 'http://atlantisz.patronet.local/nyito', '2019-05-29 10:25:52', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1310, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:25:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1311, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 10:26:43', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1312, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_footer-secondary.gif', 'http://atlantisz.patronet.local/nyito', '2019-05-29 10:26:45', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1313, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:26:46', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1314, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:26:49', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1315, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_footer-secondary.gif', 'http://atlantisz.patronet.local/nyito', '2019-05-29 10:26:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1316, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:26:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1317, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:27:26', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1318, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 10:28:11', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1319, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:28:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1320, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 10:28:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1321, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 10:28:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1322, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_footer-secondary.gif', 'http://atlantisz.patronet.local/nyito', '2019-05-29 10:28:16', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1323, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:28:16', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1324, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:28:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1325, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_footer-secondary.gif', 'http://atlantisz.patronet.local/nyito', '2019-05-29 10:28:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1326, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:28:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1327, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:28:44', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1328, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:28:50', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1329, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 10:29:18', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1330, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:29:20', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1331, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_footer-primary.gif', 'http://atlantisz.patronet.local/nyito', '2019-05-29 10:29:23', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1332, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:29:24', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1333, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:29:44', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1334, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:29:46', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1335, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 10:31:05', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1336, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:31:07', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1337, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:31:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1338, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:31:29', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1339, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:31:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1340, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 10:32:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1341, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:32:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1342, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:32:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1343, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:32:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1344, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:32:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1345, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:32:36', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1346, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 10:33:18', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1347, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:33:19', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1348, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:33:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1349, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:34:37', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1350, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 10:35:22', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1351, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:35:23', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1352, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:38:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1353, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:39:08', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1354, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:39:17', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1355, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:39:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1356, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:39:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1357, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:40:48', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1358, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:40:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1359, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 10:41:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1360, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:41:06', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1361, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:41:11', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1362, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 10:51:01', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1363, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:51:06', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1364, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:51:06', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1365, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:54:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1366, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:56:17', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1367, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 10:58:08', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1368, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 10:58:08', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36');
INSERT INTO `opey_visitors_404` (`id`, `vis_id`, `url`, `referrer_url`, `time`, `ip_address`, `browser`, `user_agent`) VALUES
(1369, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:58:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1370, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:58:36', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1371, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:59:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1372, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:59:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1373, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:59:40', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1374, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 10:59:44', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1375, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 11:00:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1376, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 11:01:46', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1377, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 11:05:26', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1378, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 11:07:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1379, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 11:08:43', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1380, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 11:09:29', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1381, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 11:09:30', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1382, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 11:09:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1383, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 11:13:03', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1384, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 11:17:06', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1385, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 11:19:49', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1386, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_footer-secondary.gif', 'http://atlantisz.patronet.local/nyito', '2019-05-29 11:19:56', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1387, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=0&keret=N', '2019-05-29 11:22:20', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1388, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=0&keret=N', '2019-05-29 11:22:20', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1389, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=0&keret=N', '2019-05-29 11:22:20', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1390, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_footer-secondary.gif', 'http://atlantisz.patronet.local/nyito', '2019-05-29 11:22:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1391, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 11:23:19', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1392, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 11:23:19', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1393, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 11:23:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1394, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 11:23:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1395, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 11:23:22', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1396, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 11:23:22', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1397, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_footer-secondary.gif', 'http://atlantisz.patronet.local/nyito', '2019-05-29 11:25:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1398, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1130&keret=N', '2019-05-29 11:25:25', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1399, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1130&keret=N', '2019-05-29 11:25:25', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1400, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1130&keret=N', '2019-05-29 11:25:25', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1401, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1130&keret=N', '2019-05-29 11:25:25', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1402, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1130&keret=N', '2019-05-29 11:25:26', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1403, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_footer-secondary.gif', 'http://atlantisz.patronet.local/nyito', '2019-05-29 11:25:26', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1404, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_footer-secondary.gif', 'http://atlantisz.patronet.local/nyito', '2019-05-29 11:26:08', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1405, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1130&keret=N', '2019-05-29 11:26:15', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1406, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1130&keret=N', '2019-05-29 11:26:15', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1407, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1130&keret=N', '2019-05-29 11:26:15', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1408, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1130&keret=N', '2019-05-29 11:26:15', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1409, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_footer-secondary.gif', 'http://atlantisz.patronet.local/nyito', '2019-05-29 11:26:15', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1410, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_footer-secondary.gif', 'http://atlantisz.patronet.local/nyito', '2019-05-29 11:29:23', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1411, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1130&keret=N', '2019-05-29 11:29:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1412, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1130&keret=N', '2019-05-29 11:29:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1413, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1130&keret=N', '2019-05-29 11:29:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1414, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1130&keret=N', '2019-05-29 11:29:29', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1415, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1130&keret=N', '2019-05-29 11:29:29', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1416, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_footer-secondary.gif', 'http://atlantisz.patronet.local/nyito', '2019-05-29 11:29:30', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1417, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_footer-secondary.gif', 'http://atlantisz.patronet.local/nyito', '2019-05-29 11:30:08', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1418, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1130&keret=N', '2019-05-29 11:30:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1419, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1130&keret=N', '2019-05-29 11:30:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1420, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1130&keret=N', '2019-05-29 11:30:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1421, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/admin.php?module=OE-ObjectEditor&op=new_freehtml&id=1130&keret=N', '2019-05-29 11:30:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1422, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_footer-secondary.gif', 'http://atlantisz.patronet.local/nyito', '2019-05-29 11:30:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1423, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 11:30:47', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1424, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 11:32:06', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1425, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 11:33:57', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1426, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 11:37:20', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1427, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 11:37:20', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1428, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 11:37:22', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1429, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 11:37:22', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1430, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 11:37:24', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1431, 0, 'index.php?&_ORIGINAL_REQUEST=style/style.css', 'bookmark', '2019-05-29 11:37:38', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1432, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/style/style.css', '2019-05-29 11:37:38', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1433, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/style/style.css', '2019-05-29 11:37:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1434, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/style/style.css', '2019-05-29 11:37:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1435, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/style/style.css', '2019-05-29 11:37:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1436, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/style/style.css', '2019-05-29 11:37:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1437, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/style/style.css', '2019-05-29 11:37:44', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1438, 0, 'index.php?&_ORIGINAL_REQUEST=style/style.css', 'bookmark', '2019-05-29 11:38:06', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1439, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/style/style.css', '2019-05-29 11:38:06', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1440, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/style/style.css', '2019-05-29 11:38:07', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1441, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/style/style.css', '2019-05-29 11:38:07', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1442, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/style/style.css', '2019-05-29 11:38:07', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1443, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/style/style.css', '2019-05-29 11:38:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1444, 0, 'index.php?&_ORIGINAL_REQUEST=atlantisz.patronet.local/style/style.css', 'bookmark', '2019-05-29 11:39:06', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1445, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/atlantisz.patronet.local/style/style.css', '2019-05-29 11:39:06', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1446, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/atlantisz.patronet.local/style/style.css', '2019-05-29 11:39:06', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1447, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/atlantisz.patronet.local/style/style.css', '2019-05-29 11:39:06', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1448, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/atlantisz.patronet.local/style/style.css', '2019-05-29 11:39:11', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1449, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 11:39:22', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1450, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 11:39:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1451, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 11:39:47', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1452, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 11:40:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1453, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 11:40:14', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1454, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_header.gif', 'http://atlantisz.patronet.local/nyito', '2019-05-29 11:42:57', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1455, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 11:43:48', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1456, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 11:44:56', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1457, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow4', '2019-05-29 11:47:07', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1458, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 11:48:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1459, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_header.gif', 'http://atlantisz.patronet.local/nyito', '2019-05-29 11:48:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1460, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 11:48:22', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1461, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 11:48:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1462, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 11:49:20', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1463, 0, 'index.php?&_ORIGINAL_REQUEST=rolunk', 'http://atlantisz.patronet.local/', '2019-05-29 11:49:55', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1464, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/rolunk', '2019-05-29 11:49:55', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1465, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/css/skitter.styles.css', 'http://atlantisz.patronet.local/rolunk', '2019-05-29 11:49:55', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1466, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/rolunk', '2019-05-29 11:49:55', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1467, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/demo.patronet/modules/Slider/misc/skitter_slideshow/js/jquery.skitter.pn.js', 'http://atlantisz.patronet.local/rolunk', '2019-05-29 11:49:55', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1468, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/netpanel/design2012/javascript/selectivizr-min.js', 'http://atlantisz.patronet.local/rolunk', '2019-05-29 11:49:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1469, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 11:50:00', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1470, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 11:53:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1471, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 11:56:44', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1472, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 11:56:49', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1473, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 11:57:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1474, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 12:03:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1475, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 12:09:00', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1476, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 12:09:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1477, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 12:10:00', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1478, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 12:10:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1479, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 12:10:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1480, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow2', '2019-05-29 12:12:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1481, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 12:17:14', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1482, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 12:17:17', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1483, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 12:18:16', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1484, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 12:19:14', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1485, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 12:19:31', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1486, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 12:19:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1487, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 12:19:43', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1488, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 12:19:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1489, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 12:19:56', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1490, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 12:20:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1491, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 12:20:36', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1492, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 12:23:25', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1493, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 12:23:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1494, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 12:23:45', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1495, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 12:23:48', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1496, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 12:24:14', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1497, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 12:24:17', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1498, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 12:24:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1499, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 12:24:24', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1500, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 12:24:37', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1501, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 12:24:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1502, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 12:26:52', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1503, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 12:26:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1504, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 12:27:08', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1505, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 12:27:10', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1506, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 12:28:02', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1507, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 12:28:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1508, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow2', '2019-05-29 12:29:16', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1509, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 12:29:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1510, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 12:29:35', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1511, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 12:29:47', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1512, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 12:29:49', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1513, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 12:30:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1514, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 12:30:14', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1515, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 12:30:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1516, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 12:30:30', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1517, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 12:30:45', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36');
INSERT INTO `opey_visitors_404` (`id`, `vis_id`, `url`, `referrer_url`, `time`, `ip_address`, `browser`, `user_agent`) VALUES
(1518, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 12:30:47', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1519, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 12:31:19', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1520, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 12:31:20', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1521, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 12:31:31', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1522, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 12:31:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1523, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 12:32:02', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1524, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 12:32:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1525, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 12:32:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1526, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 12:32:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1527, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 12:33:00', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1528, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 12:33:02', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1529, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 12:33:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1530, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 12:33:15', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1531, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 12:33:25', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1532, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 12:33:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1533, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 12:39:37', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1534, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 12:39:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1535, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 12:41:57', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1536, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 12:41:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1537, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 12:46:46', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1538, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 12:46:48', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1539, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/folderClosed.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 12:46:55', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1540, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 12:46:56', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1541, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 12:47:46', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1542, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 12:47:48', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1543, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 12:48:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1544, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 12:49:00', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1545, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow6', '2019-05-29 12:49:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1546, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow7', '2019-05-29 12:49:30', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1547, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow7', '2019-05-29 13:15:05', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1548, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow7', '2019-05-29 13:15:11', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1549, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/folderClosed.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow7', '2019-05-29 13:15:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1550, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow7', '2019-05-29 13:15:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1551, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/folderClosed.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow7', '2019-05-29 13:15:22', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1552, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow7', '2019-05-29 13:15:23', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1553, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow7', '2019-05-29 13:15:35', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1554, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow7', '2019-05-29 13:15:40', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1555, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow7', '2019-05-29 13:15:45', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1556, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow7', '2019-05-29 13:15:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1557, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow7', '2019-05-29 13:15:57', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1558, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 13:16:00', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1559, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 13:16:01', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1560, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 13:16:23', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1561, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 13:16:30', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1562, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 13:16:32', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1563, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 13:17:32', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1564, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 13:17:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1565, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 13:18:18', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1566, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 13:18:20', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1567, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/documents/oecms/gyertyaRene.jpg', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&subfile=preview&id=431&openerWindowId=inlineWindow1&inlineWindowId=inlineWindow2', '2019-05-29 13:18:24', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1568, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 13:18:30', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1569, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 13:18:31', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1570, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 13:18:47', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1571, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/folderClosed.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 13:18:47', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1572, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 13:19:14', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1573, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/', '2019-05-29 13:20:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1574, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/', '2019-05-29 13:20:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1575, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/', '2019-05-29 13:20:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1576, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/', '2019-05-29 13:20:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1577, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 13:20:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1578, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 13:22:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1579, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 13:22:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1580, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 13:22:29', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1581, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 13:22:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1582, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/documents/oecms/Atlantisz/800pxToshiba_logo.svg', 'http://atlantisz.patronet.local/nyito', '2019-05-29 13:22:37', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1583, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 13:22:38', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1584, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_header.gif', 'http://atlantisz.patronet.local/nyito', '2019-05-29 13:22:43', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1585, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/documents/oecms/Atlantisz/800pxToshiba_logo.svg', 'http://atlantisz.patronet.local/nyito', '2019-05-29 13:22:43', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1586, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 13:22:44', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1587, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/documents/oecms/Atlantisz/800pxToshiba_logo.svg', 'http://atlantisz.patronet.local/nyito', '2019-05-29 13:22:52', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1588, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 13:22:52', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1589, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 13:23:06', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1590, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 13:23:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1591, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/folderClosed.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 13:23:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1592, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 13:23:23', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1593, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 13:23:48', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1594, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/documents/oecms/Atlantisz/800pxToshiba_logo.svg', 'http://atlantisz.patronet.local/kapcsolat', '2019-05-29 13:23:50', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1595, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/documents/oecms/Atlantisz/800pxToshiba_logo.svg', 'http://atlantisz.patronet.local/nyito', '2019-05-29 13:23:50', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1596, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 13:23:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1597, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/documents/oecms/Atlantisz/800pxToshiba_logo.svg', 'http://atlantisz.patronet.local/nyito', '2019-05-29 13:24:01', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1598, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 13:24:02', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1599, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 13:24:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1600, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 13:24:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1601, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/folderClosed.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 13:24:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1602, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/folderClosed.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 13:24:10', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1603, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 13:24:10', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1604, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 13:28:11', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1605, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 13:28:14', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1606, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/documents/oecms/Atlantisz/800pxToshiba_logo.svg', 'http://atlantisz.patronet.local/nyito', '2019-05-29 13:28:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1607, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 13:28:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1608, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 13:29:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1609, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/', '2019-05-29 13:29:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1610, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/', '2019-05-29 13:29:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1611, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/', '2019-05-29 13:29:25', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1612, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/', '2019-05-29 13:29:25', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1613, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/documents/oecms/Atlantisz/800pxToshiba_logo.svg.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 13:29:31', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1614, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 13:29:35', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1615, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 13:30:50', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1616, 0, 'index.php?&_ORIGINAL_REQUEST=documents/oecms/Atlantisz/800pxToshiba_logo.svg.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 13:30:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1617, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 13:31:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1618, 0, 'index.php?&_ORIGINAL_REQUEST=documents/oecms/Design/800pxToshiba_logo.svg.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 13:31:31', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1619, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 13:31:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1620, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 13:32:38', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1621, 0, 'index.php?&_ORIGINAL_REQUEST=documents/oecms/Design/800pxToshiba_logo.svg.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 13:32:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1622, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 13:32:46', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1623, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/', '2019-05-29 13:34:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1624, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/', '2019-05-29 13:34:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1625, 0, 'index.php?&_ORIGINAL_REQUEST=images/objecteditor/tablak/CUSTOM_footer-secondary.gif', 'http://atlantisz.patronet.local/nyito', '2019-05-29 13:36:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1626, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 13:38:14', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1627, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 13:38:18', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1628, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 13:38:19', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1629, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 13:39:49', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1630, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 13:40:43', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1631, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 13:42:01', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1632, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 13:42:19', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1633, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 13:42:22', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1634, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 13:42:23', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1635, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 13:44:03', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1636, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 13:45:16', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1637, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 13:46:06', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1638, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 13:49:48', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1639, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/documents/oecms/Design/8loginroundedrightfilled.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 13:52:00', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1640, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/documents/oecms/Design/8loginroundedrightfilled.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 13:52:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1641, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/documents/oecms/Design/8loginroundedrightfilled.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 13:52:35', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1642, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/documents/oecms/Design/8loginroundedrightfilled.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 13:52:36', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1643, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/documents/oecms/Design/8loginroundedrightfilled.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 13:52:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1644, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/documents/oecms/Design/8loginroundedrightfilled.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 13:52:52', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1645, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/documents/oecms/Design/8loginroundedrightfilled.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 13:53:03', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1646, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/documents/oecms/Design/8loginroundedrightfilled.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 13:53:10', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1647, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/documents/oecms/Design/8loginroundedrightfilled.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 13:53:31', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1648, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 13:53:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1649, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 13:54:40', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1650, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 13:55:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1651, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 13:55:11', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1652, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 13:55:16', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1653, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 13:58:47', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1654, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 14:28:44', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1655, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 14:28:44', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1656, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 14:28:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1657, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 14:35:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1658, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 14:38:37', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1659, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 14:38:37', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1660, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 14:41:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1661, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 14:41:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1662, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 14:42:03', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1663, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 14:42:03', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1664, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 14:45:48', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1665, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 14:45:48', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1666, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 14:55:29', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1667, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 14:55:29', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1668, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 14:59:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1669, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 14:59:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1670, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:03:14', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36');
INSERT INTO `opey_visitors_404` (`id`, `vis_id`, `url`, `referrer_url`, `time`, `ip_address`, `browser`, `user_agent`) VALUES
(1671, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:03:14', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1672, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 15:03:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1673, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 15:03:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1674, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:03:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1675, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:03:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1676, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:05:06', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1677, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 15:05:06', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1678, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:05:06', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1679, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 15:05:07', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1680, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:05:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1681, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:05:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1682, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:05:45', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1683, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:05:45', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1684, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:05:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1685, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:05:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1686, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 15:05:57', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1687, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:06:01', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1688, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:06:01', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1689, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 15:06:17', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1690, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:06:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1691, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:06:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1692, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:06:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1693, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:06:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1694, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:07:47', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1695, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:07:48', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1696, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:08:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1697, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:08:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1698, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:08:29', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1699, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:08:29', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1700, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:08:48', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1701, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:08:48', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1702, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 15:08:49', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1703, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 15:08:49', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1704, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:08:50', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1705, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:08:50', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1706, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:08:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1707, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 15:08:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1708, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 15:08:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1709, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:08:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1710, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 15:09:01', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1711, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:09:06', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1712, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:09:06', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1713, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 15:09:47', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1714, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:09:50', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1715, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:09:50', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1716, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:10:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1717, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:10:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1718, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:10:20', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1719, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:10:20', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1720, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:12:07', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1721, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:12:07', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1722, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:12:48', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1723, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:12:48', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1724, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:13:10', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1725, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:13:10', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1726, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:13:20', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1727, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:13:20', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1728, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:14:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1729, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:14:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1730, 0, 'index.php?&_ORIGINAL_REQUEST=images/tree_image/iconUncheckAll.gif', 'http://atlantisz.patronet.local/admin.php?op=tool&tool=file2&filetype=kep&inlineWindowId=inlineWindow1', '2019-05-29 15:16:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1731, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:16:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1732, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:16:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1733, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:20:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1734, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:20:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1735, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:20:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1736, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:20:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1737, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:20:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1738, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:20:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1739, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/', '2019-05-29 15:20:38', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1740, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/', '2019-05-29 15:20:38', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1741, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:20:38', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1742, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:20:38', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1743, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:20:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1744, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:20:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1745, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/', '2019-05-29 15:20:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1746, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/', '2019-05-29 15:20:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1747, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/', '2019-05-29 15:20:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1748, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/', '2019-05-29 15:20:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1749, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/', '2019-05-29 15:21:00', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1750, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/', '2019-05-29 15:21:00', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1751, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/script$.js', 'http://atlantisz.patronet.local/nyito', '2019-05-29 15:21:03', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1752, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/script$.js', 'http://atlantisz.patronet.local/nyito', '2019-05-29 15:21:03', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1753, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/script$.js', 'http://atlantisz.patronet.local/nyito', '2019-05-29 15:21:03', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1754, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/script$.js', 'http://atlantisz.patronet.local/nyito', '2019-05-29 15:21:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1755, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/script$.js', 'http://atlantisz.patronet.local/nyito', '2019-05-29 15:21:11', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1756, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/script$.js', 'http://atlantisz.patronet.local/nyito', '2019-05-29 15:21:11', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1757, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/script$.js', 'http://atlantisz.patronet.local/nyito', '2019-05-29 15:21:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1758, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:21:16', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1759, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:21:16', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1760, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/script$.js', 'http://atlantisz.patronet.local/nyito', '2019-05-29 15:21:16', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1761, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:21:29', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1762, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:21:29', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1763, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/script$.js', 'http://atlantisz.patronet.local/nyito', '2019-05-29 15:21:32', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1764, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/script$.js', 'http://atlantisz.patronet.local/nyito', '2019-05-29 15:21:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1765, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:21:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1766, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:21:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1767, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/script$.js', 'http://atlantisz.patronet.local/nyito', '2019-05-29 15:21:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1768, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/script$.js', 'http://atlantisz.patronet.local/nyito', '2019-05-29 15:24:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1769, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/script$.js', 'http://atlantisz.patronet.local/nyito', '2019-05-29 15:24:14', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1770, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:24:14', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1771, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:24:14', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1772, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:24:15', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1773, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:24:15', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1774, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/script$.js', 'http://atlantisz.patronet.local/nyito', '2019-05-29 15:24:17', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1775, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/script$.js', 'http://atlantisz.patronet.local/nyito', '2019-05-29 15:24:17', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1776, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:24:18', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1777, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:24:18', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1778, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/script$.js', 'http://atlantisz.patronet.local/nyito', '2019-05-29 15:24:19', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1779, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/script$.js', 'http://atlantisz.patronet.local/nyito', '2019-05-29 15:24:38', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1780, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/script$.js', 'http://atlantisz.patronet.local/nyito', '2019-05-29 15:24:38', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1781, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:24:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1782, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:24:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1783, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:24:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1784, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:24:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1785, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/script$.js', 'http://atlantisz.patronet.local/nyito', '2019-05-29 15:24:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1786, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/script$.js', 'http://atlantisz.patronet.local/nyito', '2019-05-29 15:24:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1787, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:24:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1788, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:24:43', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1789, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/script$.js', 'http://atlantisz.patronet.local/nyito', '2019-05-29 15:24:43', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1790, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/script$.js', 'http://atlantisz.patronet.local/nyito', '2019-05-29 15:25:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1791, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/script$.js', 'http://atlantisz.patronet.local/nyito', '2019-05-29 15:25:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1792, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:25:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1793, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:25:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1794, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:25:14', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1795, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:25:14', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1796, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/script$.js', 'http://atlantisz.patronet.local/nyito', '2019-05-29 15:25:17', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1797, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/script$.js', 'http://atlantisz.patronet.local/nyito', '2019-05-29 15:25:17', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1798, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:25:18', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1799, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:25:18', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1800, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/script$.js', 'http://atlantisz.patronet.local/nyito', '2019-05-29 15:25:18', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1801, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/script$.js', 'http://atlantisz.patronet.local/teszt', '2019-05-29 15:31:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1802, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/script$.js', 'http://atlantisz.patronet.local/teszt', '2019-05-29 15:31:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1803, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronetocumentsImageGalleryNewimagesimg_33.jpg', 'http://atlantisz.patronet.local/', '2019-05-29 15:31:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1804, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronetocumentsImageGalleryNewimagesimg_34.jpg', 'http://atlantisz.patronet.local/', '2019-05-29 15:31:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1805, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:31:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1806, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:31:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1807, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:31:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1808, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/script$.js', 'http://atlantisz.patronet.local/teszt', '2019-05-29 15:32:40', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1809, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/script$.js', 'http://atlantisz.patronet.local/teszt', '2019-05-29 15:32:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1810, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronetocumentsImageGalleryNewimagesimg_33.jpg', 'http://atlantisz.patronet.local/', '2019-05-29 15:32:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1811, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronetocumentsImageGalleryNewimagesimg_34.jpg', 'http://atlantisz.patronet.local/', '2019-05-29 15:32:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1812, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:32:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1813, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:32:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1814, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:32:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1815, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/script$.js', 'http://atlantisz.patronet.local/teszt', '2019-05-29 15:32:46', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1816, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:33:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1817, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronetocumentsImageGalleryNewimagesimg_34.jpg', 'http://atlantisz.patronet.local/', '2019-05-29 15:33:13', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1818, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:33:14', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1819, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:33:14', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1820, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronetocumentsImageGalleryNewimagesimg_33.jpg', 'http://atlantisz.patronet.local/', '2019-05-29 15:33:14', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1821, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:34:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1822, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:34:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1823, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronetocumentsImageGalleryNewimagesimg_34.jpg', 'http://atlantisz.patronet.local/', '2019-05-29 15:34:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1824, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:34:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1825, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronetocumentsImageGalleryNewimagesimg_33.jpg', 'http://atlantisz.patronet.local/', '2019-05-29 15:34:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1826, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:35:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1827, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:35:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1828, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronetocumentsImageGalleryNewimagesimg_34.jpg', 'http://atlantisz.patronet.local/', '2019-05-29 15:35:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1829, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:35:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1830, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronetocumentsImageGalleryNewimagesimg_33.jpg', 'http://atlantisz.patronet.local/', '2019-05-29 15:35:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1831, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:35:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1832, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:35:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1833, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronetocumentsImageGalleryNewimagesimg_33.jpg', 'http://atlantisz.patronet.local/', '2019-05-29 15:35:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1834, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:35:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1835, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronetocumentsImageGalleryNewimagesimg_34.jpg', 'http://atlantisz.patronet.local/', '2019-05-29 15:35:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1836, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronetocumentsImageGalleryNewimagesimg_34.jpg', 'http://atlantisz.patronet.local/', '2019-05-29 15:38:23', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1837, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:38:23', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1838, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronetocumentsImageGalleryNewimagesimg_33.jpg', 'http://atlantisz.patronet.local/', '2019-05-29 15:38:24', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1839, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:38:24', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1840, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:38:24', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1841, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:38:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1842, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:38:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1843, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronetocumentsImageGalleryNewimagesimg_33.jpg', 'http://atlantisz.patronet.local/', '2019-05-29 15:38:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36');
INSERT INTO `opey_visitors_404` (`id`, `vis_id`, `url`, `referrer_url`, `time`, `ip_address`, `browser`, `user_agent`) VALUES
(1844, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronetocumentsImageGalleryNewimagesimg_34.jpg', 'http://atlantisz.patronet.local/', '2019-05-29 15:38:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1845, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/teszt', '2019-05-29 15:38:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1846, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:38:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1847, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/teszt', '2019-05-29 15:38:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1848, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:38:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1849, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:38:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1850, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronetocumentsImageGalleryNewimagesimg_34.jpg', 'http://atlantisz.patronet.local/', '2019-05-29 15:38:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1851, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronetocumentsImageGalleryNewimagesimg_33.jpg', 'http://atlantisz.patronet.local/', '2019-05-29 15:38:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1852, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:38:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1853, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronetocumentsImageGalleryNewimagesimg_34.jpg', 'http://atlantisz.patronet.local/', '2019-05-29 15:39:31', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1854, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:39:31', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1855, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronetocumentsImageGalleryNewimagesimg_33.jpg', 'http://atlantisz.patronet.local/', '2019-05-29 15:39:31', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1856, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:39:31', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1857, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:39:31', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1858, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:40:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1859, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronetocumentsImageGalleryNewimagesimg_33.jpg', 'http://atlantisz.patronet.local/', '2019-05-29 15:40:10', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1860, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:40:10', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1861, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronetocumentsImageGalleryNewimagesimg_34.jpg', 'http://atlantisz.patronet.local/', '2019-05-29 15:40:10', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1862, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:40:10', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1863, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:40:26', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1864, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronetocumentsImageGalleryNewimagesimg_33.jpg', 'http://atlantisz.patronet.local/', '2019-05-29 15:40:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1865, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:40:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1866, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronetocumentsImageGalleryNewimagesimg_34.jpg', 'http://atlantisz.patronet.local/', '2019-05-29 15:40:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1867, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:40:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1868, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronetocumentsImageGalleryNewimagesimg_34.jpg', 'http://atlantisz.patronet.local/', '2019-05-29 15:40:49', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1869, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronetocumentsImageGalleryNewimagesimg_34.jpg', 'http://atlantisz.patronet.local/', '2019-05-29 15:40:49', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1870, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronetocumentsImageGalleryNewimagesimg_34.jpg', 'http://atlantisz.patronet.local/', '2019-05-29 15:40:50', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1871, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:42:10', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1872, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:42:10', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1873, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:42:10', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1874, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:43:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1875, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:43:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1876, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:43:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1877, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:44:16', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1878, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:44:16', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1879, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:44:16', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1880, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:45:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1881, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:45:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1882, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:45:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1883, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:45:29', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1884, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:45:29', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1885, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:45:30', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1886, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:45:37', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1887, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:45:38', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1888, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:45:38', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1889, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:45:55', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1890, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:45:55', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1891, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:45:55', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1892, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:46:15', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1893, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:46:15', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1894, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:46:15', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1895, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:46:16', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1896, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:46:16', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1897, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:46:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1898, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:46:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1899, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:46:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1900, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:46:22', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1901, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:46:22', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1902, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:46:24', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1903, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:46:25', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1904, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:46:25', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1905, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:46:31', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1906, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:46:31', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1907, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:46:32', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1908, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:46:44', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1909, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:46:45', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1910, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:46:45', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1911, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:47:40', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1912, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:47:40', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1913, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:47:40', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1914, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:47:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1915, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:47:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1916, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:47:51', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1917, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:48:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1918, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:48:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1919, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:48:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1920, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:48:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1921, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:48:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1922, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:48:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1923, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:50:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1924, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:50:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1925, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:50:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1926, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:51:57', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1927, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:51:57', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1928, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:51:57', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1929, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:53:26', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1930, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:53:26', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1931, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:53:26', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1932, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:53:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1933, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:53:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1934, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:53:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1935, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:53:30', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1936, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 15:53:30', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1937, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 15:53:30', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1938, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:53:30', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1939, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:53:30', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1940, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:53:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1941, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:53:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1942, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:53:39', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1943, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:53:47', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1944, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:53:47', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1945, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:53:47', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1946, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:53:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1947, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:53:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1948, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:53:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1949, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:54:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1950, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:54:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1951, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:54:12', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1952, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:54:25', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1953, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:54:25', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1954, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:54:25', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1955, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:54:55', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1956, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:54:56', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1957, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:54:56', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1958, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:55:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1959, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:55:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1960, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:55:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1961, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:55:40', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1962, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:55:40', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1963, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:55:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1964, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:55:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1965, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:55:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1966, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:55:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1967, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:55:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1968, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:55:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1969, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:55:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1970, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:56:00', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1971, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:56:02', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1972, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:56:02', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1973, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:56:02', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1974, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:56:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1975, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:56:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1976, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:56:42', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1977, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:56:44', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1978, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:56:44', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1979, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:56:46', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1980, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:56:46', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1981, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:56:46', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1982, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:57:06', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1983, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:57:06', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1984, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:57:06', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1985, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:57:18', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1986, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:57:19', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1987, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:57:19', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1988, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:57:32', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1989, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:57:32', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1990, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:57:32', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1991, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:57:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1992, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:57:59', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1993, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:58:00', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1994, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:58:26', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1995, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:58:26', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1996, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:58:26', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1997, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:58:30', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1998, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:58:30', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(1999, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:58:30', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2000, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:58:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2001, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:58:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2002, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:58:34', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2003, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:58:38', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2004, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:58:38', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2005, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:58:38', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2006, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:58:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2007, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:58:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2008, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:58:41', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2009, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:59:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2010, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:59:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2011, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:59:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2012, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:59:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2013, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:59:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2014, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:59:30', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2015, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:59:30', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2016, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:59:30', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2017, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:59:31', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2018, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:59:32', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2019, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:59:32', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2020, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-32x32.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 15:59:32', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2021, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/favicon-16x16.png', 'http://atlantisz.patronet.local/nyito', '2019-05-29 15:59:32', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36');
INSERT INTO `opey_visitors_404` (`id`, `vis_id`, `url`, `referrer_url`, `time`, `ip_address`, `browser`, `user_agent`) VALUES
(2022, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:59:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2023, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:59:33', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2024, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 15:59:35', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2025, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 15:59:35', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2026, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 15:59:35', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2027, 0, 'index.php?&_ORIGINAL_REQUEST=modules/MiniCatalog/images/admin.gif', 'http://atlantisz.patronet.local/index.php?name=OE-User&file=toolsmenuMENU&TABname=Default&TABurl=modules/OE-User/toolbar/Default', '2019-05-29 16:00:44', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2028, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 16:00:44', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2029, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 16:00:44', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2030, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 16:00:44', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2031, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 16:02:50', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2032, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 16:02:50', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2033, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 16:02:50', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2034, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 16:03:02', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2035, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 16:03:02', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2036, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 16:03:02', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2037, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 16:03:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2038, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 16:03:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2039, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 16:03:28', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2040, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 16:03:45', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2041, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 16:03:45', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2042, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 16:03:45', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2043, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 16:04:30', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2044, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 16:04:30', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2045, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 16:04:30', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2046, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 16:04:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2047, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 16:04:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2048, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 16:04:54', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2049, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 16:05:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2050, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 16:05:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2051, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 16:05:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2052, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 16:05:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2053, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 16:05:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2054, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 16:05:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2055, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 16:05:44', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2056, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 16:05:44', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2057, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 16:05:44', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2058, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 16:06:03', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2059, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 16:06:03', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2060, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 16:06:03', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2061, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 16:06:08', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2062, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 16:06:08', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2063, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 16:06:08', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2064, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 16:06:29', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2065, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 16:06:30', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2066, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 16:06:30', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2067, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 16:07:19', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2068, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 16:07:19', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2069, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 16:07:19', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2070, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 16:08:06', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2071, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 16:08:06', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2072, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 16:08:06', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2073, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 16:08:15', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2074, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 16:08:15', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2075, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 16:08:15', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2076, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 16:08:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2077, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 16:08:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2078, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 16:08:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2079, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 16:09:11', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2080, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 16:09:11', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2081, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 16:09:11', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2082, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 16:09:19', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2083, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 16:09:19', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2084, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 16:09:19', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2085, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 16:09:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2086, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 16:09:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2087, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 16:09:27', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2088, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 16:09:45', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2089, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 16:09:46', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2090, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 16:09:46', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2091, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 16:09:52', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2092, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 16:09:52', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2093, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 16:09:52', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2094, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 16:10:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2095, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 16:10:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2096, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 16:10:09', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2097, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 16:10:20', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2098, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 16:10:20', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2099, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 16:10:20', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2100, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 16:10:45', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2101, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 16:10:46', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2102, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 16:10:46', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2103, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 16:10:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2104, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 16:10:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2105, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 16:10:58', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2106, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 16:11:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2107, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 16:11:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2108, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 16:11:04', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2109, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 16:11:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2110, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 16:11:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2111, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 16:11:21', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2112, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 16:12:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2113, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 16:12:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2114, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 16:12:53', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2115, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 16:14:18', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2116, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 16:14:18', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2117, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 16:14:18', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2118, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 16:15:46', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2119, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 16:15:46', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2120, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/popper.min.js.map', 'bookmark', '2019-05-29 16:15:46', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2121, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/templates/js/hammer.min.js.map', 'bookmark', '2019-05-29 16:16:57', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36'),
(2122, 0, 'index.php?&_ORIGINAL_REQUEST=parameters/atlantisz.patronet/script/bootstrap.min.js.map', 'bookmark', '2019-05-29 16:16:57', '127.0.0.1', 'Netscape', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537