<?
use PatroNet\Cms\Application\Application;
/************************************************/
/* PatroNet Content Managment System 	        */
/* =================================            */
/* Version 6.3                                  */
/* Copyright (c) 2002-2020 PatroNet Ltd.        */
/* www.patronet.hu                              */
/************************************************/

if (!defined("LOADED_AS_MODULE")) {
         die ("You can't access this file directly...");
}

$ModName = basename(dirname(__FILE__));
if(strpos(dirname(__FILE__),"/parameters/") > 0){
	$ModDir = WHERE_IS_PERSO."modules/$ModName";// . 
} else {
	$ModDir = "modules/$ModName";// . 
}
modules_get_language();

$ModLink = "index.php?name=$ModName&file=index&";

$shid = ShortLinkFind($ModLink);
if ($shid > 0) {
	$ModLink = GetShortLink($shid, $ModName);
}

$TmplDir = WHERE_IS_PERSO . "templates/$ModName";
$TmplDirDefault = "$ModDir/templates";
$tmp_dir = (file_exists("$TmplDir/index.html")) ? $TmplDir : $TmplDirDefault ;

include("$ModDir/classes/AudioList.php");

$AudioList = new AudioList();

$twigTemplate = Application::template($tmp_dir."/index.twig");

$per_page = 10;

$list = $AudioList->getAll($folder_id,$page,$per_page, $q);
$count = $AudioList->getCount($folder_id,$q);

$twigTemplate->assign("WHERE_IS_PERSO",WHERE_IS_PERSO);
$twigTemplate->assign("MODDIR",$ModDir);
$twigTemplate->assign("MODLINK",$ModLink);
$twigTemplate->assign("LIST",$list);
$twigTemplate->assign("AJAX",$ajax);
$twigTemplate->assign("FOLDER_ID",$folder_id);
$twigTemplate->assign("PAGE",($page) ? $page : 1 );
$twigTemplate->assign("PAGES",ceil($count / $per_page));
$twigTemplate->assign("COUNT",$count);
$twigTemplate->assign("PER_PAGE",$per_page);
$twigTemplate->assign("LOCATION",$_SERVER["REQUEST_URI"]);

if(!$ajax) include("header.php");

$twigTemplate->flush();


if(!$ajax) include("footer.php");



?> 
