<?php
namespace PatroNet\Cms\Site\Modules\PartnerManager;

use PatroNet\Core\Database\ResultSet;
use PatroNet\Cms\Application\Application;
use PatroNet\Cms\Site\Etc\CMS\User;
use PatroNet\Cms\Site\Etc\Util;

/**
 * Controller class for data fetching
 */
class AjaxServiceController
{

    /**
     * Handles the given data and produces some output data
     *
     * In $serviceName words should be separated with '-' (e. g. 'some-service-name')
     *
     * @param string $serviceName
     * @param mixed $inputData
     * @return mixed
     */
    public function handle($serviceName, $inputData)
    {
        if (empty($serviceName)) {
            throw new \RuntimeException("Service name can not be empty");
        }
        $methodName = "handle" . Util::separatedToCamelCase($serviceName, "-", true);
        if (!method_exists($this, $methodName)) {
            throw new \RuntimeException("Unknown service: '{$serviceName}'");
        }
        return $this->$methodName($inputData);
    }

    private function fail($message = "Hiba történt")
    {
        return ["success" => false, "message" => $message];
    }

    protected function handleAjaxTest()
    {
    	return ['success' => true];
    }

    protected function handleIsUserLoggedIn()
    {
      return (bool)Application::session()->get("uid");
    }

    protected function handleUserLogin($inputData)
    {
        if(pnUserLoggedIn() && $uid = Application::session()->get("uid")){
            $oUser = User::getRepository()->get($uid);
            if (!$oUser) {
                pnUserLogOut();
                return $this->fail('A bejelentkezett felhasználóhoz nem tartozik valós fiók, ezért kijelentkeztetünk a rendszerből.');
            }else{
                return ['success' => true];
            }
        }

        if(!Util::loginUser($inputData['username'], $inputData['password'], $inputData['remember_me'])){
            $lockoutTime = 600;
            $failLoginLimits = 5;
            if(Util::isUserLockedOut($lockoutTime, $failLoginLimits)){
                return $this->fail('Túl sok hibás bejelentkezés! Az IP címedet '.($lockoutTime/60).' percre letiltottuk.');
            }
            return $this->fail('Sikertelen bejelentkezés. A felhasználói név vagy a jelszó nem megfelelő!'.$inputData['username']." ".$inputData['password']);
        }

        return ['success' => true];
    }

    protected function handleUserLogout($inputData)
    {
        if(pnUserLoggedIn() && $uid = Application::session()->get("uid")){
            pnUserLogOut();
        }

        return ['success' => true];
    }
	
	protected function handleMapData(){
		$allpartners = PartnerManager::getAllPartners();
		return $allpartners;
	}
}
