<?php

namespace PatroNet\Cms\Site\Modules\PartnerManager;

use PatroNet\Core\Entity\ActiveRecordEntity;
use PatroNet\Core\Database\ActiveRecord;
use PatroNet\Cms\Application\Application;
use PatroNet\Core\Database\ResultSet as ResultSetInterface;

class PartnerUser extends ActiveRecordEntity
{
	private static $oRepository = null;

	function __construct(ActiveRecord $oActiveRecord)
	{
		parent::__construct($oActiveRecord);
	}

    public function get($column)
    {
        return $this->oActiveRecord[$column];
    }

    public function set($column, $value)
    {
        $this->oActiveRecord[$column] = $value;
    }

    /**
     * Gets default service repository
     *
     * @return PartnerUser\_Repository
     */
    public static function getRepository()
    {
        if (is_null(self::$oRepository)) {
            self::$oRepository = new PartnerUser\_Repository();
        }
        return self::$oRepository;
    }
}

namespace PatroNet\Cms\Site\Modules\PartnerManager\PartnerUser;

use PatroNet\Core\Database\ActiveRecord;
use PatroNet\Core\Entity\TableRepository;
use PatroNet\Cms\Application\Application;
use PatroNet\Cms\Site\Modules\PartnerManager\PartnerUser;

/**
 * @method PartnerUser create()
 * @method PartnerUser get(mixed $id)
 * @method PartnerUser[]|\PatroNet\Core\Database\ResultSet getAll(int[] $idList = null, string[string] $order = null, mixed $limit = null)
 * @method PartnerUser[]|\PatroNet\Core\Database\ResultSet getAllByFilter(mixed $filter = null, string[string] $order = null, mixed $limit = null)
 */
class _Repository extends TableRepository
{

    const TABLE = "opey_pm_partners_users";

    const TABLE_KEY = "id";

    const TABLE_ALIAS = "partners_users";

    public function __construct()
    {
        parent::__construct($oTable = Application::conn()->getTable(self::TABLE, self::TABLE_KEY, self::TABLE_ALIAS));
    }

    /**
     * @param \PatroNet\Core\Database\ActiveRecord $oActiveRecord
     * @return PartnerGroup;
     */
    protected function wrapActiveRecordToEntity(ActiveRecord $oActiveRecord)
    {
        return new PartnerUser($oActiveRecord);
    }
}
