<?php

namespace PatroNet\Cms\Site\Modules\PartnerManager;

use PatroNet\Core\Entity\ActiveRecordEntity;
use PatroNet\Core\Database\ActiveRecord;
use PatroNet\Cms\Application\Application;
use PatroNet\Core\Database\ResultSet as ResultSetInterface;
use PatroNet\Cms\Site\Etc\CMS\User;

class Partner extends ActiveRecordEntity
{
	private static $oRepository = null;

	function __construct(ActiveRecord $oActiveRecord)
	{
		parent::__construct($oActiveRecord);
	}
	
    public function getAll($id)
    {
		global $dbconn;
		$sql = "SELECT * FROM opey_pm_partners WHERE id='$id'";
		DBAssoc();
		$res = $dbconn->Execute($sql);
		RestoreDBMode();
		$res->fields["categories"] = PartnerManager::getPartnerCategories($res->fields["id"]);
        return (object)$res->fields;
    }

    public function get($column)
    {
        return $this->oActiveRecord[$column];
    }

    public function set($column, $value)
    {
        $this->oActiveRecord[$column] = $value;
    }

	public function getDocuments(){
		$docdir = WHERE_IS_PERSO."documents/PartnerManager/".$this->getId()."/";
		if(!is_dir($docdir)) return false;
		$files1 = scandir($docdir);
		if( is_array($files1)){
			foreach($files1 as $file){
				$index =  explode("-",pathinfo($file,PATHINFO_FILENAME))[1];
				if($file != "." && $file != ".."){
					$ret[$index] = $docdir.$file;
				}
			};
		}
		
		return $ret;
	}

	public function setCategories($cats){
		global $dbconn;

		$sql = "DELETE FROM opey_pm_partner2category WHERE partner_id='".$this->getId()."'";
		$res = $dbconn->Execute($sql);
		foreach($cats as $k=>$v){
			$sql = "INSERT INTO opey_pm_partner2category (partner_id, category_id) VALUES ('".$this->getId()."','".$v."')";
			$dbconn->Execute($sql);
		}
	}
	
    public function getName()
    {
        return $this->oActiveRecord["name"];
    }

    public function getHeadquarter()
    {
        return $this->oActiveRecord["headquarter"];
    }

    public function getPostalAddress()
    {
        return $this->oActiveRecord["postal_address"];
    }

    public function getTaxNumber()
    {
        return $this->oActiveRecord["tax_number"];
    }

    public function getRegNumber()
    {
        return $this->oActiveRecord["reg_number"];
    }

    public function getPhone()
    {
        return $this->oActiveRecord["phone"];
    }

    public function getEmail()
    {
        return $this->oActiveRecord["email"];
    }

    public function getWebsite()
    {
        return $this->oActiveRecord["website"];
    }

    public function getLattitude()
    {
        return $this->oActiveRecord["lattitude"];
    }

    public function getLongitude()
    {
        return $this->oActiveRecord["longitude"];
    }

    public function getCategoryId()
    {
    	return $this->oActiveRecord["partner_category_id"];
    }

    public function addUser(User $oUser)
    {
        $oPartnerUser = PartnerUser::getRepository()->create();
        $oPartnerUser->set("user_id", $oUser->getId());
        $oPartnerUser->set("partner_id", $this->getId());

        $oPartnerUser->save();

        return $oPartnerUser;
    }

    /**
     * Gets default service repository
     *
     * @return Partner\_Repository
     */
    public static function getRepository()
    {
        if (is_null(self::$oRepository)) {
            self::$oRepository = new Partner\_Repository();
        }
        return self::$oRepository;
    }
}

namespace PatroNet\Cms\Site\Modules\PartnerManager\Partner;

use PatroNet\Core\Database\ActiveRecord;
use PatroNet\Core\Entity\TableRepository;
use PatroNet\Cms\Application\Application;
use PatroNet\Cms\Site\Modules\PartnerManager\Partner;

/**
 * @method Partner create()
 * @method Partner get(mixed $id)
 * @method Partner[]|\PatroNet\Core\Database\ResultSet getAll(int[] $idList = null, string[string] $order = null, mixed $limit = null)
 * @method Partner[]|\PatroNet\Core\Database\ResultSet getAllByFilter(mixed $filter = null, string[string] $order = null, mixed $limit = null)
 */
class _Repository extends TableRepository
{

    const TABLE = "opey_pm_partners";

    const TABLE_KEY = "id";

    const TABLE_ALIAS = "partners";

    public function __construct()
    {
        parent::__construct($oTable = Application::conn()->getTable(self::TABLE, self::TABLE_KEY, self::TABLE_ALIAS));
    }

    /**
     * @param \PatroNet\Core\Database\ActiveRecord $oActiveRecord
     * @return PartnerGroup;
     */
    protected function wrapActiveRecordToEntity(ActiveRecord $oActiveRecord)
    {
        return new Partner($oActiveRecord);
    }
}
