<?php
namespace PatroNet\Cms\Site\Modules\PartnerManager;
		

class PartnerManager {

	private static $modName = "PartnerManager";

	public static function getModDir ()
	{
		return WHERE_IS_PERSO."modules/".self::getModName();
	}

	public static function getTemplateDir ()
	{
		return self::getModDir()."/public/templates/";
	}

	public static function getModUrl ()
	{
		return "index.php?name=".self::getModName();
	}

	public static function getModName ()
	{
		return self::$modName;
	}

	public function getAllPartners($map=false, $country="all"){
		global $dbconn;
		$where = "WHERE 1";
		$where .= ($map==true) ? " AND show_on_map=1 " : "";
		$where .= ($country != "all" && !empty($country)) ? " AND hq_country_id='$country' " : "";
		
		
		DBAssoc();
		$sql = "SELECT *  FROM opey_pm_partners  $where ";
		$res = $dbconn->Execute($sql);
		RestoreDBMode();
		
		$partners = array();
		while($res->fields){
			$res->fields["categories"] = PartnerManager::getPartnerCategories($res->fields["id"]);
			$partners[] = $res->fields;
			$res->MoveNext();
		}
		return $partners;
	}

	public function getPartnerCategories($id){
		global $dbconn;
		$sql = "SELECT category_id FROM opey_pm_partner2category WHERE partner_id='".$id."'";
		$res = $dbconn->Execute($sql);
		while($res->fields){
			list($pcats[]) = $res->fields;
			$res->MoveNext();
		}
		return $pcats;
	}
	
	public function getPartnersCount(){
		global $dbconn;
		$sql = "SELECT COUNT(*) FROM opey_pm_partners WHERE show_on_map=1 ORDER BY partner_category_id ";
		$res = $dbconn->Execute($sql);
		return $res->fields[0];
	
	}
	public function getCountries(){
		global $dbconn;
		DBAssoc();
		$sql = "SELECT * FROM opey_pm_country ORDER BY name_hun";
		$res = $dbconn->Execute($sql);
		RestoreDBMode();
		$ret = array();

		while($res->fields){
			$ret[] = $res->fields;
			$res->MoveNext();
		}
		return $ret;
	}
	
	public function getCategories(){
		global $dbconn;
		DBAssoc();
		$sql = "SELECT * FROM opey_pm_category ORDER BY name_hun";
		$res = $dbconn->Execute($sql);
		RestoreDBMode();		
		while($res->fields){
			$ret[$res->fields[id]] = $res->fields;
			$res->MoveNext();
		}
		return $ret;
	}
	
	public function getCountriesWhenPartners(){
		global $dbconn;
		DBAssoc();
		$sql = "SELECT * FROM opey_pm_country WHERE opey_pm_country.id IN(SELECT DISTINCT(hq_country_id) FROM opey_pm_partners WHERE show_on_map=1) ORDER BY name";
		$res = $dbconn->Execute($sql);
		RestoreDBMode();
		$ret = array();

		while($res->fields){
			$sql = "SELECT COUNT(*) FROM opey_pm_partners WHERE hq_country_id='".$res->fields["id"]."'";
			$r = $dbconn->Execute($sql);
			$res->fields["count"] = $r->fields[0];
			$ret[] = $res->fields;
			$res->MoveNext();
		}
		return $ret;		
	}
	
	public function sendEmails( $postdata, $attachments  ){
		global $dbconn;
		
error_reporting(E_ERROR | E_WARNING);
ini_set("display_errors", 1);
		
		require_once 'includes/classes/mpdf-development/vendor/autoload.php';
		require_once "includes/classes/htmlMimeMail/htmlMimeMail.php";
		require_once "includes/classes/xtpl.php";
		require_once "includes/html2text.libV2.php";
		
		$xtp = new \XTemplate(WHERE_IS_PERSO."modules/PartnerManager/templates/owner_reg_mail.html");
		
		$sql = "SELECT pn_name FROM opey_groups WHERE pn_gid='".$postdata["partner_type"]."'";
		$res = $dbconn->Execute($sql);
		list($gname) = $res->fields;
		
		$postdata["partner_type"] = $gname . " <i>(".$postdata["partner_type"].")</i>";
		$postdata["company_type"] = ($postdata["company_type"]=="company")? "Cég":"Egyéni vállalkozó";

		$xtp->assign("R",$postdata);

		$alairasi = "-";
		$cegkivonat = "-";
		foreach($attachments as $att){
			if(strpos($att,"alairasi_cimpeldany") > 0){
				$alairasi = "Van";
			}
			if(strpos($att,"cegkivonat") > 0){
				$cegkivonat = "Van";
			}			
		}

		$xtp->assign("ALAIRASI",$alairasi);
		$xtp->assign("CEGKIVONAT",$cegkivonat);
		
		$xtp->parse("main");
		$html = $xtp->text("main");
		
		$mpdf = new \Mpdf\Mpdf([
				'mode' => 'utf-8', 
				'format' => [210,297], 
				'orientation' => 'P'
		]);
		$mpdf->SetHTMLHeader('
		<div style="text-align: right; font-weight: bold;">
			Új regisztráció
		</div>');
		$mpdf->SetHTMLFooter('
		<table width="100%" style="border-top:0.1pt solid #ccc">
			<tr>
				<td width="33%" style="font-size:8pt;font-family: Arial,Helvetica,Geneva,sans-serif !important;">Kiállítva:{DATE Y-m-j h:i:s}</td>
				<td width="33%" align="center"> <img src="'.WHERE_IS_PERSO.'/documents/oecms/Design/800pxToshiba_logo.svg.png" width="80"></td>
				<td width="33%" style="text-align: right;font-size:8pt;font-family: Arial,Helvetica,Geneva,sans-serif !important;">{PAGENO}/{nbpg}</td>
			</tr>
		</table>');

		if(!is_dir(WHERE_IS_PERSO."tmp")){
			mkdir(WHERE_IS_PERSO."tmp");
		}
		
		$mpdf->WriteHTML($html);
		$mpdf->Output(WHERE_IS_PERSO."tmp/tmp_reg_".$postdata["partner_id"].".pdf" );
		
		// create mail
		
		$recipient = "dev@petho.eu";
		$smtp["host"] = "shadow.apd.hu";
		$smtp["port"] = 2525;
		$smtp["user"] = "petho@patronet.net";
		$smtp["password"] = "psz1968-1";
		
		$mail = new \htmlMimeMail();
		$mail->setHtml($html, html2text2($html) ); 
		$mail->setHtmlCharset("utf-8"); 
		$mail->setTextCharset("utf-8"); 

		$mail->setSubject('=?utf-8?B?'.base64_encode("Új regisztráció").'?=');
		$mail->setFrom('=?utf-8?B?'.base64_encode("TOSHIBA klima").'?=' . ' <'.$smtp["sender_address"].'>');	
		$mail->setReturnPath("noreply@patronet.hu");
		$mail->setHeader('Reply-to', "noreply@patronet.hu");
		$mail->setHeader('X-Mailer', "PatroNet CMS");	
		$mail->addAttachment($mail->getFile(WHERE_IS_PERSO."tmp/tmp_reg_".$postdata["partner_id"].".pdf"),"reg_".$postdata["partner_id"]."_".$postdata["company"].".pdf");
		
		if(!empty($attachments)){
			foreach($attachments as $att){
				$mail->addAttachment($mail->getFile($att),pathinfo($att,PATHINFO_BASENAME ));
			}
		}
		if($smtp["host"] != "localhost"){
			$mail->setSMTPParams($smtp["host"], $smtp["port"], $smtp["host"],true,$smtp["user"],$smtp["password"]);
		} 		
		$result = $mail->send(array($recipient), 'smtp');
		unlink(WHERE_IS_PERSO."tmp/tmp_reg_".$postdata["partner_id"].".pdf");
		
		
		/* send to partner */
		$xtp = new \XTemplate(WHERE_IS_PERSO."modules/PartnerManager/templates/client_reg_mail.html");

		$mail = new \htmlMimeMail();
		$mail->setHtml($html, html2text2($html) ); 
		$mail->setHtmlCharset("utf-8"); 
		$mail->setTextCharset("utf-8"); 

		$mail->setSubject('=?utf-8?B?'.base64_encode("Regisztráció visszaigazolása").'?=');
		$mail->setFrom('=?utf-8?B?'.base64_encode("TOSHIBA klima").'?=' . ' <'.$smtp["sender_address"].'>');	
		$mail->setReturnPath("noreply@patronet.hu");
		$mail->setHeader('Reply-to', "noreply@patronet.hu");
		$mail->setHeader('X-Mailer', "PatroNet CMS");	
		
		if($smtp["host"] != "localhost"){
			$mail->setSMTPParams($smtp["host"], $smtp["port"], $smtp["host"],true,$smtp["user"],$smtp["password"]);
		} 		
		$result = $mail->send( array($recipient), 'smtp' );
		
		//echo $result;
	}
	
	public static function getDesigners ($showOnMap = false)
	{
		$filter = ["partner_category_id" => 11];
		if ($showOnMap) {
			$filter["show_on_map"] = 1;
		}
		return Partner::getRepository()->getAllByFilter($filter)->fetchAll();
	}

	public static function getDistributors ($showOnMap = false)
	{
		$filter = ["partner_category_id" => 12];
		if ($showOnMap) {
			$filter["show_on_map"] = 1;
		}
		return Partner::getRepository()->getAllByFilter($filter)->fetchAll();
	}

	public static function getServicePartners ($showOnMap = false)
	{
		$filter = ["partner_category_id" => 13];
		if ($showOnMap) {
			$filter["show_on_map"] = 1;
		}
		return Partner::getRepository()->getAllByFilter($filter)->fetchAll();
	}

	public static function getColors ()
	{
		return [
			"designers" => "#ed751c",
			"distributors" => "#226c8e",
			"servicePartners" => "#694193"
		];
	}

	public static function createPartner ($partnerData)
	{
		global $dbconn;
		$fields = "";
		$values = "";
		foreach ($partnerData as $key => $value) {
			$fields .= "$key,";
			$values .= "'$value',";
		}
		$sql = "INSERT INTO opey_pm_partners (".trim($fields,",").") VALUES (".trim($values,",").")";
		
		$dbconn->Execute($sql);
		echo $dbconn->ErrorMsg();
		return $dbconn->insert_ID();

	}
	
	function zip2city( $zip ){
		global $dbconn;
		if(substr($zip,0,1)=="1") return "Budapest";
		switch( substr($zip,0,2) ){
			case "35" :
				return "Miskolc";
				break;
			case "40" :
			case "42" :
				return "Debrecen";
				break;
			case "67" :
				return "Szeged";
				break;
			case "76" :
				return "Pécs";
				break;
			case "90" :
				return "Győr";
				break;
		}
		
		// otherwise
		$sql = "SELECT city FROM opey_pm_zip WHERE zip='$zip' ";
		$res = $dbconn->Execute($sql);
		$ret = array();
		while(list($city) = $res->fields){
			$ret[] = $city;
			$res->MoveNext();
		}
		return $ret;
	}
	
}