var geocoderApple;
var retLatObj,retLonObj;
var directions;
var directionRes;
var disableDirections = false;
var distInput;
$(function(){
	mapkit.init({
		authorizationCallback: function(done) {
 			done('eyJhbGciOiJFUzI1NiIsInR5cCI6IkpXVCIsImtpZCI6IkNRUzI1VDZRSzQifQ.eyJpc3MiOiIzQTlWVERTQ040IiwiaWF0IjoxNTcxMDM2MzAwLCJleHAiOjE3MDIyNzc5MDB9.wg2jMAZq7KUuMIJ2dZirTbd29r_JeB4tuh86VybUwYhYjTHLXnf7BRm4ZpUXDucVvgm3MUvwY3zuqR7VPf6wUQ');			
		}
	});
	geocoderApple = new mapkit.Geocoder({
		language: "hu",
		getsUserLocation: false
	});	
	directions = new mapkit.Directions();
});

var edit_type;
function getGeolocationMapkit(country, zip, city, street, housenum, latObj, lonObj, type){
	q = zip + " " + city + ", " + housenum + " "+ street +", " + country;
	console.log(q);
	//slog(q)
	//slog("q:"+q);
	retLatObj = latObj;
	retLonObj = lonObj;
	edit_type = type;
	geocoderApple.lookup(q, mapkitCallback);
};

var forceOpenMap = false;
function mapkitCallback(){
	console.log(arguments[1]);
	if(arguments[1]["results"].length == 0){
		//slog("no results, check for existing street name...");
		alert("Nincs találat a megadott címre");
	
	} else {
		//slog(arguments[1]);
		retLatObj.val(arguments[1]["results"][0].coordinate.latitude).change();
		retLonObj.val(arguments[1]["results"][0].coordinate.longitude).change();
		//openMap(retLatObj,retLonObj,edit_type)
		/*
		distInput = (edit_type=="client") ? $("#distance") : $("#site_distance") ;
		//slog(distInput)
		if(edit_type=="settings"){
			openMap(retLatObj,retLonObj,edit_type);
		} else {
			forceOpenMap = true;
			computeDirections( $("#warehouse_lat").val(),$("#warehouse_lon").val(),retLatObj.val(),retLonObj.val(),distInput );
		};
		*/
	};
};

var mapWin;
function openMap(latObj,lonObj,edit_type){
	mapWin = openWindow({
		name:"mapWin",
		title:"Lokáció a térképen - a jelölő áthelyezhető",
		width:700,
		height:650,
		handleCover:true
	});
	mapWin.progressOn();
	
	mapWin.latObj = latObj;
	mapWin.lonObj = lonObj;
	
	$.get("admin.php?module=EasyOrder&op=mapWindow&lat="+latObj.val()+"&lon="+lonObj.val()+"&edit_type="+edit_type, function(data){
		$("#mapWin_form").html(data);
		mapWin.progressOff();

		setTimeout(function(){
			tooltip();
		}, 300);
	});
	
	mapWin.attachEvent("onClose",function(win){
		if(edit_type == "client"){
			computeDirections($('#warehouse_lat').val(),$('#warehouse_lon').val(),$('#lat').val(),$('#lon').val(), $('#distance'));
		} else if(edit_type == "site") {
			computeDirections($('#warehouse_lat').val(),$('#warehouse_lon').val(),$('#site_lat').val(),$('#site_lon').val(), $('#site_distance'));
		};
		return true;
	});
};


// distance calculating
var directions_path;
var dirtimeout;
function directionsHandler(error, data, type) {
	console.log(data);
	if(data.routes.length < 1){
		alert("Nem sikerült útvonalat tervezni és távolságot kalkulálni a megadott címhez!");
		$(".recompute_distance").removeClass("loading");
		
		return;
	};
	directions_path = data.routes[0].polyline.points;
	meters = 0;
	data["routes"].forEach(function(route, routeIdx) {
		if (routeIdx !== 0) { return; };
		meters += route.distance;
	});
	slog("meters: "+meters);
	
	if($("#site_directions_path").length > 0){
		$("#site_directions_path").val(JSON.stringify(directions_path));
	} else {
		$("#directions_path").val(JSON.stringify(directions_path));
	};
	
	distInput.val(meters/1000);
	$(".recompute_distance").removeClass("loading");

	if(forceOpenMap){
		forceOpenMap = false;
		openMap(retLatObj,retLonObj,edit_type);
	};
	
	try{
		if(map){
			if(edit_type == "client"){
				drawDirections(map,$.parseJSON( $("#directions_path").val() ));
			} else if(edit_type=="site") {
				drawDirections(map,$.parseJSON( $("#site_directions_path").val() ));
			};
		}
	} catch(e){};
};

function computeDirections(latA,lonA,latB,lonB, distanceinput) {
	if(latA=="" || lonA=="" || latB=="" || lonB==""  ) return;
	distInput = distanceinput;
	$(".recompute_distance").addClass("loading");

	//slog(distInput);
	pointA = new mapkit.Coordinate(parseFloat(latA),parseFloat(lonA));
	pointB = new mapkit.Coordinate(parseFloat(latB),parseFloat(lonB));
	var directionsOptions = { 
		origin: pointA, 
		destination:  pointB, 
		transportType: mapkit.Directions.Transport.Automobile 
	};

	directions.route(directionsOptions, directionsHandler);
};

var firstpolyline;
var ttmarker;
var circle;
function drawDirections(map,dirpath){
	slog("draw");
	//slog(dirpath);
	points = Array();
	n= 0;
	$.each(dirpath,function(i,e){
		p = new L.LatLng(e.latitude, e.longitude);
		points.push(p);
		n++;
	});
	slog(n + " route points");
	
	clearMap();
	
	firstpolyline = new L.Polyline(points, {
		color: 'red',
		weight: 4,
		opacity: 0.7,
		smoothFactor: 1,
		interactive:false
	}).addTo(map);
	
	$(firstpolyline).on("mouseover",function(e){
	}).on("mouseleave",function(){
	});
};

function clearMap() {
    for(i in map._layers) {
        if(map._layers[i]._path != undefined) {
            try {
                map.removeLayer(map._layers[i]);
            }
            catch(e) {
                console.log("problem with " + e + map._layers[i]);
            };
        };
    };
};









