// JavaScript Document
//<![CDATA[
var map, circle, circleRadius, centerMarker, origin, geocoder;
var markers = [];
var blurbs = [];
var titles = [];
var C = 57.2958;
var ajaxp, dirTitle, directions, directionsPanel, dpJQ;
var refAdd, refRad, maxDist;
var btnFind, btnReset;
var locMatch;

var mc = new Object();
mc.mapLocation = "hungary";
mc.iconURL = "/parameters/magyararu.patronet/modules/MagyarAru/icons/";

var firstLoad = true;

// Things to do when the page is fully loaded
$(document).ready(function () {

    // Make it easy to access page elements
    ajaxp = $('#ajax-progress');
    refAdd = $('#reference-address');
    btnFind = $('#find-locations');
    btnReset = $('#reset-locations');

    // make sure the browser can handle Google Maps
    if (GBrowserIsCompatible()) {
        // set up Google Maps
        origin = new GLatLng(47.168928, 19.511719);
        map = new GMap2(document.getElementById("representative-map"));
        map.setCenter(origin, 7);
        map.addControl(new GSmallMapControl());
        map.addControl(new GMapTypeControl());
		var overviewMap = new GOverviewMapControl(new GSize(150,150));
		map.addControl(overviewMap);
		map.enableDoubleClickZoom();
		map.enableContinuousZoom();
		map.enableScrollWheelZoom();
		
		// autohide controls
		GEvent.addListener(map, "mouseover", function() {
			map.showControls();
		});
		GEvent.addListener(map, "mouseout", function() {
			map.hideControls();
		});
	

        geocoder = new GClientGeocoder();

        btnFind.click(findLocation);
        btnReset.click(resetMap);
		
		initMap()
		
    } else {
        alert('Az oldal megjelenítéséhez olyan modern böngészőre van szükség, amely támogatja Google Maps térképeket!');
    }
});
$(document).unload(GUnload);

// init the map with shop address
function initMap(){
	document.getElementById('reference-address').value = opDoc.getAddressForMap();
	findLocation();
}

function saveData(){
	var latS = document.getElementById("latbox").value;
	var lonS = document.getElementById("lonbox").value;
	opDoc.insertCoords(latS,lonS);
	thisWin.close();
}

function findLocation(){
	var isFree = 1;
	var search = document.getElementById('reference-address').value;
	var vMsg = "";
	var vZoom = "16";
	showAddress(isFree,search,vMsg,vZoom);
}


// ====== Create a Client Geocoder ======
var geo = new GClientGeocoder(new GGeocodeCache()); 
// ====== Array for decoding the failure codes ======
var reasons=[];
reasons[G_GEO_SUCCESS]            = "Rendben";
reasons[G_GEO_MISSING_ADDRESS]    = "Hiányzó cím: Nem adott meg címet a keresés mezőben.";
reasons[G_GEO_UNKNOWN_ADDRESS]    = "Ismeretlen cím:  Nem rendelhető földrajzi pont a megadott címhez.";
reasons[G_GEO_UNAVAILABLE_ADDRESS]= "A cím nem elérhető:  The geocode for the given address cannot be returned due to legal or contractual reasons.";
reasons[G_GEO_BAD_KEY]            = "Rossz kulcs: The API key is either invalid or does not match the domain for which it was given";
reasons[G_GEO_TOO_MANY_QUERIES]   = "Túl sok lekérés: The daily geocoding quota for this site has been exceeded.";
reasons[G_GEO_SERVER_ERROR]       = "Szerver hiba: The geocoding request could not be successfully processed.";



// ====== Geocoding ======

function showAddress(isFree,search,vMsg,vZoom) {

// ====== Perform the Geocoding ======        

/* 
var search = "Kossuth Lajos utca 15., Budapest";
*/
//alert(search)
search += ", Magyarország";
geo.getLocations(search, function (result)
  {
	if (result.Status.code == G_GEO_SUCCESS) {
	  // ===== If there was more than one result, "ask did you mean" on them all =====
	  if (result.Placemark.length > 1) { 
		var msg = "<table cellpadding=2 cellspacing=0><tr><td style='font-size:11px;background-color:red; padding:2px;color:white; font-weight:bold' colspan=2>Melyik legyen?</td></tr>" ;
		// Loop through the results
		for (var i=0; i<result.Placemark.length; i++) {
		  var p = result.Placemark[i].Point.coordinates;
			if(i==1){ 
			x = dump(result.Placemark[i].AddressDetails );
			};
		 
		 var addr = parseAddress(result.Placemark[i]);
		 msg += "<tr><td valign=top style='font-size:11px;padding:2px; '>"+(i+1)+":</td><td><a href='javascript:place(" +p[1]+","+p[0]+",\""+ addr +"\""+")' style='font-size:11px'>"+ result.Placemark[i].address+"</a></td></tr>";
		}
		msg += "</table>";
		showDidYouMeanList( msg );
		// show BIG ARROW...
		//showBigArrow();
	  }
	  // ===== If there was a single marker =====
	  else {
		opDoc.showDidYouMeanDiv("");
		var p = result.Placemark[0].Point.coordinates;
		
		msg = parseAddress(result.Placemark[0]);
		
		// if have vMsg message string, change msg to it
		msg += "<br>" + "lat:"+p[1] + ", lng:"+p[0];
			
		
		// if zoom declared, add it
		if(vZoom){
			place(p[1],p[0],msg,vZoom);
		} else {
			place(p[1],p[0],msg);
		}
	}
	}
	// ====== Decode the error status ======
	else {
	  var reason="Code "+result.Status.code;
	  if (reasons[result.Status.code]) {
		reason = reasons[result.Status.code]
	  } 
	  var errorStr = '' + reason + "\n";
	  if(parent.document.getElementById("kerulet")){
		if(parent.document.getElementById("kerulet").value==0){
			errorStr += "\nPróbálja a kerület lista használatával listázni az utcákat,\nvagy gépeléskor, a beviteli mező alatt megjelenő listából válasszon!\n\n"; 
		}
	  }
	  alert(errorStr);
	}
	});
}


function parseAddress(addressObj){
	 //alert(dump(addressObj)) ;
    /*
	'id' => "p1"
    'address' => "Ady Endre utca 1, 1039 III. kerület, Budapest, Hungary"
    'AddressDetails' ...
        'Country' ...
            'CountryNameCode' => "HU"
            'AdministrativeArea' ...
                'AdministrativeAreaName' => "Budapest"
                'Locality' ...
                    'LocalityName' => "Budapest"
                    'DependentLocality' ...
                        'DependentLocalityName' => "III. kerület"
                        'Thoroughfare' ...
                            'ThoroughfareName' => "Ady Endre utca 1"
                        'PostalCode' ...
                            'PostalCodeNumber' => "1039"
        'Accuracy' => "8"
    'Point' ...
        'coordinates' ...
            '0' => "19.060257"
            '1' => "47.584671"
            '2' => "0"

	*/

	var ret = "";
	// budapest geocode parser
	if(mc.mapLocation == "budapest" ){
		try{
			if(addressObj.AddressDetails.Country.AdministrativeArea){
				if(addressObj.AddressDetails.Country.AdministrativeArea.Locality.DependentLocality){
					if(addressObj.AddressDetails.Country.AdministrativeArea.Locality.DependentLocality.Thoroughfare) ret += "<h5>"+addressObj.AddressDetails.Country.AdministrativeArea.Locality.DependentLocality.Thoroughfare.ThoroughfareName +"</h5><br>";
					ret += "<i>"+addressObj.AddressDetails.Country.AdministrativeArea.Locality.DependentLocality.DependentLocalityName + "</i>";
				}
				if(addressObj.AddressDetails.Country.AdministrativeArea.Locality.DependentLocality){
					if(addressObj.AddressDetails.Country.AdministrativeArea.Locality.LocalityName != addressObj.AddressDetails.Country.AdministrativeArea.Locality.DependentLocality.DependentLocalityName) ret += "<br> "+addressObj.AddressDetails.Country.AdministrativeArea.Locality.LocalityName;
					if(addressObj.AddressDetails.Country.AdministrativeArea.Locality.DependentLocality.PostalCode) ret += " "+addressObj.AddressDetails.Country.AdministrativeArea.Locality.DependentLocality.PostalCode.PostalCodeNumber;
				} else {
					
				}
			}
		} catch(err){
			//alert(err)	
		}
	}
	//alert(addressObj.Point.coordinates[0])
	
	// hungary geocoder parser
	if(mc.mapLocation == "hungary"){
		try{ 
			if(addressObj.AddressDetails.Country.AdministrativeArea){
			try{ if(addressObj.AddressDetails.Country.AdministrativeArea.Locality.Thoroughfare) ret += "<h5>"+ addressObj.AddressDetails.Country.AdministrativeArea.Locality.Thoroughfare.ThoroughfareName + "</h5><br>"} catch(err){};
			try{ if(addressObj.AddressDetails.Country.AdministrativeArea.Locality.PostalCode)ret += ""+addressObj.AddressDetails.Country.AdministrativeArea.Locality.PostalCode.PostalCodeNumber + " "} catch(err){};
			try{ if(addressObj.AddressDetails.Country.AdministrativeArea.Locality) ret += ""+addressObj.AddressDetails.Country.AdministrativeArea.Locality.LocalityName + "<br>"} catch(err){};
			try{ ret += "<i>"+ addressObj.AddressDetails.Country.AdministrativeArea.AdministrativeAreaName+" megye</i>"} catch(err){};
		}
		} catch(err){}
		//var xxx = popWindow('xx');
		//xxx.document.write("<pre>"+dump(addressObj.AddressDetails)+"</pre>");
	}
	
	ret += "<br><br>";
	
	
	return ret;
}




function place(szel,hossz, infoWindowMessage){
	// clear previous placemarks from the map...
	var mZoom = place.arguments[3];
	var mType = place.arguments[4];
	if(!mZoom) mZoom = 13;
	mZoom = parseInt(mZoom);
	if(!mType) mType = "map";
	//alert(place.arguments[3]);
	switch(mType){
		case "map" :
			tConst = G_NORMAL_MAP;
			break;
		case "sat" :
			tConst = G_SATELLITE_MAP;
			break;
		case "hyb" :
			tConst = G_HYBRID_MAP;
			break;
	}
	map.clearOverlays(); 
	
	// create GPoint from  data
	var point = new GLatLng(szel,hossz);
	
	// define marker icon
/*	var icon_small = new GIcon();
	icon.image = "http://labs.google.com/ridefinder/images/mm_20_red.png";
	icon.shadow = "http://labs.google.com/ridefinder/images/mm_20_shadow.png";
	icon.iconSize = new GSize(12, 20);
	icon.shadowSize = new GSize(22, 20);
	icon.iconAnchor = new GPoint(6, 20);
	icon.infoWindowAnchor = new GPoint(5, 1);
*/
	
	var ifoWindowIcons = [
		mc.iconURL + "infoWindow/send.png",
		mc.iconURL + "infoWindow/move.png"	  
	];
	
	var icon = new GIcon();
	icon.image = mc.iconURL + "pink.png";
	icon.shadow = mc.iconURL + "shadow50.png";
	icon.iconSize = new GSize(32, 32);
	icon.shadowSize = new GSize(40, 32);
	icon.iconAnchor = new GPoint(16, 32);
	icon.infoWindowAnchor = new GPoint(15, 0);      
	
	// marker images
	var markerImage = [
		mc.iconURL + "red-dot.png", // 0
		mc.iconURL + "dd-start.png",//1 start
		mc.iconURL + "dd-pause.png",//2 pause
		mc.iconURL + "dd-end.png",//3 stop
		
		mc.iconURL + "pink-dot.png",//4 
		mc.iconURL + "blue-dot.png",//5 
		mc.iconURL + "ltblue-dot.png",//6 
		mc.iconURL + "yellow-dot.png",//7 
		mc.iconURL + "green-dot.png",//8 
		mc.iconURL + "purple-dot.png",//9 
		
		mc.iconURL + "pink.png",//10 
		mc.iconURL + "blue.png",//11 
		mc.iconURL + "yellow.png",//12 
		mc.iconURL + "green.png",//13 
		mc.iconURL + "purple.png",//14 
		mc.iconURL + "red.png"//15
	];
	

	// create GMarker object, an add to the map
	var marker = new GMarker(point, {draggable: true, icon:icon});
	document.marker = marker;
	map.addOverlay(marker);
	marker.setImage(markerImage[0]);
	
	GEvent.addListener(marker,'mouseover',function(){
		marker.setImage(markerImage[7]);
	});
	GEvent.addListener(marker,'mouseout',function(){
		marker.setImage(markerImage[0]);
	});
	
	GEvent.addListener(marker,'dragfominfowindow',function(){
		GEvent.trigger(marker,"mouseover");
		map.closeInfoWindow();
		showDragHelp(marker);
		//marker.startdrag;
	});

	// set the center point of the map, around the current point
	//map.setCenter(point,15);
	map.setCenter(point,mZoom,tConst);
	
	// save new position for later recall
	map.savePosition();
	
	document.lastPointLat = szel;
	document.lastPointLng = hossz;
	document.lastPointHTML = infoWindowMessage;
	
	document.lastPlace = new Array()
	document.lastPlace['lat'] = szel;
	document.lastPlace['lng'] = hossz;
	document.lastPlace['html'] = infoWindowMessage;
	document.lastPlace['mod'] = false;

	infoWindowMessageHTML = "<div id='infoWindowContentDiv' style='background-color:#ffffff; '>" + infoWindowMessage +"</div>";
	infoWindowMessageHTML += "<div id='currPosition' style='border-top:1px solid #cccccc; background-color:white;padding-top:3px'></div>";
	infoWindowMessageHTML += "&nbsp;&nbsp;<a href='javascript:;' onclick='doMove();' style='font-size:10px' title='Áthelyezem a pontot'><img height=12 width=16 align=absmiddle border=0 src='"+ifoWindowIcons[1]+"'> Áthelyezem</a>";
	infoWindowMessageHTML += "</div>";
	infoWindowMessageHTML = "";
	
	var point = marker.getLatLng();
	marker.openInfoWindowHtml(marker.getLatLng().toUrlValue(6));
	computepos (point);

	GEvent.addListener(marker, "dragstart", function() {  map.closeInfoWindow();  });
	GEvent.addListener(marker, "click", function() {  
		var pointStr = marker.getPoint(); 
		marker.openInfoWindowHtml(infoWindowMessageHTML);  
		//window.parent.showMessage( pointStr ) 
        markerContext.style.visibility="hidden";

	});			  
	GEvent.addListener(marker, "dragend", function() {  
		var pointStr = marker.getPoint(); 
		
		var point = marker.getLatLng();
		marker.openInfoWindowHtml(marker.getLatLng().toUrlValue(6));
		computepos (point);
		/*
		//document.getElementById("infoWindowContentDiv").innerHTML = "<i>Módosított pozíció</i><br>" + document.getElementById("infoWindowContentDiv").innerHTML;
		if(!document.lastPlace['mod']) infoWindowMessage = "<i>Módosított pozíció</i><br>"+infoWindowMessage;
		infoWindowMessageHTML = "<div id='infoWindowContentDiv' onselectstart='return true;' contenteditable='true' style='width:250px; padding:3px; border: 2px inset; background-color:#ffffff; '>" + infoWindowMessage ;
		infoWindowMessageHTML += "</div>";
		infoWindowMessageHTML += "&nbsp;&nbsp;<a href='javascript:;' onclick='doMove();' style='font-size:10px' title='Áthelyezem a pontot'><img height=12 width=16 align=absmiddle border=0 src='"+ifoWindowIcons[1]+"'> Áthelyezem</a>";
		infoWindowMessageHTML += "</div>";
	
		marker.openInfoWindowHtml(infoWindowMessageHTML);
		
		*/
		document.lastPlace = new Array()
		document.lastPlace['lat'] = marker.getPoint().lat();
		document.lastPlace['lng'] = marker.getPoint().lng();
		document.lastPlace['html'] = infoWindowMessage;
		document.lastPlace['mod'] = true;
		GEvent.addListener(marker,'mouseout',function(){
			marker.setImage(markerImage[15]);
		});
		GEvent.addListener(marker,'mouseover',function(){
			marker.setImage(markerImage[12]);
		});
			
	});		  
	 
	//marker.openInfoWindowHtml(infoWindowMessageHTML); 
	
	
	GEvent.addListener(marker,"contextmenu",function(pixel,tile) {
		// store the "pixel" info in case we need it later
		// adjust the context menu location if near an egde
		// create a GControlPosition
		// apply it to the context menu, and make the context menu visible
		markerContext.clickedPixel = pixel;
		var x=pixel.clientX;
		var y=pixel.clientY;
		if (x > map.getSize().width - 120) { x = map.getSize().width - 120 }
		if (y > map.getSize().height - 100) { y = map.getSize().height - 100 }
		var pos = new GControlPosition(G_ANCHOR_TOP_LEFT, new GSize(x,y));  
		pos.apply(markerContext);
		markerContext.style.visibility = "visible";
	});
	var center = map.getCenter(); 
	
//**************************************************************
// === create the context menu div ===
//**************************************************************
      // === Global variable that can be used by the context handling functions ==
      var clickedPixel; 
      
	  var markerContext = document.createElement("div");
      markerContext.style.visibility="hidden";
      markerContext.style.background="#ffffff";
      markerContext.style.border="1px solid #8888FF";
      markerContext.style.padding="0px";
	  markerContext.id = "markerContext";
      markerContext.style.cursor="pointer";

	  markerContext.innerHTML = '<div  id="contextItem" style="padding:3px" onMouseOver="ctxStyle(this,\'over\')" onmouseout="ctxStyle(this,\'out\')" onclick="javascript:zoomIn();">Nagyít</div>'
								+ '<div id="contextItem"  style="padding:3px"  onMouseOver="ctxStyle(this,\'over\')" onmouseout="ctxStyle(this,\'out\')"  onclick="javascript:zoomOut()" >Kicsinyít</div>';

      map.getContainer().appendChild(markerContext);

      // === functions that perform the context menu options ===
      // === If the user clicks on the map, close the context menu ===
      GEvent.addListener(map, "click", function() {
        markerContext.style.visibility="hidden";
      });
//**************************************************************
// === create the context menu div ===
//**************************************************************
	  
//window.parent.showMessage( center.toString() );		

}		
      function zoomIn() {
		var markerContext = document.getElementById("markerContext");
		// perform the requested operation
        map.zoomIn();
        // hide the context menu now that it has been used
        markerContext.style.visibility="hidden";
      }      
      function zoomOut() {
		var markerContext = document.getElementById("markerContext");
        // perform the requested operation
        map.zoomOut();
        // hide the context menu now that it has been used
        markerContext.style.visibility="hidden";
      }      
      function zoomInHere() {
		var markerContext = document.getElementById("markerContext");
        // perform the requested operation
        var point = map.fromContainerPixelToLatLng(markerContext.clickedPixel)
        map.zoomIn(point,true);
        // hide the context menu now that it has been used
        markerContext.style.visibility="hidden";
      }      
      function zoomOutHere() {
		var markerContext = document.getElementById("markerContext");
        // perform the requested operation
        var point = map.fromContainerPixelToLatLng( markerContext.clickedPixel)
        map.setCenter(point,map.getZoom()-1); // There is no map.zoomOut() equivalent
        // hide the context menu now that it has been used
        markerContext.style.visibility="hidden";
      }     
	  
	
	function doMove(){
		GEvent.trigger(document.marker,"dragfominfowindow");
	}
	
	function showDragHelp(oObj){
		var dragHelp = document.createElement("div");
		dragHelp.style.visibility="hidden";
		dragHelp.style.background="#ffffff";
		dragHelp.style.border="1px solid #8888FF";
		dragHelp.style.padding="4px";
		dragHelp.id = "dragHelp";
		dragHelp.style.cursor="pointer";
		
		dragHelp.innerHTML = '<div>Kattintson a pontba, és húzza a kívánt helyre a pontot!</div>'
		
		map.getContainer().appendChild(dragHelp);
		var x = 100;
		var y = 100;
		var pos = new GControlPosition(G_ANCHOR_TOP_LEFT, new GSize(x,y));  
		pos.apply(markerContext);
		
		document.getElementById("dragHelp").style.visibility = "visible";
	
	}

	function ctxStyle(oObj,to){
		if(to=="out"){
			oObj.style.cssText = "background-color:menu;color:menuText;padding:3px;";
		} else {
			oObj.style.cssText = "background-color:Highlight ;color:HighlightText;padding:3px;";
		}
	}




function resetMap() {
    // Reset the map and overlays
    //ajaxp.fadeIn();
    map.setZoom(7);
    map.panTo(origin);
   // map.removeOverlay(circle);
   // map.removeOverlay(centerMarker);
    map.closeInfoWindow();
   for (var m = 0; m < markers.length; m++) {
        var mkr = markers[m];
        if (mkr.isHidden()) { mkr.show(); }
    }

}

function showDidYouMeanList(msg){
	opDoc.showDidYouMeanDiv(msg);
}

function closeDidYouMeanDiv(){
	$('#DidYouMeanDiv').fadeOut('slow');
}

// compute point into degrees, percent and seconds
function computepos (point)
{
	var latA = Math.abs(Math.round(value=point.y * 1000000.));
	var lonA = Math.abs(Math.round(value=point.x * 1000000.));
	
	if(value=point.y < 0)
	{
		var ls = '-' + Math.floor((latA / 1000000));
	}
	else
	{
		var ls = Math.floor((latA / 1000000));
	}
	
	var lm = Math.floor(((latA/1000000) - Math.floor(latA/1000000)) * 60);
	var ld = ( Math.floor(((((latA/1000000) - Math.floor(latA/1000000)) * 60) - Math.floor(((latA/1000000) - Math.floor(latA/1000000)) * 60)) * 100000) *60/100000 );
	
	if(value=point.x < 0)
	{
	  var lgs = '-' + Math.floor((lonA / 1000000));
	}
	else
	{
		var lgs = Math.floor((lonA / 1000000));
	}
	
	var lgm = Math.floor(((lonA/1000000) - Math.floor(lonA/1000000)) * 60);
	var lgd = ( Math.floor(((((lonA/1000000) - Math.floor(lonA/1000000)) * 60) - Math.floor(((lonA/1000000) - Math.floor(lonA/1000000)) * 60)) * 100000) *60/100000 );
	
	
	document.getElementById("latbox").value=point.y;
	document.getElementById("lonbox").value=point.x;
	var latR = "<i>("+ls + "º " + lm + "' " + ld + '" )';
	var lonR = "<i>("+lgs + "º " + lgm + "' " + lgd + '" )';
	
	document.getElementById("latRbox").innerHTML = latR;
	document.getElementById("lonRbox").innerHTML = lonR;
	
	
	
	/*
	document.getElementById("latboxm").value=ls;
	document.getElementById("latboxmd").value=lm;
	document.getElementById("latboxms").value=ld;
	
	document.getElementById("lonboxm").value=lgs;
	document.getElementById("lonboxmd").value=lgm;
	document.getElementById("lonboxms").value=lgd;
	*/
}

//]]>