
var MTA_basket = new Object();

MTA_basket.url = "index.php?name=MagyarAru&todo=basket_handler";
MTA_basket.datas = [];
MTA_basket.success = function(){};
MTA_basket.error = function(){};
MTA_basket.error_handler = function (objAJAXRequest, strError){
       switch (strError) {
        case "timeout":
            alert("Kosárkezelő: időtúllépési hiba!");
        break;
        case "error":
            alert("Kosárkezelő: hiba a lekérdezés folyamán!");
        break;
        default:
            alert("Kosárkezelő: ismertelen hiba!");
        }
        MTA_basket.error();
    }

MTA_basket.load = function() {
    $.ajax({
            method: "post",
            url: this.url+"&func=list",
            data: {},
            dataType: "json",
            timeout: (10*1000),
            error: this.error_handler,
            success: function (data) {
                    MTA_basket.datas = data;
                    MTA_basket.success("load");
                }
        });
    return true;
}

MTA_basket.add = function (product_id,shop_id) {
    if (this.has_product(product_id)) {
        if (this.has(product_id,shop_id)) {
            alert("Ennek a boltnak ez a terméke már szerepel a kosárban!");
            return false;
        } else if (!confirm("Ez a termék már szerepel a kosárban egy másik boltból. Kívánja felülírni?")) {
            return false;
        }
    }
    var post_query = {product_id:product_id,shop_id:shop_id};
    $.ajax({
            method: "post",
            url: this.url+"&func=add",
            data: post_query,
            dataType: "json",
            timeout: (10*1000),
            error: this.error_handler,
            success: function (data) {
                    if (is_empty(data)) {
                        alert("Kosárkezelő: a termék nem található!");
                        MTA_basket.error();
                    } else {
                        if (MTA_basket.has_product(data.id)) {
                            for (var i=0; i<MTA_basket.datas.length; i++) {
                                if (MTA_basket.datas[i].id==data.id) {
                                    MTA_basket.datas.splice(i,1);
                                }
                            }
                        }
                        MTA_basket.datas[MTA_basket.datas.length] = data;
                        MTA_basket.success("add");
                    }
                }
        });
    return true;
}

MTA_basket.remove = function (product_id,shop_id) {
    var post_query = {product_id:product_id,shop_id:shop_id};
    $.ajax({
            method: "post",
            url: this.url+"&func=remove",
            data: post_query,
            dataType: "text",
            timeout: (10*1000),
            error: this.error_handler,
            success: function (data) {
                    if (data.substr(0,2)=="ok") {
                        var numbers = data.substr(3).split(",");
                        for (var i=0; i<MTA_basket.datas.length; i++) {
                            if (MTA_basket.datas[i].id==numbers[0] && MTA_basket.datas[i].shop_id==numbers[1]) {
                                MTA_basket.datas.splice(i,1);
                                break;
                            }
                        }
                        MTA_basket.success("remove");
                    } else {
                        alert("Kosárkezelő: hiba a törlés során!");
                        MTA_basket.error();
                    }
                }
        });
    return true;
}

MTA_basket.has = function (product_id,shop_id) {
    for (var i=0; i<this.datas.length; i++) {
        if (this.datas[i].id==product_id && this.datas[i].shop_id==shop_id) {
            return true;
        }
    }
    return false;
}

MTA_basket.has_product = function (product_id) {
    for (var i=0; i<this.datas.length; i++) {
        if (this.datas[i].id==product_id) {
            return true;
        }
    }
    return false;
}

MTA_basket.has_shop = function (shop_id) {
    for (var i=0; i<this.datas.length; i++) {
        if (this.datas[i].shop_id==shop_id) {
            return true;
        }
    }
    return false;
}

MTA_basket.empty = function () {
    $.ajax({
            method: "post",
            url: this.url+"&func=empty",
            data: {},
            dataType: "text",
            timeout: (10*1000),
            error: this.error_handler,
            success: function (data) {
                    if (data=="ok") {
                        MTA_basket.datas = [];
                        MTA_basket.success("empty");
                    } else {
                        alert("Kosárkezelő: hiba a kosár ürítése során!");
                        MTA_basket.error();
                    }
                }
        });
    return true;
}
