var mc = Object();
mc.mapLocation = "hungary" ;
mc.iconURL = "/parameters/magyararu.patronet/modules/MagyarAru/icons/";
var map, circle, circleRadius, centerMarker, origin, geocoder, markers;
var markers = Object();
var  directions, directionsPanel;

var map = null;
var geocoder = null;

var scriptpath = "/parameters/magyararu.patronet/modules/MagyarAru/javascript/";


function initialize() {
	// for some reason, pulling this back with jQuery doesn't work with the API
	directionsPanel = document.getElementById("location-directions");
  if (GBrowserIsCompatible()) {
	map = new GMap2(document.getElementById("result_map_div"));
	origin = new GLatLng(47.168928, 19.511719);

	map.setCenter(origin, 7);
	
	
	map.setCenter(origin, 7);
	map.addControl(new GLargeMapControl(), new GControlPosition(G_ANCHOR_TOP_LEFT, new GSize(7, 90)));
	map.addControl(new GMapTypeControl());

	var overviewMap = new GOverviewMapControl(new GSize(150,150));
	map.addControl(overviewMap);
	map.addControl(new GScaleControl());

	map.enableDoubleClickZoom();
	map.enableContinuousZoom();


	/* LOGO:BEGIN */
	var logoDiv = document.createElement("div");
	logoDiv.style.cssText = "position:absolute; left: -3px;top:0px; width:10px; height:25px; ";
	logoDiv.innerHTML = "<img src='/parameters/magyararu.patronet/modules/MagyarAru/images/patronet_logo.png' align='absmiddle'>";
	logoDiv.id = "logoDiv";
	/* LOGO:END */
	
	/* MSZ LOGO:BEGIN */
	var MSZlogoDiv = document.createElement("div");
	MSZlogoDiv.style.cssText = "position:absolute; left: 14px;top:5px; width:10px; height:25px; ";
	MSZlogoDiv.innerHTML = "<img src='/parameters/magyararu.patronet/modules/MagyarAru/templates/images/magyar-cimer-MSZ-map.png' align='absmiddle'>";
	MSZlogoDiv.id = "MSZlogoDiv";
	/* MSZ LOGO:END */
	document.getElementById("result_map_div").appendChild(MSZlogoDiv);

	// autohide controls
	GEvent.addListener(map, "mouseover", function() {
		map.showControls();
	});
	GEvent.addListener(map, "mouseout", function() {
		map.hideControls();
	});
	
	// for getting driving directions
	directions = new GDirections(map, directionsPanel);
	
	geocoder = new GClientGeocoder();
	$(document).unload(GUnload);
	
  }
}

function getLocationLatLng(address) {
  if (geocoder) {
	geocoder.getLatLng(
	  address,
	  function(point) {
		if (!point) {
			alert(address + " nem található");
		} else {
			var ret = Array();
			ret['lat'] = point.lat();
			ret['lng'] = point.lng();
			search_in_location(ret);
		}
	  }
	);
  }
}
	
$(document).ready(initialize);


function showLocationsOnMap(markers, centerObj, searchType, locationType){
	//alert(dump(markers));	
	//alert(dump(centerObj));	
	//alert("searchType: "+searchType+", locationType: "+locationType)
	//alert(markers.length)
	resetMap()
	
	// if we search in a specified radius, 
	// draw a circle on a map, with given parameters
	if(locationType == "circle"){
		cpoint = origin = new GLatLng(centerObj['lat'], centerObj['lng']);
		centerMarker = createMarker(cpoint, 10000, map.getCenter(), 8, false, "A keresés középpontja");
		map.addOverlay(centerMarker);
		doDrawCircle(cpoint, centerObj['radius']);
	}
	
	// declare, if the bubble's content get dynamically
	if(searchType == "product" || searchType == "shop"){
		var dynContent = false;
	} else {
		var dynContent = true;
	}
	
	// show the markers
	with (Math) {
		for (var z = 0; z < markers.length; z++) {
			var point = new GLatLng(markers[z].lat, markers[z].lng);
			if(is_array(markers[z].products)){isTabbed=true;} else {isTabbed=false}
			markers[z] = createMarker(point, z, markers[z], 16, isTabbed, markers[z].label, dynContent, searchType);
			map.addOverlay(markers[z]);
		}
	}
}

// create a marker on the map
function createMarker(point, number, loc, iconNo, isTabbed, title, isDynamicContent, searchType) {
	//var icon = createMarker.arguments[3]; 
    // Add a marker overlay to the map and store various bits of info about it
	var icon = new GIcon();
	// marker images
	var markerImage = [
		mc.iconURL + "red-dot.png", // 0
		mc.iconURL + "dd-start.png",//1 start
		mc.iconURL + "dd-pause.png",//2 pause
		mc.iconURL + "dd-end.png",//3 stop
		
		mc.iconURL + "pink-dot.png",//4 
		mc.iconURL + "blue-dot.png",//5 
		mc.iconURL + "ltblue-dot.png",//6 
		mc.iconURL + "yellow-dot.png",//7 
		mc.iconURL + "green-dot.png",//8 
		mc.iconURL + "purple-dot.png",//9 
		
		mc.iconURL + "pink.png",//10 
		mc.iconURL + "blue.png",//11 
		mc.iconURL + "yellow.png",//12 
		mc.iconURL + "green.png",//13 
		mc.iconURL + "purple.png",//14 
		mc.iconURL + "red.png",//15
		mc.iconURL + "hun-dot.png"//16
	];
	if(!iconNo) iconNo = 15
	icon.image = markerImage[iconNo];
	icon.shadow = mc.iconURL + "shadow50.png";
	icon.iconSize = new GSize(32, 32);
	icon.shadowSize = new GSize(40, 32);
	icon.iconAnchor = new GPoint(16, 32);
	icon.infoWindowAnchor = new GPoint(15, 0);      

	var marker = new GMarker(point , { icon:icon, title:title});

	marker.value = number;
	marker.id = loc.id;
	
	// if the content will get dynamically, push to marker some extended date
	if(isDynamicContent){
		marker.isDynamic = true;	
		GEvent.addListener(marker, "click", function() {
			document.nozoom = true;
			openMarkerInfoWindow(loc.id);
		});
	}
	marker.type = searchType;

    // The only time we shouldn't have a representative is when it's the address
    // entered by the user
	try{
		if (loc.approved) {
			// Setup the blurb for the marker's info box
			var chain2print = (loc.chain_id != 0) ? loc.chain_label : "";
			var myHtml = '<div style="text-align:left"><font class="mapBubbleTitle">' + loc.label + '</font><br>';
			myHtml += '<div>' + loc.address +'</div>';
			myHtml += '<div>' + loc.place_nev_utf + ', ';
			myHtml += loc.zipcode + '</div>';
			
			// Only show the telephone number if it's available
			try{
				if (loc.telephone.length) {
					myHtml += '<div><strong>Tel.</strong>: ' + loc.telephone + '</div>';
				}
			} catch(e){}
	
			// Only show the fax number if it's available
			try{
				if (loc.fax.length) {
					myHtml += '<div><strong>Fax</strong>: ' + loc.fax + '</div>';
				}
			} catch(e){}
	
			// Only show the website if it's available
			try{
				if (loc.website.length) {
					if(loc.website.indexOf("http://") > -1) loc.website = "http://" + loc.website;
					myHtml += '<div><strong>Honlap</strong>: <a href="'+loc.website+'" target="_blank">' + loc.website + '</a></div>';
				}
			} catch(e){}
	
			// Only show the email if it's available
			try{
				if (loc.email.length) {
					myHtml += '<div><strong>E-mail</strong>: <a href="mailto:'+loc.email+'">' + loc.email + '</a></div>';
				}
			} catch(e){}
			myHtml += "</div>";
			
			// push the ID
			marker.id = loc.id;
			
			if(isTabbed === true){
				// Create an array that will hold the tabs
				var tabs = [];
				// Create tabs and add them to the array
				tabs.push(new GInfoWindowTab('Üzlet', myHtml));
				tab2html = '<div id="m'+loc.id+'" style="width:250px; text-align:left; overflow-x:hidden; overflow-y:auto; height:100px;">Betöltés...</div>'
				tabs.push(new GInfoWindowTab('Termékek', tab2html));
	
				// Add a listener to pop up an info box when the mouse goes over a marker
				GEvent.addListener(marker, "click", function() {
					marker.openInfoWindowHtml(tabs);
				});
				marker.tabs = tabs;
				GEvent.addListener(marker, "infowindowopen", function() {
					var tDiv = document.getElementById("m"+this.id);
					// load products, only if isn't loaded
					if(!tDiv.isLoaded) {
						view_products(loc['products'], changeTabContent, marker.id);
					}
				});
			} else {
				// Add a listener to pop up an info box when the mouse goes over a marker
				GEvent.addListener(marker, "click", function() {
					marker.openInfoWindowHtml(myHtml);
				});
				marker.myHtml = myHtml;
				
			}
			marker.isTabbed = isTabbed;
		}
	} catch(e){}
	
	markers[marker.id] = marker;
	
    return marker;
}


function changeTabContent(pArr){
	//alert("pArr: \n" + dump(pArr['products']));
	//alert("pArr['data']: \n" + pArr['data']);
	var tDiv = document.getElementById("m"+pArr['data']);
	tDiv.isLoaded = true;
	var tabCnt = "<div class='mapBubbleTitle'><b>Magyar termékek a boltban:</b></div>";
	for(i=0; i<pArr['products'].length; i++ ){
		prod = pArr['products'][i]; 
		tabCnt += "<b>" + prod['label'] + "</b>";
		if(prod['portion'].length > 0) tabCnt += " (" +prod['portion'] + ")";
		tabCnt += "<br>";
		tabCnt += "<i>Gyártó: " + prod['manufacturers_label'] + "</i><br>";
		tabCnt += "<div style='clead:both; margin-bottom:3px; border-bottom:1px solid #cccccc'></div>";
	}
	tabCnt += "</div>";
	tDiv.innerHTML = tabCnt;

}

function openMarkerInfoWindow(mID){
		// if the conten is dynamic, we get it with an other method...
		if(markers[mID].isDynamic){
			//alert(markers[mID].isDynamic)
			view_item(mID, markers[mID].type, showDynInfowindowContent);
			return;
		}
		
		if(markers[mID].isTabbed){
			markers[mID].openInfoWindowHtml(markers[mID].tabs);
		} else {
			markers[mID].openInfoWindowHtml(markers[mID].myHtml);
		}
		scroll2map();
		if(document.nozoom){
			document.nozoom = false;	
		} else {
			map.setZoom(15);
			document.nozoom = false;	
		}
		
		map.panTo(markers[mID].getLatLng());
}

//***************************************************/
// get data, and sow it in a pretty bubble on the map
//***************************************************/
function showDynInfowindowContent(loc){
	//alert("showDynInfowindowContent(loc):"+dump(loc));
	var myHtml = '<div style="text-align:left"><font class="mapBubbleTitle">' + loc.label + '</font><br>';
	myHtml += '<div>' + loc.address +'</div>';
	myHtml += '<div>' + loc.place_nev_utf + ', ';
	myHtml += loc.zipcode + '</div>';
	
	// Only show the telephone number if it's available
	try{
		if (loc.telephone.length) {
			myHtml += '<div><strong>Tel.</strong>: ' + loc.telephone + '</div>';
		}
	} catch(e){}

	// Only show the fax number if it's available
	try{
		if (loc.fax.length) {
			myHtml += '<div><strong>Fax</strong>: ' + loc.fax + '</div>';
		}
	} catch(e){}

	// Only show the website if it's available
	try{
		if (loc.website.length) {
			if(loc.website.indexOf("http://") > -1) loc.website = "http://" + loc.website;
			myHtml += '<div><strong>Honlap</strong>: <a href="'+loc.website+'" target="_blank">' + loc.website + '</a></div>';
		}
	} catch(e){}

	// Only show the email if it's available
	try{
		if (loc.email.length) {
			myHtml += '<div><strong>E-mail</strong>: <a href="mailto:'+loc.email+'">' + loc.email + '</a></div>';
		}
	} catch(e){}
	myHtml += "</div>";
	
	try{
		if(loc.description.length > 0){
			haveDesc = true;	
		} else {
			haveDesc = false;	
		}
	} catch(e){
		haveDesc = false;	
	}
	if(haveDesc){
		// Create an array that will hold the tabs
		var tabs = [];
		// Create tabs and add them to the array
		tabs.push(new GInfoWindowTab('Adatok', myHtml));
		tab2html = '<div id="m'+loc.id+'" style="width:250px; text-align:left; overflow-x:hidden; overflow-y:auto; height:100px;">'+loc.description+'</div>'
		tabs.push(new GInfoWindowTab('Leírás', tab2html));
		markers[loc.id].openInfoWindowHtml(tabs);
	} else {
		markers[loc.id].openInfoWindowHtml(myHtml);
	}
	
	scroll2map();
	if(document.nozoom){
		document.nozoom = false;	
	} else {
		map.setZoom(15);
		document.nozoom = false;	
	}
	map.panTo(markers[loc.id].getLatLng())
}

function scroll2map(){
	var rm =document.getElementById('result_map_div');
	var mTop = rm.offsetTop - 13;
	//scroll(0,mTop);
	$.scrollTo( { top:mTop, left:0}, 900 )
	return false;

}

// Source: http://maps.forum.nu/gm_sensitive_circle2.html
function doDrawCircle(centerPoint,radius) {
    if (circle) {
        map.removeOverlay(circle);
    }
	
	if(centerPoint){
		var center = centerPoint;
	} else {
		try {
			var center = centerMarker.getLatLng();
		} catch(e){
			var center = document.centerMarker.getLatLng(); 
		}
	}
	
	var bounds = new GLatLngBounds();
    var circlePoints = Array();
    circleRadius = parseInt(radius);

    with (Math) {
        //var d = circleRadius / 3963.189;  // radians
        var d = circleRadius / 6371;  // radians

        var lat1 = (PI / 180) * center.lat(); // radians
        var lng1 = (PI / 180) * center.lng(); // radians

        for (var a = 0 ; a < 361 ; a++ ) {
            var tc = (PI / 180) * a;
            var y = asin(sin(lat1) * cos(d) + cos(lat1) * sin(d) * cos(tc));
            var dlng = atan2(sin(tc) * sin(d) * cos(lat1), cos(d) - sin(lat1) * sin(y));
            var x = ((lng1 - dlng + PI) % (2 * PI)) - PI ; // MOD function
            var point = new GLatLng(parseFloat(y * (180 / PI)), parseFloat(x * (180 / PI)));
            circlePoints.push(point);
            bounds.extend(point);
        }

        if (d < 1.5678565720686044) {
            circle = new GPolygon(circlePoints, '#333333', 2, 1, '#cccccc', 0.3);
        }
        else {
            circle = new GPolygon(circlePoints, '#eeeeee', 2, 1);
        }
        map.addOverlay(circle);

        map.setZoom(map.getBoundsZoomLevel(bounds));
    }
    map.panTo(centerMarker.getLatLng());
}

function resetMap() {
    // Reset the map and overlays
    map.setZoom(7);
    map.panTo(origin);
    try{map.removeOverlay(circle);} catch(e){}
    try{map.removeOverlay(centerMarker);} catch(e){}
    try{map.closeInfoWindow();} catch(e){}
    for (var m = 0; m < markers.length+1; m++) {
        var mkr = markers[m];
           map.removeOverlay(mkr);
    }
	map.clearOverlays();

	directionsPanel.innerHTML = '';
    directions.clear();
	
}

function is_array(input){    
	return typeof(input)=='object'&&(input instanceof Array);  
}