// JavaScript Document
//<![CDATA[
var map, circle, circleRadius, centerMarker, origin, geocoder;
var markers = [];
var blurbs = [];
var titles = [];
var C = 57.2958;
var ajaxp, dirTitle, directions, directionsPanel, dpJQ;
var refAdd, refRad, maxDist;
var btnFind, btnReset;
var locMatch;
var mc = Object();
mc.mapLocation = "hungary" ;
mc.iconURL = "/parameters/magyararu.patronet/modules/MagyarAru/icons/";
var centerMarker = Object();

// Things to do when the page is fully loaded
$(document).ready(function () {

    // Make it easy to access page elements

    // for some reason, pulling this back with jQuery doesn't work with the API
    directionsPanel = document.getElementById("location-directions");
	
    // make sure the browser can handle Google Maps
    if (GBrowserIsCompatible()) {
        // set up Google Maps

        origin = new GLatLng(47.168928, 19.511719);
        map = new GMap2(document.getElementById("result_map_div"));
        map.setCenter(origin, 7);
        map.addControl(new GLargeMapControl());
        map.addControl(new GMapTypeControl());

// map.enableScrollWheelZoom();
	//map.addMapType(G_PHYSICAL_MAP);
	//map.addMapType(G_SATELLITE_3D_MAP);
	var overviewMap = new GOverviewMapControl(new GSize(150,150));
	map.addControl(overviewMap);
	map.enableDoubleClickZoom();
	map.enableContinuousZoom();
	
	// autohide controls
	GEvent.addListener(map, "mouseover", function() {
		map.showControls();
	});
	GEvent.addListener(map, "mouseout", function() {
		map.hideControls();
	});
	

        var geocoder = new GClientGeocoder();

		// for getting driving directions
        var directions = new GDirections(map, directionsPanel);

    } else {
        alert('Az oldal megjelenítéséhez olyan modern böngészőre van szükség, amely támogatja Google Maps térképeket!');
    }
});

//$(document).unload(GUnload);


function createMarker(point, number, loc, iconNo) {
	//var icon = createMarker.arguments[3]; 
    // Add a marker overlay to the map and store various bits of info about it
	var icon = new GIcon();
	
	// marker images
	var markerImage = [
		mc.iconURL + "red-dot.png", // 0
		mc.iconURL + "dd-start.png",//1 start
		mc.iconURL + "dd-pause.png",//2 pause
		mc.iconURL + "dd-end.png",//3 stop
		
		mc.iconURL + "pink-dot.png",//4 
		mc.iconURL + "blue-dot.png",//5 
		mc.iconURL + "ltblue-dot.png",//6 
		mc.iconURL + "yellow-dot.png",//7 
		mc.iconURL + "green-dot.png",//8 
		mc.iconURL + "purple-dot.png",//9 
		
		mc.iconURL + "pink.png",//10 
		mc.iconURL + "blue.png",//11 
		mc.iconURL + "yellow.png",//12 
		mc.iconURL + "green.png",//13 
		mc.iconURL + "purple.png",//14 
		mc.iconURL + "red.png"//15
	];
	if(!iconNo) iconNo = 15
	//alert(iconNo)
	icon.image = markerImage[iconNo];
	icon.shadow = mc.iconURL + "shadow50.png";
	icon.iconSize = new GSize(32, 32);
	icon.shadowSize = new GSize(40, 32);
	icon.iconAnchor = new GPoint(16, 32);
	icon.infoWindowAnchor = new GPoint(15, 0);      

	var marker = new GMarker(point , { icon:icon});
    marker.value = number;

    // The only time we shouldn't have a representative is when it's the address
    // entered by the user
		//alert(loc.homeprop)
    if (loc.approved) {
        // Setup the blurb for the marker's info box
		var chain2print = (loc.chain_id != 0) ? loc.chain_label : "";
        var myHtml = '<h3 class="representative"><a href="javascript:scroll2map();">' + loc.label + '</a></h3>';
        myHtml += '<div>' + loc.address_name + ' '+loc.address_type+' ' + loc.homeprop+'</div>';
        myHtml += '<div>' + loc.place_nev_utf + ', ';
        myHtml += loc.zipcode + '</div>';

        // Only show the telephone number if it's available
        if (loc.telephone.length) {
            myHtml += '<div><strong>Tel.</strong>: ' + loc.telephone + '</div>';
        }

        // Only show the fax number if it's available
        if (loc.fax.length) {
            myHtml += '<div><strong>Fax</strong>: ' + loc.fax + '</div>';
        }

        // Only show the website if it's available
        if (loc.website.length) {
			if(loc.website.indexOf("http://") > -1) loc.website = "http://" + loc.website;
            myHtml += '<div><strong>Honlap</strong>: <a href="'+loc.website+'" target="_blank">' + loc.website + '</a></div>';
        }

        // Only show the email if it's available
        if (loc.email.length) {
            myHtml += '<div><strong>E-mail</strong>: <a href="mailto:'+loc.email+'">' + loc.email + '</a></div>';
        }

        // Add a listener to pop up an info box when the mouse goes over a marker
        GEvent.addListener(marker, "mouseover", function() {
            map.openInfoWindowHtml(point, myHtml);
        });

        // Keep track of the marker's data
        titles.push(loc.approved);
        markers.push(marker);
        blurbs.push(myHtml);
    }

    return marker;
}

function showAllLocations() {
    // Pull back all locations from the database and make markers for each one
    ajaxp.fadeIn('fast');
    $.ajax({
        url : 'index.php?name=MagyarAru&file=index&todo=mapFind&filter=all',
        type : 'POST',
        dataType : 'json', 
        success : function (json) {
            for (var l = 0; l < json.locations.length; l++) {
                var loc = json.locations[l];
                var point = new GLatLng(loc.lat, loc.lng);
                map.addOverlay(createMarker(point, l, loc,3));
            }
        ajaxp.fadeOut('slow');
        }
    });
}

// get the coords of search address
function getLocationLatLng(locStr) {
    geocoder.getLatLng(
        locStr,
        function (point) {
            // Bail out if there was a problem on the server
            if (!point) { alert('Kérem, hogy egy létező címet adjon meg.');  return; }

			var ret = Array();
			ret['lat'] = point.lat();
			ret['lng'] = point.lng();
			return ret;
          }
    );
 }



function findLocationsInRadius() {
    // Search all of the markers we have for points that are within the chosen
    // radius from the address entered by the user
    ajaxp.fadeIn('fast');

    // reset some elements
    dirTitle.text('');
    directionsPanel.innerHTML = '';
    directions.clear();
    map.closeInfoWindow();

    locMatch.slideUp('fast');
    maxDist = parseInt(refRad.val());

    geocoder.getLatLng(
        refAdd.val(),
        function (point) {
            // Bail out if there was a problem on the server
            if (!point) { alert('Kérem, hogy egy létező címet adjon meg.'); ajax.fadeOut(); return; }
            
            if (centerMarker) {
                map.removeOverlay(centerMarker);
            }
			getListInRadius(point,maxDist);
        }
    );

 ajaxp.fadeOut('slow');
 }

function getListInRadius(point,radius){
	centerMarker = createMarker(point, 10000, {address : refAdd.val()},4);
	document.centerMarker = centerMarker;
	map.addOverlay(centerMarker);
	document.centerLat = centerMarker.getPoint().lat();
	document.centerLng = centerMarker.getPoint().lng();
	var url = 'index.php?name=MagyarAru&file=index&todo=mapFind&filter=radius&lat='+document.centerLat+'&lng='+document.centerLng+'&radius='+radius;
	//prompt(url,url);
	$.ajax({
        url : url,
        type : 'POST',
        data : {'address': refAdd.val()	},
        dataType : 'json',
        error : function (xhr, status, err) {
            alert(err);
        },
        success : function (json) {
            // Bail out if there was a problem on the server
            if (json.error) { alert(json.error); ajax.fadeOut(); return; }
            if (centerMarker) {
                map.removeOverlay(centerMarker);
            }

			var matches = [];
            var point = new GLatLng(document.centerLat, document.centerLng);
            centerMarker = createMarker(point, 10000, map.getCenter(), 8);
            map.addOverlay(centerMarker);
            doDrawCircle();
            // now run over all markers to find markers with the same lat/lng
            for (var l = 0; l < markers.length; l++) {
                var m = markers[l];
				map.removeOverlay(m);
            }
			l = 0;
			try {
				with (Math) {
					for (var z = 0; z < json.locations.length; z++) {
						var loc = json.locations[z];
						//alert(json.locations[z])
						var point = new GLatLng(loc.lat, loc.lng);
						markers[z] = createMarker(point, z, loc,11)
						var m = markers[z];
						map.addOverlay(markers[z]);
	                    matches.push(m);
						l++;
				}

					filterLocations(matches) ;
				}
			} catch(e){
				alert("nincs a korzetben bót")
			}
        }
		
    });
}

function resetMap() {
    // Reset the map and overlays
    ajaxp.fadeIn();
    map.setZoom(7);
    map.panTo(origin);
    locMatch.slideUp('slow', function () { $(this).html(''); });
    map.removeOverlay(circle);
    map.removeOverlay(centerMarker);
    map.closeInfoWindow();
    for (var m = 0; m < markers.length; m++) {
        var mkr = markers[m];
        if (mkr.isHidden()) { mkr.show(); }
    }
    dirTitle.text('');
    directionsPanel.innerHTML = '';
    directions.clear();
    ajaxp.fadeOut('slow');
}

// Source: http://maps.forum.nu/gm_sensitive_circle2.html
function doDrawCircle() {
    if (circle) {
        map.removeOverlay(circle);
    }

	try {
		var center = centerMarker.getLatLng();
	} catch(e){
		var center = document.centerMarker.getLatLng(); 
	}
	var bounds = new GLatLngBounds();
    var circlePoints = Array();
    circleRadius = parseInt(refRad.val());

    with (Math) {
        //var d = circleRadius / 3963.189;  // radians
        var d = circleRadius / 6371;  // radians

        var lat1 = (PI / 180) * center.lat(); // radians
        var lng1 = (PI / 180) * center.lng(); // radians

        for (var a = 0 ; a < 361 ; a++ ) {
            var tc = (PI / 180) * a;
            var y = asin(sin(lat1) * cos(d) + cos(lat1) * sin(d) * cos(tc));
            var dlng = atan2(sin(tc) * sin(d) * cos(lat1), cos(d) - sin(lat1) * sin(y));
            var x = ((lng1 - dlng + PI) % (2 * PI)) - PI ; // MOD function
            var point = new GLatLng(parseFloat(y * (180 / PI)), parseFloat(x * (180 / PI)));
            circlePoints.push(point);
            bounds.extend(point);
        }

        if (d < 1.5678565720686044) {
            circle = new GPolygon(circlePoints, '#333333', 2, 1, '#cccccc', 0.3);
        }
        else {
            circle = new GPolygon(circlePoints, '#eeeeee', 2, 1);
        }
        map.addOverlay(circle);

        map.setZoom(map.getBoundsZoomLevel(bounds));
    }
    map.panTo(centerMarker.getLatLng());
}

function filterLocations(matches) {
	//alert(matches[0])
    // now list each of the matches
    var html = '<h4>A megadott körzet: ' + maxDist + ' km; a keresés központja: ' + refAdd.val() + '</h4>';
    if (matches.length <= 0) {
        html += '<p>A megadott nagyságú körzeten belül nem találtam boltot.</p>';
    } else {
        for (var m = 0; m < matches.length; m++) {
            marker = matches[m];
            html += '<div class="representative-location" id="dl' + marker.value + '">';
            html += blurbs[marker.value];
            html += '<div><a href="javascript:;" id="dda' + marker.value + '" class="get-directions">Útvonal</a></div>';
            html += '</div>';
        }
    }
    locMatch.html(html);
//alert(html)
    // add a listener for when the user clicks on a match
    var locs = $('div.representative-location');
    locs.click(function () {
           // document.location = '#representative-map';
            ajaxp.fadeIn();

            // Get the marker's value
            var num = parseInt($(this).attr('id').replace('dl', ''));
			alert($(this).attr('id'))
            marker = markers[num];
            map.setZoom(14);

            // show an info box for the marker
            map.openInfoWindowHtml(marker.getLatLng(), blurbs[num]);
            map.panTo(marker.getLatLng());

            // keep the chosen match highlighted
            $(this).siblings().removeClass('active');
            $(this).addClass('active');

            ajaxp.fadeOut('slow');
        });

    locMatch.slideDown();

    // add an event handler for when the user wants to get driving directions
    var drvDirs = $('a.get-directions').click(function () {
            ajaxp.fadeIn();

            directionsPanel.innerHTML = '';

            // Get the marker's value
            var num = parseInt($(this).attr('id').replace('dda', ''));
            alert(num);
			marker = markers[num];
            directions.load('from: ' + centerMarker.getLatLng().lat() + ', ' + centerMarker.getLatLng().lng() + ' to: ' + marker.getLatLng().lat() + ', ' + marker.getLatLng().lng());
            dirTitle.text('Az útvonal ide: ' + titles[num]);
			$("dirContainer").fadeIn('slow');
			scroll2map();
            ajaxp.fadeOut('slow');
        });

    // make all matches the same height, both for aesthetics and CSS sanity
    var maxHeight = 0;
    $.each(locs, function () {
            var h = $(this).height();
            if (h > maxHeight) { maxHeight = h; }
        });
    locs.height(maxHeight);

    ajaxp.fadeOut('slow');
}

function scroll2map(){
	var rm =document.getElementById('representative-map');
	setTimeout("scroll(0,"+rm.offsetTop+")",500);
}




function findLocation(){
	var isFree = 1;
	var search = document.getElementById('reference-address').value;
	var vMsg = "";
	var vZoom = "16";
	showAddress(isFree,search,vMsg,vZoom);
}


// ====== Create a Client Geocoder ======
var geo = new GClientGeocoder(new GGeocodeCache()); 
// ====== Array for decoding the failure codes ======
var reasons=[];
reasons[G_GEO_SUCCESS]            = "Rendben";
reasons[G_GEO_MISSING_ADDRESS]    = "Hiányzó cím: Nem adott meg címet a keresés mezőben.";
reasons[G_GEO_UNKNOWN_ADDRESS]    = "Ismeretlen cím:  Nem rendelhető földrajzi pont a megadott címhez.";
reasons[G_GEO_UNAVAILABLE_ADDRESS]= "A cím nem elérhető:  The geocode for the given address cannot be returned due to legal or contractual reasons.";
reasons[G_GEO_BAD_KEY]            = "Rossz kulcs: The API key is either invalid or does not match the domain for which it was given";
reasons[G_GEO_TOO_MANY_QUERIES]   = "Túl sok lekérés: The daily geocoding quota for this site has been exceeded.";
reasons[G_GEO_SERVER_ERROR]       = "Szerver hiba: The geocoding request could not be successfully processed.";



// ====== Geocoding ======

function showAddress(isFree,search,vMsg,vZoom, coordsOnly) {

// ====== Perform the Geocoding ======        

/* 
var search = "Kossuth Lajos utca 15., Budapest";
*/
search += ", Magyarország";
geo.getLocations(search, function (result)
  {
	if (result.Status.code == G_GEO_SUCCESS) {
	  // ===== If there was more than one result, "ask did you mean" on them all =====
	  if (result.Placemark.length > 1) { 
		var msg = "<table cellpadding=0 cellspacing=0 class='leftBoxStyle'><tr><td style='background-color:red; padding:2px;color:white; font-weight:bold' colspan=2 class='leftBoxHead'><div style='float:right'><a href='javascript:closeDidYouMeanDiv();'><img src='/images/global/close.gif' border=0></a></div>Melyik legyen?</td></tr>" ;
		// Loop through the results
		for (var i=0; i<result.Placemark.length; i++) {
		  var p = result.Placemark[i].Point.coordinates;
			if(i==1){ 
			x = dump(result.Placemark[i].AddressDetails );
			};
		 
		 var addr = parseAddress(result.Placemark[i]);
		 msg += "<tr><td valign=top class='leftBoxRow' style='padding:2px'>"+(i+1)+":</td><td class='leftBoxRow'> <a href='javascript:place(" +p[1]+","+p[0]+",\""+ addr +"\""+")'>"+ result.Placemark[i].address+"</a></td></tr>";
		}
		msg += "</table>";
		showDidYouMeanList( msg );
		// show BIG ARROW...
		//showBigArrow();
	  }
	  // ===== If there was a single marker =====
	  else {
		//parent.showDidYouMeanDiv("");
		var p = result.Placemark[0].Point.coordinates;
		
		msg = parseAddress(result.Placemark[0]);
		
		// if have vMsg message string, change msg to it
		msg += "<br>" + "lat:"+p[1] + ", lng:"+p[0];
			
		if(coordsOnly){
			var ret = p[1]+","+p[0];
			return p;	
		}		
		
		// if zoom declared, add it
		if(vZoom){
			place(p[1],p[0],msg,vZoom);
		} else {
			place(p[1],p[0],msg);
		}
	}
	}
	// ====== Decode the error status ======
	else {
	  var reason="Code "+result.Status.code;
	  if (reasons[result.Status.code]) {
		reason = reasons[result.Status.code]
	  } 
	  var errorStr = '' + reason + "\n";
	  if(parent.document.getElementById("kerulet")){
		if(parent.document.getElementById("kerulet").value==0){
			errorStr += "\nPróbálja a kerület lista használatával listázni az utcákat,\nvagy gépeléskor, a beviteli mező alatt megjelenő listából válasszon!\n\n"; 
		}
	  }
	  alert(errorStr);
	}
	});
}


function parseAddress(addressObj){
	 //alert(dump(addressObj)) ;
    /*
	'id' => "p1"
    'address' => "Ady Endre utca 1, 1039 III. kerület, Budapest, Hungary"
    'AddressDetails' ...
        'Country' ...
            'CountryNameCode' => "HU"
            'AdministrativeArea' ...
                'AdministrativeAreaName' => "Budapest"
                'Locality' ...
                    'LocalityName' => "Budapest"
                    'DependentLocality' ...
                        'DependentLocalityName' => "III. kerület"
                        'Thoroughfare' ...
                            'ThoroughfareName' => "Ady Endre utca 1"
                        'PostalCode' ...
                            'PostalCodeNumber' => "1039"
        'Accuracy' => "8"
    'Point' ...
        'coordinates' ...
            '0' => "19.060257"
            '1' => "47.584671"
            '2' => "0"

	*/

	var ret = "";
	// budapest geocode parser
	if(mc.mapLocation == "budapest" ){
		try{
			if(addressObj.AddressDetails.Country.AdministrativeArea){
				if(addressObj.AddressDetails.Country.AdministrativeArea.Locality.DependentLocality){
					if(addressObj.AddressDetails.Country.AdministrativeArea.Locality.DependentLocality.Thoroughfare) ret += "<h5>"+addressObj.AddressDetails.Country.AdministrativeArea.Locality.DependentLocality.Thoroughfare.ThoroughfareName +"</h5><br>";
					ret += "<i>"+addressObj.AddressDetails.Country.AdministrativeArea.Locality.DependentLocality.DependentLocalityName + "</i>";
				}
				if(addressObj.AddressDetails.Country.AdministrativeArea.Locality.DependentLocality){
					if(addressObj.AddressDetails.Country.AdministrativeArea.Locality.LocalityName != addressObj.AddressDetails.Country.AdministrativeArea.Locality.DependentLocality.DependentLocalityName) ret += "<br> "+addressObj.AddressDetails.Country.AdministrativeArea.Locality.LocalityName;
					if(addressObj.AddressDetails.Country.AdministrativeArea.Locality.DependentLocality.PostalCode) ret += " "+addressObj.AddressDetails.Country.AdministrativeArea.Locality.DependentLocality.PostalCode.PostalCodeNumber;
				} else {
					
				}
			}
		} catch(err){
			//alert(err)	
		}
	}
	//alert(addressObj.Point.coordinates[0])
	
	// hungary geocoder parser
	if(mc.mapLocation == "hungary"){
		try{ 
			if(addressObj.AddressDetails.Country.AdministrativeArea){
			try{ if(addressObj.AddressDetails.Country.AdministrativeArea.Locality.Thoroughfare) ret += "<h5>"+ addressObj.AddressDetails.Country.AdministrativeArea.Locality.Thoroughfare.ThoroughfareName + "</h5><br>"} catch(err){};
			try{ if(addressObj.AddressDetails.Country.AdministrativeArea.Locality.PostalCode)ret += ""+addressObj.AddressDetails.Country.AdministrativeArea.Locality.PostalCode.PostalCodeNumber + " "} catch(err){};
			try{ if(addressObj.AddressDetails.Country.AdministrativeArea.Locality) ret += ""+addressObj.AddressDetails.Country.AdministrativeArea.Locality.LocalityName + "<br>"} catch(err){};
			try{ ret += "<i>"+ addressObj.AddressDetails.Country.AdministrativeArea.AdministrativeAreaName+" megye</i>"} catch(err){};
		}
		} catch(err){}
		//var xxx = popWindow('xx');
		//xxx.document.write("<pre>"+dump(addressObj.AddressDetails)+"</pre>");
	}
	
	ret += "<br><br>";
	
	
	return ret;
}



//]]>