<?php

$oShopProducts = new ShopProducts(0);

$xtp = new XTemplate($tmpl_dir."basket.html", "main");

$xtp->assign("SEARCH_URL",$ModLink."todo=search");
$xtp->assign("PRINT_URL",$ModLink."todo=basket&printable=1");

$xtp->assign("JS_DIR",$ModDir."/javascript");

$basket_items = pnSessionGetVar($basketConf['session_var_name']);

if ($_REQUEST["printable"]) {
    foreach ($basket_items as $item) {
        $record = $oShopProducts->getInfoJoinDefault($item["product_id"],$item["shop_id"]);
        $xtp->assign("PRODUCT_TEXT",$record["label"]);
        $xtp->assign("MANUFACTURER_TEXT",$record["manufacturer_label"]);
        $xtp->assign("SHOP_TEXT",$record["shop_label"].($record["shop_chain_id"]?" (".$record["shop_chain_label"].")":""));
        $xtp->assign("ADDRESS_TEXT",$record["shop_zipcode"]." ".$record["shop_place_nev_utf"].", ".$record["shop_address"]);
        $xtp->assign("PRODUCT_ID",$record["id"]);
        $xtp->assign("SHOP_ID",$record["shop_id"]);
        $xtp->parse("print.shop_product_row");
    }
    $xtp->parse("print");
    $xtp->out("print");
    exit();
}

if (!$basket_items || !is_array($basket_items)) {
    include('header.php');
    $xtp->parse("empty_basket");
    $xtp->out("empty_basket");
    include('footer.php');
}

foreach ($basket_items as $item) {
    $record = $oShopProducts->getInfoJoinDefault($item["product_id"],$item["shop_id"]);
    $xtp->assign("PRODUCT_TEXT",$record["label"]);
    $xtp->assign("MANUFACTURER_TEXT",$record["manufacturer_label"]);
    $xtp->assign("SHOP_TEXT",$record["shop_label"].($record["shop_chain_id"]?" (".$record["shop_chain_label"].")":""));
    $xtp->assign("ADDRESS_TEXT",$record["shop_zipcode"]." ".$record["shop_place_nev_utf"].", ".$record["shop_address"]);
    $xtp->assign("PRODUCT_ID",$record["id"]);
    $xtp->assign("SHOP_ID",$record["shop_id"]);
    $xtp->parse("main.shop_product_row");
}

include('header.php');

$xtp->parse("main");
$xtp->out("main");

include('footer.php');

?>