<?php

$xtp = new XTemplate($tmpl_dir."search.html", "main");

$xtp->assign("IMGDISP_URL",$ModLink."todo=thumbview");
$xtp->assign("COMBO_URL",$ModLink."todo=process&func=combo");
$xtp->assign("SEARCH_URL",$ModLink."todo=process&func=search");
$xtp->assign("VIEWPRODS_URL",$ModLink."todo=process&func=view_products");
$xtp->assign("VIEWITEM_URL",$ModLink."todo=process&func=view_item");
$xtp->assign("BASKET_URL",$ModLink."todo=basket");
$xtp->assign("PRINT_URL",$ModLink."todo=basket&printable=1");


$xtp->assign("IMG_DOCPATH",$productsConf['imageDir']);
$xtp->assign('IMGPATH',$ModDir."/images");
$xtp->assign("JS_DIR",$ModDir."/javascript");
$xtp->assign('MAPS_API_KEY',$googleMapsApiKey );
$xtp->assign('MOD_DIR',$ModDir);

$xtp->assign('MAX_ITEM',$productsConf['PublicSearchDefaultItemnum']);
$xtp->assign('IMGVIEW_WIDTH',$productsConf['imageWidth']+20);
$xtp->assign('IMGVIEW_HEIGHT',$productsConf['imageHeight']+20);


$location_types = array("county","shire","place","circle");
$location_type = in_array($_REQUEST["location_type"],$location_types)?$_REQUEST["location_type"]:"country";
$xtp->assign("LOCATION_TYPE",$location_type);

$search_types = array("product","growe","supplier","shop","manufacturer");
$search_type = in_array($_REQUEST["search_type"],$search_types)?$_REQUEST["search_type"]:"product";
$xtp->assign("SEARCH_TYPE",$search_type);

$oProductGroups = new ProductGroups(0);
$group_list = $oProductGroups->getSortedFullList();

foreach ($group_list as $group_record) {
    if ($group_record["type"]=="products") {
        $xtp->assign("PRODGROUP_ID",$group_record["id"]);
        $xtp->assign("PRODGROUP_LABEL",$group_record["full_label"]);
        $xtp->parse("main.prodgroup_option");
    }
}

$oChains = new Chains(0);
$chain_list = $oChains->getList("","`label` ASC");

foreach ($chain_list as $chain_record) {
    $xtp->assign("CHAIN_ID",$chain_record["id"]);
    $xtp->assign("CHAIN_LABEL",$chain_record["label"]);
    $xtp->parse("main.chain_option");
}

include('header.php');

$xtp->parse("main");
$xtp->out("main");

include('footer.php');

?>