var tag = document.createElement('script');
var ytwidth = 640;
var ytheight = 380;

var sctop;
var currentVideoID;

tag.src = "https://www.youtube.com/iframe_api";
var firstScriptTag = document.getElementsByTagName('script')[0];
firstScriptTag.parentNode.insertBefore(tag, firstScriptTag);

var player;
function onPlayerReady(event) {
	event.target.playVideo();
	$(".ajaxloader").hide();
}

var done = false;
function onPlayerStateChange(event) {
	if (event.data == YT.PlayerState.PLAYING && !done) {
		done = true;
	}
	if(event.data == YT.PlayerState.ENDED){
		ended();
	}
	//console.log(YT);
}
function stopVideo() {
	player.stopVideo();
}

function ended(){
	var is_chrome = navigator.userAgent.toLowerCase().indexOf('chrome') > -1;
	if(is_chrome){
		player.seekTo(0);
		stopVideo()
	} else {
		try{
			player.destroy();
		}catch(e){
		};
	
		player = new YT.Player('ytplayer', {
		  height: ytheight,
		  width: ytwidth,
		  videoId: currentVideoID,
		  events: {
			'onStateChange': onPlayerStateChange
		  }
		});
	}
}

function showPlayer(){
	$("#pnCMSFullDiv").prepend("<div class='galClose' title='Close player'></div><div id='galerySliderFullCnt'><img src='/parameters/k-v/templates/ImageGalleryNew/images/ajax-loader.gif' class='ajaxloader'></div><div id='galERRAlogo'></div>");
	$("#galERRAlogo").css("top",$(window).scrollTop()+10)
	$(".ajaxloader").css("left",$(window).innerWidth()/2);
	$('body').css('overflow','hidden');
	$("#galerySliderFullCnt").css("top",$(document).scrollTop()).click(function(e) {
        closePlayer();
    });
	$(".galClose").css("top",$(document).scrollTop()+10);
	$(".galClose").click(function(e) {
		closePlayer();
	});
	
	$(document).keyup(function(e) {
		if (e.keyCode == 27) {        
			closePlayer();
		}  
	});
	
	var viewPortTag=document.createElement('meta');
	viewPortTag.id="viewport";
	viewPortTag.name = "viewport";
	viewPortTag.content = "width=device-width,user-scalable=0,initial-scale=1.0,minimum-scale=1.0,maximum-scale=1.0";
	document.getElementsByTagName('head')[0].appendChild(viewPortTag);
	document.ontouchmove = function(e){ e.preventDefault(); }
	$("#pnCMSFullDiv").prepend("<div id='ytplayer'></div>");
	l = $(window).width()/2 - ytwidth / 2;
	t = $(window).height()/2 - ytheight / 2;
	t = t +  $(window).scrollTop();
	$("#ytplayer").css("left",l).css("top",t)
	
}
function closePlayer(){
   $("#galerySliderFullCnt").remove(); 
   $("#ytplayer").remove(); 
   $(".galClose").remove();
   $("#galERRAlogo").remove();
   $('body').css('overflow','auto');
	vptag=document.getElementById("viewport");
	vptag.content = "user-scalable=1.0,initial-scale=1.0,minimum-scale=0.5,maximum-scale=5.0"
   document.ontouchmove = function(e){ return true; }

}
function  setSizes(){
	l = $(window).width()/2 - ytwidth / 2;
	t = $(window).height()/2 - ytheight / 2;
	$("#ytplayer").css("left",l).css("top",t+$(window).scrollTop())
}

$(function(){
	$(".playyoutube").click(function(e) {
		try{
			player.destroy();
		}catch(e){};
		
		showPlayer();
		
		currentVideoID = $(e.currentTarget).data("v");
		
        player = new YT.Player('ytplayer', {
          height: ytheight,
          width: ytwidth,
          videoId: currentVideoID,
          events: {
            'onReady': onPlayerReady,
            'onStateChange': onPlayerStateChange
          }
        });

    });


	$(".playyoutube").append("<div class='playicon transp'></div>");
	
	$(".playyoutube").attr("title","Click to play this video!")

	$(".playyoutube").mouseover(function(e) {
		$(this).find("img").addClass("over");
		$(this).find(".playicon").addClass("over");
		$(this).find(".playicon").removeClass("transp");
	});


	$(".playyoutube").mouseout(function(e) {
		$(this).find("img").removeClass("over");
		$(this).find(".playicon").addClass("transp");
		$(this).find(".playicon").removeClass("over");
	});
	
	$( window ).resize(function() {
	  setSizes();
	});
		
});